/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.terascan;

import it.geosolutions.imageio.plugins.hdf4.BaseHDF4ImageReader;
import it.geosolutions.imageio.plugins.hdf4.terascan.HDF4TeraScanImageMetadata;
import it.geosolutions.imageio.plugins.hdf4.terascan.HDF4TeraScanProperties;
import it.geosolutions.imageio.plugins.hdf4.terascan.HDF4TeraScanStreamMetadata;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class HDF4TeraScanImageReader
extends BaseHDF4ImageReader {
    private String[] productList;
    private IIOMetadata streamMetadata = null;

    public HDF4TeraScanImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    protected void initializeProfile() throws IOException {
        boolean checkProducts = true;
        NetcdfDataset dataset = this.reader.getDataset();
        if (dataset == null) {
            throw new IOException("Unable to initialize profile due to a null dataset");
        }
        List variables = dataset.getVariables();
        List attributes = dataset.getGlobalAttributes();
        this.reader.setNumGlobalAttributes(attributes.size());
        this.productList = HDF4TeraScanProperties.refineProductList(variables);
        int numImages = this.productList != null ? this.productList.length : 0;
        this.setNumImages(numImages);
        this.reader.setNumImages(numImages);
        HashMap<Range, TerascanDatasetWrapper> indexMap = new HashMap<Range, TerascanDatasetWrapper>(numImages);
        try {
            block2: for (Variable var : variables) {
                String name = var.getName();
                for (int j = 0; j < numImages; ++j) {
                    if (checkProducts && !name.equals(this.productList[j])) continue;
                    indexMap.put(new Range(j, j + 1), new TerascanDatasetWrapper(var));
                    continue block2;
                }
            }
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException("Error occurred during NetCDF file parsing", e);
        }
        this.reader.setIndexMap(indexMap);
    }

    @Override
    protected BaseHDF4ImageReader.HDF4DatasetWrapper getDatasetWrapper(int imageIndex) {
        return (BaseHDF4ImageReader.HDF4DatasetWrapper)this.reader.getVariableWrapper(imageIndex);
    }

    BaseNetCDFImageReader getInnerReader() {
        return this.reader;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.productList = null;
        this.streamMetadata = null;
    }

    double[] getValidRange(int imageIndex) throws IOException {
        String[] validRanges;
        String validRange;
        double[] range = new double[]{Double.NaN, Double.NaN};
        String unsigned = this.getAttributeAsString(imageIndex, "_Unsigned");
        boolean isUnsigned = false;
        if (unsigned != null && unsigned.trim().length() > 0) {
            isUnsigned = Boolean.parseBoolean(unsigned);
        }
        if ((validRange = this.getAttributeAsString(imageIndex, "valid_range", isUnsigned)) != null && validRange.trim().length() > 0 && (validRanges = validRange.split(",")).length == 2) {
            range = new double[]{Double.parseDouble(validRanges[0]), Double.parseDouble(validRanges[1])};
        }
        return range;
    }

    double getFillValue(int imageIndex) throws IOException {
        double fillValue = Double.NaN;
        String fillS = this.getAttributeAsString(imageIndex, "_FillValue");
        if (fillS != null && fillS.trim().length() > 0) {
            fillValue = Double.parseDouble(fillS);
        }
        return fillValue;
    }

    protected int getBandNumberFromProduct(String productName) {
        return HDF4TeraScanProperties.terascanProducts.get(productName).getNBands();
    }

    String getLongName(int imageIndex) throws IOException {
        String name = "";
        String nameS = this.getAttributeAsString(imageIndex, "long_name");
        if (nameS != null) {
            name = nameS;
        }
        return name;
    }

    double getScale(int imageIndex) throws IOException {
        double scale = Double.NaN;
        String scaleS = this.getAttributeAsString(imageIndex, "scale_factor");
        if (scaleS != null && scaleS.trim().length() > 0) {
            scale = Double.parseDouble(scaleS);
        }
        return scale;
    }

    double getOffset(int imageIndex) throws IOException {
        double offset = Double.NaN;
        String offsetS = this.getAttributeAsString(imageIndex, "add_offset");
        if (offsetS != null && offsetS.trim().length() > 0) {
            offset = Double.parseDouble(offsetS);
        }
        return offset;
    }

    public void reset() {
        super.reset();
    }

    public IIOMetadata getImageMetadata(int imageIndex, String formatName, Set<String> nodeNames) throws IOException {
        this.initialize();
        this.checkImageIndex(imageIndex);
        if (formatName.equalsIgnoreCase("it_geosolutions_imageio_plugins_hdf4_terascan_terascanImageMetadata_1.0")) {
            return new HDF4TeraScanImageMetadata(this, imageIndex);
        }
        return super.getImageMetadata(imageIndex, formatName, nodeNames);
    }

    public synchronized IIOMetadata getStreamMetadata(String formatName, Set<String> nodeNames) throws IOException {
        if (formatName.equalsIgnoreCase("it_geosolutions_imageio_plugins_hdf4_terascan_TeraScanstreamMetadata_1.0")) {
            if (this.streamMetadata == null) {
                this.streamMetadata = new HDF4TeraScanStreamMetadata(this);
            }
            return this.streamMetadata;
        }
        return super.getStreamMetadata(formatName, nodeNames);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return this.getImageMetadata(imageIndex, "it_geosolutions_imageio_plugins_hdf4_terascan_terascanImageMetadata_1.0", null);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex, String format) throws IOException {
        return this.getImageMetadata(imageIndex, format, null);
    }

    @Override
    public synchronized IIOMetadata getStreamMetadata() throws IOException {
        return this.getStreamMetadata("it_geosolutions_imageio_plugins_hdf4_terascan_TeraScanstreamMetadata_1.0", null);
    }

    private class TerascanDatasetWrapper
    extends BaseHDF4ImageReader.HDF4DatasetWrapper {
        public TerascanDatasetWrapper(Variable var) {
            super(var);
        }
    }
}

