/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4.aps;

import it.geosolutions.imageio.plugins.hdf4.HDF4Products;

public class HDF4APSProperties {
    public static final APSProducts apsProducts = new APSProducts();
    public static final String STD_FA_FILE = "file";
    public static final String STD_FA_FILECLASSIFICATION = "fileClassification";
    public static final String STD_FA_FILESTATUS = "fileStatus";
    public static final String STD_FA_FILETITLE = "fileTitle";
    public static final String STD_FA_FILEVERSION = "fileVersion";
    public static final String STD_FA_CREATEAGENCY = "createAgency";
    public static final String STD_FA_CREATESOFTWARE = "createSoftware";
    public static final String STD_FA_CREATEPLATFORM = "createPlatform";
    public static final String STD_FA_CREATETIME = "createTime";
    public static final String STD_FA_CREATEUSER = "createUser";
    public static final String[] STD_FA_ATTRIB = new String[]{"file", "fileClassification", "fileStatus", "fileTitle", "fileVersion", "createAgency", "createSoftware", "createPlatform", "createTime", "createUser"};
    public static final String STD_TA_TIMESTART = "timeStart";
    public static final String STD_TA_TIMESTARTYEAR = "timeStartYear";
    public static final String STD_TA_TIMESTARTDAY = "timeStartDay";
    public static final String STD_TA_TIMESTARTTIME = "timeStartTime";
    public static final String STD_TA_TIMEEND = "timeEnd";
    public static final String STD_TA_TIMEENDYEAR = "timeEndYear";
    public static final String STD_TA_TIMEENDDAY = "timeEndDay";
    public static final String STD_TA_TIMEENDTIME = "timeEndTime";
    public static final String STD_TA_TIMEDAYNIGHT = "timeDayNight";
    public static final String[] STD_TA_ATTRIB = new String[]{"timeStart", "timeStartYear", "timeStartDay", "timeStartTime", "timeEnd", "timeEndYear", "timeEndDay", "timeEndTime", "timeDayNight"};
    public static final String STD_SA_SENSOR = "sensor";
    public static final String STD_SA_SENSORPLATFORM = "sensorPlatform";
    public static final String STD_SA_SENSORAGENCY = "sensorAgency";
    public static final String STD_SA_SENSORTYPE = "sensorType";
    public static final String STD_SA_SENSORSPECTRUM = "sensorSpectrum";
    public static final String STD_SA_SENSORNUMBEROFBANDS = "sensorNumberOfBands";
    public static final String STD_SA_SENSORBANDUNITS = "sensorBandUnits";
    public static final String STD_SA_SENSORBANDS = "sensorBands";
    public static final String STD_SA_SENSORBANDWIDTHS = "sensorBandWidths";
    public static final String STD_SA_SENSORNOMINALALTITUDEINKM = "sensorNominalAltitudeInKM";
    public static final String STD_SA_SENSORSCANWIDTHINKM = "sensorScanWidthInKM";
    public static final String STD_SA_SENSORRESOLUTIONINKM = "sensorResolutionInKM";
    public static final String STD_SA_SENSORPLATFORMTYPE = "sensorPlatformType";
    public static final String[] STD_SA_ATTRIB = new String[]{"sensor", "sensorPlatform", "sensorAgency", "sensorType", "sensorSpectrum", "sensorNumberOfBands", "sensorBandUnits", "sensorBands", "sensorBandWidths", "sensorNominalAltitudeInKM", "sensorScanWidthInKM", "sensorResolutionInKM", "sensorPlatformType"};
    public static final String PFA_IPA_INPUTCALIBRATIONFILE = "inputCalibrationFile";
    public static final String PFA_IPA_INPUTPARAMETER = "inputParameter";
    public static final String PFA_IPA_INPUTMASKSINT = "inputMasksInt";
    public static final String PFA_IPA_INPUTMASKS = "inputMasks";
    public static final String PFA_IPA_PRODLIST = "prodList";
    public static final String PFA_IPA_PROCESSINGVERSION = "processingVersion";
    public static final String[] PFA_IPA_ATTRIB = new String[]{"inputCalibrationFile", "inputParameter", "inputMasksInt", "inputMasks", "prodList", "processingVersion"};
    public static final String PFA_NA_NAVTYPE = "navType";
    public static final String PFA_NA_MAPPROJECTIONSYSTEM = "mapProjectionSystem";
    public static final String PFA_NA_MAPPROJECTION = "mapProjection";
    public static final String PFA_NA_MAPPEDUPPERLEFT = "mapUpperLeft";
    public static final String PFA_NA_MAPPEDUPPERRIGHT = "mapUpperRight";
    public static final String PFA_NA_MAPPEDLOWERLEFT = "mapLowerLeft";
    public static final String PFA_NA_MAPPEDLOWERRIGHT = "mapLowerRight";
    public static final String[] PFA_NA_ATTRIB = new String[]{"navType", "mapProjectionSystem", "mapProjection", "mapUpperLeft", "mapUpperRight", "mapLowerLeft", "mapLowerRight"};
    public static final String PFA_IGCA_LOCALEUPPERLEFT = "localeUpperLeft";
    public static final String PFA_IGCA_LOCALEUPPERRIGHT = "localeUpperRight";
    public static final String PFA_IGCA_LOCALELOWERLEFT = "localeLowerLeft";
    public static final String PFA_IGCA_LOCALELOWERRIGHT = "localeLowerRight";
    public static final String PFA_IGCA_LOCALENWCORNER = "localeNWCorner";
    public static final String PFA_IGCA_LOCALENECORNER = "localeNECorner";
    public static final String PFA_IGCA_LOCALESWCORNER = "localeSWCorner";
    public static final String PFA_IGCA_LOCALESECORNER = "localeSECorner";
    public static final String[] PFA_IGCA_ATTRIB = new String[]{"localeUpperLeft", "localeUpperRight", "localeLowerLeft", "localeLowerRight", "localeNWCorner", "localeNECorner", "localeSWCorner", "localeSECorner"};
    public static final String PDSA_CREATESOFTWARE = "createSoftware";
    public static final String PDSA_CREATETIME = "createTime";
    public static final String PDSA_CREATEPLATFORM = "createPlatform";
    public static final String PDSA_PRODUCTNAME = "productName";
    public static final String PDSA_PRODUCTALGORITHM = "productAlgorithm";
    public static final String PDSA_PRODUCTUNITS = "productUnits";
    public static final String PDSA_PRODUCTVERSION = "productVersion";
    public static final String PDSA_PRODUCTTYPE = "productType";
    public static final String PDSA_ADDITIONALUNITS_1 = "additionalUnits";
    public static final String PDSA_ADDITIONALUNITS_2 = "otherUnits";
    public static final String PDSA_PRODUCTSTATUS = "productStatus";
    public static final String PDSA_VALIDRANGE = "validRange";
    public static final String PDSA_INVALID = "invalid";
    public static final String PDSA_BADDATA = "badData";
    public static final String PDSA_PRODUCTSCALING = "productScaling";
    public static final String PDSA_SCALINGSLOPE = "scalingSlope";
    public static final String PDSA_SCALINGINTERCEPT = "scalingIntercept";
    public static final String PDSA_BROWSEFUNC = "browseFunc";
    public static final String PDSA_BROWSERANGES = "browseRanges";
    public static final String[] PDSA_ATTRIB = new String[]{"createSoftware", "createTime", "createPlatform", "productName", "productAlgorithm", "productUnits", "productVersion", "productType", "additionalUnits", "otherUnits", "productStatus", "validRange", "invalid", "badData", "productScaling", "scalingSlope", "scalingIntercept", "browseFunc", "browseRanges"};
    public static final String PRODLIST = "prodList";

    private HDF4APSProperties() {
    }

    public static final String buildISO8601Time(String time) {
        String[] times = time.split(" ");
        String iso8601Time = new StringBuffer(times[4]).append("-").append(HDF4APSProperties.getMonthNumber(times[1])).append("-").append(times[2]).append("T").append(times[3]).append("Z").toString();
        return iso8601Time;
    }

    public static final String getMonthNumber(String monthName) {
        if (monthName.equalsIgnoreCase("JAN")) {
            return "01";
        }
        if (monthName.equalsIgnoreCase("FEB")) {
            return "02";
        }
        if (monthName.equalsIgnoreCase("MAR")) {
            return "03";
        }
        if (monthName.equalsIgnoreCase("APR")) {
            return "04";
        }
        if (monthName.equalsIgnoreCase("MAY")) {
            return "05";
        }
        if (monthName.equalsIgnoreCase("JUN")) {
            return "06";
        }
        if (monthName.equalsIgnoreCase("JUL")) {
            return "07";
        }
        if (monthName.equalsIgnoreCase("AUG")) {
            return "08";
        }
        if (monthName.equalsIgnoreCase("SEP")) {
            return "09";
        }
        if (monthName.equalsIgnoreCase("OCT")) {
            return "10";
        }
        if (monthName.equalsIgnoreCase("NOV")) {
            return "11";
        }
        if (monthName.equalsIgnoreCase("DEC")) {
            return "12";
        }
        throw new IllegalArgumentException("Unsupported month name" + monthName);
    }

    static String[] refineProductList(String[] products) {
        int inputProducts = products.length;
        int j = 0;
        boolean[] accepted = new boolean[inputProducts];
        for (int i = 0; i < inputProducts; ++i) {
            if (HDF4APSProperties.isAcceptedItem(products[i])) {
                accepted[i] = true;
                ++j;
                continue;
            }
            accepted[i] = false;
        }
        if (j == inputProducts) {
            return products;
        }
        String[] returnedProductsList = new String[j];
        j = 0;
        for (int i = 0; i < inputProducts; ++i) {
            if (!accepted[i]) continue;
            returnedProductsList[j++] = products[i];
        }
        return returnedProductsList;
    }

    private static boolean isAcceptedItem(String productName) {
        if (productName.endsWith("_flags")) {
            return false;
        }
        return apsProducts.get(productName) != null;
    }

    public static class APSProducts
    extends HDF4Products {
        public APSProducts() {
            super(14);
            int index = 0;
            HDF4Products.HDF4Product sst = new HDF4Products.HDF4Product("sst", 1);
            this.add(index++, sst);
            HDF4Products.HDF4Product sst4 = new HDF4Products.HDF4Product("sst4", 1);
            this.add(index++, sst4);
            HDF4Products.HDF4Product chl_oc3 = new HDF4Products.HDF4Product("chl_oc3", 1);
            this.add(index++, chl_oc3);
            HDF4Products.HDF4Product chl_oc3m = new HDF4Products.HDF4Product("chl_oc3m", 1);
            this.add(index++, chl_oc3m);
            HDF4Products.HDF4Product k_490 = new HDF4Products.HDF4Product("K_490", 1);
            this.add(index++, k_490);
            HDF4Products.HDF4Product albedo_ch1 = new HDF4Products.HDF4Product("albedo_ch1", 1);
            this.add(index++, albedo_ch1);
            HDF4Products.HDF4Product albedo_ch2 = new HDF4Products.HDF4Product("albedo_ch2", 1);
            this.add(index++, albedo_ch2);
            HDF4Products.HDF4Product albedo_ch3 = new HDF4Products.HDF4Product("albedo_ch3", 1);
            this.add(index++, albedo_ch3);
            HDF4Products.HDF4Product btemp_ch4 = new HDF4Products.HDF4Product("btemp_ch4", 1);
            this.add(index++, btemp_ch4);
            HDF4Products.HDF4Product btemp_ch5 = new HDF4Products.HDF4Product("btemp_ch5", 1);
            this.add(index++, btemp_ch5);
            HDF4Products.HDF4Product k_PAR = new HDF4Products.HDF4Product("K_PAR", 1);
            this.add(index++, k_PAR);
            HDF4Products.HDF4Product c_660 = new HDF4Products.HDF4Product("c_660", 1);
            this.add(index++, c_660);
            HDF4Products.HDF4Product salinity = new HDF4Products.HDF4Product("salinity", 1);
            this.add(index++, salinity);
            HDF4Products.HDF4Product true_color = new HDF4Products.HDF4Product("true_color", 3);
            this.add(index++, true_color);
        }
    }
}

