/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4;

import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseVariableWrapper;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf4.H4iosp;

public abstract class BaseHDF4ImageReader
extends BaseImageReader {
    protected final BaseNetCDFImageReader reader;
    protected static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.hdf4");
    private boolean isInitialized = false;

    protected abstract HDF4DatasetWrapper getDatasetWrapper(int var1);

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return this.reader.getImageTypes(imageIndex);
    }

    protected abstract void initializeProfile() throws IOException;

    protected BaseHDF4ImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        this.reader = new BaseNetCDFImageReader(originatingProvider);
    }

    protected synchronized void initialize() throws IOException {
        if (!this.isInitialized) {
            this.initializeProfile();
            this.isInitialized = true;
        }
    }

    public void dispose() {
        super.dispose();
        this.reader.dispose();
        this.isInitialized = false;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.reader.setInput(input, seekForwardOnly, ignoreMetadata);
        NetcdfDataset dataset = this.reader.getDataset();
        if (dataset != null) {
            if (!(dataset.getIosp() instanceof H4iosp)) {
                throw new IllegalArgumentException("Provided dataset is not an HDF4 file");
            }
        } else {
            throw new IllegalArgumentException("Provided dataset is not an HDF4 file");
        }
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error occurred during NetCDF file parsing", e);
        }
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException("Stream Metadata is not implemented for the base class, use corecommonstreammetadata");
    }

    protected NetCDFUtilities.KeyValuePair getGlobalAttribute(int attributeIndex) throws IOException {
        return this.reader.getGlobalAttribute(attributeIndex);
    }

    protected String getAttributeAsString(int imageIndex, String attributeName) {
        return this.getAttributeAsString(imageIndex, attributeName, false);
    }

    protected String getAttributeAsString(int imageIndex, String attributeName, boolean isUnsigned) {
        return this.reader.getAttributeAsString(imageIndex, attributeName, isUnsigned);
    }

    protected NetCDFUtilities.KeyValuePair getAttribute(int imageIndex, int attributeIndex) throws IOException {
        return this.reader.getAttribute(imageIndex, attributeIndex);
    }

    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, false);
    }

    public void setInput(Object input) {
        this.setInput(input, false, false);
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.reader.getWidth(imageIndex);
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.reader.getHeight(imageIndex);
    }

    public int getTileHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.reader.getTileHeight(imageIndex);
    }

    public int getTileWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.reader.getTileHeight(imageIndex);
    }

    protected BufferedImage read2DVariable(int imageIndex, ImageReadParam param) throws IOException {
        int[] dstBands;
        int[] srcBands;
        int strideY;
        int strideX;
        BufferedImage image = null;
        HDF4DatasetWrapper wrapper = this.getDatasetWrapper(imageIndex);
        Variable variable = wrapper.getVariable();
        if (param != null) {
            strideX = param.getSourceXSubsampling();
            strideY = param.getSourceYSubsampling();
            srcBands = param.getSourceBands();
            dstBands = param.getDestinationBands();
        } else {
            strideX = 1;
            strideY = 1;
            srcBands = null;
            dstBands = null;
        }
        int rank = variable.getRank();
        int width = wrapper.getWidth();
        int height = wrapper.getHeight();
        int numBands = wrapper.getNumBands();
        Rectangle srcRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        BaseHDF4ImageReader.computeRegions((ImageReadParam)param, (int)width, (int)height, null, (Rectangle)srcRegion, (Rectangle)destRegion);
        int destWidth = destRegion.x + destRegion.width;
        int destHeight = destRegion.y + destRegion.height;
        LinkedList<Range> ranges = new LinkedList<Range>();
        for (int i = 0; i < rank; ++i) {
            int stride;
            int length;
            int first;
            switch (i) {
                case 1: {
                    first = srcRegion.x;
                    length = srcRegion.width;
                    stride = strideX;
                    break;
                }
                case 0: {
                    first = srcRegion.y;
                    length = srcRegion.height;
                    stride = strideY;
                    break;
                }
                default: {
                    first = 0;
                    length = numBands;
                    stride = 1;
                }
            }
            try {
                ranges.add(new Range(first, first + length - 1, stride));
                continue;
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
        Section sections = new Section(ranges);
        SampleModel sampleModel = wrapper.getSampleModel().createCompatibleSampleModel(destWidth, destHeight);
        ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        int size = destHeight * destWidth * numBands;
        Array array = null;
        try {
            array = variable.read(sections);
            DataBuffer dataBuffer = null;
            if (array instanceof ArrayByte) {
                dataBuffer = new DataBufferByte((byte[])array.get1DJavaArray(Byte.TYPE), size);
            } else if (array instanceof ArrayShort) {
                dataBuffer = new DataBufferShort((short[])array.get1DJavaArray(Short.TYPE), size);
            } else if (array instanceof ArrayInt) {
                dataBuffer = new DataBufferInt((int[])array.get1DJavaArray(Integer.TYPE), size);
            } else if (array instanceof ArrayFloat) {
                dataBuffer = new DataBufferFloat((float[])array.get1DJavaArray(Float.TYPE), size);
            } else if (array instanceof ArrayDouble) {
                dataBuffer = new DataBufferDouble((double[])array.get1DJavaArray(Double.TYPE), size);
            }
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, new Point(0, 0));
            image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        }
        catch (InvalidRangeException invalidRangeException) {
            // empty catch block
        }
        return image;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        return this.read2DVariable(imageIndex, param);
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        throw new UnsupportedOperationException("Change me as soon as possible to use corecommonimagemetadata");
    }

    public IIOMetadata getImageMetadata(int imageIndex, String metadataFormat) throws IOException {
        throw new UnsupportedOperationException("Change me as soon as possible to use corecommonimagemetadata");
    }

    protected class HDF4DatasetWrapper
    extends BaseVariableWrapper {
        private int numAttributes;

        public int getNumAttributes() {
            return this.numAttributes;
        }

        protected HDF4DatasetWrapper(Variable var) {
            super(var);
            this.numAttributes = var.getAttributes().size();
            int numBands = this.getNumBands();
            int width = this.getWidth();
            int height = this.getHeight();
            if (numBands == 3) {
                this.setSampleModel(new PixelInterleavedSampleModel(NetCDFUtilities.getRawDataType((VariableIF)var), width, height, numBands, width * numBands, new int[]{0, 1, 2}));
            } else {
                this.setSampleModel(new BandedSampleModel(NetCDFUtilities.getRawDataType((VariableIF)var), width, height, numBands));
            }
        }
    }
}

