/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.hdf4;

import it.geosolutions.imageio.plugins.hdf4.BaseHDF4ImageReader;
import it.geosolutions.imageio.plugins.hdf4.HDF4ImageReaderSpi;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf4.H4iosp;

public class HDF4ImageReaderProxy
extends BaseHDF4ImageReader {
    private BaseHDF4ImageReader wrappee;

    protected HDF4ImageReaderProxy(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        if (!(originatingProvider instanceof HDF4ImageReaderSpi)) {
            throw new IllegalArgumentException("The originatingProvider is not of type HDF4TeraScanImageReaderSpi but of type " + originatingProvider.getClass().toString());
        }
    }

    @Override
    public void dispose() {
        try {
            this.wrappee.dispose();
        }
        finally {
            this.wrappee = null;
        }
    }

    @Override
    public NetCDFUtilities.KeyValuePair getAttribute(int imageIndex, int attributeIndex) throws IOException {
        return this.wrappee.getAttribute(imageIndex, attributeIndex);
    }

    @Override
    public String getAttributeAsString(int imageIndex, String attributeName) {
        return this.wrappee.getAttributeAsString(imageIndex, attributeName);
    }

    @Override
    public String getAttributeAsString(int imageIndex, String attributeName, boolean isUnsigned) {
        return this.wrappee.getAttributeAsString(imageIndex, attributeName, isUnsigned);
    }

    @Override
    public NetCDFUtilities.KeyValuePair getGlobalAttribute(int attributeIndex) throws IOException {
        return this.wrappee.getGlobalAttribute(attributeIndex);
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return this.wrappee.getHeight(imageIndex);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return this.wrappee.getImageMetadata(imageIndex);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return this.wrappee.getImageTypes(imageIndex);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        return this.wrappee.getTileHeight(imageIndex);
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        return this.wrappee.getTileWidth(imageIndex);
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        return this.wrappee.getWidth(imageIndex);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        return this.wrappee.read(imageIndex, param);
    }

    public void reset() {
        this.wrappee.reset();
        this.wrappee = null;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        if (this.wrappee != null) {
            this.reset();
        }
        try {
            NetcdfDataset dataset = NetCDFUtilities.getDataset((Object)input);
            if (dataset != null) {
                if (!(dataset.getIosp() instanceof H4iosp)) {
                    throw new IllegalArgumentException("Provided dataset is not an HDF4 file");
                }
            } else {
                throw new IllegalArgumentException("Provided dataset is not an HDF4 file");
            }
            this.wrappee.setInput(input, seekForwardOnly, ignoreMetadata);
            this.wrappee.initialize();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Not a Valid Input", e);
        }
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, true);
    }

    @Override
    public void setInput(Object input) {
        this.setInput(input, true, true);
    }

    public BaseHDF4ImageReader getWrappee() {
        return this.wrappee;
    }

    @Override
    protected BaseHDF4ImageReader.HDF4DatasetWrapper getDatasetWrapper(int imageIndex) {
        return this.wrappee.getDatasetWrapper(imageIndex);
    }

    @Override
    protected void initializeProfile() throws IOException {
        this.wrappee.initializeProfile();
    }
}

