/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jpeg;

import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.plugins.jpeg.JpegJMagickImageReaderSpi;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.media.jai.ImageLayout;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;

public class JpegJMagickImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.jpeg");
    private File sourceFile;
    private final List<MagickImageAdapter> imagesLayouts = Collections.synchronizedList(new ArrayList());

    protected void finalize() throws Throwable {
        this.dispose();
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new JpegJMagickImageReaderReadParam();
    }

    public JpegJMagickImageReader(JpegJMagickImageReaderSpi originatingProvider) {
        super(originatingProvider);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("JpegJMagickImageReader Constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight(int imageIndex) throws IOException {
        List<MagickImageAdapter> list = this.imagesLayouts;
        synchronized (list) {
            this.checkImageIndex(imageIndex);
            return this.imagesLayouts.get(imageIndex).getLayout().getHeight(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth(int imageIndex) throws IOException {
        List<MagickImageAdapter> list = this.imagesLayouts;
        synchronized (list) {
            this.checkImageIndex(imageIndex);
            return this.imagesLayouts.get(imageIndex).getLayout().getWidth(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        List<MagickImageAdapter> list = this.imagesLayouts;
        synchronized (list) {
            this.checkImageIndex(imageIndex);
            ImageLayout layout = this.imagesLayouts.get(imageIndex).getLayout();
            return Collections.singletonList(new ImageTypeSpecifier(layout.getColorModel(null), layout.getSampleModel(null))).iterator();
        }
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        List<MagickImageAdapter> list = this.imagesLayouts;
        synchronized (list) {
            this.checkImageIndex(imageIndex);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Requesting imageMagick at index " + imageIndex + " with  ImageReadParam=" + param.toString());
            }
            int width = 0;
            int height = 0;
            MagickImageAdapter im = this.imagesLayouts.get(imageIndex);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Selected imageMagick adapter " + im.toString());
            }
            ImageLayout layout = im.getLayout();
            width = layout.getWidth(null);
            height = layout.getHeight(null);
            if (param == null) {
                param = this.getDefaultReadParam();
            }
            int dstWidth = -1;
            int dstHeight = -1;
            int srcRegionWidth = -1;
            int srcRegionHeight = -1;
            int srcRegionXOffset = 0;
            int srcRegionYOffset = 0;
            int xSubsamplingFactor = -1;
            int ySubsamplingFactor = -1;
            Rectangle srcRegion = param.getSourceRegion();
            if (srcRegion != null) {
                srcRegionWidth = (int)srcRegion.getWidth();
                srcRegionHeight = (int)srcRegion.getHeight();
                srcRegionXOffset = (int)srcRegion.getX();
                srcRegionYOffset = (int)srcRegion.getY();
                if (srcRegionXOffset < 0) {
                    srcRegionXOffset = 0;
                }
                if (srcRegionYOffset < 0) {
                    srcRegionYOffset = 0;
                }
                dstWidth = srcRegionWidth;
                if (srcRegionXOffset + srcRegionWidth > width) {
                    srcRegionWidth = width - srcRegionXOffset;
                }
                dstHeight = srcRegionHeight;
                if (srcRegionYOffset + srcRegionHeight > height) {
                    srcRegionHeight = height - srcRegionYOffset;
                }
                srcRegion = new Rectangle(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight);
            } else {
                dstWidth = width;
                dstHeight = height;
                srcRegionWidth = width;
                srcRegionHeight = height;
                srcRegionYOffset = 0;
                srcRegionXOffset = 0;
            }
            xSubsamplingFactor = param.getSourceXSubsampling();
            ySubsamplingFactor = param.getSourceYSubsampling();
            dstWidth = (dstWidth - 1) / xSubsamplingFactor + 1;
            dstHeight = (dstHeight - 1) / ySubsamplingFactor + 1;
            return MagickImageAdapter.magickImageToBufferedImage(im, srcRegion, dstWidth, dstHeight);
        }
    }

    private void checkImageIndex(int imageIndex) throws IOException {
        if (imageIndex > 0) {
            throw new IndexOutOfBoundsException();
        }
        assert (Thread.holdsLock(this.imagesLayouts));
        if (this.imagesLayouts.size() - 1 < imageIndex) {
            try {
                this.imagesLayouts.add(new MagickImageAdapter(new ImageInfo(this.sourceFile.getAbsolutePath())));
            }
            catch (MagickException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.setInput(input);
        super.setInput(this.sourceFile, seekForwardOnly, ignoreMetadata);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input);
        super.setInput(this.sourceFile, seekForwardOnly);
    }

    @Override
    public void setInput(Object input) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setInput on object " + input.toString());
        }
        if (input instanceof File) {
            this.sourceFile = (File)input;
        } else if (input instanceof FileImageInputStreamExt) {
            FileImageInputStreamExt imageIn = (FileImageInputStreamExt)input;
            this.sourceFile = imageIn.getFile();
        } else {
            throw new IllegalArgumentException("The input type provided is not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Disposing JpegJMagickImageReader");
        }
        List<MagickImageAdapter> list = this.imagesLayouts;
        synchronized (list) {
            for (MagickImageAdapter img : this.imagesLayouts) {
                img.dispose();
            }
        }
        super.dispose();
    }

    public static class MagickImageAdapter {
        private final ImageLayout layout;
        private final MagickImage imageMagick;

        public MagickImageAdapter(ImageInfo info) throws MagickException {
            this.imageMagick = new MagickImage(info);
            Dimension dim = this.imageMagick.getDimension();
            int w = dim.width;
            int h = dim.height;
            ImageLayout layout = new ImageLayout();
            layout.setWidth(w).setHeight(h).setSampleModel((SampleModel)new PixelInterleavedSampleModel(0, h, h, 3, 3 * dim.width, new int[]{0, 1, 2})).setColorModel((ColorModel)new ComponentColorModel(ColorSpace.getInstance(1004), false, false, 1, 0));
            this.layout = layout;
        }

        public ImageLayout getLayout() {
            return this.layout;
        }

        public void dispose() {
            this.imageMagick.destroyImages();
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("MagickImageAdapter={").append("\n");
            if (this.layout != null) {
                buff.append("ImageLayout " + this.layout.toString()).append("\n");
            }
            buff.append("sx=").append(this.imageMagick.toString());
            buff.append("}");
            return buff.toString();
        }

        public static WritableRaster JMagickToWritableRaster(MagickImage magickImage) throws IOException {
            try {
                Dimension dim = magickImage.getDimension();
                int size = dim.width * dim.height;
                byte[] pixxels = new byte[size * 3];
                magickImage.dispatchImage(0, 0, dim.width, dim.height, "RGB", pixxels);
                PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, dim.width, dim.height, 3, 3 * dim.width, new int[]{0, 1, 2});
                WritableRaster raster = Raster.createWritableRaster(sm, new DataBufferByte(pixxels, size, 0), null);
                return raster;
            }
            catch (MagickException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }

        public static BufferedImage magickImageToBufferedImage(MagickImage magickImage) throws IOException {
            WritableRaster raster = MagickImageAdapter.JMagickToWritableRaster(magickImage);
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1004), false, false, 1, 0);
            return new BufferedImage(cm, raster, false, null);
        }

        public static BufferedImage magickImageToBufferedImage(MagickImageAdapter image, Rectangle srcRegion, int dstWidth, int dstHeight) throws IOException {
            try {
                MagickImage im = srcRegion != null ? image.imageMagick.cropImage(srcRegion) : image.imageMagick;
                Dimension dim = im.getDimension();
                im = dim.width != dstWidth || dim.height != dstHeight ? im.sampleImage(dstWidth, dstHeight).sampleImage(dstWidth, dstHeight) : im;
                return MagickImageAdapter.magickImageToBufferedImage(im);
            }
            catch (MagickException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    public static class JpegJMagickImageReaderReadParam
    extends EnhancedImageReadParam {
        public static final int INTERPOLATION_NEAREST = 1;
        public static final int INTERPOLATION_BILINEAR = 2;
        private int interpolationType = 1;

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("JpegJMagickImageReaderReadParam={").append("\n");
            if (this.getSourceRegion() != null) {
                buff.append("SourceRegion" + this.getSourceMaxProgressivePass()).append("\n");
            }
            buff.append("sx=").append(this.getSourceXSubsampling()).append(" sy=").append(this.getSourceYSubsampling());
            buff.append("}");
            return buff.toString();
        }

        public Object clone() throws CloneNotSupportedException {
            JpegJMagickImageReaderReadParam retVal = new JpegJMagickImageReaderReadParam();
            retVal.setInterpolationType(this.getInterpolationType());
            retVal.setController(this.getController());
            retVal.setDestination(this.getDestination());
            retVal.setDestinationBands(this.getDestinationBands());
            retVal.setDestinationOffset(this.getDestinationOffset());
            retVal.setDestinationType(this.getDestinationType());
            retVal.setSourceBands(this.getSourceBands());
            retVal.setSourceProgressivePasses(this.getSourceMinProgressivePass(), this.getSourceNumProgressivePasses());
            retVal.setSourceRegion(this.getSourceRegion());
            retVal.setSourceSubsampling(this.getSourceXSubsampling(), this.getSourceYSubsampling(), this.getSubsamplingXOffset(), this.getSubsamplingYOffset());
            return retVal;
        }

        public final int getInterpolationType() {
            return this.interpolationType;
        }

        public final void setInterpolationType(int interpolationType) {
            this.interpolationType = interpolationType;
        }

        protected void intialize(ImageReadParam param) {
            if (param.hasController()) {
                this.setController(param.getController());
            }
            this.setSourceRegion(param.getSourceRegion());
            this.setSourceBands(param.getSourceBands());
            this.setDestinationBands(param.getDestinationBands());
            this.setDestination(param.getDestination());
            this.setDestinationOffset(param.getDestinationOffset());
            this.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
            this.setDestinationType(param.getDestinationType());
        }
    }
}

