/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KBox;
import it.geosolutions.imageio.plugins.jp2k.JP2KTreeController;
import it.geosolutions.imageio.plugins.jp2k.LazyJP2KBox;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.JP2KFileBox;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import kdu_jni.Jp2_family_src;
import kdu_jni.Jp2_input_box;
import kdu_jni.Jp2_locator;
import kdu_jni.KduException;

class JP2KFileWalker {
    private static final Logger LOGGER = Logger.getLogger("JP2KFileWalker");
    private boolean initialized;
    private DefaultTreeModel tree;
    private String fileName;
    private Jp2_family_src familySource;

    public JP2KFileWalker(String fileName) {
        this.fileName = fileName;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.familySource = new Jp2_family_src();
        Jp2_input_box inputBox = new Jp2_input_box();
        Jp2_locator locator = new Jp2_locator();
        List exceptions = Collections.emptyList();
        try {
            this.familySource.Open(this.fileName);
            JP2KFileBox box = new JP2KFileBox();
            this.tree = new DefaultTreeModel(box);
            JP2KTreeController controller = new JP2KTreeController(this.tree);
            this.tree.addTreeModelListener(controller);
            if (inputBox.Open(this.familySource, locator)) {
                this.parse(inputBox, box, 0);
            }
            controller.checkTreeConsistency();
            inputBox.Close();
        }
        catch (KduException e) {
            throw new RuntimeException("Error caused by a Kakadu exception during Box management! ", e);
        }
        finally {
            block19: {
                block18: {
                    try {
                        this.familySource.Close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block18;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (inputBox != null) {
                        inputBox.Close();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
        if (!exceptions.isEmpty()) {
            throw new IllegalStateException("Tree Check failed");
        }
    }

    private void parse(Jp2_input_box inputBox, JP2KBox parent, int index) throws KduException {
        Jp2_input_box childBox = new Jp2_input_box();
        try {
            int boxtype = (int)(0xFFFFFFFFFFFFFFFFL & inputBox.Get_box_type());
            String typeString = BoxUtilities.getTypeString(boxtype);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found box " + typeString);
            }
            LazyJP2KBox currentBox = null;
            if (BoxUtilities.boxNames.containsKey(boxtype)) {
                Jp2_locator locator = inputBox.Get_locator();
                currentBox = new LazyJP2KBox(this.fileName, boxtype, locator);
                parent.insert(currentBox, index++);
                this.tree.nodesWereInserted(parent, new int[]{index - 1});
            } else if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Box of type " + typeString + " cannot be handled by this file type reader");
            }
            if (BoxUtilities.SUPERBOX_NAMES.contains(typeString) && childBox.Open(inputBox)) {
                if (childBox.Exists()) {
                    this.parse(childBox, currentBox, 0);
                }
                childBox.Close();
            }
            inputBox.Close();
            if (inputBox.Open_next() && inputBox.Exists()) {
                this.parse(inputBox, parent, index);
            }
        }
        catch (KduException e) {
            throw new RuntimeException("Error caused by a Kakadu exception during Box management! ", e);
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (childBox != null) {
                            childBox.Close();
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block23;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (inputBox != null) {
                        inputBox.Close();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block24;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public synchronized TreeModel getJP2KBoxesTree() {
        this.init();
        return this.tree;
    }
}

