/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k.box;

import com.sun.media.imageioimpl.common.ImageUtil;
import it.geosolutions.imageio.plugins.jp2k.box.BaseJP2KBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.ColorSpecificationBox;
import java.awt.color.ICC_Profile;
import javax.imageio.metadata.IIOMetadataNode;

public class ColorSpecificationBoxMetadataNode
extends BaseJP2KBoxMetadataNode {
    private String method;
    private String precedence;
    private String approximationAccuracy;
    private String enumeratedColorSpace;
    private String iccProfile;
    private ICC_Profile profile;

    public ColorSpecificationBoxMetadataNode(ColorSpecificationBox box) {
        super(box);
        byte m = box.getMethod();
        byte approx = box.getApproximationAccuracy();
        byte prec = box.getPrecedence();
        int enumCS = box.getEnumeratedColorSpace();
        this.profile = box.getICCProfile();
        try {
            IIOMetadataNode child = new IIOMetadataNode("Method");
            child.setUserObject(m);
            this.method = Byte.toString(m);
            child.setNodeValue(this.method);
            this.appendChild(child);
            child = new IIOMetadataNode("Precedence");
            child.setUserObject(prec);
            this.precedence = Byte.toString(prec);
            child.setNodeValue(this.precedence);
            this.appendChild(child);
            child = new IIOMetadataNode("ApproximationAccuracy");
            child.setUserObject(approx);
            this.approximationAccuracy = Byte.toString(approx);
            child.setNodeValue(this.approximationAccuracy);
            this.appendChild(child);
            child = new IIOMetadataNode("EnumeratedColorSpace");
            child.setUserObject(enumCS);
            this.enumeratedColorSpace = Integer.toString(enumCS);
            child.setNodeValue(this.enumeratedColorSpace);
            this.appendChild(child);
            child = new IIOMetadataNode("ICCProfile");
            child.setUserObject(this.profile);
            child.setNodeValue(ImageUtil.convertObjectToString((Object)this.profile));
            this.appendChild(child);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("BoxMetadataNode0");
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getPrecedence() {
        return this.precedence;
    }

    public String getApproximationAccuracy() {
        return this.approximationAccuracy;
    }

    public String getEnumeratedColorSpace() {
        return this.enumeratedColorSpace;
    }

    public String getICCProfile() {
        return this.iccProfile;
    }
}

