/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.jp2k;

import it.geosolutions.imageio.plugins.jp2k.JP2KBox;
import it.geosolutions.imageio.plugins.jp2k.JP2KBoxMetadata;
import it.geosolutions.imageio.plugins.jp2k.box.ASOCBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.BoxUtilities;
import it.geosolutions.imageio.plugins.jp2k.box.JP2KFileBox;
import it.geosolutions.imageio.plugins.jp2k.box.LabelBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.UUIDBoxMetadataNode;
import it.geosolutions.imageio.plugins.jp2k.box.XMLBoxMetadataNode;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Node;

public class JP2KStreamMetadata
extends IIOMetadata {
    public static final String NUM_CODESTREAMS = "NumberOfCodestreams";
    public static final String nativeMetadataFormatName = "it_geosolutions_imageio_plugins_jp2k_StreamMetadata_1.0";
    private DefaultTreeModel treeModel;
    private int numCodestreams;
    private SoftReference<Node> nativeTreeNodeRef;

    public JP2KStreamMetadata(TreeModel treeModel, int numCodestreams) {
        JP2KFileBox box = (JP2KFileBox)treeModel.getRoot();
        if (box == null) {
            throw new IllegalArgumentException("Originating tree is empty");
        }
        this.numCodestreams = numCodestreams;
        JP2KFileBox root = (JP2KFileBox)box.clone();
        this.treeModel = new DefaultTreeModel(root);
        int childCount = box.getChildCount();
        int i = 0;
        while (i < childCount) {
            JP2KBox child = (JP2KBox)box.getChildAt(i);
            this.cloneTree(child, root, i++);
        }
    }

    private void cloneTree(JP2KBox toBeCloned, JP2KBox parent, int index) {
        JP2KBox currentBox = (JP2KBox)toBeCloned.clone();
        parent.insert(currentBox, index++);
        int childCount = toBeCloned.getChildCount();
        int i = 0;
        while (i < childCount) {
            JP2KBox child = (JP2KBox)toBeCloned.getChildAt(i);
            this.cloneTree(child, currentBox, i++);
        }
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equalsIgnoreCase(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        throw new IllegalArgumentException(formatName + " is not a supported format name");
    }

    private Node getNativeTree() {
        Node nativeTree;
        Node node = nativeTree = this.nativeTreeNodeRef == null ? null : this.nativeTreeNodeRef.get();
        if (nativeTree == null) {
            IIOMetadataNode node2 = new IIOMetadataNode(nativeMetadataFormatName);
            JP2KBoxMetadata root = (JP2KBoxMetadata)this.treeModel.getRoot();
            nativeTree = this.buildTree(root);
            node2.appendChild(nativeTree);
            this.nativeTreeNodeRef = new SoftReference<Node>(nativeTree);
        }
        return nativeTree;
    }

    private Node buildTree(JP2KBoxMetadata node) {
        IIOMetadataNode mdNode;
        if (node == null) {
            throw new IllegalArgumentException("Null node provided ");
        }
        switch (node.getType()) {
            case 2020437024: {
                mdNode = new XMLBoxMetadataNode(node);
                break;
            }
            case 1970628964: {
                mdNode = new UUIDBoxMetadataNode(node);
                break;
            }
            case 1634955107: {
                mdNode = new ASOCBoxMetadataNode(node);
                break;
            }
            case 1818389536: {
                mdNode = new LabelBoxMetadataNode(node);
                break;
            }
            case 1: {
                mdNode = node.getNativeNode();
                mdNode.setAttribute(NUM_CODESTREAMS, Integer.toString(0));
                break;
            }
            case 1785737827: {
                return null;
            }
            default: {
                mdNode = node.getNativeNode();
            }
        }
        int childCount = node.getChildCount();
        int i = 0;
        while (i < childCount) {
            Node appendMe;
            if ((appendMe = this.buildTree((JP2KBoxMetadata)node.getChildAt(i++))) == null) continue;
            mdNode.appendChild(appendMe);
        }
        return mdNode;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public IIOMetadataNode searchFirstOccurrenceNode(int requestedBoxType) {
        Node rootNode = this.getAsTree(nativeMetadataFormatName);
        ArrayList<IIOMetadataNode> returnedNodes = new ArrayList<IIOMetadataNode>(1);
        this.searchOccurrencesNode(rootNode, BoxUtilities.getName(requestedBoxType), returnedNodes, true);
        if (!returnedNodes.isEmpty()) {
            return (IIOMetadataNode)returnedNodes.get(0);
        }
        return null;
    }

    public List<IIOMetadataNode> searchOccurrencesNode(int requestedBoxType) {
        Node rootNode = this.getAsTree(nativeMetadataFormatName);
        ArrayList<IIOMetadataNode> returnedNodes = new ArrayList<IIOMetadataNode>(1);
        this.searchOccurrencesNode(rootNode, BoxUtilities.getName(requestedBoxType), returnedNodes, false);
        return returnedNodes;
    }

    private void searchOccurrencesNode(Node node, String requestedBoxType, List<IIOMetadataNode> returnedNodes, boolean exitFirstFound) {
        if (node != null) {
            if (node.getNodeName().equalsIgnoreCase(requestedBoxType)) {
                boolean sameNode = false;
                for (IIOMetadataNode foundNode : returnedNodes) {
                    if (foundNode != node) continue;
                    sameNode = true;
                    break;
                }
                if (!sameNode) {
                    returnedNodes.add((IIOMetadataNode)node);
                    if (exitFirstFound) {
                        return;
                    }
                }
            }
            if (node.hasChildNodes()) {
                this.searchOccurrencesNode(node.getFirstChild(), requestedBoxType, returnedNodes, exitFirstFound);
                if (returnedNodes != null && !returnedNodes.isEmpty() && exitFirstFound) {
                    return;
                }
                for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                    this.searchOccurrencesNode(sibling, requestedBoxType, returnedNodes, exitFirstFound);
                    if (returnedNodes == null || returnedNodes.isEmpty() || !exitFirstFound) continue;
                    return;
                }
            }
        }
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("MergeTree is unsupported");
    }

    @Override
    public void reset() {
    }
}

