/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import java.awt.image.SampleModel;
import ucar.nc2.Variable;

public abstract class BaseVariableWrapper {
    private Variable variable;
    private String name;
    private int width;
    private int height;
    private int tileHeight;
    private int tileWidth;
    private int rank;
    private int numBands;
    private SampleModel sampleModel;

    public void setSampleModel(SampleModel sampleModel) {
        this.sampleModel = sampleModel;
    }

    public BaseVariableWrapper(Variable variable) {
        this.variable = variable;
        this.rank = variable.getRank();
        this.width = variable.getDimension(this.rank - 1).getLength();
        this.height = variable.getDimension(this.rank - 2).getLength();
        this.numBands = this.rank > 2 ? variable.getDimension(2).getLength() : 1;
        this.tileHeight = this.height;
        this.tileWidth = this.width;
        this.name = variable.getName();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public int getRank() {
        return this.rank;
    }

    public String getName() {
        return this.name;
    }
}

