/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseNetCDFImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseVariableWrapper;
import it.geosolutions.imageio.plugins.netcdf.NetCDFImageMetadata;
import it.geosolutions.imageio.plugins.netcdf.NetCDFStreamMetadata;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;

public class NetCDFImageReader
extends BaseImageReader
implements CancelTask {
    protected static final Logger LOGGER = Logger.getLogger(NetCDFImageReader.class.toString());
    private NetCDFUtilities.CheckType checkType = NetCDFUtilities.CheckType.UNSET;
    private BaseNetCDFImageReader reader;
    private String lastError;

    BaseNetCDFImageReader getInnerReader() {
        return this.reader;
    }

    protected synchronized void initialize() {
        NetcdfDataset dataset;
        HashMap<Range, NetCDFVariableWrapper> indexMap;
        int numImages;
        block11: {
            numImages = 0;
            indexMap = new HashMap<Range, NetCDFVariableWrapper>();
            dataset = this.reader.getDataset();
            try {
                if (dataset != null) {
                    this.checkType = NetCDFUtilities.getCheckType((NetcdfDataset)dataset);
                    List variables = dataset.getVariables();
                    if (variables != null) {
                        for (Variable variable : variables) {
                            if (variable == null || !(variable instanceof VariableDS) || !NetCDFUtilities.isVariableAccepted((Variable)variable, (NetCDFUtilities.CheckType)this.checkType)) continue;
                            int[] shape = variable.getShape();
                            switch (shape.length) {
                                case 2: {
                                    indexMap.put(new Range(numImages, numImages + 1), new NetCDFVariableWrapper(variable));
                                    ++numImages;
                                    break;
                                }
                                case 3: {
                                    indexMap.put(new Range(numImages, numImages + shape[0]), new NetCDFVariableWrapper(variable));
                                    numImages += shape[0];
                                    break;
                                }
                                case 4: {
                                    indexMap.put(new Range(numImages, numImages + shape[0] * shape[1]), new NetCDFVariableWrapper(variable));
                                    numImages += shape[0] * shape[1];
                                }
                            }
                        }
                    }
                    break block11;
                }
                throw new IllegalArgumentException("Not a valid dataset has been found");
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException("Error occurred during NetCDF file parsing", e);
            }
        }
        this.reader.setIndexMap(indexMap);
        this.setNumImages(numImages);
        this.reader.setNumImages(numImages);
        int numAttribs = 0;
        List globalAttributes = dataset.getGlobalAttributes();
        if (globalAttributes != null && !globalAttributes.isEmpty()) {
            numAttribs = globalAttributes.size();
        }
        this.reader.setNumGlobalAttributes(numAttribs);
    }

    public NetCDFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        this.reader = new BaseNetCDFImageReader(originatingProvider);
    }

    protected NetCDFVariableWrapper getVariableWrapper(int imageIndex) {
        return (NetCDFVariableWrapper)this.reader.getVariableWrapper(imageIndex);
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return new NetCDFImageMetadata(this, imageIndex);
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return new NetCDFStreamMetadata(this);
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int[] dstBands;
        int[] srcBands;
        int strideY;
        int strideX;
        this.clearAbortRequest();
        Variable variable = null;
        Range indexRange = null;
        NetCDFVariableWrapper wrapper = null;
        Map indexMap = this.reader.getIndexMap();
        for (Range range : indexMap.keySet()) {
            if (!range.contains(imageIndex) || range.first() > imageIndex || imageIndex >= range.last()) continue;
            wrapper = (NetCDFVariableWrapper)((Object)indexMap.get(range));
            indexRange = range;
            break;
        }
        variable = wrapper.getVariable();
        if (param != null) {
            strideX = param.getSourceXSubsampling();
            strideY = param.getSourceYSubsampling();
            srcBands = param.getSourceBands();
            dstBands = param.getDestinationBands();
        } else {
            strideX = 1;
            strideY = 1;
            srcBands = null;
            dstBands = null;
        }
        int rank = wrapper.getRank();
        int bandDimension = rank - 3;
        int width = wrapper.getWidth();
        int height = wrapper.getHeight();
        Rectangle srcRegion = new Rectangle();
        Rectangle destRegion = new Rectangle();
        NetCDFImageReader.computeRegions((ImageReadParam)param, (int)width, (int)height, null, (Rectangle)srcRegion, (Rectangle)destRegion);
        int destWidth = destRegion.x + destRegion.width;
        int destHeight = destRegion.y + destRegion.height;
        LinkedList<Range> ranges = new LinkedList<Range>();
        for (int i = 0; i < rank; ++i) {
            int stride;
            int length;
            int first;
            switch (rank - i) {
                case 1: {
                    first = srcRegion.x;
                    length = srcRegion.width;
                    stride = strideX;
                    break;
                }
                case 2: {
                    first = srcRegion.y;
                    length = srcRegion.height;
                    stride = strideY;
                    break;
                }
                default: {
                    first = i == bandDimension ? NetCDFUtilities.getZIndex((Variable)variable, (Range)indexRange, (int)imageIndex) : NetCDFUtilities.getTIndex((Variable)variable, (Range)indexRange, (int)imageIndex);
                    length = 1;
                    stride = 1;
                }
            }
            try {
                ranges.add(new Range(first, first + length - 1, stride));
                continue;
            }
            catch (InvalidRangeException e) {
                throw this.netcdfFailure((Exception)((Object)e));
            }
        }
        Section sections = new Section(ranges);
        SampleModel sampleModel = wrapper.getSampleModel().createCompatibleSampleModel(destWidth, destHeight);
        ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        this.processImageStarted(imageIndex);
        boolean numDstBands = true;
        float toPercent = 100.0f;
        int type = raster.getSampleModel().getDataType();
        int xmin = destRegion.x;
        int ymin = destRegion.y;
        int xmax = destRegion.width + xmin;
        int ymax = destRegion.height + ymin;
        for (int zi = 0; zi < 1; ++zi) {
            Array array;
            int dstBand = dstBands == null ? zi : dstBands[zi];
            try {
                array = variable.read(sections);
            }
            catch (InvalidRangeException e) {
                throw this.netcdfFailure((Exception)((Object)e));
            }
            IndexIterator it = array.getIndexIterator();
            for (int y = ymin; y < ymax; ++y) {
                block17: for (int x = xmin; x < xmax; ++x) {
                    switch (type) {
                        case 5: {
                            raster.setSample(x, y, dstBand, it.getDoubleNext());
                            continue block17;
                        }
                        case 4: {
                            raster.setSample(x, y, dstBand, it.getFloatNext());
                            continue block17;
                        }
                        case 0: {
                            byte b = it.getByteNext();
                            raster.setSample(x, y, dstBand, b);
                            continue block17;
                        }
                        default: {
                            raster.setSample(x, y, dstBand, it.getIntNext());
                        }
                    }
                }
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                return image;
            }
            this.processImageProgress((float)zi * 100.0f);
        }
        if (this.lastError != null) {
            throw new IIOException(this.lastError);
        }
        this.processImageComplete();
        return image;
    }

    private IIOException netcdfFailure(Exception e) throws IOException {
        return new IIOException(new StringBuffer("Can't read file ").append(this.reader.getDataset().getLocation()).toString(), e);
    }

    public void dispose() {
        super.dispose();
        this.lastError = null;
        this.checkType = NetCDFUtilities.CheckType.UNSET;
        this.reader.dispose();
    }

    public void setError(String message) {
        this.lastError = message;
    }

    public boolean isCancel() {
        return this.abortRequested();
    }

    double getScale(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        double scale = Double.NaN;
        String scaleS = this.reader.getAttributeAsString(imageIndex, "scale_factor");
        if (scaleS != null && scaleS.trim().length() > 0) {
            scale = Double.parseDouble(scaleS);
        }
        return scale;
    }

    double getFillValue(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        double fillValue = Double.NaN;
        String fillValueS = this.reader.getAttributeAsString(imageIndex, "_FillValue");
        if (fillValueS != null && fillValueS.trim().length() > 0) {
            fillValue = Double.parseDouble(fillValueS);
        }
        return fillValue;
    }

    double getOffset(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        double offset = Double.NaN;
        String offsetS = this.reader.getAttributeAsString(imageIndex, "add_offset");
        if (offsetS != null && offsetS.trim().length() > 0) {
            offset = Double.parseDouble(offsetS);
        }
        return offset;
    }

    double[] getValidRange(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        double[] range = null;
        String validRange = this.reader.getAttributeAsString(imageIndex, "valid_range", true);
        if (validRange != null && validRange.trim().length() > 0) {
            String[] validRanges = validRange.split(",");
            if (validRanges.length == 2) {
                range = new double[]{Double.parseDouble(validRanges[0]), Double.parseDouble(validRanges[1])};
            }
        } else {
            String validMin = this.reader.getAttributeAsString(imageIndex, "valid_min", true);
            String validMax = this.reader.getAttributeAsString(imageIndex, "valid_max", true);
            if (validMax != null && validMax.trim().length() > 0 && validMin != null && validMin.trim().length() > 0) {
                range = new double[]{Double.parseDouble(validMin), Double.parseDouble(validMax)};
            }
        }
        return range;
    }

    CoordinateSystem getCoordinateSystem(Variable variable) {
        List systems;
        CoordinateSystem cs = null;
        if (variable != null && !(systems = ((VariableDS)variable).getCoordinateSystems()).isEmpty()) {
            cs = (CoordinateSystem)systems.get(0);
        }
        return cs;
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.reader.getHeight(imageIndex);
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return this.reader.getImageTypes(imageIndex);
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.reader.getWidth(imageIndex);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.reader.setInput(input, seekForwardOnly, ignoreMetadata);
        this.initialize();
    }

    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, false);
    }

    public void setInput(Object input) {
        this.setInput(input, false, false);
    }

    private static class NetCDFVariableWrapper
    extends BaseVariableWrapper {
        public NetCDFVariableWrapper(Variable variable) {
            super(variable);
            int bufferType = NetCDFUtilities.getRawDataType((VariableIF)variable);
            this.setSampleModel(new BandedSampleModel(bufferType, this.getWidth(), this.getHeight(), 1));
        }
    }
}

