/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.nitronitf;

import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageWriteParam;
import it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import nitf.Field;
import nitf.FieldType;
import nitf.NITFException;
import nitf.TRE;

public class NITFUtilities {
    static final int DEFAULT_TILE_WIDTH = 1024;
    static final int DEFAULT_TILE_HEIGHT = 1024;
    static final double[] BPPPB = new double[]{0.03125, 0.0625, 0.125, 0.25, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.5, 1.7, 2.0, 2.3, 3.5, 3.9, 0.0};
    static final double[] BPPPB_15_1 = new double[]{0.0125, 0.025, 0.0375, 0.05, 0.0625, 0.075, 0.1, 0.2, 0.3, 0.4, 0.41, 0.42, 0.43, 0.44, 0.45, 0.475, 0.5, 0.52, 0.5333333333333333};
    static final double[] BPPPB_19 = new double[]{0.03125, 0.0625, 0.125, 0.25, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.5, 1.7, 2.0, 2.3, 3.5, 3.9};
    private static final Logger LOGGER = Logger.getLogger("nitf.imageio.NITFUtilities");
    private static boolean available;
    private static boolean init;

    public static boolean isNITFAvailable() {
        NITFUtilities.loadNITF();
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNITF() {
        if (!init) {
            Logger logger = LOGGER;
            synchronized (logger) {
                if (init) {
                    return;
                }
                try {
                    System.loadLibrary("nitf.jni-c");
                    available = true;
                }
                catch (UnsatisfiedLinkError e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        StringBuilder sb = new StringBuilder("Failed to load the NITF native libs. This is not a problem unless you need to use the NITF plugins: they won't be enabled.").append(e.toString());
                        LOGGER.warning(sb.toString());
                    }
                    available = false;
                }
                finally {
                    init = true;
                }
            }
        }
    }

    public static JP2KKakaduImageWriteParam getCompressionParam(JP2KKakaduImageWriter kakaduWriter, WriteCompression compression, boolean isMulti) {
        JP2KKakaduImageWriteParam param = (JP2KKakaduImageWriteParam)kakaduWriter.getDefaultWriteParam();
        param.setsProfile(1);
        if (compression.getCompression() == JP2KKakaduImageWriteParam.Compression.NUMERICALLY_LOSSLESS) {
            // empty if block
        }
        param.setQualityLayers(compression.getQualityLayers());
        param.setQualityLayersBitRates(compression.getBitRates());
        param.setCompression(compression.getCompression());
        param.setCompressionMode(2);
        param.setCLevels(5);
        if (compression.toString().startsWith("EPJE")) {
            param.setcOrder(JP2KKakaduImageWriteParam.ProgressionOrder.RLCP);
        } else {
            param.setcOrder(JP2KKakaduImageWriteParam.ProgressionOrder.LRCP);
        }
        param.setTilingMode(2);
        param.setTiling(1024, 1024, 0, 0);
        param.setOrgGen_plt(true);
        param.setOrgGen_tlm(1);
        param.setWriteCodeStreamOnly(true);
        return param;
    }

    public static void setTREField(TRE tre, String fieldName, String fieldValue, boolean doValidation) throws NITFException {
        Field field = tre.getField(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("The specified field " + fieldName + " doesn't exist in the specified TRE " + tre.getTag());
        }
        if (doValidation) {
            NITFUtilities.validateField(fieldName, field, fieldValue);
        }
        field.setData(fieldValue);
    }

    public static void setTREFieldDirect(TRE tre, String fieldName, String fieldValue) throws NITFException {
        tre.setField(fieldName, fieldValue);
    }

    private static void validateField(String fieldName, Field field, String fieldValue) {
        if (fieldValue == null || fieldValue.length() == 0) {
            throw new IllegalArgumentException("The value specified for field " + fieldName + " is " + (fieldValue == null ? "null" : "empty"));
        }
        NITFUtilities.validateField(fieldName, field, fieldValue.getBytes());
    }

    private static void validateField(String fieldName, Field field, byte[] fieldValue) {
        if (fieldValue == null || fieldValue.length == 0) {
            throw new IllegalArgumentException("The value specified for field " + fieldName + " is " + (fieldValue == null ? "null" : "empty"));
        }
        int valueLength = fieldValue.length;
        long length = field.getLength();
        if ((long)valueLength > length) {
            throw new IllegalArgumentException("The specified field " + fieldName + " size is " + length + " whilst the specified value is " + valueLength + " bytes length");
        }
        if (!NITFUtilities.isValid(field, fieldValue)) {
            throw new IllegalArgumentException("The value specified for the field " + fieldName + " doesn't respect the field's type " + field.getType());
        }
    }

    private static boolean isValid(Field field, byte[] fieldValue) {
        FieldType type = field.getType();
        if (type.equals((Object)FieldType.NITF_BCS_N)) {
            for (byte b : fieldValue) {
                if (b <= 57 && b >= 48 || b == 43 || b == 45 || b == 46 || b == 47) continue;
                return false;
            }
        }
        if (type.equals((Object)FieldType.NITF_BCS_A)) {
            for (byte b : fieldValue) {
                if (b <= 126 && b >= 32) continue;
                return false;
            }
        }
        return true;
    }

    public static void setField(String fieldName, Field field, String fieldValue) {
        NITFUtilities.setField(fieldName, field, fieldValue, true);
    }

    public static void setField(String fieldName, Field field, byte[] fieldValue) {
        NITFUtilities.setField(fieldName, field, fieldValue, true);
    }

    public static void setField(String fieldName, Field field, String fieldValue, boolean doValidation) {
        if (doValidation) {
            NITFUtilities.validateField(fieldName, field, fieldValue);
        }
        field.setData(fieldValue);
    }

    public static void setField(String fieldName, Field field, byte[] fieldValue, boolean doValidation) {
        if (doValidation) {
            NITFUtilities.validateField(fieldName, field, fieldValue);
        }
        field.setRawData(fieldValue);
    }

    static {
        init = false;
    }

    public static class Consts {
        public static final String NONE = "N";
        public static final String ZERO = "0";
        public static final String ONE = "1";
        public static final String EIGHT = "8";
        public static final String DEFAULT_SECURITY_CLASSIFICATION_SYSTEM = "US";
        public static final String DEFAULT_SECURITY_CLASSIFICATION = "U";
        public static final int DEFAULT_ENCRYPTED = 0;
        public static final String DEFAULT_FILE_HEADER = "NITF";
        public static final String DEFAULT_FILE_VERSION = "02.10";
        public static final String DEFAULT_SYSTEM_TYPE = "BF01";
        public static final String DEFAULT_PVTYPE = "INT";
        public static final String DEFAULT_PJUST = "R";
        public static final String DEFAULT_IMODE = "B";
        public static final String COMPRESSION_JP2 = "C8";
        public static final String COMPRESSION_NONE = "NC";
        public static final String COMPRESSION_V039 = "V039";
        public static final String COMPRESSION_L005 = "L005";

        private Consts() {
        }
    }

    public static enum WriteCompression {
        UNCOMPRESSED{

            @Override
            double[] getBitRates() {
                return null;
            }

            @Override
            int getQualityLayers() {
                return 1;
            }

            @Override
            JP2KKakaduImageWriteParam.Compression getCompression() {
                return JP2KKakaduImageWriteParam.Compression.UNDEFINED;
            }
        }
        ,
        NPJE_VL{

            @Override
            double[] getBitRates() {
                return BPPPB_19;
            }

            @Override
            int getQualityLayers() {
                return BPPPB_19.length;
            }

            @Override
            JP2KKakaduImageWriteParam.Compression getCompression() {
                return JP2KKakaduImageWriteParam.Compression.LOSSY;
            }
        }
        ,
        EPJE_VL{

            @Override
            double[] getBitRates() {
                return BPPPB_19;
            }

            @Override
            int getQualityLayers() {
                return BPPPB_19.length;
            }

            @Override
            JP2KKakaduImageWriteParam.Compression getCompression() {
                return JP2KKakaduImageWriteParam.Compression.LOSSY;
            }
        }
        ,
        NPJE_NL{

            @Override
            double[] getBitRates() {
                return BPPPB;
            }

            @Override
            int getQualityLayers() {
                return BPPPB.length;
            }

            @Override
            JP2KKakaduImageWriteParam.Compression getCompression() {
                return JP2KKakaduImageWriteParam.Compression.NUMERICALLY_LOSSLESS;
            }
        }
        ,
        EPJE_NL{

            @Override
            double[] getBitRates() {
                return BPPPB;
            }

            @Override
            int getQualityLayers() {
                return BPPPB.length;
            }

            @Override
            JP2KKakaduImageWriteParam.Compression getCompression() {
                return JP2KKakaduImageWriteParam.Compression.NUMERICALLY_LOSSLESS;
            }
        }
        ,
        RATIO_15_1{

            @Override
            double[] getBitRates() {
                return BPPPB_15_1;
            }

            @Override
            int getQualityLayers() {
                return BPPPB_15_1.length;
            }

            @Override
            JP2KKakaduImageWriteParam.Compression getCompression() {
                return JP2KKakaduImageWriteParam.Compression.LOSSY;
            }
        };


        abstract double[] getBitRates();

        abstract int getQualityLayers();

        abstract JP2KKakaduImageWriteParam.Compression getCompression();
    }
}

