/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;

public final class RasterShortGrayAlphaProvider
extends AbstractScanlineProvider {
    final short[] shorts;
    final boolean alphaFirst;

    public RasterShortGrayAlphaProvider(Raster raster) {
        super(raster, 16, raster.getWidth() * 4, 2);
        this.shorts = ((DataBufferUShort)raster.getDataBuffer()).getData();
        int[] bandOffsets = ((PixelInterleavedSampleModel)raster.getSampleModel()).getBandOffsets();
        this.alphaFirst = bandOffsets[0] != 0;
    }

    @Override
    public void next(byte[] scanline, int offset, int length) {
        int shortsIdx = this.cursor.next();
        int i = offset;
        int max = offset + length;
        if (this.alphaFirst) {
            while (i < max) {
                short alpha = this.shorts[shortsIdx++];
                short gray = this.shorts[shortsIdx++];
                scanline[i++] = (byte)(gray >> 8 & 0xFF);
                scanline[i++] = (byte)(gray & 0xFF);
                scanline[i++] = (byte)(alpha >> 8 & 0xFF);
                scanline[i++] = (byte)(alpha & 0xFF);
            }
        } else {
            while (i < max) {
                short gray = this.shorts[shortsIdx++];
                short alpha = this.shorts[shortsIdx++];
                scanline[i++] = (byte)(gray >> 8 & 0xFF);
                scanline[i++] = (byte)(gray & 0xFF);
                scanline[i++] = (byte)(alpha >> 8 & 0xFF);
                scanline[i++] = (byte)(alpha & 0xFF);
            }
        }
    }
}

