/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.ScanlineCursor;
import it.geosolutions.imageio.plugins.png.ScanlineProvider;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;

public abstract class AbstractScanlineProvider
implements ScanlineProvider {
    protected final int width;
    protected final int height;
    protected final int scanlineLength;
    protected final ScanlineCursor cursor;
    protected final IndexColorModel palette;
    protected final byte bitDepth;
    protected int currentRow = 0;

    public AbstractScanlineProvider(Raster raster, int bitDepth, int scanlineLength, int pixelStride) {
        this(raster, (byte)bitDepth, scanlineLength, pixelStride, (IndexColorModel)null);
    }

    public AbstractScanlineProvider(Raster raster, int bitDepth, int scanlineLength, int pixelStride, IndexColorModel palette) {
        this(raster, (byte)bitDepth, scanlineLength, pixelStride, palette);
    }

    protected AbstractScanlineProvider(Raster raster, byte bitDepth, int scanlineLength, int pixelStride, IndexColorModel palette) {
        this.width = raster.getWidth();
        this.height = raster.getHeight();
        this.bitDepth = bitDepth;
        this.palette = palette;
        this.cursor = new ScanlineCursor(raster, pixelStride);
        this.scanlineLength = scanlineLength;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final byte getBitDepth() {
        return this.bitDepth;
    }

    @Override
    public final IndexColorModel getPalette() {
        return this.palette;
    }

    @Override
    public final int getScanlineLength() {
        return this.scanlineLength;
    }

    public void readFromPngRaw(byte[] raw, int len, int offset, int step) {
        throw new UnsupportedOperationException("This bridge works write only");
    }

    public void endReadFromPngRaw() {
        throw new UnsupportedOperationException("This bridge works write only");
    }

    public void writeToPngRaw(byte[] raw) {
        this.next(raw, 1, raw.length - 1);
    }

    public static int computePixelStride(Raster raster, int[] expectedPixelStrides, boolean hasAlpha) {
        int pixelStride = ((ComponentSampleModel)raster.getSampleModel()).getPixelStride();
        if (raster.getNumBands() != pixelStride) {
            return pixelStride;
        }
        return expectedPixelStrides.length == 2 && hasAlpha ? expectedPixelStrides[1] : expectedPixelStrides[0];
    }

    public static int computePixelStride(Raster raster, int[] expectedPixelStrides) {
        return AbstractScanlineProvider.computePixelStride(raster, expectedPixelStrides, false);
    }
}

