/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.plugins.netcdf.NetCDFConverterUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.media.jai.JAI;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class NCOMConverter {
    private static final ArrayList<String> VARIABLES = new ArrayList(14);
    private static final int NUMVARS;
    private static final String fileNameIn = "E:\\Work\\data\\rixen\\lsvc08\\NRL\\NCOM\\20080929\\temp_m08_nest0_20080929.nc";
    private static final String fileNameOut = "E:/work/data/rixen/converted/converted_temp_m08_nest0_20080929.nc";

    public static void main(String[] args) throws IOException {
        NCOMConverter converter = new NCOMConverter();
        String fileNameIn = fileNameIn;
        String fileNameOut = fileNameOut;
        converter.run(fileNameIn, fileNameOut);
    }

    private void run(String fileNameIn, String fileNameOut) {
        try {
            File fileIn = new File(fileNameIn);
            NetcdfFile ncFileIn = NetcdfFile.open((String)fileNameIn);
            File fileOut = new File(fileNameOut);
            File outputFile = File.createTempFile(fileIn.getName(), ".tmp");
            NetcdfFileWriteable ncFileOut = NetcdfFileWriteable.createNew((String)outputFile.getAbsolutePath());
            boolean hasDepth = false;
            Dimension timeDim0 = ncFileIn.findDimension("time");
            int nTimes = timeDim0.getLength();
            Dimension latDim0 = ncFileIn.findDimension("lat");
            int nLat = latDim0.getLength();
            Dimension lonDim0 = ncFileIn.findDimension("lon");
            int nLon = lonDim0.getLength();
            Variable timeOriginalVar = ncFileIn.findVariable("time");
            Array timeOriginalData = timeOriginalVar.read();
            Index timeOriginalIndex = timeOriginalData.getIndex();
            DataType timeDataType = timeOriginalVar.getDataType();
            Variable lonOriginalVar = ncFileIn.findVariable("lon");
            DataType lonDataType = lonOriginalVar.getDataType();
            Variable latOriginalVar = ncFileIn.findVariable("lat");
            DataType latDataType = latOriginalVar.getDataType();
            Array latOriginalData = latOriginalVar.read();
            Array lonOriginalData = lonOriginalVar.read();
            Array depthOriginalData = null;
            int nDepths = 0;
            Array depth1Data = null;
            Dimension depthDim = null;
            DataType depthDataType = null;
            Variable depthOriginalVar = ncFileIn.findVariable("depth");
            if (depthOriginalVar != null) {
                nDepths = depthOriginalVar.getDimension(0).getLength();
                depthOriginalData = depthOriginalVar.read();
                depthDataType = depthOriginalVar.getDataType();
                hasDepth = true;
            }
            Dimension timeDim = ncFileOut.addDimension("time", nTimes);
            Dimension latDim = ncFileOut.addDimension("lat", nLat);
            Dimension lonDim = ncFileOut.addDimension("lon", nLon);
            if (hasDepth) {
                depthDim = ncFileOut.addDimension("depth", nDepths);
            }
            NetCDFConverterUtilities.copyGlobalAttributes(ncFileOut, ncFileIn.getGlobalAttributes());
            Variable timeVar = ncFileOut.addVariable("time", timeDataType, new Dimension[]{timeDim});
            NetCDFConverterUtilities.setVariableAttributes(timeOriginalVar, ncFileOut, new String[]{"long_name"});
            ncFileOut.addVariableAttribute("time", "long_name", "time");
            ncFileOut.addVariable("lat", latDataType, new Dimension[]{latDim});
            NetCDFConverterUtilities.setVariableAttributes(latOriginalVar, ncFileOut);
            ncFileOut.addVariable("lon", lonDataType, new Dimension[]{lonDim});
            NetCDFConverterUtilities.setVariableAttributes(lonOriginalVar, ncFileOut);
            if (hasDepth) {
                ncFileOut.addVariable("depth", depthDataType, new Dimension[]{depthDim});
                NetCDFConverterUtilities.setVariableAttributes(depthOriginalVar, ncFileOut);
            }
            Array lat1Data = NetCDFConverterUtilities.getArray(nLat, latDataType);
            NetCDFConverterUtilities.setData1D(latOriginalData, lat1Data, latDataType, nLat, true);
            Array lon1Data = NetCDFConverterUtilities.getArray(nLon, lonDataType);
            NetCDFConverterUtilities.setData1D(lonOriginalData, lon1Data, lonDataType, nLon, false);
            if (hasDepth) {
                depth1Data = NetCDFConverterUtilities.getArray(nDepths, depthDataType);
                NetCDFConverterUtilities.setData1D(depthOriginalData, depth1Data, depthDataType, nDepths, false);
            }
            ArrayList<String> variables = new ArrayList<String>(5);
            HashMap<String, String> updatingValidRange = new HashMap<String, String>(5);
            int numVars = 0;
            for (int i = 0; i < NUMVARS; ++i) {
                String varName = VARIABLES.get(i);
                Variable var = ncFileIn.findVariable(varName);
                if (var == null) continue;
                variables.add(varName);
                List dims = var.getDimensions();
                boolean hasLocalDepth = false;
                for (Dimension dim : dims) {
                    if (!dim.getName().equalsIgnoreCase("depth")) continue;
                    hasLocalDepth = true;
                    break;
                }
                if (hasDepth && hasLocalDepth) {
                    ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, depthDim, latDim, lonDim});
                } else {
                    ncFileOut.addVariable(varName, var.getDataType(), new Dimension[]{timeDim, latDim, lonDim});
                }
                Attribute validRange = var.findAttribute("valid_max");
                if (validRange != null) {
                    validRange = var.findAttribute("valid_min");
                }
                if (validRange == null) {
                    validRange = var.findAttribute("valid_range");
                }
                if (validRange == null) {
                    updatingValidRange.put(varName, "");
                    ArrayShort range = new ArrayShort(new int[]{2});
                    Index index = range.getIndex();
                    range.setShort(index.set(0), (short)Short.MIN_VALUE);
                    range.setShort(index.set(1), (short)Short.MAX_VALUE);
                    ncFileOut.addVariableAttribute(varName, "valid_range", (Array)range);
                }
                NetCDFConverterUtilities.setVariableAttributes(var, ncFileOut);
                ++numVars;
            }
            ncFileOut.create();
            ArrayFloat timeData = new ArrayFloat(new int[]{timeDim.getLength()});
            Index timeIndex = timeData.getIndex();
            for (int t = 0; t < timeDim.getLength(); ++t) {
                timeData.setFloat(timeIndex.set(t), timeOriginalData.getFloat(timeOriginalIndex.set(t)));
            }
            ncFileOut.write("time", (Array)timeData);
            timeVar = ncFileOut.findVariable("time");
            timeDim.addCoordinateVariable(timeVar);
            ncFileOut.write("lat", lat1Data);
            ncFileOut.write("lon", lon1Data);
            if (hasDepth) {
                Variable depthVar = ncFileOut.findVariable("depth");
                depthDim.addCoordinateVariable(depthVar);
                ncFileOut.write("depth", depth1Data);
            }
            for (int i = 0; i < numVars; ++i) {
                String varName = (String)variables.get(i);
                Variable var = ncFileIn.findVariable(varName);
                boolean hasLocalDepth = NetCDFConverterUtilities.hasThisDimension(var, "depth");
                Array originalVarArray = var.read();
                DataType varDataType = var.getDataType();
                Array destArray = null;
                int[] dimensions = null;
                dimensions = hasDepth && hasLocalDepth ? new int[]{timeDim.getLength(), depthDim.getLength(), latDim.getLength(), lonDim.getLength()} : new int[]{timeDim.getLength(), latDim.getLength(), lonDim.getLength()};
                destArray = NetCDFConverterUtilities.getArray(dimensions, varDataType);
                boolean findNewRange = updatingValidRange.containsKey(varName);
                boolean setDepth = hasDepth && hasLocalDepth;
                int[] loopLengths = setDepth ? new int[]{nTimes, nDepths, nLat, nLon} : new int[]{nTimes, nLat, nLon};
                NetCDFConverterUtilities.writeData(ncFileOut, varName, var, originalVarArray, destArray, findNewRange, false, loopLengths, true);
            }
            ncFileOut.close();
            outputFile.renameTo(fileOut);
        }
        catch (Exception e) {
            if (NetCDFConverterUtilities.LOGGER.isLoggable(Level.INFO)) {
                NetCDFConverterUtilities.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
    }

    static {
        VARIABLES.add("surf_atm_press");
        VARIABLES.add("surf_temp_flux");
        VARIABLES.add("surf_salt_flux");
        VARIABLES.add("surf_solar_flux");
        VARIABLES.add("surf_roughness");
        VARIABLES.add("surf_wnd_stress_grid_x");
        VARIABLES.add("surf_wnd_stress_grid_y");
        VARIABLES.add("surf_el");
        VARIABLES.add("water_u");
        VARIABLES.add("water_v");
        VARIABLES.add("water_w");
        VARIABLES.add("water_temp");
        VARIABLES.add("salinity");
        NUMVARS = VARIABLES.size();
    }
}

