/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.jaiext.affine.AffineDescriptor;
import it.geosolutions.jaiext.affine.TestAffine;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.testclasses.TestData;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.Test;

public class ImageRGBTest
extends TestAffine {
    private int imageWidth;
    private int imageHeigth;
    private Logger logger = Logger.getLogger(ImageRGBTest.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolation() {
        boolean bicubic2Disabled = true;
        boolean useROIAccessor = true;
        boolean roiUsed = true;
        boolean setDestinationNoData = true;
        TIFFImageReader reader = null;
        ImageInputStreamImpl stream_in = null;
        try {
            reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
            File inputFile = TestData.file((Object)((Object)this), (String)"testImageLittle.tif");
            stream_in = new FileImageInputStream(inputFile);
            reader.setInput((Object)stream_in);
            RenderedImage image = reader.readAsRenderedImage(0, null);
            this.imageWidth = image.getWidth();
            this.imageHeigth = image.getHeight();
            int dataType = image.getSampleModel().getDataType();
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, setDestinationNoData, dataType, TestBase.InterpolationType.NEAREST_INTERP, TestBase.ScaleType.MAGNIFY);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, setDestinationNoData, dataType, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.ScaleType.MAGNIFY);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, setDestinationNoData, dataType, TestBase.InterpolationType.BICUBIC_INTERP, TestBase.ScaleType.MAGNIFY);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, setDestinationNoData, dataType, TestBase.InterpolationType.NEAREST_INTERP, TestBase.ScaleType.REDUCTION);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, setDestinationNoData, dataType, TestBase.InterpolationType.BILINEAR_INTERP, TestBase.ScaleType.REDUCTION);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, setDestinationNoData, dataType, TestBase.InterpolationType.BICUBIC_INTERP, TestBase.ScaleType.REDUCTION);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.dispose();
                }
            }
            catch (Exception e) {}
            try {
                if (stream_in != null) {
                    stream_in.flush();
                    ((FileImageInputStream)stream_in).close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected ROIShape roiCreation() {
        int roiHeight = this.imageHeigth / 2;
        int roiWidth = this.imageWidth / 2;
        Rectangle roiBound = new Rectangle(0, 0, roiWidth, roiHeight);
        ROIShape roi = new ROIShape((Shape)roiBound);
        return roi;
    }

    private void testImage(RenderedImage sourceImage, boolean useROIAccessor, boolean roiUsed, boolean bicubic2Disabled, boolean setDestinationNoData, int dataType, TestBase.InterpolationType interpType, TestBase.ScaleType scaleValue) {
        if (scaleValue == TestBase.ScaleType.REDUCTION) {
            this.scaleX = 0.5f;
            this.scaleY = 0.5f;
        } else {
            this.scaleX = 1.5f;
            this.scaleY = 1.5f;
        }
        RenderingHints hints = null;
        ROIShape roi = null;
        if (roiUsed) {
            if (useROIAccessor) {
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)0));
            }
            roi = this.roiCreation();
        } else {
            useROIAccessor = false;
        }
        this.destinationNoData = 255.0;
        AffineTransform transform = AffineTransform.getQuadrantRotateInstance(this.numquadrants, this.anchorX, this.anchorY);
        transform.concatenate(AffineTransform.getScaleInstance(this.scaleX, this.scaleY));
        transform.concatenate(AffineTransform.getTranslateInstance(this.transX, this.transY));
        InterpolationNearest interp = null;
        switch (interpType) {
            case NEAREST_INTERP: {
                interp = new InterpolationNearest(null, useROIAccessor, this.destinationNoData, dataType);
                break;
            }
            case BILINEAR_INTERP: {
                interp = new InterpolationBilinear(8, null, useROIAccessor, this.destinationNoData, dataType);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                    break;
                }
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                break;
            }
            case BICUBIC_INTERP: {
                interp = new InterpolationBicubic(8, null, useROIAccessor, this.destinationNoData, dataType, bicubic2Disabled, 8);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                    break;
                }
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                break;
            }
        }
        RenderedOp destinationIMG = AffineDescriptor.create((RenderedImage)sourceImage, (AffineTransform)transform, (Interpolation)interp, null, (ROI)roi, (boolean)useROIAccessor, (boolean)setDestinationNoData, null, (RenderingHints)hints);
        if (INTERACTIVE && TEST_SELECTOR.intValue() == interpType.getType() && INVERSE_SCALE.intValue() == scaleValue.getType()) {
            RenderedImageBrowser.showChain((RenderedImage)destinationIMG, (boolean)false, (boolean)roiUsed);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ((PlanarImage)destinationIMG).getTiles();
        }
        int minTileX = destinationIMG.getMinTileX();
        int tileNumX = destinationIMG.getNumXTiles();
        int minTileY = destinationIMG.getMinTileY();
        Raster simpleTile = destinationIMG.getTile(minTileX + tileNumX - 1, minTileY + 1);
        int tileMinX = simpleTile.getMinX();
        int tileMinY = simpleTile.getMinY();
        int tileWidth = simpleTile.getWidth();
        int tileHeight = simpleTile.getHeight();
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        for (int i = tileMinY; i < tileMinY + tileHeight; ++i) {
            for (int j = tileMinX; j < tileMinX + tileWidth; ++j) {
                int value = simpleTile.getSample(j, i, 0);
                if (value > maxValue) {
                    maxValue = value;
                }
                if (value >= minValue) continue;
                minValue = value;
            }
        }
        Assert.assertFalse((minValue == maxValue ? 1 : 0) != 0);
        Assert.assertFalse((minValue == Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertFalse((maxValue == Integer.MIN_VALUE ? 1 : 0) != 0);
        int value = simpleTile.getSample(simpleTile.getMinX() + simpleTile.getWidth() / 2, simpleTile.getMinY() + simpleTile.getHeight() / 4, 0);
        Assert.assertFalse((value == (int)this.destinationNoData ? 1 : 0) != 0);
        Assert.assertEquals((long)((int)((float)this.imageWidth * this.scaleX)), (long)destinationIMG.getHeight());
        Assert.assertEquals((long)((int)((float)this.imageHeigth * this.scaleY)), (long)destinationIMG.getWidth());
        if (destinationIMG instanceof RenderedOp) {
            destinationIMG.dispose();
        }
    }
}

