/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import it.geosolutions.jaiext.affine.AffineDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;

public class TestAffine
extends TestBase {
    protected int numquadrants = 1;
    protected double anchorX = 0.0;
    protected double anchorY = DEFAULT_HEIGHT - 1;
    public static Integer TRANSFORMATION_SELECTOR = Integer.getInteger("JAI.Ext.TransformationSelector");
    protected float transY = -DEFAULT_HEIGHT;

    protected <T extends Number> void testImageAffine(RenderedImage sourceImage, int dataType, T noDataValue, boolean useROIAccessor, boolean isBinary, boolean bicubic2Disabled, boolean noDataRangeUsed, boolean roiPresent, boolean setDestinationNoData, TestBase.TransformationType transformType, TestBase.InterpolationType interpType, TestBase.TestSelection testSelect, TestBase.ScaleType scaleValue) {
        if (scaleValue == TestBase.ScaleType.REDUCTION) {
            this.scaleX = 0.5f;
            this.scaleY = 0.5f;
        } else {
            this.scaleX = 1.5f;
            this.scaleY = 1.5f;
        }
        Range noDataRange = null;
        if (noDataRangeUsed && !isBinary) {
            switch (dataType) {
                case 0: {
                    noDataRange = RangeFactory.create((byte)noDataValue.byteValue(), (boolean)true, (byte)noDataValue.byteValue(), (boolean)true);
                    break;
                }
                case 1: {
                    noDataRange = RangeFactory.create((short)noDataValue.shortValue(), (boolean)true, (short)noDataValue.shortValue(), (boolean)true);
                    break;
                }
                case 2: {
                    noDataRange = RangeFactory.create((short)noDataValue.shortValue(), (boolean)true, (short)noDataValue.shortValue(), (boolean)true);
                    break;
                }
                case 3: {
                    noDataRange = RangeFactory.create((int)noDataValue.intValue(), (boolean)true, (int)noDataValue.intValue(), (boolean)true);
                    break;
                }
                case 4: {
                    noDataRange = RangeFactory.create((float)noDataValue.floatValue(), (boolean)true, (float)noDataValue.floatValue(), (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    noDataRange = RangeFactory.create((double)noDataValue.doubleValue(), (boolean)true, (double)noDataValue.doubleValue(), (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        ROIShape roi = null;
        if (roiPresent) {
            roi = this.roiCreation();
        }
        RenderingHints hints = null;
        if (useROIAccessor) {
            hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)0));
        }
        AffineTransform transform = null;
        if (transformType == TestBase.TransformationType.ROTATE_OP) {
            transform = AffineTransform.getQuadrantRotateInstance(this.numquadrants, this.anchorX, this.anchorY);
        } else if (transformType == TestBase.TransformationType.SCALE_OP) {
            transform = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
        } else if (transformType == TestBase.TransformationType.TRANSLATE_OP) {
            this.transX = DEFAULT_WIDTH;
            this.transY = 0.0f;
            transform = AffineTransform.getTranslateInstance(this.transX, this.transY);
        } else if (transformType == TestBase.TransformationType.ALL) {
            this.transX = 0.0f;
            this.transY = -DEFAULT_HEIGHT;
            transform = AffineTransform.getQuadrantRotateInstance(this.numquadrants, this.anchorX, this.anchorY);
            transform.concatenate(AffineTransform.getScaleInstance(this.scaleX, this.scaleY));
            transform.concatenate(AffineTransform.getTranslateInstance(this.transX, this.transY));
        } else {
            transform = new AffineTransform();
        }
        RenderedImage destinationIMG = null;
        InterpolationNearest interpN = null;
        InterpolationBilinear interpB = null;
        InterpolationBicubic interpBN = null;
        switch (interpType) {
            case NEAREST_INTERP: {
                interpN = new InterpolationNearest();
                destinationIMG = AffineDescriptor.create((RenderedImage)sourceImage, (AffineTransform)transform, (Interpolation)interpN, (double[])new double[]{this.destinationNoData}, (ROI)roi, (boolean)useROIAccessor, (boolean)setDestinationNoData, (Range)noDataRange, (RenderingHints)hints);
                break;
            }
            case BILINEAR_INTERP: {
                interpB = new InterpolationBilinear(8);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                } else {
                    hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                }
                destinationIMG = AffineDescriptor.create((RenderedImage)sourceImage, (AffineTransform)transform, (Interpolation)interpB, (double[])new double[]{this.destinationNoData}, (ROI)roi, (boolean)useROIAccessor, (boolean)setDestinationNoData, (Range)noDataRange, (RenderingHints)hints);
                break;
            }
            case BICUBIC_INTERP: {
                interpBN = new InterpolationBicubic(8);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                } else {
                    hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                }
                destinationIMG = AffineDescriptor.create((RenderedImage)sourceImage, (AffineTransform)transform, (Interpolation)interpBN, (double[])new double[]{this.destinationNoData}, (ROI)roi, (boolean)useROIAccessor, (boolean)setDestinationNoData, (Range)noDataRange, (RenderingHints)hints);
                break;
            }
        }
        if (INTERACTIVE && dataType == 0 && TEST_SELECTOR.intValue() == testSelect.getType() && TRANSFORMATION_SELECTOR.intValue() == transformType.getValue() && INVERSE_SCALE.intValue() == scaleValue.getType()) {
            RenderedImageBrowser.showChain((RenderedImage)destinationIMG, (boolean)false, (boolean)roiPresent);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ((PlanarImage)destinationIMG).getTiles();
        }
        PlanarImage planarIMG = (PlanarImage)destinationIMG;
        if (transformType == TestBase.TransformationType.SCALE_OP) {
            if (!isBinary && roiPresent) {
                int imgWidthROI = destinationIMG.getWidth() * 3 / 4 - 2;
                int imgHeightROI = destinationIMG.getHeight() * 3 / 4 - 2;
                int tileInROIx = planarIMG.XToTileX(imgWidthROI);
                int tileInROIy = planarIMG.YToTileY(imgHeightROI);
                Raster testTile = destinationIMG.getTile(tileInROIx, tileInROIy);
                boolean interpNear = false;
                if (interpN != null) {
                    interpNear = true;
                }
                this.testROI(dataType, testTile, interpNear);
                int xFirstTile = destinationIMG.getMinTileX() + destinationIMG.getNumXTiles() - 1;
                int ySecondTile = destinationIMG.getMinTileY() + destinationIMG.getNumYTiles() - 1;
                Raster simpleTile = destinationIMG.getTile(xFirstTile, ySecondTile);
                this.testEmptyImage(dataType, simpleTile, isBinary, interpNear);
            }
            Assert.assertEquals((long)((int)((float)DEFAULT_WIDTH * this.scaleX)), (long)destinationIMG.getWidth());
            Assert.assertEquals((long)((int)((float)DEFAULT_HEIGHT * this.scaleY)), (long)destinationIMG.getHeight());
        } else if (transformType == TestBase.TransformationType.TRANSLATE_OP) {
            if (!isBinary && roiPresent) {
                int imgWidthROI = destinationIMG.getMinX() + destinationIMG.getWidth() / 4 - 1;
                int imgHeightROI = destinationIMG.getMinY() + destinationIMG.getHeight() * 3 / 4 - 1;
                int tileInROIx = planarIMG.XToTileX(imgWidthROI);
                int tileInROIy = planarIMG.YToTileY(imgHeightROI);
                Raster testTile = destinationIMG.getTile(tileInROIx, tileInROIy);
                boolean interpNear = false;
                if (interpN != null) {
                    interpNear = true;
                }
                this.testROI(dataType, testTile, interpNear);
                int xFirstTile = destinationIMG.getMinTileX() + destinationIMG.getNumXTiles() - 1;
                int ySecondTile = destinationIMG.getMinTileY() + destinationIMG.getNumYTiles() - 1;
                Raster simpleTile = destinationIMG.getTile(xFirstTile, ySecondTile);
                this.testEmptyImage(dataType, simpleTile, isBinary, interpNear);
            }
            double actualX = destinationIMG.getMinX();
            double actualY = destinationIMG.getMinY();
            double expectedX = (float)sourceImage.getMinX() + this.transX;
            double expectedY = (float)sourceImage.getMinY() + this.transY;
            double tolerance = 0.1f;
            Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
            Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        } else if (transformType == TestBase.TransformationType.ROTATE_OP) {
            if (!isBinary && roiPresent) {
                int imgWidthROI = destinationIMG.getMinX() + destinationIMG.getWidth() / 4 + 1;
                int imgHeightROI = destinationIMG.getMinY() + destinationIMG.getHeight() * 3 / 4 - 1;
                int tileInROIx = planarIMG.XToTileX(imgWidthROI);
                int tileInROIy = planarIMG.YToTileY(imgHeightROI);
                Raster testTile = destinationIMG.getTile(tileInROIx, tileInROIy);
                boolean interpNear = false;
                if (interpN != null) {
                    interpNear = true;
                }
                this.testROI(dataType, testTile, interpNear);
                int xFirstTile = destinationIMG.getMinTileX() + 1;
                int ySecondTile = destinationIMG.getMinTileY() + 1;
                Raster simpleTile = destinationIMG.getTile(xFirstTile, ySecondTile);
                this.testEmptyImage(dataType, simpleTile, isBinary, interpNear);
            }
            Assert.assertEquals((long)DEFAULT_WIDTH, (long)destinationIMG.getHeight());
            Assert.assertEquals((long)DEFAULT_HEIGHT, (long)destinationIMG.getWidth());
        }
        if (destinationIMG instanceof RenderedOp) {
            ((RenderedOp)destinationIMG).dispose();
        }
    }

    protected void testROI(int dataType, Raster testTile, boolean interpNearest) {
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int value = 0;
                if (interpNearest) {
                    value = testTile.getSample(testTile.getMinX(), testTile.getMinY() + 2, 0);
                    Assert.assertFalse((value == (int)this.destinationNoData ? 1 : 0) != 0);
                    break;
                }
                value = testTile.getSample(testTile.getMinX() + 1, testTile.getMinY(), 0);
                Assert.assertFalse((value == (int)this.destinationNoData ? 1 : 0) != 0);
                break;
            }
            case 4: {
                if (interpNearest) {
                    float valuef = testTile.getSampleFloat(testTile.getMinX(), testTile.getMinY() + 2, 0);
                    Assert.assertFalse(((int)valuef == (int)this.destinationNoData ? 1 : 0) != 0);
                    break;
                }
                float valuef = testTile.getSampleFloat(testTile.getMinX(), testTile.getMinY(), 0);
                Assert.assertFalse(((int)valuef == (int)this.destinationNoData ? 1 : 0) != 0);
                break;
            }
            case 5: {
                if (interpNearest) {
                    double valued = testTile.getSampleDouble(testTile.getMinX(), testTile.getMinY() + 2, 0);
                    Assert.assertFalse((valued == this.destinationNoData ? 1 : 0) != 0);
                    break;
                }
                double valued = testTile.getSampleDouble(testTile.getMinX(), testTile.getMinY(), 0);
                Assert.assertFalse((valued == this.destinationNoData ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
    }

    protected void testEmptyImage(int dataType, Raster simpleTile, boolean isBinary, boolean interpNear) {
        int padding = interpNear ? 0 : 1;
        int tileminX = simpleTile.getMinX() + padding;
        int tileminY = simpleTile.getMinY() + padding;
        int tileWidth = tileminX + simpleTile.getWidth() - padding;
        int tileHeight = tileminY + simpleTile.getHeight() - padding;
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int minValue = Integer.MAX_VALUE;
                int maxValue = Integer.MIN_VALUE;
                for (int i = tileminY; i < tileHeight; ++i) {
                    for (int j = tileminX; j < tileWidth; ++j) {
                        int value = simpleTile.getSample(j, i, 0);
                        if (value > maxValue) {
                            maxValue = value;
                        }
                        if (value >= minValue) continue;
                        minValue = value;
                    }
                }
                Assert.assertFalse((minValue == Integer.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValue == Integer.MIN_VALUE ? 1 : 0) != 0);
                Assert.assertEquals((double)minValue, (double)this.destinationNoData, (double)1.0E-6);
                Assert.assertEquals((double)maxValue, (double)this.destinationNoData, (double)1.0E-6);
                break;
            }
            case 4: {
                float minValuef = Float.MAX_VALUE;
                float maxValuef = -3.4028235E38f;
                for (int i = tileminY; i < tileHeight; ++i) {
                    for (int j = tileminX; j < tileWidth; ++j) {
                        float valuef = simpleTile.getSample(j, i, 0);
                        if (Float.isNaN(valuef) || valuef == Float.POSITIVE_INFINITY || valuef == Float.POSITIVE_INFINITY) {
                            valuef = 255.0f;
                        }
                        if (valuef > maxValuef) {
                            maxValuef = valuef;
                        }
                        if (!(valuef < minValuef)) continue;
                        minValuef = valuef;
                    }
                }
                Assert.assertFalse((minValuef == Float.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValuef == -3.4028235E38f ? 1 : 0) != 0);
                Assert.assertEquals((double)minValuef, (double)this.destinationNoData, (double)1.0E-6);
                Assert.assertEquals((double)maxValuef, (double)this.destinationNoData, (double)1.0E-6);
                break;
            }
            case 5: {
                double minValued = Double.MAX_VALUE;
                double maxValued = -1.7976931348623157E308;
                for (int i = tileminY; i < tileHeight; ++i) {
                    for (int j = tileminX; j < tileWidth; ++j) {
                        double valued = simpleTile.getSampleDouble(j, i, 0);
                        if (Double.isNaN(valued) || valued == Double.POSITIVE_INFINITY || valued == Double.POSITIVE_INFINITY) {
                            valued = 255.0;
                        }
                        if (valued > maxValued) {
                            maxValued = valued;
                        }
                        if (!(valued < minValued)) continue;
                        minValued = valued;
                    }
                }
                Assert.assertFalse((minValued == Double.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertFalse((maxValued == -1.7976931348623157E308 ? 1 : 0) != 0);
                Assert.assertEquals((double)minValued, (double)this.destinationNoData, (double)1.0E-6);
                Assert.assertEquals((double)maxValued, (double)this.destinationNoData, (double)1.0E-6);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
    }

    protected void testGlobalAffine(boolean useROIAccessor, boolean isBinary, boolean bicubic2Disabled, boolean noDataRangeUsed, boolean roiPresent, boolean setDestinationNoData, TestBase.InterpolationType interpType, TestBase.TestSelection testSelect, TestBase.ScaleType scaleValue) {
        Byte sourceNoDataByte = 100;
        Short sourceNoDataUshort = 32766;
        Short sourceNoDataShort = -255;
        Integer sourceNoDataInt = 0x7FFFFFFE;
        Float sourceNoDataFloat = Float.valueOf(-15.2f);
        Double sourceNoDataDouble = Double.POSITIVE_INFINITY;
        if (isBinary) {
            sourceNoDataByte = 1;
            sourceNoDataUshort = 1;
            sourceNoDataInt = 1;
            this.destinationNoData = 0.0;
        } else {
            this.destinationNoData = 255.0;
        }
        int dataType = 0;
        this.testAllOperation(dataType, isBinary, sourceNoDataByte, useROIAccessor, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, interpType, testSelect, scaleValue);
        dataType = 1;
        this.testAllOperation(dataType, isBinary, sourceNoDataUshort, useROIAccessor, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, interpType, testSelect, scaleValue);
        dataType = 3;
        this.testAllOperation(dataType, isBinary, sourceNoDataInt, useROIAccessor, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, interpType, testSelect, scaleValue);
        if (!isBinary) {
            dataType = 2;
            this.testAllOperation(dataType, isBinary, sourceNoDataShort, useROIAccessor, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, interpType, testSelect, scaleValue);
            dataType = 4;
            this.testAllOperation(dataType, isBinary, sourceNoDataFloat, useROIAccessor, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, interpType, testSelect, scaleValue);
            dataType = 5;
            this.testAllOperation(dataType, isBinary, sourceNoDataDouble, useROIAccessor, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, interpType, testSelect, scaleValue);
        }
    }

    protected <T extends Number> void testAllOperation(int dataType, boolean isBinary, T sourceNoData, boolean useROIAccessor, boolean bicubic2Disabled, boolean noDataRangeUsed, boolean roiPresent, boolean setDestinationNoData, TestBase.InterpolationType interpType, TestBase.TestSelection testSelect, TestBase.ScaleType scaleValue) {
        RenderedImage sourceImage = TestAffine.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, sourceNoData, (boolean)isBinary);
        this.testImageAffine(sourceImage, dataType, sourceNoData, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, TestBase.TransformationType.ROTATE_OP, interpType, testSelect, scaleValue);
        this.testImageAffine(sourceImage, dataType, sourceNoData, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, TestBase.TransformationType.TRANSLATE_OP, interpType, testSelect, scaleValue);
        this.testImageAffine(sourceImage, dataType, sourceNoData, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, TestBase.TransformationType.SCALE_OP, interpType, testSelect, scaleValue);
        this.testImageAffine(sourceImage, dataType, sourceNoData, useROIAccessor, isBinary, bicubic2Disabled, noDataRangeUsed, roiPresent, setDestinationNoData, TestBase.TransformationType.ALL, interpType, testSelect, scaleValue);
    }

    protected void testROILayout(int interpolation) {
        this.testROILayout(0, interpolation);
        this.testROILayout(1, interpolation);
        this.testROILayout(2, interpolation);
        this.testROILayout(3, interpolation);
        this.testROILayout(4, interpolation);
        this.testROILayout(5, interpolation);
    }

    protected void testROILayout(int dataType, int interpolationType) {
        RenderedImage testIMG = TestAffine.createTestImage((int)dataType, (int)1, (int)1, null, (boolean)false);
        PlanarImage testImgWithROI = PlanarImage.wrapRenderedImage((RenderedImage)testIMG);
        ROI roi = new ROI((RenderedImage)new ROIShape((Shape)new Rectangle(0, 0, 1, 1)).getAsImage());
        testImgWithROI.setProperty("roi", (Object)roi);
        ImageLayout targetLayout = new ImageLayout();
        targetLayout.setTileWidth(512);
        targetLayout.setTileHeight(512);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, targetLayout);
        RenderedOp rotated = AffineDescriptor.create((RenderedImage)testIMG, (AffineTransform)new AffineTransform(1.0f, -1.0f, 1.0f, 1.0f, 0.0f, 0.0f), (Interpolation)Interpolation.getInstance((int)interpolationType), null, (ROI)roi, (boolean)false, (boolean)false, null, (RenderingHints)hints);
        ROI rotatedRoi = (ROI)rotated.getProperty("roi");
        Assert.assertEquals((Object)rotated.getBounds(), (Object)rotatedRoi.getBounds());
        PlanarImage scaleRoiImage = rotatedRoi.getAsImage();
        Assert.assertEquals((long)rotated.getTileHeight(), (long)scaleRoiImage.getTileHeight());
        Assert.assertEquals((long)rotated.getTileWidth(), (long)scaleRoiImage.getTileWidth());
        Assert.assertEquals((long)512L, (long)scaleRoiImage.getTileWidth());
        Assert.assertEquals((long)512L, (long)scaleRoiImage.getTileHeight());
    }
}

