/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.affine.AffineDescriptor;
import it.geosolutions.jaiext.affine.TestAffine;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestData;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestAffine {
    private static final int BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean NATIVE_ACCELERATION = Boolean.getBoolean("JAI.Ext.Acceleration");
    public static Integer TRANSFORMATION_SELECTOR = Integer.getInteger("JAI.Ext.TransformationSelector", 0);
    private static final int TEST_SELECTOR = Integer.getInteger("JAI.Ext.TestSelector", 0);
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static final int DEFAULT_SUBSAMPLE_BITS = 8;
    private static final int DEFAULT_PRECISION_BITS = 8;
    private static double destinationNoData = 0.0;
    private static AffineTransform rotateTransform;
    private static AffineTransform translateTransform;
    private static AffineTransform scaleTransform;
    private static javax.media.jai.InterpolationNearest interpNearOld;
    private static InterpolationNearest interpNearNew;
    private static javax.media.jai.InterpolationBilinear interpBilOld;
    private static InterpolationBilinear interpBilNew;
    private static javax.media.jai.InterpolationBicubic interpBicOld;
    private static InterpolationBicubic interpBicNew;
    private static RenderedImage image;
    private static RenderingHints hints;
    private static int[][] weight;

    @BeforeClass
    public static void initialSetup() throws FileNotFoundException, IOException {
        int dataType = 0;
        Range rangeND = null;
        if (RANGE_USED) {
            rangeND = RangeFactory.create((byte)100, (boolean)true, (byte)100, (boolean)true);
        }
        interpNearOld = new javax.media.jai.InterpolationNearest();
        interpNearNew = new InterpolationNearest(rangeND, false, destinationNoData, dataType);
        interpBilOld = new javax.media.jai.InterpolationBilinear(8);
        interpBilNew = new InterpolationBilinear(8, rangeND, false, destinationNoData, dataType);
        interpBicOld = new javax.media.jai.InterpolationBicubic(8);
        interpBicNew = new InterpolationBicubic(8, rangeND, false, destinationNoData, dataType, false, 8);
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageRead");
        File file = TestData.file(ComparisonTest.class, (String)"testImageLittle.tif");
        pbj.setParameter("Input", (Object)file);
        image = JAI.create((String)"ImageRead", (ParameterBlock)pbj);
        hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        double theta = 0.7853981633974483;
        rotateTransform = AffineTransform.getRotateInstance(theta);
        translateTransform = AffineTransform.getTranslateInstance(100.0, 0.0);
        scaleTransform = AffineTransform.getScaleInstance(1.5, 1.5);
        weight = new int[4][BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION];
        for (int i = 0; i < BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION; ++i) {
            double rnd = Math.random();
            if (rnd >= 0.0 & rnd < 0.25) {
                ComparisonTest.weight[0][i] = 0;
                ComparisonTest.weight[1][i] = 1;
                ComparisonTest.weight[2][i] = 0;
                ComparisonTest.weight[3][i] = 0;
                continue;
            }
            if (rnd >= 0.25 & rnd < 0.5) {
                ComparisonTest.weight[0][i] = 0;
                ComparisonTest.weight[1][i] = 1;
                ComparisonTest.weight[2][i] = 0;
                ComparisonTest.weight[3][i] = 1;
                continue;
            }
            if (rnd >= 0.25 & rnd < 0.5) {
                ComparisonTest.weight[0][i] = 1;
                ComparisonTest.weight[1][i] = 1;
                ComparisonTest.weight[2][i] = 0;
                ComparisonTest.weight[3][i] = 0;
                continue;
            }
            ComparisonTest.weight[0][i] = 1;
            ComparisonTest.weight[1][i] = 1;
            ComparisonTest.weight[2][i] = 1;
            ComparisonTest.weight[3][i] = 1;
        }
        if (OLD_DESCRIPTOR) {
            JAIExt.registerJAIDescriptor((String)"Affine");
        }
    }

    @Test
    public void testSpeedCalculationInt() {
        int one = 256;
        int shift2 = 16;
        int round2 = 1 << shift2 - 1;
        int s0 = 0;
        int s1 = 0;
        int s = 0;
        int s00 = 0;
        int s01 = 1;
        int s10 = 2;
        int s11 = 3;
        int xfrac = (int)(Math.random() * Math.pow(2.0, 8.0));
        int yfrac = (int)(Math.random() * Math.pow(2.0, 8.0));
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION; ++i) {
            int w00 = weight[0][i];
            int w01 = weight[1][i];
            int w10 = weight[2][i];
            int w11 = weight[3][i];
            boolean w00z = w00 == 0;
            boolean w01z = w01 == 0;
            boolean w10z = w10 == 0;
            boolean w11z = w11 == 0;
            long start = System.nanoTime();
            int xfracCompl = one - xfrac;
            int yfracCompl = one - yfrac;
            s0 = w00z && w01z ? 0 : (w00z ? -s01 * xfracCompl + (s01 << 8) : (w01z ? -s00 * xfrac + (s00 << 8) : (s01 - s00) * xfrac + (s00 << 8)));
            s1 = w10z && w11z ? 0 : (w10z ? -s11 * xfracCompl + (s11 << 8) : (w11z ? -s10 * xfrac + (s10 << 8) : (s11 - s10) * xfrac + (s10 << 8)));
            s = w00z && w01z ? -s1 * yfracCompl + (s1 << 8) + round2 >> shift2 : (w10z && w11z ? -s0 * yfrac + (s0 << 8) + round2 >> shift2 : (s1 - s0) * yfrac + (s0 << 8) + round2 >> shift2);
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
            if (end > max) {
                max = end;
            }
            if (end >= min) continue;
            min = end;
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        double maxD = max;
        double minD = min;
        System.out.println("\nMean value for int calculation : " + meanValue + " nsec.");
        System.out.println("Maximum value for int calculation  : " + maxD + " nsec.");
        System.out.println("Minimum value for int calculation : " + minD + " nsec.");
    }

    @Test
    public void testSpeedCalculationDouble() {
        double s0 = 0.0;
        double s1 = 0.0;
        double s = 0.0;
        double s00 = 0.0;
        double s01 = 1.0;
        double s10 = 2.0;
        double s11 = 3.0;
        float xfrac = (float)Math.random();
        float yfrac = (float)Math.random();
        float xfracCompl = 1.0f - xfrac;
        float yfracCompl = 1.0f - yfrac;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION; ++i) {
            int w00 = weight[0][i];
            int w01 = weight[1][i];
            int w10 = weight[2][i];
            int w11 = weight[3][i];
            boolean w00z = w00 == 0;
            boolean w01z = w01 == 0;
            boolean w10z = w10 == 0;
            boolean w11z = w11 == 0;
            long start = System.nanoTime();
            if (w00z || w01z || w10z || w11z) {
                s0 = w00z && w01z ? 0.0 : (w00z ? s01 * (double)xfrac : (w01z ? s00 * (double)xfracCompl : (s01 - s00) * (double)xfrac + s00));
                s1 = w10z && w11z ? 0.0 : (w10z ? s11 * (double)xfrac : (w11z ? s10 * (double)xfracCompl : (s11 - s10) * (double)xfrac + s10));
                s = w00z && w01z ? s1 * (double)yfrac : (w10z && w11z ? s0 * (double)yfracCompl : (s1 - s0) * (double)yfrac + s0);
            } else {
                s0 = (s01 - s00) * (double)xfrac + s00;
                s1 = (s11 - s10) * (double)xfrac + s10;
                s = (s1 - s0) * (double)yfrac + s0;
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
            if (end > max) {
                max = end;
            }
            if (end >= min) continue;
            min = end;
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        double maxD = max;
        double minD = min;
        System.out.println("\nMean value for double calculation : " + meanValue + " nsec.");
        System.out.println("Maximum value for double calculation  : " + maxD + " nsec.");
        System.out.println("Minimum value for double calculation : " + minD + " nsec.");
    }

    @Test
    public void testNearestNewAffineDescriptor() {
        if (TEST_SELECTOR == 0 && !OLD_DESCRIPTOR) {
            this.testInterpolators((Interpolation)interpNearNew, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testNearestOldAffineDescriptor() {
        if (TEST_SELECTOR == 0 && OLD_DESCRIPTOR) {
            this.testInterpolators((Interpolation)interpNearOld, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBilinearNewAffineDescriptor() {
        if (TEST_SELECTOR == 1 && !OLD_DESCRIPTOR) {
            this.testInterpolators((Interpolation)interpBilNew, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBilinearOldAffineDescriptor() {
        if (TEST_SELECTOR == 1 && OLD_DESCRIPTOR) {
            this.testInterpolators((Interpolation)interpBilOld, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBicubicNewAffineDescriptor() {
        if (TEST_SELECTOR == 2 && !OLD_DESCRIPTOR) {
            this.testInterpolators((Interpolation)interpBicNew, OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testBicubicOldAffineDescriptor() {
        if (TEST_SELECTOR == 2 && OLD_DESCRIPTOR) {
            this.testInterpolators((Interpolation)interpBicOld, OLD_DESCRIPTOR);
        }
    }

    public void testInterpolators(Interpolation interp, boolean old) {
        String interpType = "";
        if (interp instanceof javax.media.jai.InterpolationBilinear || interp instanceof InterpolationBilinear) {
            interpType = "Bilinear";
        } else if (interp instanceof javax.media.jai.InterpolationBicubic || interp instanceof InterpolationBicubic) {
            interpType = "Bicubic";
        } else if (interp instanceof javax.media.jai.InterpolationNearest || interp instanceof InterpolationNearest) {
            interpType = "Nearest";
        }
        String description = "";
        if (old) {
            description = "Old Affine";
            if (NATIVE_ACCELERATION) {
                description = description + " accelerated ";
                System.setProperty("com.sun.media.jai.disableMediaLib", "false");
            } else {
                System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            }
        } else {
            description = "New Affine";
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        }
        AffineTransform transform = new AffineTransform();
        switch (TRANSFORMATION_SELECTOR) {
            case 0: {
                transform.concatenate(rotateTransform);
                break;
            }
            case 1: {
                transform.concatenate(scaleTransform);
                break;
            }
            case 2: {
                transform.concatenate(rotateTransform);
                transform.concatenate(scaleTransform);
                transform.concatenate(translateTransform);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong transformation value");
            }
        }
        double[] destinationNoDataArray = new double[]{destinationNoData, destinationNoData, destinationNoData};
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageAffine = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            imageAffine = old ? javax.media.jai.operator.AffineDescriptor.create((RenderedImage)image, (AffineTransform)transform, (Interpolation)interp, (double[])destinationNoDataArray, (RenderingHints)hints) : AffineDescriptor.create((RenderedImage)image, (AffineTransform)transform, (Interpolation)interp, (double[])destinationNoDataArray, null, (boolean)false, (boolean)false, null, (RenderingHints)hints);
            long start = System.nanoTime();
            imageAffine.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println("\n" + interpType);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageAffine instanceof RenderedOp) {
            imageAffine.dispose();
        }
    }
}

