/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.artifacts;

import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;

public class ArtifactsFilterDescriptor
extends OperationDescriptorImpl {
    private static final String[] srcImageNames = new String[]{"sourceImage"};
    private static final Class<?>[][] srcImageClasses = new Class[][]{{RenderedImage.class}};
    static final int ROI_ARG = 0;
    static final int BACKGROUND_ARG = 1;
    static final int THRESHOLD_ARG = 2;
    static final int FILTERSIZE_ARG = 3;
    static final int NODATA_ARG = 4;
    private static final int DEFAULT_FILTER_SIZE = 3;
    private static final int DEFAULT_THRESHOLD = 10;
    private static final String[] paramNames = new String[]{"roi", "backgroundValues", "threshold", "filterSize", "nodata"};
    private static final Class<?>[] paramClasses = new Class[]{ROI.class, double[].class, Integer.class, Integer.class, Range.class};
    private static final Object[] paramDefaults = new Object[]{null, null, 10, 3, null};

    public ArtifactsFilterDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "ArtifactsFilter"}, {"LocalName", "ArtifactsFilter"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Filter pixels along the ROI BORDER with Luminance value less than threshold"}, {"DocURL", ""}, {"Version", "1.0.0"}, {"arg0Desc", String.format("%s (default %s) - a ROI defining working area", paramNames[0], paramDefaults[0])}, {"arg1Desc", String.format("%s (default %s) - an array of double that define values for the background ", paramNames[1], paramDefaults[1])}, {"arg2Desc", String.format("%s (default %s) - an integer defining the luminance threshold value", paramNames[2], paramDefaults[2])}, {"arg3Desc", String.format("%s (default %s) - an integer defining the filterSize", paramNames[3], paramDefaults[3])}, {"arg4Desc", String.format("%s (default %s) - a Range defining the image nodata", paramNames[4], paramDefaults[4])}}, new String[]{"rendered"}, srcImageNames, (Class[][])srcImageClasses, paramNames, (Class[])paramClasses, paramDefaults, null);
    }

    public static RenderedImage create(RenderedImage sourceImage, ROI sourceRoi, double[] backgroundValues, int threshold, RenderingHints hints) {
        return ArtifactsFilterDescriptor.create(sourceImage, sourceRoi, backgroundValues, threshold, 3, null, hints);
    }

    public static RenderedImage create(RenderedImage sourceImage, ROI sourceRoi, double[] backgroundValues, RenderingHints hints) {
        return ArtifactsFilterDescriptor.create(sourceImage, sourceRoi, backgroundValues, 10, 3, null, hints);
    }

    public static RenderedImage create(RenderedImage sourceImage, ROI sourceRoi, double[] backgroundValues, int threshold, Range nodata, RenderingHints hints) {
        return ArtifactsFilterDescriptor.create(sourceImage, sourceRoi, backgroundValues, threshold, 3, nodata, hints);
    }

    public static RenderedImage create(RenderedImage sourceImage, ROI sourceRoi, double[] backgroundValues, Range nodata, RenderingHints hints) {
        return ArtifactsFilterDescriptor.create(sourceImage, sourceRoi, backgroundValues, 10, 3, nodata, hints);
    }

    public static RenderedImage create(RenderedImage sourceImage, ROI sourceRoi, double[] backgroundValues, int threshold, int filterSize, Range nodata, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("ArtifactsFilter", "rendered");
        pb.setSource(srcImageNames[0], (Object)sourceImage);
        pb.setParameter(paramNames[0], (Object)sourceRoi);
        pb.setParameter(paramNames[1], (Object)backgroundValues);
        pb.setParameter(paramNames[2], threshold);
        pb.setParameter(paramNames[3], filterSize);
        pb.setParameter(paramNames[4], (Object)nodata);
        return JAI.create((String)"ArtifactsFilter", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public boolean arePropertiesSupported() {
        return true;
    }

    public boolean validateArguments(String modeName, ParameterBlock pb, StringBuffer msg) {
        if (pb.getNumSources() == 0 || pb.getNumSources() > 1) {
            msg.append("ArtifactsFilter operator takes 1 source image");
            return false;
        }
        Object backgroundValues = pb.getObjectParameter(1);
        double[] bgValues = null;
        if (!(backgroundValues instanceof double[])) {
            msg.append(paramNames[1] + " arg has to be of type double[]");
            return false;
        }
        bgValues = (double[])backgroundValues;
        RenderedImage dataImg = pb.getRenderedSource(0);
        Rectangle dataBounds = new Rectangle(dataImg.getMinX(), dataImg.getMinY(), dataImg.getWidth(), dataImg.getHeight());
        Object roiObject = pb.getObjectParameter(0);
        if (roiObject != null) {
            if (!(roiObject instanceof ROI)) {
                msg.append("The supplied ROI is not a supported class");
                return false;
            }
            ROI roi = (ROI)roiObject;
            Rectangle roiBounds = roi.getBounds();
            if (!roiBounds.intersects(dataBounds)) {
                msg.append("The supplied ROI does not intersect the source image");
                return false;
            }
        } else {
            msg.append("The ROI parameter is missing ");
            return false;
        }
        return true;
    }
}

