/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.artifacts;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.operator.BandCombineDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactsFilterOpImage
extends PointOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private static final double[][] RGB_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0}};
    private final double[] backgroundValues;
    private final int numBands;
    private final BorderExtender sourceExtender;
    private int filterSize;
    private ROI thresholdRoi;
    private ROI sourceROI;
    private PlanarImage thresholdRoiImg;
    private PlanarImage sourceROIimg;
    private final boolean hasNoData;
    private Range nodata;
    private DataTypeCalculator calculator;

    public ArtifactsFilterOpImage(RenderedImage source, ImageLayout layout, Map<?, ?> config, ROI sourceROI, double[] backgroundValues, int threshold, int filterSize, Range nodata) {
        super(source, layout, config, true);
        double sourceExtensionConstant;
        RenderedImage inputRI = source;
        int tr = inputRI.getColorModel().getTransparency();
        this.numBands = this.sampleModel.getNumBands();
        this.filterSize = filterSize;
        this.sourceROI = sourceROI;
        this.thresholdRoi = null;
        if (sourceROI != null) {
            RenderedImage image = inputRI;
            if (threshold != Integer.MAX_VALUE) {
                if (this.numBands == 3) {
                    image = BandCombineDescriptor.create((RenderedImage)image, (double[][])RGB_TO_GRAY_MATRIX, null);
                } else {
                    double fillValue = tr == 1 ? 1.0 / (double)this.numBands : 1.0 / (double)(this.numBands - 1);
                    double[][] matrix = new double[1][this.numBands + 1];
                    for (int i = 0; i < this.numBands; ++i) {
                        matrix[0][i] = fillValue;
                    }
                    image = BandCombineDescriptor.create((RenderedImage)image, (double[][])matrix, null);
                }
                this.thresholdRoi = new ROI(image, threshold);
                this.thresholdRoi = this.thresholdRoi.intersect(sourceROI);
            }
        }
        this.backgroundValues = new double[this.numBands];
        if (backgroundValues == null) {
            backgroundValues = new double[]{0.0};
        }
        if (backgroundValues.length < this.numBands) {
            Arrays.fill(this.backgroundValues, backgroundValues[0]);
        } else {
            System.arraycopy(backgroundValues, 0, this.backgroundValues, 0, this.numBands);
        }
        boolean bl = this.hasNoData = nodata != null;
        if (this.hasNoData) {
            this.nodata = nodata;
        }
        int dataType = this.sampleModel.getDataType();
        DataTypeCalculator calc = null;
        switch (dataType) {
            case 0: {
                sourceExtensionConstant = 0.0;
                calc = DataTypeCalculator.BYTE;
                break;
            }
            case 1: {
                sourceExtensionConstant = 0.0;
                calc = DataTypeCalculator.SHORT;
                break;
            }
            case 2: {
                sourceExtensionConstant = -32768.0;
                calc = DataTypeCalculator.SHORT;
                break;
            }
            case 3: {
                sourceExtensionConstant = -2.147483648E9;
                calc = DataTypeCalculator.INTEGER;
                break;
            }
            case 4: {
                sourceExtensionConstant = -3.4028234663852886E38;
                calc = DataTypeCalculator.FLOAT;
                break;
            }
            default: {
                sourceExtensionConstant = -1.7976931348623157E308;
                calc = DataTypeCalculator.DOUBLE;
            }
        }
        this.calculator = calc;
        this.sourceExtender = sourceExtensionConstant == 0.0 ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(new double[]{sourceExtensionConstant});
    }

    private RoiAccessor buildRoiAccessor(boolean threshold) {
        if (threshold) {
            if (this.thresholdRoi != null) {
                PlanarImage roiImage = this.getROIThresholdImage();
                RandomIter roiIter = RandomIterFactory.create((RenderedImage)roiImage, null, (boolean)true, (boolean)true);
                int minRoiX = roiImage.getMinX();
                int minRoiY = roiImage.getMinY();
                int roiW = roiImage.getWidth();
                int roiH = roiImage.getHeight();
                return new RoiAccessor(roiIter, this.thresholdRoi, roiImage, minRoiX, minRoiY, roiW, roiH);
            }
        } else if (this.sourceROI != null) {
            PlanarImage roiImage = this.getROIImage();
            RandomIter roiIter = RandomIterFactory.create((RenderedImage)roiImage, null, (boolean)true, (boolean)true);
            int minRoiX = roiImage.getMinX();
            int minRoiY = roiImage.getMinY();
            int roiW = roiImage.getWidth();
            int roiH = roiImage.getHeight();
            return new RoiAccessor(roiIter, this.sourceROI, roiImage, minRoiX, minRoiY, roiW, roiH);
        }
        return null;
    }

    public Raster computeTile(int tileX, int tileY) {
        PlanarImage source;
        WritableRaster dest = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(tileX), this.tileYToY(tileY)));
        Rectangle destRect = this.getTileRect(tileX, tileY);
        int numSources = this.getNumSources();
        Raster rasterSources = null;
        for (int i = 0; i < numSources; ++i) {
            source = this.getSourceImage(i);
            Rectangle srcRect = this.mapDestRect(destRect, i);
            rasterSources = srcRect != null && srcRect.isEmpty() ? null : source.getExtendedData(destRect, this.sourceExtender);
        }
        this.computeRect(rasterSources, dest, destRect);
        Raster sourceData = rasterSources;
        if (sourceData != null && (source = this.getSourceImage(0)).overlapsMultipleTiles(sourceData.getBounds())) {
            this.recycleTile(sourceData);
        }
        return dest;
    }

    private void computeRect(Raster source, WritableRaster destinationRaster, Rectangle destRect) {
        if (source == null) {
            ImageUtil.fillBackground((WritableRaster)destinationRaster, (Rectangle)destRect, (double[])this.backgroundValues);
            return;
        }
        SampleModel[] sourceSM = new SampleModel[]{source.getSampleModel()};
        int formatTagID = RasterAccessor.findCompatibleTag((SampleModel[])sourceSM, (SampleModel)destinationRaster.getSampleModel());
        RasterAccessor rasterAccessor = new RasterAccessor((Raster)destinationRaster, destRect, new RasterFormatTag(destinationRaster.getSampleModel(), formatTagID), null);
        int dataType = rasterAccessor.getDataType();
        switch (dataType) {
            case 0: {
                this.computeRectByte(source, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectShort(source, rasterAccessor, true);
                break;
            }
            case 2: {
                this.computeRectShort(source, rasterAccessor, false);
                break;
            }
            case 3: {
                this.computeRectInt(source, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(source, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(source, rasterAccessor);
                break;
            }
            default: {
                throw new UnsupportedOperationException("The following datatype isn't actually supported " + dataType);
            }
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(Raster source, RasterAccessor dest) {
        int j;
        int dwidth = dest.getWidth();
        int dheight = dest.getHeight();
        int dnumBands = dest.getNumBands();
        byte[][] dstDataArrays = dest.getByteDataArrays();
        int[] dstBandOffsets = dest.getBandOffsets();
        int dstPixelStride = dest.getPixelStride();
        int dstScanlineStride = dest.getScanlineStride();
        int x = dest.getX();
        int y = dest.getY();
        int[][] valuess = new int[this.filterSize * this.filterSize][dnumBands];
        int min = -(this.filterSize / 2);
        int max = this.filterSize / 2;
        int[] dstPixelOffset = new int[dnumBands];
        int[] dstScanlineOffset = new int[dnumBands];
        int[] val = new int[dnumBands];
        int valueCount = 0;
        boolean readOriginalValues = false;
        RandomIter iter = RandomIterFactory.create((Raster)source, null, (boolean)true, (boolean)true);
        RoiAccessor roiAccessor = this.buildRoiAccessor(false);
        RoiAccessor thresholdRoiAccessor = this.buildRoiAccessor(true);
        for (int k = 0; k < dnumBands; ++k) {
            dstScanlineOffset[k] = dstBandOffsets[k];
        }
        if (this.hasNoData) {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k2;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k3 = 0; k3 < dnumBands; ++k3) {
                        val[k3] = Integer.MIN_VALUE;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean isValid;
                            int[] data;
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    data = new int[valuess[0].length];
                                    iter.getPixel(x + i + v, y + j + u, data);
                                    isValid = this.isValid(data);
                                    if (!isValid) continue;
                                    valuess[valueCount++] = data;
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        data = new int[valuess[0].length];
                                        iter.getPixel(x + i + v, y + j + u, data);
                                        isValid = this.isValid(data);
                                        if (!isValid) continue;
                                        valuess[valueCount++] = data;
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset[k2]] = (byte)val[k2];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            val[k2] = iter.getSample(x + i, y + j, k2) & 0xFF;
                            dstDataArrays[k2][dstPixelOffset[k2]] = this.nodata.contains((byte)val[k2]) ? (byte)0 : (byte)val[k2];
                        }
                    }
                    k2 = 0;
                    while (k2 < dnumBands) {
                        int n = k2++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        } else {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k4;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k5 = 0; k5 < dnumBands; ++k5) {
                        val[k5] = Integer.MIN_VALUE;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            dstDataArrays[k4][dstPixelOffset[k4]] = (byte)val[k4];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            val[k4] = iter.getSample(x + i, y + j, k4) & 0xFF;
                            dstDataArrays[k4][dstPixelOffset[k4]] = (byte)val[k4];
                        }
                    }
                    k4 = 0;
                    while (k4 < dnumBands) {
                        int n = k4++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        }
        if (roiAccessor != null) {
            roiAccessor.dispose();
            roiAccessor = null;
        }
        if (thresholdRoiAccessor != null) {
            thresholdRoiAccessor.dispose();
            thresholdRoiAccessor = null;
        }
    }

    private void computeRectShort(Raster source, RasterAccessor dest, boolean isUshort) {
        int nodataValue;
        int dwidth = dest.getWidth();
        int dheight = dest.getHeight();
        int dnumBands = dest.getNumBands();
        short[][] dstDataArrays = dest.getShortDataArrays();
        int[] dstBandOffsets = dest.getBandOffsets();
        int dstPixelStride = dest.getPixelStride();
        int dstScanlineStride = dest.getScanlineStride();
        int x = dest.getX();
        int y = dest.getY();
        int[][] valuess = new int[this.filterSize * this.filterSize][dnumBands];
        int min = -(this.filterSize / 2);
        int max = this.filterSize / 2;
        int[] dstPixelOffset = new int[dnumBands];
        int[] dstScanlineOffset = new int[dnumBands];
        int[] val = new int[dnumBands];
        int valueCount = 0;
        boolean readOriginalValues = false;
        RandomIter iter = RandomIterFactory.create((Raster)source, null, (boolean)true, (boolean)true);
        RoiAccessor roiAccessor = this.buildRoiAccessor(false);
        RoiAccessor thresholdRoiAccessor = this.buildRoiAccessor(true);
        for (int k = 0; k < dnumBands; ++k) {
            dstScanlineOffset[k] = dstBandOffsets[k];
        }
        int n = nodataValue = isUshort ? 0 : Short.MIN_VALUE;
        if (this.hasNoData) {
            for (int j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k2;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k3 = 0; k3 < dnumBands; ++k3) {
                        val[k3] = Integer.MIN_VALUE;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean isValid;
                            int[] data;
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    data = new int[valuess[0].length];
                                    iter.getPixel(x + i + v, y + j + u, data);
                                    isValid = this.isValid(data);
                                    if (!isValid) continue;
                                    valuess[valueCount++] = data;
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        data = new int[valuess[0].length];
                                        iter.getPixel(x + i + v, y + j + u, data);
                                        isValid = this.isValid(data);
                                        if (!isValid) continue;
                                        valuess[valueCount++] = data;
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset[k2]] = (short)val[k2];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            val[k2] = iter.getSample(x + i, y + j, k2);
                            dstDataArrays[k2][dstPixelOffset[k2]] = this.nodata.contains((short)val[k2]) ? nodataValue : (short)val[k2];
                        }
                    }
                    k2 = 0;
                    while (k2 < dnumBands) {
                        int n2 = k2++;
                        dstPixelOffset[n2] = dstPixelOffset[n2] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n3 = k++;
                    dstScanlineOffset[n3] = dstScanlineOffset[n3] + dstScanlineStride;
                }
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k4;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k5 = 0; k5 < dnumBands; ++k5) {
                        val[k5] = Integer.MIN_VALUE;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            dstDataArrays[k4][dstPixelOffset[k4]] = (short)val[k4];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            val[k4] = iter.getSample(x + i, y + j, k4);
                            dstDataArrays[k4][dstPixelOffset[k4]] = (short)val[k4];
                        }
                    }
                    k4 = 0;
                    while (k4 < dnumBands) {
                        int n4 = k4++;
                        dstPixelOffset[n4] = dstPixelOffset[n4] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n5 = k++;
                    dstScanlineOffset[n5] = dstScanlineOffset[n5] + dstScanlineStride;
                }
            }
        }
        if (roiAccessor != null) {
            roiAccessor.dispose();
            roiAccessor = null;
        }
        if (thresholdRoiAccessor != null) {
            thresholdRoiAccessor.dispose();
            thresholdRoiAccessor = null;
        }
    }

    private void computeRectInt(Raster source, RasterAccessor dest) {
        int j;
        int dwidth = dest.getWidth();
        int dheight = dest.getHeight();
        int dnumBands = dest.getNumBands();
        int[][] dstDataArrays = dest.getIntDataArrays();
        int[] dstBandOffsets = dest.getBandOffsets();
        int dstPixelStride = dest.getPixelStride();
        int dstScanlineStride = dest.getScanlineStride();
        int x = dest.getX();
        int y = dest.getY();
        int[][] valuess = new int[this.filterSize * this.filterSize][dnumBands];
        int min = -(this.filterSize / 2);
        int max = this.filterSize / 2;
        int[] dstPixelOffset = new int[dnumBands];
        int[] dstScanlineOffset = new int[dnumBands];
        int[] val = new int[dnumBands];
        int valueCount = 0;
        boolean readOriginalValues = false;
        RandomIter iter = RandomIterFactory.create((Raster)source, null, (boolean)true, (boolean)true);
        RoiAccessor roiAccessor = this.buildRoiAccessor(false);
        RoiAccessor thresholdRoiAccessor = this.buildRoiAccessor(true);
        for (int k = 0; k < dnumBands; ++k) {
            dstScanlineOffset[k] = dstBandOffsets[k];
        }
        if (this.hasNoData) {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k2;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k3 = 0; k3 < dnumBands; ++k3) {
                        val[k3] = Integer.MIN_VALUE;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean isValid;
                            int[] data;
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    data = new int[valuess[0].length];
                                    iter.getPixel(x + i + v, y + j + u, data);
                                    isValid = this.isValid(data);
                                    if (!isValid) continue;
                                    valuess[valueCount++] = data;
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        data = new int[valuess[0].length];
                                        iter.getPixel(x + i + v, y + j + u, data);
                                        isValid = this.isValid(data);
                                        if (!isValid) continue;
                                        valuess[valueCount++] = data;
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset[k2]] = val[k2];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            val[k2] = iter.getSample(x + i, y + j, k2);
                            dstDataArrays[k2][dstPixelOffset[k2]] = this.nodata.contains(val[k2]) ? Integer.MIN_VALUE : val[k2];
                        }
                    }
                    k2 = 0;
                    while (k2 < dnumBands) {
                        int n = k2++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        } else {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k4;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k5 = 0; k5 < dnumBands; ++k5) {
                        val[k5] = Integer.MIN_VALUE;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            dstDataArrays[k4][dstPixelOffset[k4]] = val[k4];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            val[k4] = iter.getSample(x + i, y + j, k4);
                            dstDataArrays[k4][dstPixelOffset[k4]] = val[k4];
                        }
                    }
                    k4 = 0;
                    while (k4 < dnumBands) {
                        int n = k4++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        }
        if (roiAccessor != null) {
            roiAccessor.dispose();
            roiAccessor = null;
        }
        if (thresholdRoiAccessor != null) {
            thresholdRoiAccessor.dispose();
            thresholdRoiAccessor = null;
        }
    }

    private void computeRectFloat(Raster source, RasterAccessor dest) {
        int j;
        int dwidth = dest.getWidth();
        int dheight = dest.getHeight();
        int dnumBands = dest.getNumBands();
        float[][] dstDataArrays = dest.getFloatDataArrays();
        int[] dstBandOffsets = dest.getBandOffsets();
        int dstPixelStride = dest.getPixelStride();
        int dstScanlineStride = dest.getScanlineStride();
        int x = dest.getX();
        int y = dest.getY();
        float[][] valuess = new float[this.filterSize * this.filterSize][dnumBands];
        int min = -(this.filterSize / 2);
        int max = this.filterSize / 2;
        int[] dstPixelOffset = new int[dnumBands];
        int[] dstScanlineOffset = new int[dnumBands];
        float[] val = new float[dnumBands];
        int valueCount = 0;
        boolean readOriginalValues = false;
        RandomIter iter = RandomIterFactory.create((Raster)source, null, (boolean)true, (boolean)true);
        RoiAccessor roiAccessor = this.buildRoiAccessor(false);
        RoiAccessor thresholdRoiAccessor = this.buildRoiAccessor(true);
        for (int k = 0; k < dnumBands; ++k) {
            dstScanlineOffset[k] = dstBandOffsets[k];
        }
        if (this.hasNoData) {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k2;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k3 = 0; k3 < dnumBands; ++k3) {
                        val[k3] = -3.4028235E38f;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean isValid;
                            float[] data;
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    data = new float[valuess[0].length];
                                    iter.getPixel(x + i + v, y + j + u, data);
                                    isValid = this.isValid(data);
                                    if (!isValid) continue;
                                    valuess[valueCount++] = data;
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        data = new float[valuess[0].length];
                                        iter.getPixel(x + i + v, y + j + u, data);
                                        isValid = this.isValid(data);
                                        if (!isValid) continue;
                                        valuess[valueCount++] = data;
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset[k2]] = val[k2];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            val[k2] = iter.getSampleFloat(x + i, y + j, k2);
                            dstDataArrays[k2][dstPixelOffset[k2]] = this.nodata.contains(val[k2]) ? -3.4028235E38f : val[k2];
                        }
                    }
                    k2 = 0;
                    while (k2 < dnumBands) {
                        int n = k2++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        } else {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k4;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k5 = 0; k5 < dnumBands; ++k5) {
                        val[k5] = -3.4028235E38f;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            dstDataArrays[k4][dstPixelOffset[k4]] = val[k4];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            val[k4] = iter.getSampleFloat(x + i, y + j, k4);
                            dstDataArrays[k4][dstPixelOffset[k4]] = val[k4];
                        }
                    }
                    k4 = 0;
                    while (k4 < dnumBands) {
                        int n = k4++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        }
        if (roiAccessor != null) {
            roiAccessor.dispose();
            roiAccessor = null;
        }
        if (thresholdRoiAccessor != null) {
            thresholdRoiAccessor.dispose();
            thresholdRoiAccessor = null;
        }
    }

    private void computeRectDouble(Raster source, RasterAccessor dest) {
        int j;
        int dwidth = dest.getWidth();
        int dheight = dest.getHeight();
        int dnumBands = dest.getNumBands();
        double[][] dstDataArrays = dest.getDoubleDataArrays();
        int[] dstBandOffsets = dest.getBandOffsets();
        int dstPixelStride = dest.getPixelStride();
        int dstScanlineStride = dest.getScanlineStride();
        int x = dest.getX();
        int y = dest.getY();
        double[][] valuess = new double[this.filterSize * this.filterSize][dnumBands];
        int min = -(this.filterSize / 2);
        int max = this.filterSize / 2;
        int[] dstPixelOffset = new int[dnumBands];
        int[] dstScanlineOffset = new int[dnumBands];
        double[] val = new double[dnumBands];
        int valueCount = 0;
        boolean readOriginalValues = false;
        RandomIter iter = RandomIterFactory.create((Raster)source, null, (boolean)true, (boolean)true);
        RoiAccessor roiAccessor = this.buildRoiAccessor(false);
        RoiAccessor thresholdRoiAccessor = this.buildRoiAccessor(true);
        for (int k = 0; k < dnumBands; ++k) {
            dstScanlineOffset[k] = dstBandOffsets[k];
        }
        if (this.hasNoData) {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k2;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k3 = 0; k3 < dnumBands; ++k3) {
                        val[k3] = -1.7976931348623157E308;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean isValid;
                            double[] data;
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    data = new double[valuess[0].length];
                                    iter.getPixel(x + i + v, y + j + u, data);
                                    isValid = this.isValid(data);
                                    if (!isValid) continue;
                                    valuess[valueCount++] = data;
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        data = new double[valuess[0].length];
                                        iter.getPixel(x + i + v, y + j + u, data);
                                        isValid = this.isValid(data);
                                        if (!isValid) continue;
                                        valuess[valueCount++] = data;
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset[k2]] = val[k2];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k2 = 0; k2 < dnumBands; ++k2) {
                            val[k2] = iter.getSampleDouble(x + i, y + j, k2);
                            dstDataArrays[k2][dstPixelOffset[k2]] = this.nodata.contains(val[k2]) ? -1.7976931348623157E308 : val[k2];
                        }
                    }
                    k2 = 0;
                    while (k2 < dnumBands) {
                        int n = k2++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        } else {
            for (j = 0; j < dheight; ++j) {
                int k;
                for (k = 0; k < dnumBands; ++k) {
                    dstPixelOffset[k] = dstScanlineOffset[k];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int k4;
                    valueCount = 0;
                    readOriginalValues = false;
                    for (int k5 = 0; k5 < dnumBands; ++k5) {
                        val[k5] = -1.7976931348623157E308;
                    }
                    boolean insideRoi = this.contains(roiAccessor, x + i, y + j);
                    if (insideRoi) {
                        if (!this.contains(thresholdRoiAccessor, x + i, y + j)) {
                            boolean set;
                            int v;
                            int u;
                            for (u = min; u <= max; ++u) {
                                for (v = min; v <= max; ++v) {
                                    set = false;
                                    if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                        set = true;
                                    }
                                    if (!set) continue;
                                    iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                }
                            }
                            if (valueCount == 0) {
                                for (u = min - 1; u <= max + 1; u += this.filterSize + 1) {
                                    for (v = min - 1; v <= max + 1; v += this.filterSize + 1) {
                                        set = false;
                                        if (this.contains(thresholdRoiAccessor, x + i + v, y + j + u)) {
                                            set = true;
                                        }
                                        if (!set) continue;
                                        iter.getPixel(x + i + v, y + j + u, valuess[valueCount++]);
                                    }
                                }
                            }
                            if (valueCount > 0) {
                                DataTypeCalculator.computeValueAtOnce(valuess, valueCount, val, this.numBands);
                            } else {
                                readOriginalValues = true;
                            }
                        } else {
                            readOriginalValues = true;
                        }
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            dstDataArrays[k4][dstPixelOffset[k4]] = val[k4];
                        }
                    } else {
                        readOriginalValues = true;
                    }
                    if (readOriginalValues) {
                        for (k4 = 0; k4 < dnumBands; ++k4) {
                            val[k4] = iter.getSampleDouble(x + i, y + j, k4);
                            dstDataArrays[k4][dstPixelOffset[k4]] = val[k4];
                        }
                    }
                    k4 = 0;
                    while (k4 < dnumBands) {
                        int n = k4++;
                        dstPixelOffset[n] = dstPixelOffset[n] + dstPixelStride;
                    }
                }
                k = 0;
                while (k < dnumBands) {
                    int n = k++;
                    dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
                }
            }
        }
        if (roiAccessor != null) {
            roiAccessor.dispose();
            roiAccessor = null;
        }
        if (thresholdRoiAccessor != null) {
            thresholdRoiAccessor.dispose();
            thresholdRoiAccessor = null;
        }
    }

    private final boolean contains(RoiAccessor roiAccessor, int x, int y) {
        return x >= roiAccessor.minX && x < roiAccessor.minX + roiAccessor.w && y >= roiAccessor.minY && y < roiAccessor.minY + roiAccessor.h && roiAccessor.iterator.getSample(x, y, 0) >= 1;
    }

    public void dispose() {
        super.dispose();
    }

    private boolean isValid(int[] data) {
        boolean valid = true;
        for (int i = 0; i < data.length; ++i) {
            int value = data[i];
            if (!this.calculator.isNoData(this.nodata, value)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    private boolean isValid(float[] data) {
        boolean valid = true;
        for (int i = 0; i < data.length; ++i) {
            float value = data[i];
            if (!this.calculator.isNoData(this.nodata, Float.valueOf(value))) continue;
            valid = false;
            break;
        }
        return valid;
    }

    private boolean isValid(double[] data) {
        boolean valid = true;
        for (int i = 0; i < data.length; ++i) {
            double value = data[i];
            if (!this.calculator.isNoData(this.nodata, value)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getROIImage() {
        PlanarImage img = this.sourceROIimg;
        if (img == null) {
            ArtifactsFilterOpImage artifactsFilterOpImage = this;
            synchronized (artifactsFilterOpImage) {
                img = this.sourceROIimg;
                if (img == null) {
                    this.sourceROIimg = img = this.sourceROI.getAsImage();
                }
            }
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getROIThresholdImage() {
        PlanarImage img = this.thresholdRoiImg;
        if (img == null) {
            ArtifactsFilterOpImage artifactsFilterOpImage = this;
            synchronized (artifactsFilterOpImage) {
                img = this.thresholdRoiImg;
                if (img == null) {
                    this.thresholdRoiImg = img = this.thresholdRoi.getAsImage();
                }
            }
        }
        return img;
    }

    class RoiAccessor {
        RandomIter iterator;
        ROI roi;
        PlanarImage image;
        int minX;
        int minY;
        int w;
        int h;

        public RoiAccessor(RandomIter iterator, ROI roi, PlanarImage image, int minX, int minY, int w, int h) {
            this.iterator = iterator;
            this.roi = roi;
            this.image = image;
            this.minX = minX;
            this.minY = minY;
            this.w = w;
            this.h = h;
        }

        public void dispose() {
            this.image.dispose();
            this.iterator.done();
            this.roi = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataTypeCalculator {
        BYTE{

            public boolean isNoData(Range nodata, Number value) {
                return nodata.contains(value.byteValue());
            }
        }
        ,
        SHORT{

            public boolean isNoData(Range nodata, Number value) {
                return nodata.contains(value.shortValue());
            }
        }
        ,
        INTEGER{

            public boolean isNoData(Range nodata, Number value) {
                return nodata.contains(value.intValue());
            }
        }
        ,
        FLOAT{

            public boolean isNoData(Range nodata, Number value) {
                return nodata.contains(value.floatValue());
            }
        }
        ,
        DOUBLE{

            public boolean isNoData(Range nodata, Number value) {
                return nodata.contains(value.doubleValue());
            }
        };


        public abstract boolean isNoData(Range var1, Number var2);

        public static void computeValueAtOnce(int[][] values, int valueCount, int[] val, int numBands) {
            for (int k = 0; k < numBands; ++k) {
                val[k] = DataTypeCalculator.computeValueBands(values, valueCount, k);
            }
        }

        public static void computeValueAtOnce(float[][] values, int valueCount, float[] val, int numBands) {
            for (int k = 0; k < numBands; ++k) {
                val[k] = DataTypeCalculator.computeValueBands(values, valueCount, k);
            }
        }

        public static void computeValueAtOnce(double[][] values, int valueCount, double[] val, int numBands) {
            for (int k = 0; k < numBands; ++k) {
                val[k] = DataTypeCalculator.computeValueBands(values, valueCount, k);
            }
        }

        private static int computeValueBands(int[][] data, int valueCount, int band) {
            int left = 0;
            int right = valueCount - 1;
            int target = valueCount / 2;
            while (true) {
                int oleft = left;
                int oright = right;
                int mid = data[(left + right) / 2][band];
                while (true) {
                    if (data[left][band] < mid) {
                        ++left;
                        continue;
                    }
                    while (mid < data[right][band]) {
                        --right;
                    }
                    if (left <= right) {
                        int tmp = data[left][band];
                        data[left][band] = data[right][band];
                        data[right][band] = tmp;
                        ++left;
                        --right;
                    }
                    if (left > right) break;
                }
                if (oleft < right && right >= target) {
                    left = oleft;
                    continue;
                }
                if (left >= oright || left > target) break;
                right = oright;
            }
            return data[target][band];
        }

        private static float computeValueBands(float[][] data, int valueCount, int band) {
            int left = 0;
            int right = valueCount - 1;
            int target = valueCount / 2;
            while (true) {
                int oleft = left;
                int oright = right;
                float mid = data[(left + right) / 2][band];
                while (true) {
                    if (data[left][band] < mid) {
                        ++left;
                        continue;
                    }
                    while (mid < data[right][band]) {
                        --right;
                    }
                    if (left <= right) {
                        float tmp = data[left][band];
                        data[left][band] = data[right][band];
                        data[right][band] = tmp;
                        ++left;
                        --right;
                    }
                    if (left > right) break;
                }
                if (oleft < right && right >= target) {
                    left = oleft;
                    continue;
                }
                if (left >= oright || left > target) break;
                right = oright;
            }
            return data[target][band];
        }

        private static double computeValueBands(double[][] data, int valueCount, int band) {
            int left = 0;
            int right = valueCount - 1;
            int target = valueCount / 2;
            while (true) {
                int oleft = left;
                int oright = right;
                double mid = data[(left + right) / 2][band];
                while (true) {
                    if (data[left][band] < mid) {
                        ++left;
                        continue;
                    }
                    while (mid < data[right][band]) {
                        --right;
                    }
                    if (left <= right) {
                        double tmp = data[left][band];
                        data[left][band] = data[right][band];
                        data[right][band] = tmp;
                        ++left;
                        --right;
                    }
                    if (left > right) break;
                }
                if (oleft < right && right >= target) {
                    left = oleft;
                    continue;
                }
                if (left >= oright || left > target) break;
                right = oright;
            }
            return data[target][band];
        }
    }
}

