/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.bandmerge;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.bandmerge.BandMergeDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestBase {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static final int BAND_NUMBER = 4;
    private static RenderedImage[] testImage;
    private static Range[] rangeND;
    private static double destNoData;

    @BeforeClass
    public static void initialSetup() {
        IMAGE_FILLER = true;
        byte noDataB = 100;
        short noDataUS = 100;
        short noDataS = 100;
        int noDataI = 100;
        float noDataF = 100.0f;
        double noDataD = 100.0;
        testImage = new RenderedImage[4];
        switch (TEST_SELECTOR) {
            case 0: {
                RenderedImage image = ComparisonTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)1);
                for (int i = 0; i < 4; ++i) {
                    ComparisonTest.testImage[i] = image;
                }
                break;
            }
            case 1: {
                RenderedImage image = ComparisonTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false, (int)1);
                for (int i = 0; i < 4; ++i) {
                    ComparisonTest.testImage[i] = image;
                }
                break;
            }
            case 2: {
                RenderedImage image = ComparisonTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1);
                for (int i = 0; i < 4; ++i) {
                    ComparisonTest.testImage[i] = image;
                }
                break;
            }
            case 3: {
                RenderedImage image = ComparisonTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)1);
                for (int i = 0; i < 4; ++i) {
                    ComparisonTest.testImage[i] = image;
                }
                break;
            }
            case 4: {
                RenderedImage image = ComparisonTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)1);
                for (int i = 0; i < 4; ++i) {
                    ComparisonTest.testImage[i] = image;
                }
                break;
            }
            case 5: {
                RenderedImage image = ComparisonTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)1);
                for (int i = 0; i < 4; ++i) {
                    ComparisonTest.testImage[i] = image;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        IMAGE_FILLER = false;
        if (RANGE_USED) {
            switch (TEST_SELECTOR) {
                case 0: {
                    rangeND = new Range[]{RangeFactory.create((byte)noDataB, (boolean)true, (byte)noDataB, (boolean)true)};
                    break;
                }
                case 1: {
                    rangeND = new Range[]{RangeFactory.createU((short)noDataUS, (boolean)true, (short)noDataUS, (boolean)true)};
                    break;
                }
                case 2: {
                    rangeND = new Range[]{RangeFactory.create((short)noDataS, (boolean)true, (short)noDataS, (boolean)true)};
                    break;
                }
                case 3: {
                    rangeND = new Range[]{RangeFactory.create((int)noDataI, (boolean)true, (int)noDataI, (boolean)true)};
                    break;
                }
                case 4: {
                    rangeND = new Range[]{RangeFactory.create((float)noDataF, (boolean)true, (float)noDataF, (boolean)true, (boolean)true)};
                    break;
                }
                case 5: {
                    rangeND = new Range[]{RangeFactory.create((double)noDataD, (boolean)true, (double)noDataD, (boolean)true, (boolean)true)};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        destNoData = 50.0;
    }

    @Test
    public void testBandMergeDescriptor() {
        int dataType = TEST_SELECTOR;
        String description = "\n ";
        String stat = "BandMerge";
        description = OLD_DESCRIPTOR ? "Old " + stat : "New " + stat;
        String dataTypeString = "";
        switch (dataType) {
            case 0: {
                dataTypeString = dataTypeString + "Byte";
                break;
            }
            case 1: {
                dataTypeString = dataTypeString + "UShort";
                break;
            }
            case 2: {
                dataTypeString = dataTypeString + "Short";
                break;
            }
            case 3: {
                dataTypeString = dataTypeString + "Integer";
                break;
            }
            case 4: {
                dataTypeString = dataTypeString + "Float";
                break;
            }
            case 5: {
                dataTypeString = dataTypeString + "Double";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageMerged = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        Vector<RenderedImage> vec = new Vector<RenderedImage>(testImage.length);
        for (RenderedImage img : testImage) {
            vec.add(img);
        }
        ParameterBlockJAI pbj = new ParameterBlockJAI("bandmerge");
        pbj.setSources(vec);
        for (int i = 0; i < totalCycles; ++i) {
            if (OLD_DESCRIPTOR) {
                JAIExt.registerJAIDescriptor((String)"bandmerge");
                imageMerged = JAI.create((String)"bandmerge", (ParameterBlock)pbj, null);
            } else {
                imageMerged = BandMergeDescriptor.create((Range[])rangeND, (double)destNoData, (boolean)false, null, (RenderedImage[])testImage);
            }
            long start = System.nanoTime();
            imageMerged.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println(dataTypeString);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageMerged instanceof RenderedOp) {
            imageMerged.dispose();
        }
        for (int band = 0; band < 4; ++band) {
            ((TiledImage)testImage[band]).dispose();
        }
    }
}

