/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.border;

import it.geosolutions.jaiext.border.BorderDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BorderTest
extends TestBase {
    private static final double TOLERANCE = 0.1;
    public static boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static RenderedImage[] sourceIMG;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static BorderExtender[] extenders;
    private static double destNoData;
    private static int leftPad;
    private static int rightPad;
    private static int topPad;
    private static int bottomPad;

    @BeforeClass
    public static void initialSetup() {
        byte noDataB = 50;
        short noDataU = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        boolean nanIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataU, (boolean)minIncluded, (short)noDataU, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)nanIncluded);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)nanIncluded);
        sourceIMG = new RenderedImage[6];
        IMAGE_FILLER = true;
        BorderTest.sourceIMG[0] = BorderTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)1);
        BorderTest.sourceIMG[1] = BorderTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataU, (boolean)false, (int)1);
        BorderTest.sourceIMG[2] = BorderTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)1);
        BorderTest.sourceIMG[3] = BorderTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)1);
        BorderTest.sourceIMG[4] = BorderTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)1);
        BorderTest.sourceIMG[5] = BorderTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)1);
        IMAGE_FILLER = false;
        extenders = new BorderExtender[4];
        BorderTest.extenders[0] = BorderExtender.createInstance((int)0);
        BorderTest.extenders[1] = BorderExtender.createInstance((int)1);
        BorderTest.extenders[2] = BorderExtender.createInstance((int)2);
        BorderTest.extenders[3] = BorderExtender.createInstance((int)3);
        destNoData = 100.0;
        leftPad = 2;
        rightPad = 2;
        topPad = 2;
        bottomPad = 2;
    }

    @Test
    public void testBorderZero() {
        boolean noDataRangeUsed = false;
        int borderType = 0;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
        noDataRangeUsed = true;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
    }

    @Test
    public void testBorderCopy() {
        boolean noDataRangeUsed = false;
        int borderType = 1;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
        noDataRangeUsed = true;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
    }

    @Test
    public void testBorderReflect() {
        boolean noDataRangeUsed = false;
        int borderType = 2;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
        noDataRangeUsed = true;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
    }

    @Test
    public void testBorderWrap() {
        boolean noDataRangeUsed = false;
        int borderType = 3;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
        noDataRangeUsed = true;
        this.testBorder(0, noDataRangeUsed, borderType);
        this.testBorder(1, noDataRangeUsed, borderType);
        this.testBorder(2, noDataRangeUsed, borderType);
        this.testBorder(3, noDataRangeUsed, borderType);
        this.testBorder(4, noDataRangeUsed, borderType);
        this.testBorder(5, noDataRangeUsed, borderType);
    }

    private void testBorder(int dataType, boolean noDataRangeUsed, int borderType) {
        Range noDataRange;
        BorderExtender extend;
        RenderedImage source;
        block13: {
            block12: {
                source = sourceIMG[dataType];
                extend = extenders[borderType];
                if (!noDataRangeUsed) break block12;
                switch (dataType) {
                    case 0: {
                        noDataRange = noDataByte;
                        break block13;
                    }
                    case 1: {
                        noDataRange = noDataUShort;
                        break block13;
                    }
                    case 2: {
                        noDataRange = noDataShort;
                        break block13;
                    }
                    case 3: {
                        noDataRange = noDataInt;
                        break block13;
                    }
                    case 4: {
                        noDataRange = noDataFloat;
                        break block13;
                    }
                    case 5: {
                        noDataRange = noDataDouble;
                        break block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noDataRange = null;
        }
        RenderedOp borderIMG = BorderDescriptor.create((RenderedImage)source, (int)leftPad, (int)rightPad, (int)topPad, (int)bottomPad, (BorderExtender)extend, (Range)noDataRange, (double)destNoData, null);
        if (INTERACTIVE && dataType == 0 && TEST_SELECTOR == borderType && noDataRangeUsed == RANGE_USED) {
            RenderedImageBrowser.showChain((RenderedImage)borderIMG, (boolean)false, (boolean)false);
            try {
                System.in.read();
            }
            catch (IOException iOException) {}
        } else {
            borderIMG.getTiles();
        }
        this.checkBorderImage(noDataRangeUsed, borderType, borderIMG);
    }

    private void checkBorderImage(boolean noDataRangeUsed, int borderType, RenderedOp borderIMG) {
        double valueWrap;
        Raster tileWrap;
        double valueReflect;
        double valueCopy;
        double value;
        Raster tile;
        int minX = borderIMG.getMinX();
        int minY = borderIMG.getMinY();
        int maxXPadding = minX + leftPad;
        int maxYPadding = minY + topPad;
        int maxX = borderIMG.getMaxX();
        int maxY = borderIMG.getMaxY();
        int width = DEFAULT_WIDTH / 2;
        int height = DEFAULT_HEIGHT / 2;
        int widthReduced = width - rightPad;
        int heightReduced = height - bottomPad;
        int topPaddingBorder = topPad + minY;
        int leftPaddingBorder = leftPad + minX;
        int xIndex = 0;
        int yIndex = 0;
        int tileX = 0;
        int tileY = 0;
        int xWrap = 0;
        int yWrap = 0;
        for (int x = minX; x < width; ++x) {
            tileX = borderIMG.XToTileX(x);
            if (x <= leftPad || x >= widthReduced) continue;
            block13: for (int y = minY; y < topPaddingBorder; ++y) {
                tileY = borderIMG.YToTileY(y);
                tile = borderIMG.getTile(tileX, tileY);
                value = tile.getSampleDouble(x, y, 0);
                switch (borderType) {
                    case 0: {
                        Assert.assertEquals((double)value, (double)0.0, (double)0.1);
                        continue block13;
                    }
                    case 1: {
                        valueCopy = tile.getSampleDouble(x, maxYPadding, 0);
                        if (noDataRangeUsed) {
                            if (noDataDouble.contains(valueCopy)) {
                                Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                continue block13;
                            }
                            Assert.assertEquals((double)value, (double)valueCopy, (double)0.1);
                            continue block13;
                        }
                        Assert.assertEquals((double)value, (double)valueCopy, (double)0.1);
                        continue block13;
                    }
                    case 2: {
                        yIndex = y - minY;
                        valueReflect = tile.getSampleDouble(x, topPad - yIndex - 1, 0);
                        if (noDataRangeUsed) {
                            if (noDataDouble.contains(valueReflect)) {
                                Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                continue block13;
                            }
                            Assert.assertEquals((double)value, (double)valueReflect, (double)0.1);
                            continue block13;
                        }
                        Assert.assertEquals((double)value, (double)valueReflect, (double)0.1);
                        continue block13;
                    }
                    case 3: {
                        yIndex = topPad - (y - minY);
                        yWrap = maxY - bottomPad - yIndex;
                        tileY = borderIMG.YToTileY(yWrap);
                        tileWrap = borderIMG.getTile(tileX, tileY);
                        valueWrap = tileWrap.getSampleDouble(x, yWrap, 0);
                        if (noDataRangeUsed) {
                            if (noDataDouble.contains(valueWrap)) {
                                Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                continue block13;
                            }
                            Assert.assertEquals((double)value, (double)valueWrap, (double)0.1);
                            continue block13;
                        }
                        Assert.assertEquals((double)value, (double)valueWrap, (double)0.1);
                        continue block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong BorderExtender type");
                    }
                }
            }
        }
        for (int y = minY; y < height; ++y) {
            tileY = borderIMG.YToTileY(y);
            if (y <= topPad || y >= heightReduced) continue;
            block15: for (int x = minX; x < leftPaddingBorder; ++x) {
                tileX = borderIMG.XToTileX(x);
                tile = borderIMG.getTile(tileX, tileY);
                value = tile.getSampleDouble(x, y, 0);
                switch (borderType) {
                    case 0: {
                        Assert.assertEquals((double)value, (double)0.0, (double)0.1);
                        continue block15;
                    }
                    case 1: {
                        valueCopy = tile.getSampleDouble(maxXPadding, y, 0);
                        if (noDataRangeUsed) {
                            if (noDataDouble.contains(valueCopy)) {
                                Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                continue block15;
                            }
                            Assert.assertEquals((double)value, (double)valueCopy, (double)0.1);
                            continue block15;
                        }
                        Assert.assertEquals((double)value, (double)valueCopy, (double)0.1);
                        continue block15;
                    }
                    case 2: {
                        xIndex = x - minX;
                        valueReflect = tile.getSampleDouble(leftPad - xIndex - 1, y, 0);
                        if (noDataRangeUsed) {
                            if (noDataDouble.contains(valueReflect)) {
                                Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                continue block15;
                            }
                            Assert.assertEquals((double)value, (double)valueReflect, (double)0.1);
                            continue block15;
                        }
                        Assert.assertEquals((double)value, (double)valueReflect, (double)0.1);
                        continue block15;
                    }
                    case 3: {
                        xIndex = leftPad - (x - minX);
                        xWrap = maxX - rightPad - xIndex;
                        tileX = borderIMG.XToTileX(xWrap);
                        tileWrap = borderIMG.getTile(tileX, tileY);
                        valueWrap = tileWrap.getSampleDouble(xWrap, y, 0);
                        if (noDataRangeUsed) {
                            if (noDataDouble.contains(valueWrap)) {
                                Assert.assertEquals((double)value, (double)destNoData, (double)0.1);
                                continue block15;
                            }
                            Assert.assertEquals((double)value, (double)valueWrap, (double)0.1);
                            continue block15;
                        }
                        Assert.assertEquals((double)value, (double)valueWrap, (double)0.1);
                        continue block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong BorderExtender type");
                    }
                }
            }
        }
    }

    @Test
    public void testPackedImage() {
        int[] dataTypes;
        Integer validData = 1;
        for (int dataType : dataTypes = new int[]{0, 1, 3}) {
            for (int borderType = 0; borderType < extenders.length; ++borderType) {
                BorderExtender extender = extenders[borderType];
                MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(dataType, DEFAULT_WIDTH, DEFAULT_HEIGHT, 2);
                RenderedImage image = BorderTest.createTestImage((int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)0, (int)1, (Number)validData, (SampleModel)sm);
                Range noDataRange = null;
                RenderedOp borderImg = BorderDescriptor.create((RenderedImage)image, (int)leftPad, (int)rightPad, (int)topPad, (int)bottomPad, (BorderExtender)extender, noDataRange, (double)destNoData, null);
                borderImg.getData();
                this.checkBorderImage(false, borderType, borderImg);
                borderImg.dispose();
            }
        }
    }
}

