/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.buffer;

import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.buffer.BufferDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.BorderExtender;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BufferTest
extends TestBase {
    public static final int DEFAULT_IMG_NUM = 6;
    public static final int DEFAULT_TILE_WIDTH = 32;
    public static final int DEFAULT_TILE_HEIGHT = 32;
    private static final int INPUT = 1;
    private static final int OUTPUT = 100;
    private static final double EXPECTED_RESULT = 0.0;
    private static final double TOLERANCE = 1.0E-4;
    private static TiledImage[] images;
    private static List<ROI> rois;
    private static double noDataValue;
    private static int leftPad;
    private static int rightPad;
    private static int topPad;
    private static int bottomPad;
    private static int type;
    private static double pixelArea;
    private static BorderExtender extender;
    private static TiledImage imageFinal;

    @BeforeClass
    public static void initialSetup() {
        images = new TiledImage[6];
        BufferTest.images[0] = BufferTest.createImage(0, 1);
        BufferTest.images[1] = BufferTest.createImage(1, 1);
        BufferTest.images[2] = BufferTest.createImage(2, 1);
        BufferTest.images[3] = BufferTest.createImage(3, 1);
        BufferTest.images[4] = BufferTest.createImage(4, 1);
        BufferTest.images[5] = BufferTest.createImage(5, 1);
        imageFinal = BufferTest.createImage(3, 100);
        rois = new ArrayList<ROI>(1);
        rois.add((ROI)new ROIShape((Shape)new Rectangle(10, 10, 10, 10)));
        leftPad = 10;
        rightPad = 10;
        topPad = 10;
        bottomPad = 10;
        type = 3;
        extender = BufferDescriptor.DEFAULT_EXTENDER;
        noDataValue = 0.0;
        pixelArea = 1.0;
    }

    @Test
    public void testImages() {
        boolean noDataUsed = false;
        this.testImage((RenderedImage)images[0], noDataUsed);
        this.testImage((RenderedImage)images[1], noDataUsed);
        this.testImage((RenderedImage)images[2], noDataUsed);
        this.testImage((RenderedImage)images[3], noDataUsed);
        this.testImage((RenderedImage)images[4], noDataUsed);
        this.testImage((RenderedImage)images[5], noDataUsed);
    }

    @Test
    public void testImagesNoData() {
        boolean noDataUsed = true;
        this.testImage((RenderedImage)images[0], noDataUsed);
        this.testImage((RenderedImage)images[1], noDataUsed);
        this.testImage((RenderedImage)images[2], noDataUsed);
        this.testImage((RenderedImage)images[3], noDataUsed);
        this.testImage((RenderedImage)images[4], noDataUsed);
        this.testImage((RenderedImage)images[5], noDataUsed);
    }

    @AfterClass
    public static void finalStuff() {
        images[0].dispose();
        images[1].dispose();
        images[2].dispose();
        images[3].dispose();
        images[4].dispose();
        images[5].dispose();
    }

    private void testImage(RenderedImage source, boolean noData) {
        Range noDataRange = null;
        int dataType = source.getSampleModel().getDataType();
        if (noData) {
            switch (dataType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    noDataRange = RangeFactory.create((int)((int)noDataValue), (boolean)true, (int)((int)noDataValue), (boolean)true);
                    break;
                }
                case 4: {
                    noDataRange = RangeFactory.create((float)((float)noDataValue), (boolean)true, (float)((float)noDataValue), (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    noDataRange = RangeFactory.create((double)noDataValue, (boolean)true, (double)noDataValue, (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        RenderedOp dest = BufferDescriptor.create((RenderedImage)source, (BorderExtender)extender, (int)leftPad, (int)rightPad, (int)topPad, (int)bottomPad, rois, (Range)noDataRange, (double)noDataValue, null, (Integer)type, (double)pixelArea, null);
        if (INTERACTIVE && dataType == 0) {
            RenderedImageBrowser.showChain((RenderedImage)dest);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            dest.getTiles();
        }
        RenderedOp difference = AlgebraDescriptor.create((AlgebraDescriptor.Operator)AlgebraDescriptor.Operator.SUBTRACT, null, null, (double)3.0, null, (RenderedImage[])new RenderedImage[]{dest, imageFinal});
        Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.MEAN};
        RenderedOp statsIMG = StatisticsDescriptor.create((RenderedImage)difference, (int)1, (int)1, null, null, (boolean)false, null, (Statistics.StatsType[])stats, null);
        Statistics mean = ((Statistics[][])statsIMG.getProperty("JAI-EXT.stats"))[0][0];
        double meanValue = (Double)mean.getResult();
        Assert.assertEquals((double)0.0, (double)meanValue, (double)1.0E-4);
        statsIMG.dispose();
        difference.dispose();
        dest.dispose();
    }

    private static TiledImage createImage(int dataType, int value) {
        ComponentSampleModel sm = new ComponentSampleModel(dataType, DEFAULT_WIDTH, DEFAULT_HEIGHT, 1, DEFAULT_WIDTH, new int[]{0});
        TiledImage image = new TiledImage((SampleModel)sm, 32, 32);
        int minX = 10;
        int maxX = 20;
        int minY = 10;
        int maxY = 20;
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                image.setSample(x, y, 0, value);
            }
        }
        return image;
    }
}

