/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.ClassBreaksDescriptor;
import it.geosolutions.jaiext.classbreaks.ClassBreaksRIF;
import it.geosolutions.jaiext.classbreaks.Classification;
import it.geosolutions.jaiext.classbreaks.ClassificationMethod;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.ExtremaDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class ClassBreaksOpImageTest
extends TestBase {
    static final double EPS = 0.001;

    static RenderedImage createImage() {
        return ImageUtilities.createImageFromArray((Number[])new Number[]{1, 1, 2, 3, 3, 8, 8, 9, 11, 14, 16, 24, 26, 26, 45, 53}, (int)4, (int)4);
    }

    @Test
    public void getMissingProperty() {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.QUANTILE);
        pb.setParameter("numClasses", 5);
        RenderedImage op = new ClassBreaksRIF().create((ParameterBlock)pb, null);
        Object roi = op.getProperty("ROI");
        Assert.assertEquals((Object)Image.UndefinedProperty, (Object)roi);
    }

    @Test
    public void testEqualInterval() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.EQUAL_INTERVAL);
        pb.setParameter("numClasses", 4);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        Number[] breaks = classification.getBreaks()[0];
        Assert.assertEquals((long)5L, (long)breaks.length);
        Assert.assertEquals((double)1.0, (double)breaks[0].doubleValue(), (double)0.001);
        Assert.assertEquals((double)14.0, (double)breaks[1].doubleValue(), (double)0.001);
        Assert.assertEquals((double)27.0, (double)breaks[2].doubleValue(), (double)0.001);
        Assert.assertEquals((double)40.0, (double)breaks[3].doubleValue(), (double)0.001);
        Assert.assertEquals((double)53.0, (double)breaks[4].doubleValue(), (double)0.001);
    }

    @Test
    public void testQuantileBreaks() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.QUANTILE);
        pb.setParameter("numClasses", 4);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        Number[] breaks = classification.getBreaks()[0];
        Assert.assertEquals((long)5L, (long)breaks.length);
        Assert.assertEquals((double)1.0, (double)breaks[0].doubleValue(), (double)0.001);
        Assert.assertEquals((double)3.0, (double)breaks[1].doubleValue(), (double)0.001);
        Assert.assertEquals((double)11.0, (double)breaks[2].doubleValue(), (double)0.001);
        Assert.assertEquals((double)26.0, (double)breaks[3].doubleValue(), (double)0.001);
        Assert.assertEquals((double)53.0, (double)breaks[4].doubleValue(), (double)0.001);
    }

    @Test
    public void testQuantileBreaksHistogram() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.QUANTILE);
        pb.setParameter("numClasses", 4);
        pb.setParameter("extrema", (Object)this.getExtrema(image));
        pb.setParameter("histogram", true);
        pb.setParameter("histogramBins", 100);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        Number[] breaks = classification.getBreaks()[0];
        Assert.assertEquals((long)5L, (long)breaks.length);
        Assert.assertEquals((double)1.0, (double)breaks[0].doubleValue(), (double)0.001);
        Assert.assertEquals((double)8.0, (double)breaks[1].doubleValue(), (double)0.001);
        Assert.assertEquals((double)11.0, (double)breaks[2].doubleValue(), (double)0.001);
        Assert.assertEquals((double)26.0, (double)breaks[3].doubleValue(), (double)0.001);
        Assert.assertEquals((double)53.0, (double)breaks[4].doubleValue(), (double)0.001);
    }

    @Test
    public void testNaturalBreaks() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.NATURAL_BREAKS);
        pb.setParameter("numClasses", 4);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        Number[] breaks = classification.getBreaks()[0];
        Assert.assertEquals((long)5L, (long)breaks.length);
        Assert.assertEquals((double)1.0, (double)breaks[0].doubleValue(), (double)0.001);
        Assert.assertEquals((double)3.0, (double)breaks[1].doubleValue(), (double)0.001);
        Assert.assertEquals((double)16.0, (double)breaks[2].doubleValue(), (double)0.001);
        Assert.assertEquals((double)26.0, (double)breaks[3].doubleValue(), (double)0.001);
        Assert.assertEquals((double)53.0, (double)breaks[4].doubleValue(), (double)0.001);
    }

    @Test
    public void testNaturalBreaksHistogram() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.NATURAL_BREAKS);
        pb.setParameter("numClasses", 4);
        pb.setParameter("extrema", (Object)this.getExtrema(image));
        pb.setParameter("histogram", true);
        pb.setParameter("histogramBins", 100);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        Number[] breaks = classification.getBreaks()[0];
        Assert.assertEquals((long)5L, (long)breaks.length);
        Assert.assertEquals((double)1.0, (double)breaks[0].doubleValue(), (double)0.001);
        Assert.assertEquals((double)3.0, (double)breaks[1].doubleValue(), (double)0.001);
        Assert.assertEquals((double)16.0, (double)breaks[2].doubleValue(), (double)0.001);
        Assert.assertEquals((double)26.0, (double)breaks[3].doubleValue(), (double)0.001);
        Assert.assertEquals((double)53.0, (double)breaks[4].doubleValue(), (double)0.001);
    }

    @Test
    public void testNaturalBreaksWithPercentages() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.NATURAL_BREAKS);
        pb.setParameter("numClasses", 4);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)4L, (long)percentages.length);
        Assert.assertTrue((percentages[0] == 18.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 43.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[2] == 12.5 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[3] == 25.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNaturalBreaksHistogramWithPercentages() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.NATURAL_BREAKS);
        pb.setParameter("numClasses", 4);
        pb.setParameter("extrema", (Object)this.getExtrema(image));
        pb.setParameter("histogram", true);
        pb.setParameter("histogramBins", 4);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)3L, (long)percentages.length);
        Assert.assertTrue((Math.floor(percentages[0]) == 56.0 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 31.25 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[2] == 12.5 ? 1 : 0) != 0);
    }

    @Test
    public void testNaturalBreaksWithPercentagesMoreClassesThanIntervals() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.NATURAL_BREAKS);
        pb.setParameter("numClasses", 11);
        pb.setParameter("extrema", (Object)this.getExtrema(image));
        pb.setParameter("histogram", true);
        pb.setParameter("histogramBins", 100);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)6L, (long)percentages.length);
        Assert.assertTrue((percentages[0] == 12.5 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 18.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[2] == 18.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[3] == 12.5 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[4] == 12.5 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[5] == 25.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNaturalBreaksHistogramWithPercentagesMoreClassesThanIntervals() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.NATURAL_BREAKS);
        pb.setParameter("numClasses", 11);
        pb.setParameter("extrema", (Object)this.getExtrema(image));
        pb.setParameter("histogram", true);
        pb.setParameter("histogramBins", 100);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)6L, (long)percentages.length);
        Assert.assertTrue((percentages[0] == 12.5 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 18.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[2] == 18.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[3] == 12.5 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[4] == 12.5 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[5] == 25.0 ? 1 : 0) != 0);
    }

    @Test
    public void testQuantileBreaksWithPercentages() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.QUANTILE);
        pb.setParameter("numClasses", 4);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)4L);
        Assert.assertTrue((percentages[0] == 18.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 31.25 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[2] == 25.0 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[3] == 25.0 ? 1 : 0) != 0);
    }

    @Test
    public void testQuantileBreaksPercentagesMoreClassesThaIntervals() {
        TiledImage image = ImageUtilities.createImageFromArray((Number[])new Number[]{1, 1, 1, 1, 1, 1, 1, 1, 8, 8, 8, 8, 3, 3, 3, 3}, (int)4, (int)4);
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.QUANTILE);
        pb.setParameter("numClasses", 5);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)2L);
        Assert.assertTrue((percentages[0] == 50.0 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 50.0 ? 1 : 0) != 0);
    }

    @Test
    public void testQuantileBreaksHistogramWithPercentages() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.QUANTILE);
        pb.setParameter("numClasses", 4);
        pb.setParameter("extrema", (Object)this.getExtrema(image));
        pb.setParameter("histogram", true);
        pb.setParameter("histogramBins", 100);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)4L);
        Assert.assertTrue((percentages[0] == 31.25 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 18.75 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[2] == 25.0 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[3] == 25.0 ? 1 : 0) != 0);
    }

    @Test
    public void testQuantileBreaksHistogramsPercentagesMoreClassesThaIntervals() {
        TiledImage image2 = ImageUtilities.createImageFromArray((Number[])new Number[]{1, 1, 1, 1, 1, 1, 1, 1, 8, 8, 8, 8, 11, 11, 11, 16}, (int)4, (int)4);
        ParameterBlockJAI pb2 = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb2.addSource((Object)image2);
        pb2.setParameter("method", (Object)ClassificationMethod.QUANTILE);
        pb2.setParameter("numClasses", 5);
        pb2.setParameter("extrema", (Object)this.getExtrema((RenderedImage)image2));
        pb2.setParameter("histogram", true);
        pb2.setParameter("histogramBins", 100);
        pb2.setParameter("percentages", true);
        RenderedOp op2 = JAI.create((String)"ClassBreaks", (ParameterBlock)pb2, null);
        Classification classification2 = (Classification)op2.getProperty("Classification");
        Assert.assertNotNull((Object)classification2);
        double[] percentages2 = classification2.getPercentages();
        Assert.assertEquals((long)percentages2.length, (long)3L);
        Assert.assertTrue((percentages2[0] == 50.0 ? 1 : 0) != 0);
        Assert.assertTrue((percentages2[1] == 25.0 ? 1 : 0) != 0);
        Assert.assertTrue((percentages2[2] == 25.0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualIntervalBreaksWithPercentages() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new ClassBreaksDescriptor());
        pb.addSource((Object)image);
        pb.setParameter("method", (Object)ClassificationMethod.EQUAL_INTERVAL);
        pb.setParameter("numClasses", 4);
        pb.setParameter("percentages", true);
        RenderedOp op = JAI.create((String)"ClassBreaks", (ParameterBlock)pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        double[] percentages = classification.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)4L);
        Assert.assertTrue((percentages[0] == 56.25 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[1] == 31.25 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[2] == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((percentages[3] == 12.5 ? 1 : 0) != 0);
    }

    private Double[][] getExtrema(RenderedImage image) {
        RenderedOp extremaOp = ExtremaDescriptor.create((RenderedImage)image, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)1, null);
        double[][] extrema = (double[][])extremaOp.getProperty("extrema");
        Double[][] result = new Double[][]{{extrema[0][0]}, {extrema[1][0]}};
        return result;
    }

    @Test
    public void testCreatesOperationDirectlyFromClassBreaksRIF() throws Exception {
        RenderedImage image = ClassBreaksOpImageTest.createImage();
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.set(4, 0);
        pb.set(ClassificationMethod.NATURAL_BREAKS, 1);
        pb.set(null, 2);
        pb.set(null, 3);
        pb.set(new Integer[]{0}, 4);
        pb.set(1, 5);
        pb.set(1, 6);
        pb.set(0.0, 7);
        RenderedImage op = new ClassBreaksRIF().create(pb, null);
        Classification classification = (Classification)op.getProperty("Classification");
        Assert.assertNotNull((Object)classification);
        Number[] breaks = classification.getBreaks()[0];
        Assert.assertEquals((long)5L, (long)breaks.length);
        Assert.assertEquals((double)1.0, (double)breaks[0].doubleValue(), (double)0.001);
        Assert.assertEquals((double)3.0, (double)breaks[1].doubleValue(), (double)0.001);
        Assert.assertEquals((double)16.0, (double)breaks[2].doubleValue(), (double)0.001);
        Assert.assertEquals((double)26.0, (double)breaks[3].doubleValue(), (double)0.001);
        Assert.assertEquals((double)53.0, (double)breaks[4].doubleValue(), (double)0.001);
    }
}

