/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.ClassBreaksOpImage;
import it.geosolutions.jaiext.classbreaks.ClassPercentagesManager;
import it.geosolutions.jaiext.classbreaks.Classification;
import it.geosolutions.jaiext.classbreaks.HistogramClassification;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.media.jai.ROI;

public class QuantileBreaksHistogramOpImage
extends ClassBreaksOpImage {
    int numBins;

    public QuantileBreaksHistogramOpImage(RenderedImage image, Integer numClasses, Double[][] extrema, ROI roi, Integer[] bands, Integer xStart, Integer yStart, Integer xPeriod, Integer yPeriod, Double noData, int numBins, Boolean percentages) {
        super(image, numClasses, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
        this.numBins = numBins;
    }

    @Override
    protected Classification createClassification() {
        return new HistogramClassification(this.bands.length, this.extrema, this.numBins);
    }

    @Override
    protected void handleValue(double d, Classification c, int band) {
        ((HistogramClassification)c).count(d, band);
    }

    @Override
    protected void postCalculate(Classification c, int band) {
        HistogramClassification hc = (HistogramClassification)c;
        List<HistogramClassification.Bucket> buckets = hc.getBuckets(band);
        int nvalues = buckets.stream().mapToInt(b -> b.getCount()).sum();
        int size = (int)Math.ceil((double)nvalues / (double)this.numClasses.intValue());
        Iterator<HistogramClassification.Bucket> it = buckets.iterator();
        TreeSet<Double> set = new TreeSet<Double>();
        HistogramClassification.Bucket e = it.next();
        int classIdx = 1;
        int count = 0;
        set.add(e.getMin());
        while (classIdx < this.numClasses && it.hasNext()) {
            e = it.next();
            if ((count += e.getCount()) < size * classIdx) continue;
            ++classIdx;
            set.add(e.getMin());
        }
        set.add(buckets.get(buckets.size() - 1).getMax());
        hc.setBreaks(band, set.toArray(new Double[set.size()]));
        if (this.percentages.booleanValue()) {
            int nBreaks = set.size();
            int actualClassNum = this.numClasses >= nBreaks ? nBreaks - 1 : this.numClasses;
            hc.setPercentages(this.getPercentages(new ArrayList<Double>(set), buckets, nvalues, actualClassNum));
        }
    }

    private double[] getPercentages(List<Double> tBreaks, List<HistogramClassification.Bucket> buckets, int nvalues, int numClasses) {
        ClassPercentagesManager percentagesManager = new ClassPercentagesManager();
        return percentagesManager.getPercentages(buckets, tBreaks, numClasses);
    }
}

