/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.ClassBreaksOpImage;
import it.geosolutions.jaiext.classbreaks.ClassPercentagesManager;
import it.geosolutions.jaiext.classbreaks.Classification;
import it.geosolutions.jaiext.classbreaks.ClassificationMethod;
import it.geosolutions.jaiext.classbreaks.NaturalClassification;
import java.awt.image.RenderedImage;
import java.util.List;
import javax.media.jai.ROI;

public class EqualIntervalBreaksOpImage
extends ClassBreaksOpImage {
    public EqualIntervalBreaksOpImage(RenderedImage image, Integer numClasses, Double[][] extrema, ROI roi, Integer[] bands, Integer xStart, Integer yStart, Integer xPeriod, Integer yPeriod, Double noData, Boolean percentages) {
        super(image, numClasses, extrema, roi, bands, xStart, yStart, xPeriod, yPeriod, noData, percentages);
    }

    @Override
    protected Classification createClassification() {
        if (!this.percentages.booleanValue()) {
            return new Classification(ClassificationMethod.EQUAL_INTERVAL, this.bands.length);
        }
        return new NaturalClassification(ClassificationMethod.EQUAL_INTERVAL, this.bands.length);
    }

    @Override
    protected Classification preCalculate() {
        if (this.extrema != null) {
            Classification c = this.createClassification();
            for (int b = 0; b < this.bands.length; ++b) {
                double min = this.extrema[0][b];
                double max = this.extrema[1][b];
                c.setMin(b, min);
                c.setMax(b, max);
                this.calculateBreaks(c, b);
            }
            return c;
        }
        return null;
    }

    @Override
    protected void handleValue(double d, Classification c, int band) {
        c.setMin(band, c.getMin(band) == null ? d : Math.min(c.getMin(band), d));
        c.setMax(band, c.getMax(band) == null ? d : Math.max(c.getMax(band), d));
        if (this.percentages.booleanValue()) {
            ((NaturalClassification)c).count(d, band);
        }
    }

    @Override
    protected void postCalculate(Classification c, int band) {
        this.calculateBreaks(c, band);
    }

    void calculateBreaks(Classification c, int band) {
        Double[] breaks = new Double[this.numClasses + 1];
        double min = c.getMin(band);
        double max = c.getMax(band);
        double delta = (max - min) / (double)this.numClasses.intValue();
        double start = min;
        for (int j = 0; j < this.numClasses; ++j) {
            breaks[j] = start;
            start += delta;
        }
        breaks[this.numClasses.intValue()] = max;
        c.setBreaks(band, breaks);
        if (this.percentages.booleanValue()) {
            c.setPercentages(this.getPercentages(c, band, breaks));
        }
    }

    private double[] getPercentages(Classification c, int band, Double[] breaks) {
        ClassPercentagesManager percentagesManager = new ClassPercentagesManager();
        List<Double> data = ((NaturalClassification)c).getValues(band);
        return percentagesManager.getPercentages(data, breaks, (double)data.size(), (int)this.numClasses);
    }
}

