/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorconvert;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.colorconvert.IHSColorSpaceJAIExt;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ColorSpaceJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.iterator.RandomIter;

public abstract class ColorSpaceJAIExt
extends ColorSpaceJAI {
    private static final double maxXYZ = 1.999969482421875;
    private static double[] LUT = new double[256];
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    public static final double POWER1 = 0.4166666666666667;

    protected ColorSpaceJAIExt(int type, int numComponents, boolean isRGBPreferredIntermediary) {
        super(type, numComponents, isRGBPreferredIntermediary);
    }

    public abstract WritableRaster fromCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4, ROI var5, Range var6, float[] var7);

    public abstract WritableRaster fromRGB(Raster var1, int[] var2, WritableRaster var3, Rectangle var4, int[] var5, ROI var6, Range var7, float[] var8);

    public abstract WritableRaster toCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4, ROI var5, Range var6, float[] var7);

    public abstract WritableRaster toRGB(Raster var1, int[] var2, WritableRaster var3, Rectangle var4, int[] var5, ROI var6, Range var7, float[] var8);

    public WritableRaster fromCIEXYZ(Raster src, int[] srcComponentSize, WritableRaster dest, int[] dstComponentSize) {
        return this.fromCIEXYZ(src, srcComponentSize, dest, dstComponentSize, null, null, null);
    }

    public WritableRaster fromRGB(Raster src, int[] srcComponentSize, WritableRaster dest, int[] dstComponentSize) {
        return this.fromRGB(src, srcComponentSize, dest, null, dstComponentSize, null, null, null);
    }

    public WritableRaster toCIEXYZ(Raster src, int[] srcComponentSize, WritableRaster dest, int[] dstComponentSize) {
        return this.toCIEXYZ(src, srcComponentSize, dest, dstComponentSize, null, null, null);
    }

    public WritableRaster toRGB(Raster src, int[] srcComponentSize, WritableRaster dest, int[] dstComponentSize) {
        return this.toRGB(src, srcComponentSize, dest, null, dstComponentSize, null, null, null);
    }

    public static void RGB2XYZ(float[] RGB, float[] XYZ) {
        for (int i = 0; i < 3; ++i) {
            if (RGB[i] < 0.040449936f) {
                int n = i;
                RGB[n] = RGB[n] / 12.92f;
                continue;
            }
            RGB[i] = (float)Math.pow(((double)RGB[i] + 0.055) / 1.055, 2.4);
        }
        XYZ[0] = 0.45593762f * RGB[0] + 0.39533818f * RGB[1] + 0.19954965f * RGB[2];
        XYZ[1] = 0.23157515f * RGB[0] + 0.7790526f * RGB[1] + 0.07864978f * RGB[2];
        XYZ[2] = 0.01593493f * RGB[0] + 0.09841772f * RGB[1] + 0.7848861f * RGB[2];
    }

    public static void XYZ2RGB(float[] XYZ, float[] RGB) {
        RGB[0] = 2.9311228f * XYZ[0] - 1.4111496f * XYZ[1] - 0.6038046f * XYZ[2];
        RGB[1] = -0.8763701f * XYZ[0] + 1.7219844f * XYZ[1] + 0.0502565f * XYZ[2];
        RGB[2] = 0.05038065f * XYZ[0] - 0.187272f * XYZ[1] + 1.280027f * XYZ[2];
        for (int i = 0; i < 3; ++i) {
            float v = RGB[i];
            if (v < 0.0f) {
                v = 0.0f;
            }
            if (v < 0.0031308f) {
                RGB[i] = 12.92f * v;
                continue;
            }
            if (v > 1.0f) {
                v = 1.0f;
            }
            RGB[i] = (float)(1.055 * Math.pow(v, 0.4166666666666667) - 0.055);
        }
    }

    public static void convertToSigned(double[] buf, int dataType) {
        block3: {
            block2: {
                if (dataType != 2) break block2;
                for (int i = 0; i < buf.length; ++i) {
                    short temp = (short)((int)buf[i] & 0xFFFF);
                    buf[i] = temp;
                }
                break block3;
            }
            if (dataType != 3) break block3;
            for (int i = 0; i < buf.length; ++i) {
                int temp = (int)((long)buf[i] & 0xFFFFFFFFL);
                buf[i] = temp;
            }
        }
    }

    public static ColorSpaceJAIExt getIHSColorSpaceJAIEXT() {
        return new IHSColorSpaceJAIExt();
    }

    public static WritableRaster RGBToCIEXYZ(Raster src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, ROI roi, Range nodata, float[] destNodata) {
        ColorSpaceJAIExt.checkParameters((Raster)src, (int[])srcComponentSize, (WritableRaster)dest, (int[])destComponentSize);
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        Rectangle bounds = null;
        if (roi != null) {
            bounds = roi.getBounds();
            Rectangle srcRectExpanded = dest.getBounds();
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
            if (!bounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = roi.getAsImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        SampleModel srcSampleModel = src.getSampleModel();
        if (srcComponentSize == null) {
            srcComponentSize = srcSampleModel.getSampleSize();
        }
        if (dest == null) {
            Point origin = new Point(src.getMinX(), src.getMinY());
            dest = RasterFactory.createWritableRaster((SampleModel)srcSampleModel, (Point)origin);
        }
        SampleModel dstSampleModel = dest.getSampleModel();
        if (destComponentSize == null) {
            destComponentSize = dstSampleModel.getSampleSize();
        }
        PixelAccessor srcAcc = new PixelAccessor(srcSampleModel, null);
        UnpackedImageData srcUid = srcAcc.getPixels(src, src.getBounds(), srcSampleModel.getDataType(), false);
        switch (srcSampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAIExt.RGBToCIEXYZByte(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAIExt.RGBToCIEXYZShort(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 3: {
                ColorSpaceJAIExt.RGBToCIEXYZInt(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 4: {
                ColorSpaceJAIExt.RGBToCIEXYZFloat(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 5: {
                ColorSpaceJAIExt.RGBToCIEXYZDouble(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
            }
        }
        return dest;
    }

    private static void RGBToCIEXYZByte(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isInt;
        double normx;
        byte[] rBuf = src.getByteData(0);
        byte[] gBuf = src.getByteData(1);
        byte[] bBuf = src.getByteData(2);
        int normr = 8 - srcComponentSize[0];
        int normg = 8 - srcComponentSize[1];
        int normb = 8 - srcComponentSize[2];
        double normy = normx = 1.0;
        double normz = normx;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isInt = dstType < 4;
        if (isInt) {
            normx = (double)((1L << destComponentSize[0]) - 1L) / 1.999969482421875;
            normy = (double)((1L << destComponentSize[1]) - 1L) / 1.999969482421875;
            normz = (double)((1L << destComponentSize[2]) - 1L) / 1.999969482421875;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodataB(isInt, destNodata, normr, normg, normb, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    double R = LUT[(rBuf[rIndex] & 0xFF) << normr];
                    double G = LUT[(gBuf[gIndex] & 0xFF) << normg];
                    double B = LUT[(bBuf[bIndex] & 0xFF) << normb];
                    if (isInt) {
                        dstPixels[dIndex++] = (0.45593763 * R + 0.39533819 * G + 0.19954964 * B) * normx;
                        dstPixels[dIndex++] = (0.23157515 * R + 0.77905262 * G + 0.07864978 * B) * normy;
                        dstPixels[dIndex++] = (0.01593493 * R + 0.09841772 * G + 0.78488615 * B) * normz;
                    } else {
                        dstPixels[dIndex++] = 0.45593763 * R + 0.39533819 * G + 0.19954964 * B;
                        dstPixels[dIndex++] = 0.23157515 * R + 0.77905262 * G + 0.07864978 * B;
                        dstPixels[dIndex++] = 0.01593493 * R + 0.09841772 * G + 0.78488615 * B;
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double R = LUT[(rBuf[rIndex] & 0xFF) << normr];
                        double G = LUT[(gBuf[gIndex] & 0xFF) << normg];
                        double B = LUT[(bBuf[bIndex] & 0xFF) << normb];
                        if (isInt) {
                            dstPixels[dIndex++] = (0.45593763 * R + 0.39533819 * G + 0.19954964 * B) * normx;
                            dstPixels[dIndex++] = (0.23157515 * R + 0.77905262 * G + 0.07864978 * B) * normy;
                            dstPixels[dIndex++] = (0.01593493 * R + 0.09841772 * G + 0.78488615 * B) * normz;
                        } else {
                            dstPixels[dIndex++] = 0.45593763 * R + 0.39533819 * G + 0.19954964 * B;
                            dstPixels[dIndex++] = 0.23157515 * R + 0.77905262 * G + 0.07864978 * B;
                            dstPixels[dIndex++] = 0.01593493 * R + 0.09841772 * G + 0.78488615 * B;
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    byte r = rBuf[rIndex];
                    byte g = gBuf[gIndex];
                    byte b = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(r) || nodata.contains(g) || nodata.contains(b);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double R = LUT[(r & 0xFF) << normr];
                        double G = LUT[(g & 0xFF) << normg];
                        double B = LUT[(b & 0xFF) << normb];
                        if (isInt) {
                            dstPixels[dIndex++] = (0.45593763 * R + 0.39533819 * G + 0.19954964 * B) * normx;
                            dstPixels[dIndex++] = (0.23157515 * R + 0.77905262 * G + 0.07864978 * B) * normy;
                            dstPixels[dIndex++] = (0.01593493 * R + 0.09841772 * G + 0.78488615 * B) * normz;
                        } else {
                            dstPixels[dIndex++] = 0.45593763 * R + 0.39533819 * G + 0.19954964 * B;
                            dstPixels[dIndex++] = 0.23157515 * R + 0.77905262 * G + 0.07864978 * B;
                            dstPixels[dIndex++] = 0.01593493 * R + 0.09841772 * G + 0.78488615 * B;
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    byte r = rBuf[rIndex];
                    byte g = gBuf[gIndex];
                    byte b = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(r) || nodata.contains(g) || nodata.contains(b);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        double R = LUT[(r & 0xFF) << normr];
                        double G = LUT[(g & 0xFF) << normg];
                        double B = LUT[(b & 0xFF) << normb];
                        if (isInt) {
                            dstPixels[dIndex++] = (0.45593763 * R + 0.39533819 * G + 0.19954964 * B) * normx;
                            dstPixels[dIndex++] = (0.23157515 * R + 0.77905262 * G + 0.07864978 * B) * normy;
                            dstPixels[dIndex++] = (0.01593493 * R + 0.09841772 * G + 0.78488615 * B) * normz;
                        } else {
                            dstPixels[dIndex++] = 0.45593763 * R + 0.39533819 * G + 0.19954964 * B;
                            dstPixels[dIndex++] = 0.23157515 * R + 0.77905262 * G + 0.07864978 * B;
                            dstPixels[dIndex++] = 0.01593493 * R + 0.09841772 * G + 0.78488615 * B;
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void RGBToCIEXYZShort(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isInt;
        short[] rBuf = src.getShortData(0);
        short[] gBuf = src.getShortData(1);
        short[] bBuf = src.getShortData(2);
        float normr = (1 << srcComponentSize[0]) - 1;
        float normg = (1 << srcComponentSize[1]) - 1;
        float normb = (1 << srcComponentSize[2]) - 1;
        double normx = 1.0;
        double normy = 1.0;
        double normz = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isInt = dstType < 4;
        if (isInt) {
            normx = (double)((1L << destComponentSize[0]) - 1L) / 1.999969482421875;
            normy = (double)((1L << destComponentSize[1]) - 1L) / 1.999969482421875;
            normz = (double)((1L << destComponentSize[2]) - 1L) / 1.999969482421875;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodata(isInt, destNodata, 2, normr, normg, normb, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    RGB[0] = (float)(rBuf[rIndex] & 0xFFFF) / normr;
                    RGB[1] = (float)(gBuf[gIndex] & 0xFFFF) / normg;
                    RGB[2] = (float)(bBuf[bIndex] & 0xFFFF) / normb;
                    ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                    if (isInt) {
                        dstPixels[dIndex++] = (double)XYZ[0] * normx;
                        dstPixels[dIndex++] = (double)XYZ[1] * normy;
                        dstPixels[dIndex++] = (double)XYZ[2] * normz;
                    } else {
                        dstPixels[dIndex++] = XYZ[0];
                        dstPixels[dIndex++] = XYZ[1];
                        dstPixels[dIndex++] = XYZ[2];
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = (float)(rBuf[rIndex] & 0xFFFF) / normr;
                        RGB[1] = (float)(gBuf[gIndex] & 0xFFFF) / normg;
                        RGB[2] = (float)(bBuf[bIndex] & 0xFFFF) / normb;
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    short r = rBuf[rIndex];
                    short g = gBuf[gIndex];
                    short b = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(r) || nodata.contains(g) || nodata.contains(b);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = (float)(r & 0xFFFF) / normr;
                        RGB[1] = (float)(g & 0xFFFF) / normg;
                        RGB[2] = (float)(b & 0xFFFF) / normb;
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    short r = rBuf[rIndex];
                    short g = gBuf[gIndex];
                    short b = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(r) || nodata.contains(g) || nodata.contains(b);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = (float)(r & 0xFFFF) / normr;
                        RGB[1] = (float)(g & 0xFFFF) / normg;
                        RGB[2] = (float)(b & 0xFFFF) / normb;
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void RGBToCIEXYZInt(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isInt;
        int[] rBuf = src.getIntData(0);
        int[] gBuf = src.getIntData(1);
        int[] bBuf = src.getIntData(2);
        float normr = (1L << srcComponentSize[0]) - 1L;
        float normg = (1L << srcComponentSize[1]) - 1L;
        float normb = (1L << srcComponentSize[2]) - 1L;
        double normx = 1.0;
        double normy = 1.0;
        double normz = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isInt = dstType < 4;
        if (isInt) {
            normx = (double)((1L << destComponentSize[0]) - 1L) / 1.999969482421875;
            normy = (double)((1L << destComponentSize[1]) - 1L) / 1.999969482421875;
            normz = (double)((1L << destComponentSize[2]) - 1L) / 1.999969482421875;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodata(isInt, destNodata, 3, normr, normg, normb, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    RGB[0] = (float)((long)rBuf[rIndex] & 0xFFFFFFFFL) / normr;
                    RGB[1] = (float)((long)gBuf[gIndex] & 0xFFFFFFFFL) / normg;
                    RGB[2] = (float)((long)bBuf[bIndex] & 0xFFFFFFFFL) / normb;
                    ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                    if (isInt) {
                        dstPixels[dIndex++] = (double)XYZ[0] * normx;
                        dstPixels[dIndex++] = (double)XYZ[1] * normy;
                        dstPixels[dIndex++] = (double)XYZ[2] * normz;
                    } else {
                        dstPixels[dIndex++] = XYZ[0];
                        dstPixels[dIndex++] = XYZ[1];
                        dstPixels[dIndex++] = XYZ[2];
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = (float)((long)rBuf[rIndex] & 0xFFFFFFFFL) / normr;
                        RGB[1] = (float)((long)gBuf[gIndex] & 0xFFFFFFFFL) / normg;
                        RGB[2] = (float)((long)bBuf[bIndex] & 0xFFFFFFFFL) / normb;
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int r = rBuf[rIndex];
                    int g = gBuf[gIndex];
                    int b = bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(r) || nodata.contains(g) || nodata.contains(b);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = (float)((long)r & 0xFFFFFFFFL) / normr;
                        RGB[1] = (float)((long)g & 0xFFFFFFFFL) / normg;
                        RGB[2] = (float)((long)b & 0xFFFFFFFFL) / normb;
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    int r = rBuf[rIndex];
                    int g = gBuf[gIndex];
                    int b = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(r) || nodata.contains(g) || nodata.contains(b);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = (float)((long)r & 0xFFFFFFFFL) / normr;
                        RGB[1] = (float)((long)g & 0xFFFFFFFFL) / normg;
                        RGB[2] = (float)((long)b & 0xFFFFFFFFL) / normb;
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void RGBToCIEXYZFloat(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean hasNodata;
        boolean isInt;
        float[] rBuf = src.getFloatData(0);
        float[] gBuf = src.getFloatData(1);
        float[] bBuf = src.getFloatData(2);
        double normx = 1.0;
        double normy = 1.0;
        double normz = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isInt = dstType < 4;
        if (isInt) {
            normx = (double)((1L << destComponentSize[0]) - 1L) / 1.999969482421875;
            normy = (double)((1L << destComponentSize[1]) - 1L) / 1.999969482421875;
            normz = (double)((1L << destComponentSize[2]) - 1L) / 1.999969482421875;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean bl2 = hasNodata = nodata != null;
        if (hasNodata) {
            nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        }
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodata(isInt, destNodata, 4, 0.0, 0.0, 0.0, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    RGB[0] = rBuf[rIndex];
                    RGB[1] = gBuf[gIndex];
                    RGB[2] = bBuf[bIndex];
                    ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                    if (isInt) {
                        dstPixels[dIndex++] = (double)XYZ[0] * normx;
                        dstPixels[dIndex++] = (double)XYZ[1] * normy;
                        dstPixels[dIndex++] = (double)XYZ[2] * normz;
                    } else {
                        dstPixels[dIndex++] = XYZ[0];
                        dstPixels[dIndex++] = XYZ[1];
                        dstPixels[dIndex++] = XYZ[2];
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = rBuf[rIndex];
                        RGB[1] = gBuf[gIndex];
                        RGB[2] = bBuf[bIndex];
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    RGB[0] = rBuf[rIndex];
                    RGB[1] = gBuf[gIndex];
                    RGB[2] = bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(RGB[0]) || nodata.contains(RGB[1]) || nodata.contains(RGB[2]);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    RGB[0] = rBuf[rIndex];
                    RGB[1] = gBuf[gIndex];
                    RGB[2] = bBuf[bIndex];
                    boolean bl4 = notValid = nodata.contains(RGB[0]) || nodata.contains(RGB[1]) || nodata.contains(RGB[2]);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void RGBToCIEXYZDouble(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean isInt;
        double[] rBuf = src.getDoubleData(0);
        double[] gBuf = src.getDoubleData(1);
        double[] bBuf = src.getDoubleData(2);
        double normx = 1.0;
        double normy = 1.0;
        double normz = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        boolean bl = isInt = dstType < 4;
        if (isInt) {
            normx = (double)((1L << destComponentSize[0]) - 1L) / 1.999969482421875;
            normy = (double)((1L << destComponentSize[1]) - 1L) / 1.999969482421875;
            normz = (double)((1L << destComponentSize[2]) - 1L) / 1.999969482421875;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int rStart = src.bandOffsets[0];
        int gStart = src.bandOffsets[1];
        int bStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodata(isInt, destNodata, 5, 0.0, 0.0, 0.0, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    RGB[0] = (float)rBuf[rIndex];
                    RGB[1] = (float)gBuf[gIndex];
                    RGB[2] = (float)bBuf[bIndex];
                    ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                    if (isInt) {
                        dstPixels[dIndex++] = (double)XYZ[0] * normx;
                        dstPixels[dIndex++] = (double)XYZ[1] * normy;
                        dstPixels[dIndex++] = (double)XYZ[2] * normz;
                    } else {
                        dstPixels[dIndex++] = XYZ[0];
                        dstPixels[dIndex++] = XYZ[1];
                        dstPixels[dIndex++] = XYZ[2];
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        RGB[0] = (float)rBuf[rIndex];
                        RGB[1] = (float)gBuf[gIndex];
                        RGB[2] = (float)bBuf[bIndex];
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    RGB[0] = (float)rBuf[rIndex];
                    RGB[1] = (float)gBuf[gIndex];
                    RGB[2] = (float)bBuf[bIndex];
                    boolean bl2 = notValid = nodata.contains(rBuf[rIndex]) || nodata.contains(gBuf[gIndex]) || nodata.contains(bBuf[bIndex]);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int rIndex = rStart;
                int gIndex = gStart;
                int bIndex = bStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    RGB[0] = (float)rBuf[rIndex];
                    RGB[1] = (float)gBuf[gIndex];
                    RGB[2] = (float)bBuf[bIndex];
                    boolean bl3 = notValid = nodata.contains(rBuf[rIndex]) || nodata.contains(gBuf[gIndex]) || nodata.contains(bBuf[bIndex]);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
                        if (isInt) {
                            dstPixels[dIndex++] = (double)XYZ[0] * normx;
                            dstPixels[dIndex++] = (double)XYZ[1] * normy;
                            dstPixels[dIndex++] = (double)XYZ[2] * normz;
                        } else {
                            dstPixels[dIndex++] = XYZ[0];
                            dstPixels[dIndex++] = XYZ[1];
                            dstPixels[dIndex++] = XYZ[2];
                        }
                    }
                    ++i;
                    rIndex += srcPixelStride;
                    gIndex += srcPixelStride;
                    bIndex += srcPixelStride;
                }
                ++j;
                rStart += srcLineStride;
                gStart += srcLineStride;
                bStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    public static WritableRaster CIEXYZToRGB(Raster src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, ROI roi, Range nodata, float[] destNodata) {
        ColorSpaceJAIExt.checkParameters((Raster)src, (int[])srcComponentSize, (WritableRaster)dest, (int[])destComponentSize);
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        Rectangle bounds = null;
        if (roi != null) {
            bounds = roi.getBounds();
            Rectangle srcRectExpanded = dest.getBounds();
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
            if (!bounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = roi.getAsImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        SampleModel srcSampleModel = src.getSampleModel();
        if (srcComponentSize == null) {
            srcComponentSize = srcSampleModel.getSampleSize();
        }
        if (dest == null) {
            Point origin = new Point(src.getMinX(), src.getMinY());
            dest = RasterFactory.createWritableRaster((SampleModel)srcSampleModel, (Point)origin);
        }
        SampleModel dstSampleModel = dest.getSampleModel();
        if (destComponentSize == null) {
            destComponentSize = dstSampleModel.getSampleSize();
        }
        PixelAccessor srcAcc = new PixelAccessor(srcSampleModel, null);
        UnpackedImageData srcUid = srcAcc.getPixels(src, src.getBounds(), srcSampleModel.getDataType(), false);
        switch (srcSampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAIExt.CIEXYZToRGBByte(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAIExt.CIEXYZToRGBShort(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 3: {
                ColorSpaceJAIExt.CIEXYZToRGBInt(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 4: {
                ColorSpaceJAIExt.CIEXYZToRGBFloat(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
                break;
            }
            case 5: {
                ColorSpaceJAIExt.CIEXYZToRGBDouble(srcUid, srcComponentSize, dest, destComponentSize, roiContainsTile, roiDisjointTile, roiIter, bounds, nodata, destNodata);
            }
        }
        return dest;
    }

    private static void CIEXYZToRGBByte(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        byte[] xBuf = src.getByteData(0);
        byte[] yBuf = src.getByteData(1);
        byte[] zBuf = src.getByteData(2);
        float normx = (float)(1.999969482421875 / (double)((1L << srcComponentSize[0]) - 1L));
        float normy = (float)(1.999969482421875 / (double)((1L << srcComponentSize[1]) - 1L));
        float normz = (float)(1.999969482421875 / (double)((1L << srcComponentSize[2]) - 1L));
        double upperr = 1.0;
        double upperg = 1.0;
        double upperb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            upperr = (1L << destComponentSize[0]) - 1L;
            upperg = (1L << destComponentSize[1]) - 1L;
            upperb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int xStart = src.bandOffsets[0];
        int yStart = src.bandOffsets[1];
        int zStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodataCIEXYZ(destNodata, 0, upperr, upperg, upperb, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    XYZ[0] = (float)(xBuf[xIndex] & 0xFF) * normx;
                    XYZ[1] = (float)(yBuf[yIndex] & 0xFF) * normy;
                    XYZ[2] = (float)(zBuf[zIndex] & 0xFF) * normz;
                    ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                    dstPixels[dIndex++] = upperr * (double)RGB[0];
                    dstPixels[dIndex++] = upperg * (double)RGB[1];
                    dstPixels[dIndex++] = upperb * (double)RGB[2];
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)(xBuf[xIndex] & 0xFF) * normx;
                        XYZ[1] = (float)(yBuf[yIndex] & 0xFF) * normy;
                        XYZ[2] = (float)(zBuf[zIndex] & 0xFF) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    byte x = xBuf[xIndex];
                    byte y = yBuf[yIndex];
                    byte z = zBuf[zIndex];
                    boolean bl = notValid = nodata.contains(x) || nodata.contains(y) || nodata.contains(z);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)(x & 0xFF) * normx;
                        XYZ[1] = (float)(y & 0xFF) * normy;
                        XYZ[2] = (float)(z & 0xFF) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    byte x = xBuf[xIndex];
                    byte y = yBuf[yIndex];
                    byte z = zBuf[zIndex];
                    boolean bl = notValid = nodata.contains(x) || nodata.contains(y) || nodata.contains(z);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)(x & 0xFF) * normx;
                        XYZ[1] = (float)(y & 0xFF) * normy;
                        XYZ[2] = (float)(z & 0xFF) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void CIEXYZToRGBShort(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        short[] xBuf = src.getShortData(0);
        short[] yBuf = src.getShortData(1);
        short[] zBuf = src.getShortData(2);
        float normx = (float)(1.999969482421875 / (double)((1L << srcComponentSize[0]) - 1L));
        float normy = (float)(1.999969482421875 / (double)((1L << srcComponentSize[1]) - 1L));
        float normz = (float)(1.999969482421875 / (double)((1L << srcComponentSize[2]) - 1L));
        double upperr = 1.0;
        double upperg = 1.0;
        double upperb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            upperr = (1L << destComponentSize[0]) - 1L;
            upperg = (1L << destComponentSize[1]) - 1L;
            upperb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int xStart = src.bandOffsets[0];
        int yStart = src.bandOffsets[1];
        int zStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodataCIEXYZ(destNodata, 2, upperr, upperg, upperb, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    XYZ[0] = (float)(xBuf[xIndex] & 0xFFFF) * normx;
                    XYZ[1] = (float)(yBuf[yIndex] & 0xFFFF) * normy;
                    XYZ[2] = (float)(zBuf[zIndex] & 0xFFFF) * normz;
                    ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                    dstPixels[dIndex++] = upperr * (double)RGB[0];
                    dstPixels[dIndex++] = upperg * (double)RGB[1];
                    dstPixels[dIndex++] = upperb * (double)RGB[2];
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)(xBuf[xIndex] & 0xFFFF) * normx;
                        XYZ[1] = (float)(yBuf[yIndex] & 0xFFFF) * normy;
                        XYZ[2] = (float)(zBuf[zIndex] & 0xFFFF) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    short x = xBuf[xIndex];
                    short y = yBuf[yIndex];
                    short z = zBuf[zIndex];
                    boolean bl = notValid = nodata.contains(x) || nodata.contains(y) || nodata.contains(z);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)(x & 0xFFFF) * normx;
                        XYZ[1] = (float)(y & 0xFFFF) * normy;
                        XYZ[2] = (float)(z & 0xFFFF) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    short x = xBuf[xIndex];
                    short y = yBuf[yIndex];
                    short z = zBuf[zIndex];
                    boolean bl = notValid = nodata.contains(x) || nodata.contains(y) || nodata.contains(z);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)(x & 0xFFFF) * normx;
                        XYZ[1] = (float)(y & 0xFFFF) * normy;
                        XYZ[2] = (float)(z & 0xFFFF) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void CIEXYZToRGBInt(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        int[] xBuf = src.getIntData(0);
        int[] yBuf = src.getIntData(1);
        int[] zBuf = src.getIntData(2);
        float normx = (float)(1.999969482421875 / (double)((1L << srcComponentSize[0]) - 1L));
        float normy = (float)(1.999969482421875 / (double)((1L << srcComponentSize[1]) - 1L));
        float normz = (float)(1.999969482421875 / (double)((1L << srcComponentSize[2]) - 1L));
        double upperr = 1.0;
        double upperg = 1.0;
        double upperb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            upperr = (1L << destComponentSize[0]) - 1L;
            upperg = (1L << destComponentSize[1]) - 1L;
            upperb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int xStart = src.bandOffsets[0];
        int yStart = src.bandOffsets[1];
        int zStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean hasNodata = nodata != null;
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodataCIEXYZ(destNodata, 2, upperr, upperg, upperb, normx, normy, normz);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    XYZ[0] = (float)((long)xBuf[xIndex] & 0xFFFFFFFFL) * normx;
                    XYZ[1] = (float)((long)yBuf[yIndex] & 0xFFFFFFFFL) * normy;
                    XYZ[2] = (float)((long)zBuf[zIndex] & 0xFFFFFFFFL) * normz;
                    ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                    dstPixels[dIndex++] = upperr * (double)RGB[0];
                    dstPixels[dIndex++] = upperg * (double)RGB[1];
                    dstPixels[dIndex++] = upperb * (double)RGB[2];
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)((long)xBuf[xIndex] & 0xFFFFFFFFL) * normx;
                        XYZ[1] = (float)((long)yBuf[yIndex] & 0xFFFFFFFFL) * normy;
                        XYZ[2] = (float)((long)zBuf[zIndex] & 0xFFFFFFFFL) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    int x = xBuf[xIndex];
                    int y = yBuf[yIndex];
                    int z = zBuf[zIndex];
                    boolean bl = notValid = nodata.contains(x) || nodata.contains(y) || nodata.contains(z);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)((long)x & 0xFFFFFFFFL) * normx;
                        XYZ[1] = (float)((long)y & 0xFFFFFFFFL) * normy;
                        XYZ[2] = (float)((long)z & 0xFFFFFFFFL) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    int x = xBuf[xIndex];
                    int y = yBuf[yIndex];
                    int z = zBuf[zIndex];
                    boolean bl = notValid = nodata.contains(x) || nodata.contains(y) || nodata.contains(z);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)((long)x & 0xFFFFFFFFL) * normx;
                        XYZ[1] = (float)((long)y & 0xFFFFFFFFL) * normy;
                        XYZ[2] = (float)((long)z & 0xFFFFFFFFL) * normz;
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void CIEXYZToRGBFloat(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean hasNodata;
        float[] xBuf = src.getFloatData(0);
        float[] yBuf = src.getFloatData(1);
        float[] zBuf = src.getFloatData(2);
        double upperr = 1.0;
        double upperg = 1.0;
        double upperb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            upperr = (1L << destComponentSize[0]) - 1L;
            upperg = (1L << destComponentSize[1]) - 1L;
            upperb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int xStart = src.bandOffsets[0];
        int yStart = src.bandOffsets[1];
        int zStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean bl = hasNodata = nodata != null;
        if (hasNodata) {
            nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        }
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodataCIEXYZ(destNodata, 4, upperr, upperg, upperb, 0.0, 0.0, 0.0);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    XYZ[0] = xBuf[xIndex];
                    XYZ[1] = yBuf[yIndex];
                    XYZ[2] = zBuf[zIndex];
                    ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                    dstPixels[dIndex++] = upperr * (double)RGB[0];
                    dstPixels[dIndex++] = upperg * (double)RGB[1];
                    dstPixels[dIndex++] = upperb * (double)RGB[2];
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = xBuf[xIndex];
                        XYZ[1] = yBuf[yIndex];
                        XYZ[2] = zBuf[zIndex];
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    XYZ[0] = xBuf[xIndex];
                    XYZ[1] = yBuf[yIndex];
                    XYZ[2] = zBuf[zIndex];
                    boolean bl2 = notValid = nodata.contains(XYZ[0]) || nodata.contains(XYZ[0]) || nodata.contains(XYZ[0]);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    XYZ[0] = xBuf[xIndex];
                    XYZ[1] = yBuf[yIndex];
                    XYZ[2] = zBuf[zIndex];
                    boolean bl3 = notValid = nodata.contains(XYZ[0]) || nodata.contains(XYZ[0]) || nodata.contains(XYZ[0]);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void CIEXYZToRGBDouble(UnpackedImageData src, int[] srcComponentSize, WritableRaster dest, int[] destComponentSize, boolean roiContainsTile, boolean roiDisjointTile, RandomIter roiIter, Rectangle roiBounds, Range nodata, float[] destNodata) {
        boolean hasNodata;
        double[] xBuf = src.getDoubleData(0);
        double[] yBuf = src.getDoubleData(1);
        double[] zBuf = src.getDoubleData(2);
        double upperr = 1.0;
        double upperg = 1.0;
        double upperb = 1.0;
        int dstType = dest.getSampleModel().getDataType();
        if (dstType < 4) {
            upperr = (1L << destComponentSize[0]) - 1L;
            upperg = (1L << destComponentSize[1]) - 1L;
            upperb = (1L << destComponentSize[2]) - 1L;
        }
        int height = dest.getHeight();
        int width = dest.getWidth();
        double[] dstPixels = new double[3 * height * width];
        int xStart = src.bandOffsets[0];
        int yStart = src.bandOffsets[1];
        int zStart = src.bandOffsets[2];
        int srcPixelStride = src.pixelStride;
        int srcLineStride = src.lineStride;
        float[] XYZ = new float[3];
        float[] RGB = new float[3];
        int dIndex = 0;
        boolean hasROI = roiIter != null && roiBounds != null;
        boolean bl = hasNodata = nodata != null;
        if (hasNodata) {
            nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        }
        int destX = dest.getMinX();
        int destY = dest.getMinY();
        double[] destNoDataFinal = ColorSpaceJAIExt.getConvertedNodataCIEXYZ(destNodata, 5, upperr, upperg, upperb, 0.0, 0.0, 0.0);
        if (roiDisjointTile) {
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)dest.getBounds(), (double[])destNoDataFinal);
            return;
        }
        if (!hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    XYZ[0] = (float)xBuf[xIndex];
                    XYZ[1] = (float)yBuf[yIndex];
                    XYZ[2] = (float)zBuf[zIndex];
                    ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                    dstPixels[dIndex++] = upperr * (double)RGB[0];
                    dstPixels[dIndex++] = upperg * (double)RGB[1];
                    dstPixels[dIndex++] = upperb * (double)RGB[2];
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (!hasNodata && hasROI) {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    int x0 = i + destX;
                    if (!roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        XYZ[0] = (float)xBuf[xIndex];
                        XYZ[1] = (float)yBuf[yIndex];
                        XYZ[2] = (float)zBuf[zIndex];
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else if (hasNodata && (!hasROI || hasROI && roiContainsTile)) {
            int j = 0;
            while (j < height) {
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    XYZ[0] = (float)xBuf[xIndex];
                    XYZ[1] = (float)yBuf[yIndex];
                    XYZ[2] = (float)zBuf[zIndex];
                    boolean bl2 = notValid = nodata.contains(xBuf[xIndex]) || nodata.contains(yBuf[yIndex]) || nodata.contains(zBuf[zIndex]);
                    if (notValid) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        } else {
            int j = 0;
            while (j < height) {
                int y0 = j + destY;
                int i = 0;
                int xIndex = xStart;
                int yIndex = yStart;
                int zIndex = zStart;
                while (i < width) {
                    boolean notValid;
                    int x0 = i + destX;
                    XYZ[0] = (float)xBuf[xIndex];
                    XYZ[1] = (float)yBuf[yIndex];
                    XYZ[2] = (float)zBuf[zIndex];
                    boolean bl3 = notValid = nodata.contains(xBuf[xIndex]) || nodata.contains(yBuf[yIndex]) || nodata.contains(zBuf[zIndex]);
                    if (notValid || !roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                        dstPixels[dIndex++] = destNoDataFinal[0];
                        dstPixels[dIndex++] = destNoDataFinal[1];
                        dstPixels[dIndex++] = destNoDataFinal[2];
                    } else {
                        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
                        dstPixels[dIndex++] = upperr * (double)RGB[0];
                        dstPixels[dIndex++] = upperg * (double)RGB[1];
                        dstPixels[dIndex++] = upperb * (double)RGB[2];
                    }
                    ++i;
                    xIndex += srcPixelStride;
                    yIndex += srcPixelStride;
                    zIndex += srcPixelStride;
                }
                ++j;
                xStart += srcLineStride;
                yStart += srcLineStride;
                zStart += srcLineStride;
            }
        }
        if (dstType < 4) {
            ColorSpaceJAIExt.roundValues(dstPixels);
        }
        ColorSpaceJAIExt.convertToSigned(dstPixels, dstType);
        dest.setPixels(dest.getMinX(), dest.getMinY(), width, height, dstPixels);
    }

    private static void roundValues(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = (long)(data[i] + 0.5);
        }
    }

    private static double[] getConvertedNodataB(boolean isInt, float[] destNodata, int normr, int normg, int normb, double normx, double normy, double normz) {
        double[] result = new double[3];
        double R = LUT[((int)destNodata[0] & 0xFF) << normr];
        double G = LUT[((int)destNodata[1] & 0xFF) << normg];
        double B = LUT[((int)destNodata[2] & 0xFF) << normb];
        if (isInt) {
            result[0] = (0.45593763 * R + 0.39533819 * G + 0.19954964 * B) * normx;
            result[1] = (0.23157515 * R + 0.77905262 * G + 0.07864978 * B) * normy;
            result[2] = (0.01593493 * R + 0.09841772 * G + 0.78488615 * B) * normz;
        } else {
            result[0] = 0.45593763 * R + 0.39533819 * G + 0.19954964 * B;
            result[1] = 0.23157515 * R + 0.77905262 * G + 0.07864978 * B;
            result[2] = 0.01593493 * R + 0.09841772 * G + 0.78488615 * B;
        }
        return result;
    }

    private static double[] getConvertedNodata(boolean isInt, float[] destNodata, int dataType, double normr, double normg, double normb, double normx, double normy, double normz) {
        double[] result = new double[3];
        float[] RGB = new float[3];
        float[] XYZ = new float[3];
        switch (dataType) {
            case 1: 
            case 2: {
                RGB[0] = (float)((double)((int)destNodata[0] & 0xFFFF) / normr);
                RGB[1] = (float)((double)((int)destNodata[1] & 0xFFFF) / normg);
                RGB[2] = (float)((double)((int)destNodata[2] & 0xFFFF) / normb);
                break;
            }
            case 3: {
                RGB[0] = (float)((double)((long)((int)destNodata[0]) & 0xFFFFFFFFL) / normr);
                RGB[1] = (float)((double)((long)((int)destNodata[1]) & 0xFFFFFFFFL) / normg);
                RGB[2] = (float)((double)((long)((int)destNodata[2]) & 0xFFFFFFFFL) / normb);
                break;
            }
            case 4: 
            case 5: {
                RGB[0] = destNodata[0];
                RGB[1] = destNodata[1];
                RGB[2] = destNodata[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type defined");
            }
        }
        ColorSpaceJAIExt.RGB2XYZ(RGB, XYZ);
        if (isInt) {
            result[0] = (double)XYZ[0] * normx;
            result[1] = (double)XYZ[1] * normy;
            result[2] = (double)XYZ[2] * normz;
        } else {
            result[0] = XYZ[0];
            result[1] = XYZ[1];
            result[2] = XYZ[2];
        }
        return result;
    }

    private static double[] getConvertedNodataCIEXYZ(float[] destNodata, int dataType, double upperr, double upperg, double upperb, double normx, double normy, double normz) {
        double[] result = new double[3];
        float[] RGB = new float[3];
        float[] XYZ = new float[3];
        switch (dataType) {
            case 0: {
                XYZ[0] = (float)((double)((int)destNodata[0] & 0xFF) * normx);
                XYZ[1] = (float)((double)((int)destNodata[1] & 0xFF) * normy);
                XYZ[2] = (float)((double)((int)destNodata[2] & 0xFF) * normz);
                break;
            }
            case 1: 
            case 2: {
                XYZ[0] = (float)((double)((int)destNodata[0] & 0xFFFF) * normx);
                XYZ[1] = (float)((double)((int)destNodata[1] & 0xFFFF) * normy);
                XYZ[2] = (float)((double)((int)destNodata[2] & 0xFFFF) * normz);
                break;
            }
            case 3: {
                XYZ[0] = (float)((double)((long)((int)destNodata[0]) & 0xFFFFFFFFL) * normx);
                XYZ[1] = (float)((double)((long)((int)destNodata[1]) & 0xFFFFFFFFL) * normy);
                XYZ[2] = (float)((double)((long)((int)destNodata[2]) & 0xFFFFFFFFL) * normz);
                break;
            }
            case 4: 
            case 5: {
                XYZ[0] = destNodata[0];
                XYZ[1] = destNodata[1];
                XYZ[2] = destNodata[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type defined");
            }
        }
        ColorSpaceJAIExt.XYZ2RGB(XYZ, RGB);
        result[0] = upperr * (double)RGB[0];
        result[1] = upperg * (double)RGB[1];
        result[2] = upperb * (double)RGB[2];
        return result;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            double v = (double)i / 255.0;
            ColorSpaceJAIExt.LUT[i] = v < 0.040449936 ? v / 12.92 : Math.pow((v + 0.055) / 1.055, 2.4);
        }
    }
}

