/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

import it.geosolutions.jaiext.bandcombine.BandCombineDescriptor;
import it.geosolutions.jaiext.bandmerge.BandMergeDescriptor;
import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.colorindexer.ColorIndexerDescriptor;
import it.geosolutions.jaiext.colorindexer.Quantizer;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.lookup.LookupDescriptor;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableWrapper;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import org.junit.Assert;
import org.junit.Test;

public class ColorIndexerTest
extends TestBase {
    private static final double TOLERANCE = 0.01;

    @Test
    public void test2BandsBug() {
        BufferedImage image = new BufferedImage(256, 256, 10);
        RenderedOp img = BandMergeDescriptor.create(null, (double)0.0, (boolean)false, null, (RenderedImage[])new RenderedImage[]{image, image});
        image = img.getAsBufferedImage();
        RenderedImage indexed = this.quantize(image);
        Assert.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        Assert.assertEquals((long)2L, (long)icm.getMapSize());
    }

    private RenderedImage quantize(RenderedImage image) {
        return this.quantize(image, null, null, 0);
    }

    private RenderedImage quantize(RenderedImage image, ROI roi, Range nodata, int destNoData) {
        Quantizer q = new Quantizer(256);
        ColorIndexer indexer = q.buildColorIndexer(image);
        RenderedOp indexed = ColorIndexerDescriptor.create((RenderedImage)image, (ColorIndexer)indexer, (ROI)roi, (Range)nodata, (Integer)destNoData, null);
        this.checkNoDataROI((RenderedImage)indexed, image, roi, nodata, destNoData);
        return indexed;
    }

    @Test
    public void testOneColorBug() {
        BufferedImage image = new BufferedImage(256, 256, 6);
        RenderedImage indexed = this.quantize(image);
        Assert.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        Assert.assertEquals((long)2L, (long)icm.getMapSize());
    }

    @Test
    public void testGrayColorNoData() {
        BufferedImage image = new BufferedImage(256, 256, 10);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 20, 20);
        g.setColor(new Color(20, 20, 20));
        g.fillRect(20, 20, 20, 20);
        g.setColor(new Color(200, 200, 200));
        g.fillRect(0, 20, 20, 20);
        g.dispose();
        RenderedImage indexed = this.quantize(image, null, RangeFactory.create((byte)-1, (byte)-1), 1);
        Assert.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        Assert.assertEquals((long)4L, (long)icm.getMapSize());
    }

    @Test
    public void testAlphaZeroNoRemoval() {
        BufferedImage image = new BufferedImage(40, 40, 2);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 20, 20);
        g.setColor(new Color(20, 20, 20, 20));
        g.fillRect(20, 20, 20, 20);
        g.setColor(new Color(200, 200, 200, 20));
        g.fillRect(0, 20, 20, 20);
        g.setColor(new Color(254, 254, 254, 20));
        g.fillRect(0, 20, 20, 20);
        g.setColor(new Color(1, 1, 1, 0));
        g.fillRect(20, 0, 20, 20);
        g.dispose();
        Quantizer q = new Quantizer(2);
        ColorIndexer indexer = q.buildColorIndexer((RenderedImage)image);
        Assert.assertTrue((indexer.toIndexColorModel().getTransparentPixel() != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAlphaZeroPreserveColors() {
        BufferedImage image = new BufferedImage(41, 41, 2);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 20, 20);
        g.setColor(new Color(20, 20, 20, 20));
        g.fillRect(20, 20, 20, 20);
        g.setColor(new Color(200, 200, 200, 20));
        g.fillRect(0, 20, 20, 20);
        g.setColor(new Color(254, 254, 254, 20));
        g.fillRect(20, 0, 20, 20);
        g.setColor(new Color(1, 1, 1, 0));
        g.fillRect(20, 0, 20, 20);
        g.dispose();
        Quantizer q = new Quantizer(5);
        ColorIndexer indexer = q.buildColorIndexer((RenderedImage)image);
        Assert.assertTrue((indexer.toIndexColorModel().getTransparentPixel() != -1 ? 1 : 0) != 0);
        int transparentIndex = indexer.getClosestIndex(1, 1, 1, 0);
        Assert.assertTrue((indexer.getClosestIndex(20, 20, 20, 20) != transparentIndex ? 1 : 0) != 0);
        Assert.assertTrue((indexer.getClosestIndex(200, 200, 200, 20) != transparentIndex ? 1 : 0) != 0);
        Assert.assertTrue((indexer.getClosestIndex(254, 254, 254, 20) != transparentIndex ? 1 : 0) != 0);
        Assert.assertTrue((indexer.getClosestIndex(255, 255, 255, 255) != transparentIndex ? 1 : 0) != 0);
    }

    @Test
    public void testAlphaZeroNoRemovalFromImage() throws IOException {
        Quantizer q = new Quantizer(256);
        BufferedImage image = ImageIO.read(ColorIndexerTest.class.getResourceAsStream("/transparent_sample.png"));
        ColorIndexer indexer = q.buildColorIndexer((RenderedImage)image);
        Assert.assertTrue((indexer.toIndexColorModel().getTransparentPixel() != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testCompletelyTransparentImage() {
        BufferedImage image = new BufferedImage(20, 20, 2);
        Graphics g = image.getGraphics();
        g.setColor(new Color(20, 20, 20, 0));
        g.fillRect(0, 0, 20, 20);
        g.dispose();
        Quantizer q = new Quantizer(2);
        ColorIndexer indexer = q.buildColorIndexer((RenderedImage)image);
        Assert.assertTrue((indexer.toIndexColorModel().getTransparentPixel() != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testTranslatedImage() throws Exception {
        BufferedImage bi = new BufferedImage(256, 256, 10);
        TiledImage image = new TiledImage(0, 0, 256, 256, 1, 1, bi.getSampleModel().createCompatibleSampleModel(256, 256), bi.getColorModel());
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 20, 20);
        g.setColor(new Color(20, 20, 20));
        g.fillRect(20, 20, 20, 20);
        g.setColor(new Color(200, 200, 200));
        g.fillRect(0, 20, 20, 20);
        g.dispose();
        RenderedImage indexed = this.quantize((RenderedImage)image);
        Assert.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        Assert.assertEquals((long)4L, (long)icm.getMapSize());
    }

    @Test
    public void testFourColorROI() {
        BufferedImage image = new BufferedImage(256, 256, 6);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 10, 10);
        g.setColor(Color.RED);
        g.fillRect(10, 0, 10, 10);
        g.setColor(Color.BLUE);
        g.fillRect(20, 0, 10, 10);
        g.setColor(Color.GREEN);
        g.fillRect(30, 0, 10, 10);
        g.dispose();
        RenderedImage indexed = this.quantize(image, (ROI)new ROIShape((Shape)new Rectangle(10, 0, 10, 10)), null, 10);
        Assert.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        Assert.assertEquals((long)5L, (long)icm.getMapSize());
    }

    @Test
    public void testTranslatedImageTileGridROINoData() {
        BufferedImage image_ = new BufferedImage(256, 256, 10);
        Graphics2D g = image_.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(236, 236, 20, 20);
        g.setColor(new Color(80, 80, 80));
        g.fillRect(216, 216, 20, 20);
        g.setColor(new Color(200, 200, 200));
        g.fillRect(216, 236, 20, 20);
        g.dispose();
        TiledImage image = new TiledImage(0, 0, 256, 256, 128, 128, image_.getColorModel().createCompatibleSampleModel(256, 256), image_.getColorModel());
        image.set((RenderedImage)image_);
        Range range = RangeFactory.create((byte)-1, (byte)-1);
        ROIShape roi = new ROIShape((Shape)new Rectangle(0, 0, 20, 20));
        RenderedImage indexed = this.quantize((RenderedImage)image, (ROI)roi, range, 1);
        Assert.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        Assert.assertEquals((long)4L, (long)icm.getMapSize());
        RenderedImage component = this.forceComponentColorModel(indexed);
        double[][] coeff = new double[1][5];
        Arrays.fill(coeff[0], 0, 4, 0.25);
        component = BandCombineDescriptor.create((RenderedImage)component, (double[][])coeff, null, null, (double)this.destinationNoData, null);
        Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.EXTREMA};
        component = StatisticsDescriptor.create((RenderedImage)component, (int)1, (int)1, null, null, (boolean)false, (int[])new int[]{0}, (Statistics.StatsType[])stats, null);
        Statistics stat = ((Statistics[][])component.getProperty("JAI-EXT.stats"))[0][0];
        double[] result = (double[])stat.getResult();
        double minimum = result[0];
        double maximum = result[1];
        Assert.assertFalse((Math.abs(maximum - minimum) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testNoDataChecksAllBands() {
        BufferedImage image_ = new BufferedImage(256, 256, 1);
        Graphics2D g = image_.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(236, 236, 20, 20);
        g.setColor(new Color(80, 0, 0));
        g.fillRect(216, 216, 20, 20);
        g.setColor(new Color(0, 0, 200));
        g.fillRect(216, 236, 20, 20);
        g.dispose();
        TiledImage image = new TiledImage(0, 0, 256, 256, 128, 128, image_.getColorModel().createCompatibleSampleModel(256, 256), image_.getColorModel());
        image.set((RenderedImage)image_);
        Range range = RangeFactory.create((byte)0, (byte)0);
        RenderedImage indexed = this.quantize((RenderedImage)image, null, range, 1);
        Assert.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        Assert.assertEquals((long)4L, (long)icm.getMapSize());
        RenderedImage component = this.forceComponentColorModel(indexed);
        int[] rgb = new int[4];
        rgb = component.getData().getPixel(218, 218, rgb);
        Assert.assertEquals((long)80L, (long)rgb[0]);
        Assert.assertEquals((long)0L, (long)rgb[1]);
        Assert.assertEquals((long)0L, (long)rgb[2]);
        rgb = component.getData().getPixel(218, 238, rgb);
        Assert.assertEquals((long)0L, (long)rgb[0]);
        Assert.assertEquals((long)0L, (long)rgb[1]);
        Assert.assertEquals((long)200L, (long)rgb[2]);
    }

    private RenderedImage forceComponentColorModel(RenderedImage image) {
        IndexColorModel icm = (IndexColorModel)image.getColorModel();
        SampleModel sm = image.getSampleModel();
        int datatype = sm.getDataType();
        boolean alpha = icm.hasAlpha();
        int numDestinationBands = 4;
        LookupTableJAI lut = null;
        byte[][] data = new byte[4][icm.getMapSize()];
        icm.getReds(data[0]);
        icm.getGreens(data[1]);
        icm.getBlues(data[2]);
        icm.getAlphas(data[3]);
        lut = new LookupTableJAI(data);
        ImageLayout layout = new ImageLayout(image);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        int[] bits = new int[4];
        for (int i = 0; i < 4; ++i) {
            bits[i] = sm.getSampleSize(i);
        }
        ComponentColorModel destinationColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), bits, alpha, image.getColorModel().isAlphaPremultiplied(), alpha ? 3 : 1, datatype);
        SampleModel destinationSampleModel = destinationColorModel.createCompatibleSampleModel(image.getWidth(), image.getHeight());
        layout.setColorModel((ColorModel)destinationColorModel);
        layout.setSampleModel(destinationSampleModel);
        image = LookupDescriptor.create((RenderedImage)image, (LookupTable)new LookupTableWrapper(lut), (double)0.0, null, null, (boolean)false, (RenderingHints)hints);
        return image;
    }

    private void checkNoDataROI(RenderedImage indexed, RenderedImage image, ROI roi, Range nodata, int destNoData) {
        boolean nodataExists;
        Assert.assertEquals((long)indexed.getMinX(), (long)image.getMinX());
        Assert.assertEquals((long)indexed.getMinY(), (long)image.getMinY());
        Assert.assertEquals((long)indexed.getWidth(), (long)image.getWidth());
        Assert.assertEquals((long)indexed.getHeight(), (long)image.getHeight());
        boolean roiExists = roi != null;
        boolean bl = nodataExists = nodata != null;
        if (!nodataExists && !roiExists) {
            PlanarImage.wrapRenderedImage((RenderedImage)indexed).getTiles();
            return;
        }
        if (nodataExists) {
            nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        }
        RandomIter roiIter = null;
        Rectangle roiBounds = null;
        if (roiExists) {
            PlanarImage roiIMG = roi.getAsImage();
            roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
            roiBounds = roi.getBounds();
        }
        RandomIter sourceIter = RandomIterFactory.create((RenderedImage)image, null, (boolean)true, (boolean)true);
        RandomIter destIter = RandomIterFactory.create((RenderedImage)indexed, null, (boolean)true, (boolean)true);
        int w = image.getWidth();
        int h = image.getHeight();
        int minX = image.getMinX();
        int minY = image.getMinY();
        int maxX = minX + w;
        int maxY = minY + h;
        int limx = minX - image.getTileGridXOffset();
        int limy = minY - image.getTileGridYOffset();
        Rectangle translated = new Rectangle(limx, limy, w, h);
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                double src = sourceIter.getSampleDouble(x, y, 0);
                double dest = destIter.getSampleDouble(x, y, 0);
                boolean valid = true;
                if (roiExists && (!roiBounds.contains(x, y) || roiIter.getSample(x, y, 0) <= 0) && translated.contains(x, y)) {
                    valid = false;
                }
                if (nodataExists && nodata.contains(src)) {
                    valid = false;
                }
                if (valid) continue;
                Assert.assertEquals((double)destNoData, (double)dest, (double)0.01);
            }
        }
    }
}

