/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.concurrencytest;

import com.sun.media.imageio.plugins.tiff.TIFFImageReadParam;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import com.sun.media.jai.util.SunTileCache;
import it.geosolutions.concurrent.ConcurrentTileCache;
import it.geosolutions.concurrent.ConcurrentTileCacheMultiMap;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import javax.media.jai.operator.ScaleDescriptor;
import org.junit.Test;

public class ConcurrentCacheTest {
    public static final long DEFAULT_MEMORY_CAPACITY = 0x8000000L;
    public static final int DEFAULT_MAX_REQUEST_PER_THREAD = 100;
    public static final int STARTING_REQUEST_PER_FIRST_THREAD = 1000;
    public static final int EXPONENT = 6;
    public static final Logger LOGGER = Logger.getLogger(ConcurrentCacheTest.class.toString());
    public static boolean DEFAULT_DIAGNOSTICS = false;
    public static boolean DEFAULT_MULTIOPERATIONS = false;
    public static int DEFAULT_CONCURRENCY_LEVEL = 16;
    private int maxRequestPerThread;
    private CountDownLatch latch;
    private Random generator;
    private double minTileX;
    private double minTileY;
    private double maxTileX;
    private double maxTileY;
    private RenderedImage image_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] testwriteImageAndWatchFlag(CacheType cacheUsed, int concurrencyLevel, long memoryCacheCapacity, RenderedImage img, String path, boolean diagnostics, boolean multipleOperations) throws IOException, InterruptedException {
        switch (cacheUsed) {
            case SUN_TILE_CACHE: {
                SunTileCache sunCache = new SunTileCache();
                if (diagnostics) {
                    sunCache.enableDiagnostics();
                }
                JAI.getDefaultInstance().setTileCache((TileCache)sunCache);
                break;
            }
            case CONCURRENT_TILE_CACHE: {
                ConcurrentTileCache cTileCache = new ConcurrentTileCache();
                cTileCache.setConcurrencyLevel(concurrencyLevel);
                if (diagnostics) {
                    cTileCache.enableDiagnostics();
                }
                JAI.getDefaultInstance().setTileCache((TileCache)cTileCache);
                break;
            }
            case CONCURRENT_MULTIMAP_TILE_CACHE: {
                ConcurrentTileCacheMultiMap cmTileCache = new ConcurrentTileCacheMultiMap();
                cmTileCache.setConcurrencyLevel(concurrencyLevel);
                if (diagnostics) {
                    cmTileCache.enableDiagnostics();
                }
                JAI.getDefaultInstance().setTileCache((TileCache)cmTileCache);
            }
        }
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(memoryCacheCapacity);
        JAI.getDefaultInstance().getTileScheduler().setParallelism(10);
        int threadMaxNumber = (int)Math.pow(2.0, 6.0);
        double[] througputArray = new double[7];
        ThreadPoolExecutor pool = new ThreadPoolExecutor(threadMaxNumber, threadMaxNumber, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000000));
        this.generator = new Random();
        int index = 0;
        TIFFImageReader reader = null;
        ImageInputStreamImpl stream_in = null;
        try {
            RenderedImage image;
            if (path != null) {
                reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
                TIFFImageReadParam param = new TIFFImageReadParam();
                File inputFile = new File(path);
                stream_in = new FileImageInputStream(inputFile);
                reader.setInput((Object)stream_in);
                image = reader.readAsRenderedImage(0, (ImageReadParam)param);
            } else {
                image = img;
            }
            image = ScaleDescriptor.create((RenderedImage)image, (Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
            this.image_ = ScaleDescriptor.create((RenderedImage)image, (Float)Float.valueOf(3.5f), (Float)Float.valueOf(3.5f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)new InterpolationNearest(), null);
            this.minTileX = this.image_.getMinTileX();
            this.minTileY = this.image_.getMinTileY();
            this.maxTileX = this.minTileX + (double)this.image_.getNumXTiles();
            this.maxTileY = this.minTileY + (double)this.image_.getNumYTiles();
            for (int s = 1; s <= threadMaxNumber; s *= 2) {
                this.latch = new CountDownLatch(s);
                if (s <= 4) {
                    if (s == 1) {
                        this.latch = new CountDownLatch(2);
                        this.maxRequestPerThread = 1000;
                        Worker firstThread = new Worker(multipleOperations);
                        WeigherPeriodic secondThread = new WeigherPeriodic(cacheUsed);
                        pool.execute(firstThread);
                        pool.execute(secondThread);
                        this.latch.await();
                        LOGGER.log(Level.INFO, "Starting Thread Executed");
                        this.latch = new CountDownLatch(s);
                    }
                    this.maxRequestPerThread = 100;
                } else {
                    this.maxRequestPerThread = 400 / s;
                }
                long startTime = System.nanoTime();
                for (int count = 1; count <= s; ++count) {
                    Worker prefetch = new Worker(multipleOperations);
                    pool.execute(prefetch);
                }
                this.latch.await();
                double time = (double)(System.nanoTime() - startTime) * 1.0E-9;
                througputArray[index] = (double)(this.maxRequestPerThread * s) / time;
                LOGGER.log(Level.INFO, "Number of Threads: " + s);
                ++index;
            }
        }
        finally {
            try {
                if (stream_in != null) {
                    stream_in.flush();
                    ((FileImageInputStream)stream_in).close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (reader != null) {
                    reader.dispose();
                }
            }
            catch (Throwable throwable) {}
        }
        pool.shutdown();
        pool.awaitTermination(180L, TimeUnit.SECONDS);
        return througputArray;
    }

    public static void main(String[] args) throws Exception {
        boolean mainData;
        CacheType cacheUsed = CacheType.CONCURRENT_MULTIMAP_TILE_CACHE;
        int concurrencyLevel = DEFAULT_CONCURRENCY_LEVEL;
        long memoryCacheCapacity = 0x8000000L;
        boolean syntheticImage = false;
        boolean diagnosticEnabled = DEFAULT_DIAGNOSTICS;
        boolean multipleOp = DEFAULT_MULTIOPERATIONS;
        RenderedImage imageSynth = ConcurrentCacheTest.getSynthetic(1.0);
        String path = null;
        boolean bl = mainData = args != null;
        if (mainData && args.length > 0) {
            cacheUsed = CacheType.values()[Integer.parseInt(args[0])];
            if (cacheUsed != CacheType.SUN_TILE_CACHE) {
                concurrencyLevel = Integer.parseInt(args[1]);
                memoryCacheCapacity = Long.parseLong(args[2]);
                diagnosticEnabled = Boolean.parseBoolean(args[3]);
                multipleOp = Boolean.parseBoolean(args[4]);
                syntheticImage = Boolean.parseBoolean(args[5]);
                if (syntheticImage) {
                    imageSynth = ConcurrentCacheTest.getSynthetic(1.0);
                } else {
                    path = args[6];
                }
            } else {
                memoryCacheCapacity = Long.parseLong(args[1]);
                diagnosticEnabled = Boolean.parseBoolean(args[2]);
                multipleOp = Boolean.parseBoolean(args[3]);
                syntheticImage = Boolean.parseBoolean(args[4]);
                if (syntheticImage) {
                    imageSynth = ConcurrentCacheTest.getSynthetic(1.0);
                } else {
                    path = args[5];
                }
            }
        }
        LOGGER.setLevel(Level.FINE);
        FileHandler fileTxt = new FileHandler("target/ConcurrentCacheTestLog.txt");
        int numTest = 10;
        double[][] dataTest = new double[numTest][7];
        for (int f = 0; f < numTest; ++f) {
            LOGGER.log(Level.INFO, "Test N\u00ef\u00bf\u00bd." + (f + 1));
            dataTest[f] = new ConcurrentCacheTest().testwriteImageAndWatchFlag(cacheUsed, concurrencyLevel, memoryCacheCapacity, imageSynth, path, diagnosticEnabled, multipleOp);
        }
        String stringConcurrent = " with " + cacheUsed.tileCacheString;
        if (cacheUsed != CacheType.SUN_TILE_CACHE) {
            stringConcurrent = stringConcurrent + " and " + concurrencyLevel + " segments";
        }
        for (int f = 0; f < numTest; ++f) {
            for (int g = 0; g < dataTest[f].length; ++g) {
                LOGGER.log(Level.INFO, "Throughput in test " + (f + 1) + " for " + (int)Math.pow(2.0, g) + " threads is " + (int)dataTest[f][g] + " requests/second" + stringConcurrent);
            }
        }
    }

    public static RenderedImage getSynthetic(double maximum) {
        float width = 1000.0f;
        float height = 1000.0f;
        ParameterBlock pb = new ParameterBlock();
        pb.add(1000.0f);
        pb.add(1000.0f);
        pb.add(new Integer[]{1});
        return JAI.create((String)"constant", (ParameterBlock)pb);
    }

    @Test
    public void emptyTest() {
    }

    private class WeigherPeriodic
    implements Runnable {
        private CacheType typeCache;

        private WeigherPeriodic(CacheType cacheUsed) {
            this.typeCache = cacheUsed;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                TileCache cache = JAI.getDefaultInstance().getTileCache();
                long memory = 0L;
                switch (this.typeCache) {
                    case SUN_TILE_CACHE: {
                        SunTileCache sunCache = (SunTileCache)cache;
                        memory = sunCache.getCacheMemoryUsed();
                        break;
                    }
                    case CONCURRENT_MULTIMAP_TILE_CACHE: {
                        ConcurrentTileCacheMultiMap cmTileCache = (ConcurrentTileCacheMultiMap)cache;
                        memory = cmTileCache.getCacheMemoryUsed();
                    }
                }
                LOGGER.log(Level.INFO, "Current Memory Used: " + memory / 1024L + " Kb");
            }
            ConcurrentCacheTest.this.latch.countDown();
        }
    }

    private class Worker
    implements Runnable {
        private boolean multipleTestOperations;

        private Worker(boolean multipleTestOperations) {
            this.multipleTestOperations = multipleTestOperations;
        }

        @Override
        public void run() {
            if (!this.multipleTestOperations) {
                for (int i = 0; i < ConcurrentCacheTest.this.maxRequestPerThread; ++i) {
                    double dataX = ConcurrentCacheTest.this.generator.nextDouble();
                    double dataY = ConcurrentCacheTest.this.generator.nextDouble();
                    int tilex = (int)(dataX * (ConcurrentCacheTest.this.maxTileX - ConcurrentCacheTest.this.minTileX) + ConcurrentCacheTest.this.minTileX);
                    int tiley = (int)(dataY * (ConcurrentCacheTest.this.maxTileY - ConcurrentCacheTest.this.minTileY) + ConcurrentCacheTest.this.minTileY);
                    ConcurrentCacheTest.this.image_.getTile(tilex, tiley);
                }
                JAI.getDefaultInstance().getTileCache().removeTiles(ConcurrentCacheTest.this.image_);
                ConcurrentCacheTest.this.latch.countDown();
            } else {
                JAI.getDefaultInstance().getTileCache().getTiles(ConcurrentCacheTest.this.image_);
                JAI.getDefaultInstance().getTileCache().removeTiles(ConcurrentCacheTest.this.image_);
                ConcurrentCacheTest.this.latch.countDown();
            }
        }
    }

    public static enum CacheType {
        SUN_TILE_CACHE(0, "SunTileCache"),
        CONCURRENT_TILE_CACHE(1, "ConcurrentTileCache"),
        CONCURRENT_MULTIMAP_TILE_CACHE(2, "ConcurrentMultimapCache");

        private final int tileCache;
        private final String tileCacheString;

        private CacheType(int value, String s) {
            this.tileCache = value;
            this.tileCacheString = s;
        }

        public int valueCache() {
            return this.tileCache;
        }

        public String cacheName() {
            return this.tileCacheString;
        }
    }
}

