/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.convolve;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.convolve.ConvolveOpImage;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.iterator.RandomIter;

public class ConvolveGeneralOpImage
extends ConvolveOpImage {
    public ConvolveGeneralOpImage(RenderedImage source, BorderExtender extender, RenderingHints hints, ImageLayout l, KernelJAI kernel, ROI roi, Range noData, double destinationNoData, boolean skipNoData) {
        super(source, extender, hints, l, kernel, roi, noData, destinationNoData, skipNoData);
    }

    @Override
    protected void byteLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[] kdata = this.kernel.getKernelData();
        int kw = this.kernel.getWidth();
        int kh = this.kernel.getHeight();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        int srcScanlineOffset = 0;
        int dstScanlineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        byte[] dstData = dstDataArrays[k];
                        byte[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw; ++v) {
                                f += (float)(srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v];
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = ImageUtil.clampRoundByte((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        byte[] dstData = dstDataArrays[k];
                        byte[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    f += (float)(srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = !inRoi ? this.destNoDataByte : ImageUtil.clampRoundByte((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        byte[] dstData = dstDataArrays[k];
                        byte[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw && valid; ++v) {
                                int value = srcData[imageOffset] & 0xFF;
                                if (valid && this.lut[value]) {
                                    f += (float)value * kdata[kernelVerticalOffset + v];
                                } else if (this.skipNoData) {
                                    valid = false;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = valid ? ImageUtil.clampRoundByte((float)f) : this.destNoDataByte;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        byte[] dstData = dstDataArrays[k];
                        byte[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw && valid; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    int value = srcData[imageOffset] & 0xFF;
                                    if (valid && this.lut[value]) {
                                        f += (float)value * kdata[kernelVerticalOffset + v];
                                    } else if (this.skipNoData) {
                                        valid = false;
                                    }
                                    f += (float)(srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = inRoi && valid ? ImageUtil.clampRoundByte((float)f) : this.destNoDataByte;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    @Override
    protected void ushortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[] kdata = this.kernel.getKernelData();
        int kw = this.kernel.getWidth();
        int kh = this.kernel.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        int srcScanlineOffset = 0;
        int dstScanlineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw; ++v) {
                                f += (float)(srcData[imageOffset] & 0xFFFF) * kdata[kernelVerticalOffset + v];
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = ImageUtil.clampRoundUShort((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    f += (float)(srcData[imageOffset] & 0xFFFF) * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = !inRoi ? this.destNoDataShort : ImageUtil.clampRoundUShort((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw && valid; ++v) {
                                short value = srcData[imageOffset];
                                if (valid && this.noData.contains(value)) {
                                    f += (float)(value & 0xFFFF) * kdata[kernelVerticalOffset + v];
                                } else if (this.skipNoData) {
                                    valid = false;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = valid ? ImageUtil.clampRoundUShort((float)f) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw && valid; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    short value = srcData[imageOffset];
                                    if (valid && this.noData.contains(value)) {
                                        f += (float)(value & 0xFFFF) * kdata[kernelVerticalOffset + v];
                                    } else if (this.skipNoData) {
                                        valid = false;
                                    }
                                    f += (float)(srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = inRoi && valid ? ImageUtil.clampRoundUShort((float)f) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    @Override
    protected void shortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[] kdata = this.kernel.getKernelData();
        int kw = this.kernel.getWidth();
        int kh = this.kernel.getHeight();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        int srcScanlineOffset = 0;
        int dstScanlineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw; ++v) {
                                f += (float)srcData[imageOffset] * kdata[kernelVerticalOffset + v];
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = ImageUtil.clampRoundShort((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    f += (float)srcData[imageOffset] * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = !inRoi ? this.destNoDataShort : ImageUtil.clampRoundShort((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw && valid; ++v) {
                                short value = srcData[imageOffset];
                                if (valid && this.noData.contains(value)) {
                                    f += (float)value * kdata[kernelVerticalOffset + v];
                                } else if (this.skipNoData) {
                                    valid = false;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = valid ? ImageUtil.clampRoundShort((float)f) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        short[] dstData = dstDataArrays[k];
                        short[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw && valid; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    short value = srcData[imageOffset];
                                    if (valid && this.noData.contains(value)) {
                                        f += (float)value * kdata[kernelVerticalOffset + v];
                                    } else if (this.skipNoData) {
                                        valid = false;
                                    }
                                    f += (float)(srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = inRoi && valid ? ImageUtil.clampRoundShort((float)f) : this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    @Override
    protected void intLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[] kdata = this.kernel.getKernelData();
        int kw = this.kernel.getWidth();
        int kh = this.kernel.getHeight();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        int srcScanlineOffset = 0;
        int dstScanlineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        int[] dstData = dstDataArrays[k];
                        int[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw; ++v) {
                                f += (float)srcData[imageOffset] * kdata[kernelVerticalOffset + v];
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = ImageUtil.clampRoundInt((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        int[] dstData = dstDataArrays[k];
                        int[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    f += (float)srcData[imageOffset] * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = !inRoi ? this.destNoDataInt : ImageUtil.clampRoundInt((float)f);
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        int[] dstData = dstDataArrays[k];
                        int[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw && valid; ++v) {
                                int value = srcData[imageOffset];
                                if (valid && this.noData.contains(value)) {
                                    f += (float)value * kdata[kernelVerticalOffset + v];
                                } else if (this.skipNoData) {
                                    valid = false;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = valid ? ImageUtil.clampRoundInt((float)f) : this.destNoDataInt;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        int[] dstData = dstDataArrays[k];
                        int[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw && valid; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    int value = srcData[imageOffset];
                                    if (valid && this.noData.contains(value)) {
                                        f += (float)value * kdata[kernelVerticalOffset + v];
                                    } else if (this.skipNoData) {
                                        valid = false;
                                    }
                                    f += (float)(srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = inRoi && valid ? ImageUtil.clampRoundInt((float)f) : this.destNoDataInt;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    @Override
    protected void floatLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[] kdata = this.kernel.getKernelData();
        int kw = this.kernel.getWidth();
        int kh = this.kernel.getHeight();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        int srcScanlineOffset = 0;
        int dstScanlineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        float[] dstData = dstDataArrays[k];
                        float[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw; ++v) {
                                f += srcData[imageOffset] * kdata[kernelVerticalOffset + v];
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = f;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        float[] dstData = dstDataArrays[k];
                        float[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    f += srcData[imageOffset] * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = !inRoi ? this.destNoDataFloat : f;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        float[] dstData = dstDataArrays[k];
                        float[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw && valid; ++v) {
                                float value = srcData[imageOffset];
                                if (valid && this.noData.contains(value)) {
                                    f += value * kdata[kernelVerticalOffset + v];
                                } else if (this.skipNoData) {
                                    valid = false;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = valid ? f : this.destNoDataFloat;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        float[] dstData = dstDataArrays[k];
                        float[] srcData = srcDataArrays[k];
                        float f = 0.5f;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw && valid; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    float value = srcData[imageOffset];
                                    if (valid && this.noData.contains(value)) {
                                        f += value * kdata[kernelVerticalOffset + v];
                                    } else if (this.skipNoData) {
                                        valid = false;
                                    }
                                    f += (float)((int)srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = inRoi && valid ? f : this.destNoDataFloat;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    @Override
    protected void doubleLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        float[] kdata = this.kernel.getKernelData();
        int kw = this.kernel.getWidth();
        int kh = this.kernel.getHeight();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        int srcScanlineOffset = 0;
        int dstScanlineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        double[] dstData = dstDataArrays[k];
                        double[] srcData = srcDataArrays[k];
                        double f = 0.5;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw; ++v) {
                                f += srcData[imageOffset] * (double)kdata[kernelVerticalOffset + v];
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = f;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        double[] dstData = dstDataArrays[k];
                        double[] srcData = srcDataArrays[k];
                        double f = 0.5;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        for (int u = 0; u < kh; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    f += srcData[imageOffset] * (double)kdata[kernelVerticalOffset + v];
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = !inRoi ? this.destNoDataDouble : f;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    for (int k = 0; k < dnumBands; ++k) {
                        double[] dstData = dstDataArrays[k];
                        double[] srcData = srcDataArrays[k];
                        double f = 0.5;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            for (int v = 0; v < kw && valid; ++v) {
                                double value = srcData[imageOffset];
                                if (valid && this.noData.contains(value)) {
                                    f += value * (double)kdata[kernelVerticalOffset + v];
                                } else if (this.skipNoData) {
                                    valid = false;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = valid ? f : this.destNoDataDouble;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int j = 0; j < dheight; ++j) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + j;
                for (int i = 0; i < dwidth; ++i) {
                    x0 = srcX + i;
                    for (int k = 0; k < dnumBands; ++k) {
                        double[] dstData = dstDataArrays[k];
                        double[] srcData = srcDataArrays[k];
                        double f = 0.5;
                        int kernelVerticalOffset = 0;
                        int imageVerticalOffset = srcPixelOffset + srcBandOffsets[k];
                        boolean inRoi = false;
                        boolean valid = true;
                        for (int u = 0; u < kh && valid; ++u) {
                            int imageOffset = imageVerticalOffset;
                            int yI = y0 + u;
                            for (int v = 0; v < kw && valid; ++v) {
                                int xI = x0 + v;
                                if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                    double value = srcData[imageOffset];
                                    if (valid && this.noData.contains(value)) {
                                        f += value * (double)kdata[kernelVerticalOffset + v];
                                    } else if (this.skipNoData) {
                                        valid = false;
                                    }
                                    f += (double)((float)((int)srcData[imageOffset] & 0xFF) * kdata[kernelVerticalOffset + v]);
                                    inRoi = true;
                                }
                                imageOffset += srcPixelStride;
                            }
                            kernelVerticalOffset += kw;
                            imageVerticalOffset += srcScanlineStride;
                        }
                        dstData[dstPixelOffset + dstBandOffsets[k]] = inRoi && valid ? f : this.destNoDataDouble;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }
}

