/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.errordiffusion;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.testclasses.TestData;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.ColorCube;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import org.junit.Assert;
import org.junit.Test;

public class ErrorDiffusionTest
extends TestBase {
    private static final double TOLERANCE = 0.01;

    @Test
    public void testSyntheticShort() throws IOException {
        float[] data = new float[256];
        for (int i = 0; i < 256; ++i) {
            data[i] = i;
        }
        LookupTableJAI lt = new LookupTableJAI(data);
        KernelJAI k = KernelJAI.GRADIENT_MASK_SOBEL_VERTICAL;
        BufferedImage image = this.getSyntheticShortImage();
        ParameterBlockJAI pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        RenderedOp finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, null, null);
        finalimage.dispose();
        ROIShape roi = new ROIShape((Shape)new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4));
        Range nodata = RangeFactory.create((short)5, (short)5);
        pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        pbj.setParameter("roi", (Object)roi);
        finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, (ROI)roi, null);
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, null, nodata);
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        pbj.setParameter("roi", (Object)roi);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, (ROI)roi, nodata);
        finalimage.dispose();
    }

    private void checkNoDataROI(RenderedOp finalimage, RenderedImage image, ROI roi, Range nodata) {
        boolean nodataExists;
        Assert.assertEquals((long)finalimage.getMinX(), (long)image.getMinX());
        Assert.assertEquals((long)finalimage.getMinY(), (long)image.getMinY());
        Assert.assertEquals((long)finalimage.getWidth(), (long)image.getWidth());
        Assert.assertEquals((long)finalimage.getHeight(), (long)image.getHeight());
        boolean roiExists = roi != null;
        boolean bl = nodataExists = nodata != null;
        if (!roiExists && !nodataExists) {
            double maximum;
            Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.EXTREMA};
            RenderedOp calculated = StatisticsDescriptor.create((RenderedImage)finalimage, (int)1, (int)1, null, null, (boolean)false, (int[])new int[]{0}, (Statistics.StatsType[])stats, null);
            Statistics stat = ((Statistics[][])calculated.getProperty("JAI-EXT.stats"))[0][0];
            double[] result = (double[])stat.getResult();
            double minimum = result[0];
            Assert.assertTrue((minimum < (maximum = result[1]) ? 1 : 0) != 0);
            return;
        }
        if (nodataExists) {
            nodata = RangeFactory.convertToDoubleRange((Range)nodata);
        }
        RandomIter roiIter = null;
        Rectangle roiBounds = null;
        if (roiExists) {
            PlanarImage roiIMG = roi.getAsImage();
            roiIter = RandomIterFactory.create((RenderedImage)roiIMG, (Rectangle)finalimage.getBounds(), (boolean)true, (boolean)true);
            roiBounds = roi.getBounds();
        }
        RandomIter sourceIter = RandomIterFactory.create((RenderedImage)image, null, (boolean)true, (boolean)true);
        RandomIter destIter = RandomIterFactory.create((RenderedImage)finalimage, null, (boolean)true, (boolean)true);
        int w = image.getWidth();
        int h = image.getHeight();
        int minX = image.getMinX();
        int minY = image.getMinY();
        int maxX = minX + w;
        int maxY = minY + h;
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                double src = sourceIter.getSampleDouble(x, y, 0);
                double dest = destIter.getSampleDouble(x, y, 0);
                boolean valid = true;
                if (roiExists && (!roiBounds.contains(x, y) || roiIter.getSample(x, y, 0) <= 0)) {
                    valid = false;
                }
                if (nodataExists && nodata.contains(src)) {
                    valid = false;
                }
                if (valid) continue;
                Assert.assertEquals((double)0.0, (double)dest, (double)0.01);
            }
        }
    }

    private BufferedImage getSyntheticShortImage() {
        int width = 256;
        int height = 256;
        WritableRaster raster = RasterFactory.createBandedRaster((int)1, (int)256, (int)256, (int)1, null);
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 1);
        BufferedImage image = new BufferedImage(cm, raster, false, null);
        return image;
    }

    @Test
    public void testTiff() throws IOException {
        ColorCube lt = ColorCube.BYTE_496;
        KernelJAI k = KernelJAI.ERROR_FILTER_FLOYD_STEINBERG;
        RenderedImage image = this.getTestTiff();
        ParameterBlockJAI pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        RenderedOp finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, null, null);
        finalimage.dispose();
        ROIShape roi = new ROIShape((Shape)new Rectangle(image.getMinX() + 5, image.getMinY() + 5, image.getWidth() / 4, image.getHeight() / 4));
        Range nodata = RangeFactory.create((byte)5, (byte)5);
        pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        pbj.setParameter("roi", (Object)roi);
        finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, (ROI)roi, null);
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, null, nodata);
        finalimage.dispose();
        pbj = new ParameterBlockJAI("ErrorDiffusion");
        pbj.addSource((Object)image);
        pbj.setParameter("errorKernel", (Object)k);
        pbj.setParameter("colorMap", (Object)lt);
        pbj.setParameter("roi", (Object)roi);
        pbj.setParameter("nodata", (Object)nodata);
        finalimage = JAI.create((String)"ErrorDiffusion", (ParameterBlock)pbj);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)finalimage, (boolean)false, (boolean)false, null);
        } else {
            finalimage.getTiles();
        }
        this.checkNoDataROI(finalimage, image, (ROI)roi, nodata);
        finalimage.dispose();
    }

    private RenderedImage getTestTiff() throws IOException, FileNotFoundException {
        File spearfish = TestData.file((Object)((Object)this), (String)"test.tif");
        RenderedOp image = JAI.create((String)"ImageRead", (Object)spearfish);
        return image;
    }
}

