/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.iterators;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RandomIterTest {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final int TEST_SELECTOR = Integer.getInteger("JAI.Ext.TestSelector", 0);
    private static final boolean SUBSEQUENCY = Boolean.getBoolean("JAI.Ext.Subsequency");
    private static int[] valueArrayByte;
    private static int[] valueArrayShort;
    private static int[] valueArrayInt;
    private static float[] valueArrayByteIMGFloat;
    private static float[] valueArrayShortIMGFloat;
    private static float[] valueArrayIntIMGFloat;
    private static double[] valueArrayByteIMGDouble;
    private static double[] valueArrayShortIMGDouble;
    private static double[] valueArrayIntIMGDouble;
    private static int[][] indexArray;
    private static RenderedImage testImageByte;
    private static RenderedImage testImageShort;
    private static RenderedImage testImageInt;
    private static RenderedImage testImageByteIMGFloat;
    private static RenderedImage testImageShortIMGFloat;
    private static RenderedImage testImageIntIMGFloat;
    private static RenderedImage testImageByteIMGDouble;
    private static RenderedImage testImageShortIMGDouble;
    private static RenderedImage testImageIntIMGDouble;
    private static RandomIter iterByte;
    private static RandomIter iterShort;
    private static RandomIter iterInt;
    private static RandomIter iterByteIMGFloat;
    private static RandomIter iterShortIMGFloat;
    private static RandomIter iterIntIMGFloat;
    private static RandomIter iterByteIMGDouble;
    private static RandomIter iterShortIMGDouble;
    private static RandomIter iterIntIMGDouble;
    private final double DELTA = 0.01;

    @BeforeClass
    public static void imagePreparation() {
        testImageByte = RandomIterTest.createTestImage(3, 254, 254, 64, 64);
        testImageByteIMGFloat = RandomIterTest.createTestImage(4, 254, 254, 64, 64);
        testImageByteIMGDouble = RandomIterTest.createTestImage(5, 254, 254, 64, 64);
        testImageShort = RandomIterTest.createTestImage(3, 512, 254, 2, 64);
        testImageShortIMGFloat = RandomIterTest.createTestImage(3, 512, 254, 2, 64);
        testImageShortIMGDouble = RandomIterTest.createTestImage(3, 512, 254, 2, 64);
        testImageInt = RandomIterTest.createTestImage(3, 65534, 254, 1, 64);
        testImageIntIMGFloat = RandomIterTest.createTestImage(3, 65534, 254, 1, 64);
        testImageIntIMGDouble = RandomIterTest.createTestImage(3, 65534, 1024, 1, 64);
        iterByte = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageByte, null);
        iterShort = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageShort, null);
        iterInt = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageInt, null);
        iterByteIMGFloat = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageByteIMGFloat, null);
        iterShortIMGFloat = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageShortIMGFloat, null);
        iterIntIMGFloat = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageIntIMGFloat, null);
        iterByteIMGDouble = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageByteIMGDouble, null);
        iterShortIMGDouble = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageShortIMGDouble, null);
        iterIntIMGDouble = javax.media.jai.iterator.RandomIterFactory.create((RenderedImage)testImageIntIMGDouble, null);
        valueArrayByte = new int[4];
        valueArrayShort = new int[4];
        valueArrayInt = new int[4];
        valueArrayByteIMGFloat = new float[4];
        valueArrayShortIMGFloat = new float[4];
        valueArrayIntIMGFloat = new float[4];
        valueArrayByteIMGDouble = new double[4];
        valueArrayShortIMGDouble = new double[4];
        valueArrayIntIMGDouble = new double[4];
        for (int i = 0; i < indexArray.length; ++i) {
            int x = indexArray[i][0];
            int y = indexArray[i][1];
            RandomIterTest.valueArrayByte[i] = iterByte.getSample(x, y, 0);
            RandomIterTest.valueArrayShort[i] = iterShort.getSample(x, y, 0);
            RandomIterTest.valueArrayInt[i] = iterInt.getSample(x, y, 0);
            RandomIterTest.valueArrayByteIMGFloat[i] = iterByteIMGFloat.getSampleFloat(x, y, 0);
            RandomIterTest.valueArrayShortIMGFloat[i] = iterShortIMGFloat.getSampleFloat(x, y, 0);
            RandomIterTest.valueArrayIntIMGFloat[i] = iterIntIMGFloat.getSampleFloat(x, y, 0);
            RandomIterTest.valueArrayByteIMGDouble[i] = iterByteIMGDouble.getSampleDouble(x, y, 0);
            RandomIterTest.valueArrayShortIMGDouble[i] = iterShortIMGDouble.getSampleDouble(x, y, 0);
            RandomIterTest.valueArrayIntIMGDouble[i] = iterIntIMGDouble.getSampleDouble(x, y, 0);
        }
    }

    @Test
    public void testRandomIterByte() {
        this.testRandomIterInt(testImageByte, valueArrayByte, true, true);
        this.testRandomIterFloat(testImageByteIMGFloat, valueArrayByteIMGFloat, true, true);
        this.testRandomIterDouble(testImageByteIMGDouble, valueArrayByteIMGDouble, true, true);
    }

    @Test
    public void testRandomIterByteNoCache() {
        this.testRandomIterInt(testImageByte, valueArrayByte, false, true);
        this.testRandomIterFloat(testImageByteIMGFloat, valueArrayByteIMGFloat, false, true);
        this.testRandomIterDouble(testImageByteIMGDouble, valueArrayByteIMGDouble, false, true);
    }

    @Test
    public void testRandomIterShort() {
        this.testRandomIterInt(testImageShort, valueArrayShort, true, true);
        this.testRandomIterFloat(testImageShortIMGFloat, valueArrayShortIMGFloat, true, true);
        this.testRandomIterDouble(testImageShortIMGDouble, valueArrayShortIMGDouble, true, true);
    }

    @Test
    public void testRandomIterShortNoCache() {
        this.testRandomIterInt(testImageShort, valueArrayShort, false, true);
        this.testRandomIterFloat(testImageShortIMGFloat, valueArrayShortIMGFloat, false, true);
        this.testRandomIterDouble(testImageShortIMGDouble, valueArrayShortIMGDouble, false, true);
    }

    @Test
    public void testRandomIterInt() {
        this.testRandomIterInt(testImageInt, valueArrayInt, true, true);
        this.testRandomIterFloat(testImageIntIMGFloat, valueArrayIntIMGFloat, true, true);
        this.testRandomIterDouble(testImageIntIMGDouble, valueArrayIntIMGDouble, true, true);
    }

    @Test
    public void testRandomIterIntNoCache() {
        this.testRandomIterInt(testImageInt, valueArrayInt, false, true);
        this.testRandomIterFloat(testImageIntIMGFloat, valueArrayIntIMGFloat, false, true);
        this.testRandomIterDouble(testImageIntIMGDouble, valueArrayIntIMGDouble, false, true);
    }

    @Test
    public void testRandomIterNoArrayCalculation() {
        this.testRandomIterInt(testImageInt, valueArrayInt, false, false);
        this.testRandomIterFloat(testImageIntIMGFloat, valueArrayIntIMGFloat, false, false);
        this.testRandomIterDouble(testImageIntIMGDouble, valueArrayIntIMGDouble, false, false);
    }

    @Test
    public void testSpeed() {
        if (TEST_SELECTOR == 0) {
            this.testIteratorSpeed(testImageByte, true, true, SUBSEQUENCY);
        }
    }

    @Test
    public void testSpeedNoCached() {
        if (TEST_SELECTOR == 1) {
            this.testIteratorSpeed(testImageByte, false, true, SUBSEQUENCY);
        }
    }

    @Test
    public void testSpeedNoArray() {
        if (TEST_SELECTOR == 2) {
            this.testIteratorSpeed(testImageByte, false, false, SUBSEQUENCY);
        }
    }

    public static RenderedImage createTestImage(int dataType, int width, int height, int tileW, int tileH) {
        int imageDim = width * height;
        int numBands = 1;
        ComponentSampleModel sm = new ComponentSampleModel(dataType, width, height, 3, width, new int[]{0, imageDim, imageDim * 2});
        TiledImage used = new TiledImage((SampleModel)sm, tileW, tileH);
        for (int b = 0; b < numBands; ++b) {
            for (int j = 0; j < width; ++j) {
                block7: for (int k = 0; k < height; ++k) {
                    if (k >= 255 || j >= 255) continue;
                    switch (dataType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            int value = (int)(Math.random() * 10.0);
                            used.setSample(j, k, b, value);
                            continue block7;
                        }
                        case 4: {
                            float valuef = (float)(Math.random() * 10.0);
                            used.setSample(j, k, b, valuef);
                            continue block7;
                        }
                        case 5: {
                            double valued = Math.random() * 10.0;
                            used.setSample(j, k, b, valued);
                            continue block7;
                        }
                        default: {
                            throw new IllegalArgumentException("Wrong data type");
                        }
                    }
                }
            }
        }
        return used;
    }

    public void testRandomIterInt(RenderedImage img, int[] valueArray, boolean cachedTiles, boolean arrayCalculation) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)img, null, (boolean)cachedTiles, (boolean)arrayCalculation);
        int[] array = new int[3];
        for (int i = 0; i < indexArray.length; ++i) {
            int x = indexArray[i][0];
            int y = indexArray[i][1];
            int valueExpected = iter.getSample(x, y, 0);
            Assert.assertEquals((long)valueExpected, (long)valueArray[i]);
            int valueExpectedArray = iter.getPixel(x, y, array)[0];
            Assert.assertEquals((long)valueExpectedArray, (long)valueArray[i]);
        }
    }

    public void testRandomIterFloat(RenderedImage img, float[] valueArray, boolean cachedTiles, boolean arrayCalculation) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)img, null, (boolean)cachedTiles, (boolean)arrayCalculation);
        float[] array = new float[3];
        for (int i = 0; i < indexArray.length; ++i) {
            int x = indexArray[i][0];
            int y = indexArray[i][1];
            float valueExpected = iter.getSampleFloat(x, y, 0);
            Assert.assertEquals((double)valueExpected, (double)valueArray[i], (double)0.01);
            float valueExpectedArray = iter.getPixel(x, y, array)[0];
            Assert.assertEquals((double)valueExpectedArray, (double)valueArray[i], (double)0.01);
        }
    }

    public void testRandomIterDouble(RenderedImage img, double[] valueArray, boolean cachedTiles, boolean arrayCalculation) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)img, null, (boolean)cachedTiles, (boolean)arrayCalculation);
        double[] array = new double[3];
        for (int i = 0; i < indexArray.length; ++i) {
            int x = indexArray[i][0];
            int y = indexArray[i][1];
            double valueExpected = iter.getSampleDouble(x, y, 0);
            Assert.assertEquals((double)valueExpected, (double)valueArray[i], (double)0.01);
            double valueExpectedArray = iter.getPixel(x, y, array)[0];
            Assert.assertEquals((double)valueExpectedArray, (double)valueArray[i], (double)0.01);
        }
    }

    public void testIteratorSpeed(RenderedImage img, boolean cachedTiles, boolean arrayCalculation, boolean subsequentIterator) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)img, null, (boolean)cachedTiles, (boolean)arrayCalculation);
        String descriptor = "";
        if (arrayCalculation) {
            descriptor = descriptor + "ArrayCalculation ";
            descriptor = cachedTiles ? descriptor + "Cached Tiles" : descriptor + "No Cached Tiles";
        } else {
            descriptor = descriptor + "No ArrayCalculation ";
        }
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        int imgMinX = testImageByte.getMinX();
        int imgMinY = testImageByte.getMinY();
        int imgWidth = testImageByte.getWidth();
        int imgHeight = testImageByte.getHeight();
        int x = imgMinX;
        int y = imgMinY;
        int xStep = (imgWidth - 1) / totalCycles;
        int yStep = (imgHeight - 1) / totalCycles;
        for (int i = 0; i < totalCycles; ++i) {
            if (subsequentIterator) {
                x += xStep;
                y += yStep;
            } else {
                x = (int)(Math.random() * (double)imgWidth + (double)imgMinX);
                y = (int)(Math.random() * (double)imgHeight + (double)imgMinY);
            }
            long start = System.nanoTime();
            iter.getSample(x, y, 0);
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
            if (end > max) {
                max = end;
            }
            if (end >= min) continue;
            min = end;
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION.intValue();
        double maxD = max;
        double minD = min;
        System.out.println("\nMean value for RandomIterator with " + descriptor + " : " + meanValue + " nsec.");
        System.out.println("Maximum value for RandomIterator with " + descriptor + " : " + maxD + " nsec.");
        System.out.println("Minimum value for RandomIterator with " + descriptor + " : " + minD + " nsec.");
        iter.done();
    }

    static {
        indexArray = new int[][]{{1, 5}, {40, 5}, {80, 5}, {250, 5}};
    }
}

