/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.docs;

import it.geosolutions.jaiext.jiffle.JiffleBuilder;
import it.geosolutions.jaiext.swing.ImageFrame;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.File;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;

public class Ripples {
    public static void main(String[] args) {
        Ripples me = new Ripples();
        TiledImage image = ImageUtilities.createConstantImage((int)300, (int)300, (Number)0.0);
        me.createRipplesImage((WritableRenderedImage)image);
        ImageFrame frame = new ImageFrame((RenderedImage)image, "ripples");
        frame.setSize(550, 550);
        frame.setVisible(true);
    }

    public void createRipplesImage(WritableRenderedImage destImg) {
        int width = destImg.getWidth();
        int height = destImg.getHeight();
        int x = destImg.getMinX();
        int y = destImg.getMinY();
        int xc = x + destImg.getWidth() / 2;
        int yc = y + destImg.getHeight() / 2;
        double C = Math.PI * 8;
        WritableRectIter iter = RectIterFactory.createWritable((WritableRenderedImage)destImg, null);
        do {
            double dy = (double)(y - yc) / (double)yc;
            do {
                double dx = (double)(x - xc) / (double)xc;
                double d = Math.sqrt(dx * dx + dy * dy);
                iter.setSample(Math.sin(d * C));
                ++x;
            } while (!iter.nextPixelDone());
            x = destImg.getMinX();
            ++y;
            iter.startPixels();
        } while (!iter.nextLineDone());
    }

    public void runScriptWithBuilder(File scriptFile) throws Exception {
        JiffleBuilder builder = new JiffleBuilder();
        builder.script(scriptFile).dest("destImg", 500, 500).run();
        RenderedImage result = builder.getImage("destImg");
    }
}

