/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.docs;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.JiffleBuilder;
import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransforms;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.swing.ImageFrame;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.HashMap;
import javax.media.jai.TiledImage;

public class RunProportionalRipples {
    public static void main(String[] args) throws JiffleException {
        RunProportionalRipples self = new RunProportionalRipples();
        String script = "init { C = M_PI * 8; }dx = 2*(x() - 0.5); \ndy = 2*(y() - 0.5); \nd = sqrt(dx*dx + dy*dy); \ndestImg = sin(C * d);";
        TiledImage destImage = ImageUtilities.createConstantImage((int)500, (int)500, (Number)0.0);
        self.runScriptWithJiffle(script, "destImg", (WritableRenderedImage)destImage);
        ImageFrame frame = new ImageFrame((RenderedImage)destImage, "Ripples");
        frame.setSize(550, 550);
        frame.setVisible(true);
    }

    public void runScriptWithJiffle(String script, String destVar, WritableRenderedImage destImage) throws JiffleException {
        Jiffle jiffle = new Jiffle();
        jiffle.setScript(script);
        HashMap<String, Jiffle.ImageRole> imageParams = new HashMap<String, Jiffle.ImageRole>();
        imageParams.put(destVar, Jiffle.ImageRole.DEST);
        jiffle.setImageParams(imageParams);
        jiffle.compile();
        JiffleDirectRuntime runtimeObj = jiffle.getRuntimeInstance();
        Rectangle imageBounds = new Rectangle(destImage.getMinX(), destImage.getMinY(), destImage.getWidth(), destImage.getHeight());
        Rectangle2D.Double worldBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        CoordinateTransform transform = CoordinateTransforms.unitBounds((Rectangle)imageBounds);
        runtimeObj.setWorldByNumPixels((Rectangle2D)worldBounds, destImage.getWidth(), destImage.getHeight());
        runtimeObj.setDestinationImage(destVar, destImage, transform);
        runtimeObj.evaluateAll(null);
    }

    public void runScriptWithBuilder(String script, String destVar, WritableRenderedImage destImage) throws JiffleException {
        Rectangle imageBounds = new Rectangle(destImage.getMinX(), destImage.getMinY(), destImage.getWidth(), destImage.getHeight());
        Rectangle2D.Double worldBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        CoordinateTransform transform = CoordinateTransforms.unitBounds((Rectangle)imageBounds);
        JiffleBuilder builder = new JiffleBuilder();
        builder.worldAndNumPixels((Rectangle2D)worldBounds, destImage.getWidth(), destImage.getHeight());
        builder.script(script).dest(destVar, destImage, transform);
        builder.run();
    }
}

