/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import it.geosolutions.jaiext.jiffle.parser.node.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class StatementList
implements Statement {
    private final List<Statement> stmts;

    public StatementList(List<Statement> stmts) {
        this.stmts = new ArrayList<Statement>(stmts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Statement stmt : this.stmts) {
            sb.append(stmt).append('\n');
        }
        return sb.toString();
    }

    @Override
    public void write(SourceWriter w) {
        for (Statement stmt : this.stmts) {
            stmt.write(w);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementList that = (StatementList)o;
        return Objects.equals(this.stmts, that.stmts);
    }

    public int hashCode() {
        return Objects.hash(this.stmts);
    }

    public List<Statement> getStmts() {
        return Collections.unmodifiableList(this.stmts);
    }
}

