/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.runtime;

import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.runtime.AbstractJiffleRuntime;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.IdentityCoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.jiffle.runtime.JiffleProgressListener;
import it.geosolutions.jaiext.jiffle.runtime.NullProgressListener;
import it.geosolutions.jaiext.jiffle.runtime.WorldNotSetException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;

public abstract class AbstractDirectRuntime
extends AbstractJiffleRuntime
implements JiffleDirectRuntime {
    private static final double EPS = 1.0E-10;
    protected Map<String, DestinationImage> _destImages = new HashMap<String, DestinationImage>();

    public AbstractDirectRuntime() {
        super(new String[0]);
        this.initOptionVars();
    }

    public AbstractDirectRuntime(String[] variableNames) {
        super(variableNames);
        this.initOptionVars();
    }

    @Override
    public void setDestinationImage(String varName, WritableRenderedImage image) {
        try {
            this.doSetDestinationImage(varName, image, null);
        }
        catch (WorldNotSetException worldNotSetException) {
            // empty catch block
        }
    }

    @Override
    public void setDestinationImage(String varName, WritableRenderedImage image, CoordinateTransform tr) throws JiffleException {
        try {
            this.doSetDestinationImage(varName, image, tr);
        }
        catch (WorldNotSetException ex) {
            throw new JiffleException(String.format("Setting a coordinate tranform for a destination (%s) withouthaving first set the world bounds and resolution", varName));
        }
    }

    private void doSetDestinationImage(String varName, WritableRenderedImage image, CoordinateTransform tr) throws WorldNotSetException {
        DestinationImage destinationImage = new DestinationImage(varName, image);
        boolean defaultTransform = tr == null;
        CoordinateTransform tt = defaultTransform ? this._defaultTransform : tr;
        destinationImage.setTransform(tt, defaultTransform);
        this._destImages.put(varName, destinationImage);
        this._imageScopeVarsInitialized = false;
    }

    @Override
    public void evaluateAll(JiffleProgressListener pl) {
        JiffleProgressListener listener;
        JiffleProgressListener jiffleProgressListener = listener = pl == null ? new NullProgressListener() : pl;
        if (!this.isWorldSet()) {
            this.setDefaultBounds();
        }
        long numPixels = this.getNumPixels();
        listener.setTaskSize(numPixels);
        long count = 0L;
        long sinceLastUpdate = 0L;
        long updateInterval = listener.getUpdateInterval();
        double minX = this.getMinX();
        double maxX = this.getMaxX();
        double resX = this.getXRes();
        double minY = this.getMinY();
        double maxY = this.getMaxY();
        double resY = this.getYRes();
        listener.start();
        for (double y = minY; y < maxY - 1.0E-10; y += resY) {
            for (double x = minX; x < maxX - 1.0E-10; x += resX) {
                this.evaluate(x, y);
                if (pl != null) {
                    ++count;
                }
                if (++sinceLastUpdate < updateInterval) continue;
                listener.update(count);
                sinceLastUpdate = 0L;
            }
        }
        listener.finish();
    }

    @Override
    public void writeToImage(String destImageName, double x, double y, int band, double value) {
        DestinationImage image = this._destImages.get(destImageName);
        image.write(x, y, band, value);
    }

    @Override
    public void setDefaultBounds() {
        RenderedImage refImage = null;
        String imageName = null;
        if (!this._destImages.isEmpty()) {
            imageName = this._destImages.keySet().iterator().next();
            refImage = this._destImages.get((Object)imageName).image;
        } else {
            imageName = (String)this._images.keySet().iterator().next();
            refImage = ((AbstractJiffleRuntime.SourceImage)this._images.get((Object)imageName)).image;
        }
        Rectangle rect = new Rectangle(refImage.getMinX(), refImage.getMinY(), refImage.getWidth(), refImage.getHeight());
        this.setWorldByResolution(rect, 1.0, 1.0);
    }

    @Override
    public void setDefaultTransform(CoordinateTransform tr) throws JiffleException {
        super.setDefaultTransform(tr);
        for (DestinationImage destImage : this._destImages.values()) {
            if (!destImage.defaultTransform) continue;
            destImage.setTransform(tr, true);
        }
    }

    public Map get_images() {
        Map<String, RenderedImage> images = super.get_images();
        for (DestinationImage destImage : this._destImages.values()) {
            images.put(destImage.imageName, destImage.image);
        }
        return images;
    }

    protected class DestinationImage {
        final String imageName;
        final WritableRenderedImage image;
        CoordinateTransform transform;
        boolean defaultTransform;
        final WritableRandomIter iterator;

        public DestinationImage(String imageName, WritableRenderedImage image) {
            this.imageName = imageName;
            this.image = image;
            this.iterator = RandomIterFactory.createWritable((WritableRenderedImage)image, null);
        }

        public void write(double x, double y, int band, double value) {
            int posy;
            int posx;
            if (this.transform != null && !(this.transform instanceof IdentityCoordinateTransform)) {
                Point imgPos = this.transform.worldToImage(x, y, null);
                posx = imgPos.x;
                posy = imgPos.y;
            } else {
                posx = (int)x;
                posy = (int)y;
            }
            this.iterator.setSample(posx, posy, band, value);
        }

        public void setTransform(CoordinateTransform transform, boolean defaultTransform) throws WorldNotSetException {
            if (transform != null && !AbstractDirectRuntime.this.isWorldSet()) {
                throw new WorldNotSetException();
            }
            this.transform = transform;
            this.defaultTransform = defaultTransform;
        }
    }
}

