/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.runtime;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.JiffleException;
import it.geosolutions.jaiext.jiffle.runtime.BandTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.IdentityCoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.IntegerStack;
import it.geosolutions.jaiext.jiffle.runtime.JiffleFunctions;
import it.geosolutions.jaiext.jiffle.runtime.JiffleRuntime;
import it.geosolutions.jaiext.jiffle.runtime.JiffleRuntimeException;
import it.geosolutions.jaiext.jiffle.runtime.WorldNotSetException;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;

public abstract class AbstractJiffleRuntime
implements JiffleRuntime {
    private static final double EPS = 1.0E-8;
    public static final String MAX_ITERATIONS_KEY = "it.geosolutions.jaiext.jiffle.maxIterations";
    private static final int DEFAULT_MAX_ITERATIONS = 200;
    private Map<String, Jiffle.ImageRole> _imageParams;
    private Rectangle2D _worldBounds;
    private double _xres;
    private double _yres;
    private boolean _worldSet;
    private String[] _variableNames;
    protected boolean _imageScopeVarsInitialized = false;
    private long _numPixels;
    protected Map<String, SourceImage> _images = new HashMap<String, SourceImage>();
    private static final int VAR_ARRAY_CHUNK = 100;
    protected boolean _outsideValueSet;
    protected double _outsideValue;
    protected IntegerStack _stk;
    protected final JiffleFunctions _FN = new JiffleFunctions();
    protected CoordinateTransform _defaultTransform;
    private final long _maxIterations;
    protected long _iterations = 0L;

    public AbstractJiffleRuntime() {
        this(new String[0]);
    }

    public AbstractJiffleRuntime(String[] variableNames) {
        this._stk = new IntegerStack();
        this._xres = Double.NaN;
        this._yres = Double.NaN;
        this._variableNames = variableNames;
        this._maxIterations = Integer.getInteger(MAX_ITERATIONS_KEY, 200).intValue();
    }

    public void setImageParams(Map imageParams) {
        this._imageParams = new HashMap<String, Jiffle.ImageRole>();
        for (Object oname : imageParams.keySet()) {
            String name = (String)oname;
            Jiffle.ImageRole role = (Jiffle.ImageRole)((Object)imageParams.get(oname));
            this._imageParams.put(name, role);
        }
    }

    @Override
    public String[] getSourceVarNames() {
        return this.doGetImageVarNames(Jiffle.ImageRole.SOURCE);
    }

    @Override
    public String[] getDestinationVarNames() {
        return this.doGetImageVarNames(Jiffle.ImageRole.DEST);
    }

    private String[] doGetImageVarNames(Jiffle.ImageRole role) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this._imageParams.keySet()) {
            if (this._imageParams.get(name) != role) continue;
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public void setWorldByResolution(Rectangle2D bounds, double xres, double yres) {
        if (bounds == null || bounds.isEmpty()) {
            throw new IllegalArgumentException("bounds cannot be null or empty");
        }
        if (xres < 1.0E-8 || yres < 1.0E-8) {
            throw new IllegalArgumentException("xres and yres but must be greater than 0");
        }
        this.doSetWorld(bounds, xres, yres);
    }

    @Override
    public void setWorldByNumPixels(Rectangle2D bounds, int numX, int numY) {
        if (bounds == null || bounds.isEmpty()) {
            throw new IllegalArgumentException("bounds cannot be null or empty");
        }
        if (numX <= 0 || numY <= 0) {
            throw new IllegalArgumentException("numX and numY must be greater than 0");
        }
        this.doSetWorld(bounds, bounds.getWidth() / (double)numX, bounds.getHeight() / (double)numY);
    }

    @Override
    public boolean isWorldSet() {
        return this._worldSet;
    }

    @Override
    public Double getVar(String varName) {
        Field field = this.getVariableField(varName);
        if (field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return field.getDouble(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected Field getVariableField(String varName) {
        try {
            return this.getClass().getDeclaredField("v_" + varName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Override
    public void setVar(String varName, Double value) throws JiffleRuntimeException {
        Field field = this.getVariableField(varName);
        if (field == null) {
            throw new JiffleRuntimeException("Undefined variable: " + varName);
        }
        try {
            field.setAccessible(true);
            field.setDouble(this, value == null ? Double.NaN : value);
            this._imageScopeVarsInitialized = false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getVarNames() {
        String[] names = new String[this._variableNames.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this._variableNames[i];
        }
        return names;
    }

    @Override
    public double getMinX() {
        return this._worldBounds.getMinX();
    }

    @Override
    public double getMaxX() {
        return this._worldBounds.getMaxX();
    }

    @Override
    public double getMinY() {
        return this._worldBounds.getMinY();
    }

    @Override
    public double getMaxY() {
        return this._worldBounds.getMaxY();
    }

    @Override
    public double getWidth() {
        return this._worldBounds.getWidth();
    }

    @Override
    public double getHeight() {
        return this._worldBounds.getHeight();
    }

    @Override
    public double getXRes() {
        return this._xres;
    }

    @Override
    public double getYRes() {
        return this._yres;
    }

    @Override
    public long getNumPixels() {
        if (!this._worldSet) {
            throw new IllegalStateException("Processing area has not been set");
        }
        return this._numPixels;
    }

    @Override
    public void setDefaultTransform(CoordinateTransform tr) throws JiffleException {
        if (tr != null && !this.isWorldSet()) {
            throw new WorldNotSetException();
        }
        this._defaultTransform = tr;
        for (SourceImage sourceImage : this._images.values()) {
            if (!sourceImage.defaultTransform) continue;
            sourceImage.setTransform(tr, true);
        }
    }

    protected CoordinateTransform getTransform(String imageVarName) {
        CoordinateTransform tr = this._images.get((Object)imageVarName).transform;
        if (tr == null) {
            tr = IdentityCoordinateTransform.INSTANCE;
        }
        return tr;
    }

    protected abstract void initImageScopeVars();

    protected void initOptionVars() {
    }

    private void doSetWorld(Rectangle2D bounds, double xres, double yres) {
        this.checkResValue(xres, Dim.XDIM, bounds);
        this.checkResValue(yres, Dim.YDIM, bounds);
        this._worldBounds = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        this._xres = xres;
        this._yres = yres;
        this._worldSet = true;
    }

    private void checkResValue(double value, Dim dim, Rectangle2D bounds) {
        String name;
        String string = name = dim == Dim.XDIM ? "xres" : "yres";
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException(name + " cannot be infinite");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(name + " cannot be NaN");
        }
        if (dim == Dim.XDIM && value > bounds.getWidth()) {
            throw new IllegalArgumentException(name + "should be less than processing area width");
        }
        if (dim == Dim.YDIM && value > bounds.getHeight()) {
            throw new IllegalArgumentException(name + "should be less than processing area height");
        }
    }

    @Override
    public double readFromImage(String srcImageName, double x, double y, int band) {
        SourceImage sourceImage = this._images.get(srcImageName);
        return sourceImage.read(x, y, band);
    }

    @Override
    public void setSourceImage(String varName, RenderedImage image) {
        try {
            this.doSetSourceImage(varName, image, null);
        }
        catch (WorldNotSetException worldNotSetException) {
            // empty catch block
        }
    }

    @Override
    public void setSourceImage(String varName, RenderedImage image, CoordinateTransform tr) throws JiffleException {
        try {
            this.doSetSourceImage(varName, image, tr);
        }
        catch (WorldNotSetException ex) {
            throw new JiffleException(String.format("Setting a coordinate tranform for a source (%s) withouthaving first set the world bounds and resolution", varName));
        }
    }

    private void doSetSourceImage(String varName, RenderedImage image, CoordinateTransform tr) throws WorldNotSetException {
        SourceImage sourceImage = new SourceImage(varName, image);
        boolean defaultTransform = tr == null;
        CoordinateTransform tt = defaultTransform ? this._defaultTransform : tr;
        sourceImage.setTransform(tt, defaultTransform);
        this._images.put(varName, sourceImage);
        this._imageScopeVarsInitialized = false;
    }

    @Override
    public Map<String, RenderedImage> get_images() {
        HashMap<String, RenderedImage> copy = new HashMap<String, RenderedImage>();
        for (SourceImage sourceImage : this._images.values()) {
            copy.put(sourceImage.imageName, sourceImage.image);
        }
        return copy;
    }

    @Override
    public void setSourceImageBandTransform(String varName, BandTransform btr) throws JiffleException {
        SourceImage image = this._images.get(varName);
        if (image == null) {
            throw new JiffleException("Unknown source image " + varName);
        }
        image.bandTransform = btr;
    }

    @Override
    public void setSourceImageCoordinateTransform(String varName, CoordinateTransform tr) throws JiffleException {
        SourceImage image = this._images.get(varName);
        if (image == null) {
            throw new JiffleException("Unknown source image " + varName);
        }
        image.setTransform(tr, tr == null);
    }

    protected int getBands(String imageName) {
        return this._images.get((Object)imageName).image.getSampleModel().getNumBands();
    }

    protected void checkLoopIterations() {
        ++this._iterations;
        if (this._maxIterations >= 0L && this._iterations > this._maxIterations) {
            throw new JiffleRuntimeException("Exceeded maximum allowed loop iterations per pixel");
        }
    }

    public abstract void setDefaultBounds();

    protected class SourceImage {
        final String imageName;
        final RenderedImage image;
        final RandomIter roiIterator;
        final Range noDataRange;
        BandTransform bandTransform;
        CoordinateTransform transform;
        boolean defaultTransform;
        final RandomIter iterator;
        final int minX;
        final int maxX;
        final int minY;
        final int maxY;

        public SourceImage(String imageName, RenderedImage image) {
            this.imageName = imageName;
            this.image = image;
            this.minX = image.getMinX();
            this.maxX = image.getMinX() + image.getWidth();
            this.minY = image.getMinY();
            this.maxY = image.getMinY() + image.getHeight();
            this.iterator = RandomIterFactory.create((RenderedImage)image, null, (boolean)true, (boolean)true);
            Object property = image.getProperty("ROI");
            if (property instanceof ROI) {
                ROI roi = (ROI)property;
                PlanarImage roiImage = roi.getAsImage();
                this.roiIterator = RandomIterFactory.create((RenderedImage)roiImage, null, (boolean)true, (boolean)true);
            } else {
                this.roiIterator = null;
            }
            Object noDataProperty = image.getProperty("GC_NODATA");
            if (noDataProperty instanceof NoDataContainer) {
                NoDataContainer noData = (NoDataContainer)noDataProperty;
                Range range = noData.getAsRange();
                if (range == null && noData.getAsArray() != null && noData.getAsArray().length > 0) {
                    double noDataValue = noData.getAsArray()[0];
                    range = RangeFactory.create((double)noDataValue, (boolean)true, (double)noDataValue, (boolean)true, (boolean)true);
                } else {
                    double noDataValue = noData.getAsSingleValue();
                    range = RangeFactory.create((double)noDataValue, (boolean)true, (double)noDataValue, (boolean)true, (boolean)true);
                }
                this.noDataRange = range;
            } else {
                this.noDataRange = null;
            }
        }

        public double read(double x, double y, int band) {
            boolean inside;
            int posx = (int)x;
            int posy = (int)y;
            if (this.transform != null && !(this.transform instanceof IdentityCoordinateTransform)) {
                Point imgPos = this.transform.worldToImage(x, y, null);
                posx = imgPos.x;
                posy = imgPos.y;
            }
            boolean bl = inside = posx >= this.minX && posx < this.maxX && posy >= this.minY && posy < this.maxY;
            if (!inside) {
                if (AbstractJiffleRuntime.this._outsideValueSet) {
                    return AbstractJiffleRuntime.this._outsideValue;
                }
                throw new JiffleRuntimeException(String.format("Position %.4f %.4f is outside bounds of image: %s", x, y, this.imageName));
            }
            if (this.bandTransform != null) {
                band = this.bandTransform.scriptToImage(x, y, band);
            }
            if (this.roiIterator != null && (this.roiIterator.getSample(posx, posy, 0) & 0xFF) == 0) {
                return Double.NaN;
            }
            double result = this.iterator.getSampleDouble(posx, posy, band);
            if (this.noDataRange != null && this.noDataRange.contains(result)) {
                return Double.NaN;
            }
            return result;
        }

        public void setTransform(CoordinateTransform transform, boolean defaultTransform) throws WorldNotSetException {
            if (transform != null && !AbstractJiffleRuntime.this.isWorldSet()) {
                throw new WorldNotSetException();
            }
            this.transform = transform;
            this.defaultTransform = defaultTransform;
        }
    }

    private static enum Dim {
        XDIM,
        YDIM;

    }
}

