/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffleop;

import it.geosolutions.jaiext.jiffle.runtime.BandTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.JiffleIndirectRuntime;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public class JiffleOpImage
extends OpImage {
    private final JiffleIndirectRuntime runtime;
    private final int band = 0;

    public JiffleOpImage(Map<String, ImageSpecification> sourceImages, ImageLayout layout, Map configuration, JiffleIndirectRuntime runtime, String destVarName) {
        super(JiffleOpImage.specsToImages(sourceImages), layout, configuration, false);
        this.runtime = runtime;
        this.setProperty("GC_NODATA", new NoDataContainer(Double.NaN));
    }

    private static Vector specsToImages(Map<String, ImageSpecification> sourceImages) {
        return new Vector(sourceImages.values().stream().map(is -> is.image).collect(Collectors.toList()));
    }

    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        return null;
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        return this.getSourceImage(sourceIndex).getBounds();
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        int destBands = dest.getNumBands();
        double[] pixel = new double[destBands];
        int y = destRect.y;
        for (int iy = 0; iy < destRect.height; ++iy) {
            int x = destRect.x;
            for (int ix = 0; ix < destRect.width; ++ix) {
                Arrays.fill(pixel, Double.NaN);
                this.runtime.evaluate((double)x, (double)y, pixel);
                dest.setPixel(x, y, pixel);
                ++x;
            }
            ++y;
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        super.computeRect(sources, dest, destRect);
    }

    public Raster computeTile(int tileX, int tileY) {
        return super.computeTile(tileX, tileY);
    }

    static class ImageSpecification {
        RenderedImage image;
        CoordinateTransform coordinateTransform;
        BandTransform bandTransform;
        Range nodata;

        public ImageSpecification(RenderedImage image, CoordinateTransform coordinateTransform, BandTransform bandTransform) {
            this(image, coordinateTransform, bandTransform, null);
        }

        public ImageSpecification(RenderedImage image, CoordinateTransform coordinateTransform, BandTransform bandTransform, Range nodata) {
            this.image = image;
            this.coordinateTransform = coordinateTransform;
            this.bandTransform = bandTransform;
            this.nodata = nodata;
        }
    }
}

