/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffleop;

import it.geosolutions.jaiext.jiffle.runtime.BandTransform;
import it.geosolutions.jaiext.jiffleop.JiffleDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.junit.Assert;
import org.junit.Test;

public class JiffleOpTest
extends TestBase {
    @Test
    public void testCopyDefaults() {
        RenderedImage src = this.buildTestImage(10, 10);
        RenderedOp op = JiffleDescriptor.create((RenderedImage[])new RenderedImage[]{src}, null, null, (String)"dest = src;", null, null, null, null, null);
        this.assertCopy(src, op, 5);
    }

    @Test
    public void testCopyRemappedDefaults() {
        RenderedImage src = this.buildTestImage(10, 10);
        BandTransform transform = (x, y, b) -> 0;
        RenderedOp op = JiffleDescriptor.create((RenderedImage[])new RenderedImage[]{src}, null, null, (String)"dest = src[10];", null, null, null, (BandTransform[])new BandTransform[]{transform}, null);
        this.assertCopy(src, op, 5);
    }

    @Test
    public void testCopyNonDefaults() {
        RenderedImage src = this.buildTestImage(10, 10);
        RenderedOp op = JiffleDescriptor.create((RenderedImage[])new RenderedImage[]{src}, (String[])new String[]{"a"}, (String)"b", (String)"b = a;", null, (Integer)0, null, null, null);
        this.assertCopy(src, op, 0);
    }

    @Test
    public void testSum() {
        RenderedImage src1 = this.buildTestImage(10, 10);
        RenderedImage src2 = this.buildTestImage(10, 10);
        RenderedOp op = JiffleDescriptor.create((RenderedImage[])new RenderedImage[]{src1, src2}, (String[])new String[]{"a", "b"}, (String)"res", (String)"res = a + b;", null, (Integer)3, null, null, null);
        Assert.assertEquals((long)src1.getMinX(), (long)op.getMinX());
        Assert.assertEquals((long)src1.getWidth(), (long)op.getWidth());
        Assert.assertEquals((long)src1.getMinY(), (long)op.getMinY());
        Assert.assertEquals((long)src1.getHeight(), (long)op.getHeight());
        Assert.assertEquals((long)3L, (long)op.getSampleModel().getDataType());
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)src1, null);
        RandomIter opIter = RandomIterFactory.create((RenderedImage)op, null);
        for (int y = src1.getMinY(); y < src1.getMinY() + src1.getHeight(); ++y) {
            for (int x = src1.getMinX(); x < src1.getMinX() + src1.getWidth(); ++x) {
                double expected = srcIter.getSampleDouble(x, y, 0) * 2.0;
                double actual = opIter.getSampleDouble(x, y, 0);
                Assert.assertEquals((double)expected, (double)actual, (double)0.0);
            }
        }
    }

    private void assertCopy(RenderedImage src, RenderedOp op, int dataType) {
        Assert.assertEquals((long)src.getMinX(), (long)op.getMinX());
        Assert.assertEquals((long)src.getWidth(), (long)op.getWidth());
        Assert.assertEquals((long)src.getMinY(), (long)op.getMinY());
        Assert.assertEquals((long)src.getHeight(), (long)op.getHeight());
        Assert.assertEquals((long)dataType, (long)op.getSampleModel().getDataType());
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)src, null);
        RandomIter opIter = RandomIterFactory.create((RenderedImage)op, null);
        for (int y = src.getMinY(); y < src.getMinY() + src.getHeight(); ++y) {
            for (int x = src.getMinX(); x < src.getMinX() + src.getWidth(); ++x) {
                double expected = srcIter.getSampleDouble(x, y, 0);
                double actual = opIter.getSampleDouble(x, y, 0);
                Assert.assertEquals((double)expected, (double)actual, (double)0.0);
            }
        }
    }

    private RenderedImage buildTestImage(int width, int height) {
        Number[] values = new Number[width * height];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (byte)i;
        }
        return ImageUtilities.createImageFromArray((Number[])values, (int)width, (int)height);
    }
}

