/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.mosaic.MosaicDescriptor;
import it.geosolutions.jaiext.mosaic.MosaicOpImage;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.TranslateDescriptor;
import javax.media.jai.util.ImagingException;
import org.junit.Assert;
import org.junit.Test;

public class MosaicTest
extends TestBase {
    public static final boolean DEFAULT_SETUP_INITALIZATION = false;
    private static final MosaicType DEFAULT_MOSAIC_TYPE = javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY;
    public static final float DEFAULT_WIDTH = 512.0f;
    public static final float DEFAULT_HEIGTH = 512.0f;
    public static final Logger LOGGER = Logger.getLogger(MosaicTest.class.toString());
    public static final double DEFAULT_DELTA = 1.5;
    private static RenderingHints hints;

    @Test
    public void testByteNoData1NoData2() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean(dataType, 0, false, false);
        this.testMethodBody(testBean, dataType, null);
    }

    @Test
    public void testUShortNoData1NoData2() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean(dataType, 0, false, false);
        this.testMethodBody(testBean, dataType, null);
    }

    @Test
    public void testShortNoData1NoData2() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean(dataType, 0, false, false);
        this.testMethodBody(testBean, dataType, null);
    }

    @Test
    public void testIntNoData1NoData2() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean(dataType, 0, false, false);
        this.testMethodBody(testBean, dataType, null);
    }

    @Test
    public void testFloatNoData1NoData2() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean(dataType, 0, false, false);
        this.testMethodBody(testBean, dataType, null);
    }

    @Test
    public void testDoubleNoData1NoData2() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean(dataType, 0, false, false);
        this.testMethodBody(testBean, dataType, null);
    }

    @Test
    public void testByteNoData1Data2() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource2);
    }

    @Test
    public void testUShortNoData1Data2() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource2);
    }

    @Test
    public void testShortNoData1Data2() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource2);
    }

    @Test
    public void testIntNoData1Data2() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource2);
    }

    @Test
    public void testFloatNoData1Data2() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource2);
    }

    @Test
    public void testDoubleNoData1Data2() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource2);
    }

    @Test
    public void testByteData1Data2() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        this.testMethodBody(testBean, dataType, valideValueSource1);
    }

    @Test
    public void testUShortData1Data2() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        this.testMethodBody(testBean, dataType, valideValueSource1);
    }

    @Test
    public void testShortData1Data2() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        this.testMethodBody(testBean, dataType, valideValueSource1);
    }

    @Test
    public void testIntData1Data2() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        this.testMethodBody(testBean, dataType, valideValueSource1);
    }

    @Test
    public void testFloatData1Data2() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        this.testMethodBody(testBean, dataType, valideValueSource1);
    }

    @Test
    public void testDoubleData1Data2() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        this.testMethodBody(testBean, dataType, valideValueSource1);
    }

    @Test
    public void testROIByteData1Data2() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean(dataType, 2, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource1, true, false);
    }

    @Test
    public void testROIUShortData1Data2() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean(dataType, 2, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource1, true, false);
    }

    @Test
    public void testROIShortData1Data2() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean(dataType, 2, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource1, true, false);
    }

    @Test
    public void testROIIntData1Data2() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean(dataType, 2, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource1, true, false);
    }

    @Test
    public void testROIFloatData1Data2() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean(dataType, 2, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource1, true, false);
    }

    @Test
    public void testROIDoubleData1Data2() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean(dataType, 2, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource1, true, false);
    }

    @Test
    public void testROIByteNoData1Data2() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean(dataType, 1, true, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, true, false);
    }

    @Test
    public void testROIUShortNoData1Data2() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean(dataType, 1, true, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, true, false);
    }

    @Test
    public void testROIShortNoData1Data2() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean(dataType, 1, true, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, true, false);
    }

    @Test
    public void testROIIntNoData1Data2() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean(dataType, 1, true, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, true, false);
    }

    @Test
    public void testROIFloatNoData1Data2() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean(dataType, 1, true, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, true, false);
    }

    @Test
    public void testROIDoubleNoData1Data2() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean(dataType, 1, true, false);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, true, false);
    }

    @Test
    public void testAlphaByteData1Data2() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, true);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaUShortData1Data2() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, true);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaShortData1Data2() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, true);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaIntData1Data2() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, true);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaFloatData1Data2() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, true);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaDoubleData1Data2() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean(dataType, 2, false, true);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaNoByteData1Data2() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaNoUShortData1Data2() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaNoShortData1Data2() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaIntNoData1Data2() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaFloatNoData1Data2() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, false, true);
    }

    @Test
    public void testAlphaDoubleNoData1Data2() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean(dataType, 1, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, valideValueSource2, false, true);
    }

    @Test
    public void testByte3ImagesNoDataROIAlpha() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, true);
    }

    @Test
    public void testUShort3ImagesNoDataROIAlpha() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, true);
    }

    @Test
    public void testShort3ImagesNoDataROIAlpha() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, true);
    }

    @Test
    public void testInt3ImagesNoDataROIAlpha() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, true);
    }

    @Test
    public void testFloat3ImagesNoDataROIAlpha() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, true);
    }

    @Test
    public void testDouble3ImagesNoDataROIAlpha() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, true);
    }

    @Test
    public void testBLENDByte3Images() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, false);
    }

    @Test
    public void testBLENDUShort3Images() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, false);
    }

    @Test
    public void testBLENDShort3Images() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, false);
    }

    @Test
    public void testBLENDInt3Images() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, false);
    }

    @Test
    public void testBLENDFloat3Images() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, false);
    }

    @Test
    public void testBLENDDouble3Images() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean3Images(dataType, false, true);
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, null, valideValueSource2, null, valideValueSource3, valideValueSource2, valideValueSource3, false, false, false);
    }

    @Test
    public void testByteNullNoData() {
        int dataType = 0;
        TestBean testBean = MosaicTest.createBean3Images(dataType, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, valideValueSource1, valideValueSource1, valideValueSource3, false, false, true);
    }

    @Test
    public void testUShortNullNoData() {
        int dataType = 1;
        TestBean testBean = MosaicTest.createBean3Images(dataType, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, valideValueSource1, valideValueSource1, valideValueSource3, false, false, true);
    }

    @Test
    public void testShortNullNoData() {
        int dataType = 2;
        TestBean testBean = MosaicTest.createBean3Images(dataType, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, valideValueSource1, valideValueSource1, valideValueSource3, false, false, true);
    }

    @Test
    public void testIntNullNoData() {
        int dataType = 3;
        TestBean testBean = MosaicTest.createBean3Images(dataType, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, valideValueSource1, valideValueSource1, valideValueSource3, false, false, true);
    }

    @Test
    public void testFloatNullNoData() {
        int dataType = 4;
        TestBean testBean = MosaicTest.createBean3Images(dataType, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, valideValueSource1, valideValueSource1, valideValueSource3, false, false, true);
    }

    @Test
    public void testDoubleNullNoData() {
        int dataType = 5;
        TestBean testBean = MosaicTest.createBean3Images(dataType, true, false);
        Number valideValueSource1 = testBean.getSourceValidData()[0];
        Number valideValueSource2 = testBean.getSourceValidData()[1];
        Number valideValueSource3 = testBean.getSourceValidData()[2];
        this.testMethodBody(testBean, dataType, valideValueSource1, valideValueSource1, valideValueSource2, valideValueSource1, valideValueSource1, valideValueSource3, false, false, true);
    }

    @Test
    public void testExceptionImagesLayoutNotValid() {
        TestBean testBean = MosaicTest.createBean3Images(0, true, false);
        RenderedImage[] mosaicArray = new RenderedImage[3];
        double[] destinationValues = new double[]{testBean.getDestinationNoData()[0]};
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        Range[] nd = testBean.getSourceNoDataRange3Bands();
        mosaicArray = new RenderedImage[]{};
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, null);
        boolean exception = false;
        try {
            image5.getTile(0, 0);
        }
        catch (ImagingException e) {
            LOGGER.log(Level.INFO, "IllegalArgumentException: Layout not valid");
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Layout not valid"));
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testExceptionImagesNoSampleModelPresent() {
        ImageLayout layout = new ImageLayout();
        layout.setValid(4);
        layout.setValid(8);
        layout.setValid(256);
        layout.setWidth(4);
        layout.setHeight(4);
        TestBean testBean = MosaicTest.createBean3Images(0, true, false);
        RenderedImage[] mosaicArray = new RenderedImage[3];
        double[] destinationValues = new double[]{testBean.getDestinationNoData()[0]};
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        Range[] nd = testBean.getSourceNoDataRange3Bands();
        mosaicArray = new RenderedImage[]{};
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)renderingHints);
        boolean exception = false;
        try {
            image5.getTile(0, 0);
        }
        catch (ImagingException e) {
            LOGGER.log(Level.INFO, "No sample model present");
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("No sample model present"));
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testExceptionImagesSameSampleSize() {
        TestBean testBean = MosaicTest.createBean3Images(0, true, false);
        RenderedImage[] mosaicArray = new RenderedImage[3];
        double[] destinationValues = new double[]{testBean.getDestinationNoData()[0]};
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        Range[] nd = testBean.getSourceNoDataRange3Bands();
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        int width = 15;
        int heigth = 15;
        layout.setSampleModel(new SampleModel(3, width, heigth, 2){

            public void setSample(int x, int y, int b, int s, DataBuffer data) {
            }

            public void setDataElements(int x, int y, Object obj, DataBuffer data) {
            }

            public int getSampleSize(int band) {
                if (band == 0) {
                    return 1;
                }
                if (band == 1) {
                    return 2;
                }
                return 0;
            }

            public int[] getSampleSize() {
                return new int[]{1, 2};
            }

            public int getSample(int x, int y, int b, DataBuffer data) {
                return 0;
            }

            public int getNumDataElements() {
                return 0;
            }

            public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
                return null;
            }

            public SampleModel createSubsetSampleModel(int[] bands) {
                return null;
            }

            public DataBuffer createDataBuffer() {
                return null;
            }

            public SampleModel createCompatibleSampleModel(int w, int h) {
                return null;
            }
        });
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        mosaicArray = new RenderedImage[]{};
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)renderingHints);
        boolean exception = false;
        try {
            image5.getTile(0, 0);
        }
        catch (ImagingException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Sample size is not the same for every band"));
            LOGGER.log(Level.INFO, "Sample size is not the same for every band");
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testExceptionImagesSameBandNum() {
        TestBean testBean = MosaicTest.createBean3Images(0, true, false);
        RenderedImage[] mosaicArray = new RenderedImage[2];
        double[] destinationValues = new double[]{testBean.getDestinationNoData()[0]};
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        Range[] nd = testBean.getSourceNoDataRange3Bands();
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        Number[] exampleData = new Number[]{15, 15};
        mosaicArray[0] = MosaicTest.getSyntheticUniformTypeImage(exampleData, null, 3, 3, DataDisplacement.DATA_DATA, true, false);
        mosaicArray[1] = MosaicTest.getSyntheticUniformTypeImage(exampleData, null, 3, 1, DataDisplacement.DATA_DATA, false, false);
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)renderingHints);
        boolean exception = false;
        try {
            image5.getTile(0, 0);
        }
        catch (ImagingException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Bands number is not the same for every source"));
            LOGGER.log(Level.INFO, "Bands number is not the same for every source");
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testExceptionImagesSameSizeSourcesAndNoData() {
        TestBean testBean = MosaicTest.createBean3Images(0, true, false);
        RenderedImage[] mosaicArray = new RenderedImage[2];
        double[] destinationValues = new double[]{testBean.getDestinationNoData()[0]};
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        Number[] exampleData = new Number[]{15, 15};
        mosaicArray[0] = MosaicTest.getSyntheticUniformTypeImage(exampleData, null, 3, 1, DataDisplacement.DATA_DATA, true, false);
        mosaicArray[1] = MosaicTest.getSyntheticUniformTypeImage(exampleData, null, 3, 1, DataDisplacement.DATA_DATA, false, false);
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        Range[] nd = new Range[10];
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)renderingHints);
        boolean exception = false;
        try {
            image5.getTile(0, 0);
        }
        catch (ImagingException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("no data number is not equal to the source number"));
            LOGGER.log(Level.INFO, "no data number is not equal to the source number");
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testExceptionImagesAlphaBandUnic() {
        PlanarImage newAlphaChannel;
        TestBean testBean = MosaicTest.createBean3Images(0, true, false);
        RenderedImage[] mosaicArray = testBean.getImage3Bands();
        double[] destinationValues = new double[]{testBean.getDestinationNoData()[0]};
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        PlanarImage[] alphas = new PlanarImage[3];
        ROI[] rois = testBean.getRois();
        Range[] nd = testBean.getSourceNoDataRange3Bands();
        Number[] exampleData = new Number[]{15};
        alphas[1] = alphas[2] = (newAlphaChannel = (PlanarImage)MosaicTest.getSyntheticUniformTypeImage(exampleData, null, 3, 3, DataDisplacement.DATA_DATA, true, false));
        alphas[0] = alphas[2];
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)renderingHints);
        boolean exception = false;
        try {
            image5.getTile(0, 0);
        }
        catch (ImagingException e) {
            Assert.assertTrue((boolean)e.getRootCause().getMessage().contains("Alpha bands number must be 1"));
            LOGGER.log(Level.INFO, "Alpha bands number must be 1");
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionImagesMapDestRectNullDest() {
        int index = 1;
        this.exceptionMapRectBody(null, index, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionImagesMapDestRectZeroIndex() {
        Rectangle testRect = new Rectangle(0, 0, 10, 10);
        int index = -1;
        this.exceptionMapRectBody(testRect, index, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionImagesMapDestRectOverIndex() {
        Rectangle testRect = new Rectangle(0, 0, 10, 10);
        int index = 10;
        this.exceptionMapRectBody(testRect, index, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionImagesMapSourceRectNullSource() {
        int index = 1;
        this.exceptionMapRectBody(null, index, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionImagesMapSourceRectZeroIndex() {
        Rectangle testRect = new Rectangle(0, 0, 10, 10);
        int index = -1;
        this.exceptionMapRectBody(testRect, index, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionImagesMapSourceRectOverIndex() {
        Rectangle testRect = new Rectangle(0, 0, 10, 10);
        int index = 10;
        this.exceptionMapRectBody(testRect, index, true);
    }

    private void exceptionMapRectBody(Rectangle testRect, int index, boolean sourceRect) {
        TestBean testBean = MosaicTest.createBean3Images(0, true, true);
        RenderedImage[] mosaicArray = testBean.getImage3Bands();
        Range[] nd = testBean.getSourceNoDataRange3Bands();
        Vector<RenderedImage> mosaicList = new Vector<RenderedImage>();
        for (int i = 0; i < mosaicArray.length; ++i) {
            mosaicList.add(mosaicArray[i]);
        }
        double[] destinationValues = new double[]{testBean.getDestinationNoData()[0]};
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        if (sourceRect) {
            Rectangle rect = new MosaicOpImage(mosaicList, layout, (Map)renderingHints, DEFAULT_MOSAIC_TYPE, alphas, rois, (double[][])null, destinationValues, nd).mapSourceRect(testRect, index);
        } else {
            Rectangle rect = new MosaicOpImage(mosaicList, layout, (Map)renderingHints, DEFAULT_MOSAIC_TYPE, alphas, rois, (double[][])null, destinationValues, nd).mapDestRect(testRect, index);
        }
    }

    private void testMethodBody(TestBean testBean, int dataType, Number firstValue) {
        this.testMethodBody(testBean, dataType, firstValue, null, null, null, null, null, false, false, false);
    }

    private void testMethodBody(TestBean testBean, int dataType, Number firstValue, Number secondValue, Number thirdValue, boolean roiused, boolean alphaused) {
        this.testMethodBody(testBean, dataType, firstValue, secondValue, thirdValue, null, null, null, roiused, alphaused, false);
    }

    private void testMethodBody(TestBean testBean, int dataType, Number firstValue, Number secondValue, Number thirdValue, Number fourthValue, Number fifthValue, Number sixthValue, boolean roiused, boolean alphaused, boolean overlay) {
        Number[][] arrayPixel = null;
        Number[][] arrayPixel3Band = null;
        if (fourthValue == null) {
            Number[][] arrayPixelArr = new Number[][]{this.testExecution(testBean, 1)};
            Number[][] arrayPixel3BandArr = new Number[][]{this.testExecution(testBean, 3)};
            arrayPixel = arrayPixelArr;
            arrayPixel3Band = arrayPixel3BandArr;
        }
        if (firstValue == null && secondValue == null) {
            this.assertEquality(0, arrayPixel, dataType, testBean.getDestinationNoData()[0]);
            this.assertEquality(0, arrayPixel3Band, dataType, testBean.getDestinationNoData()[0]);
            this.assertEquality(1, arrayPixel3Band, dataType, testBean.getDestinationNoData()[1]);
            this.assertEquality(2, arrayPixel3Band, dataType, testBean.getDestinationNoData()[2]);
        } else if (fourthValue != null) {
            arrayPixel = this.testExecution3Image(testBean, 1, overlay);
            arrayPixel3Band = this.testExecution3Image(testBean, 3, overlay);
            if (!overlay) {
                double centerValue = (secondValue.doubleValue() + sixthValue.doubleValue()) / 2.0;
                if (dataType < 4) {
                    centerValue += 1.0;
                }
                fifthValue = centerValue;
            }
            if (firstValue == null && thirdValue == null) {
                this.assertEquality(0, arrayPixel, dataType, testBean.getDestinationNoData()[0], secondValue, testBean.getDestinationNoData()[0], fourthValue, fifthValue, sixthValue);
                this.assertEquality(0, arrayPixel3Band, dataType, testBean.getDestinationNoData()[0], secondValue, testBean.getDestinationNoData()[0], fourthValue, fifthValue, sixthValue);
                this.assertEquality(1, arrayPixel3Band, dataType, testBean.getDestinationNoData()[1], secondValue, testBean.getDestinationNoData()[1], fourthValue, fifthValue, sixthValue);
                this.assertEquality(2, arrayPixel3Band, dataType, testBean.getDestinationNoData()[2], secondValue, testBean.getDestinationNoData()[2], fourthValue, fifthValue, sixthValue);
            } else {
                this.assertEquality(0, arrayPixel, dataType, firstValue, secondValue, thirdValue, fourthValue, fifthValue, sixthValue);
                this.assertEquality(0, arrayPixel3Band, dataType, firstValue, secondValue, thirdValue, fourthValue, fifthValue, sixthValue);
                this.assertEquality(1, arrayPixel3Band, dataType, firstValue, secondValue, thirdValue, fourthValue, fifthValue, sixthValue);
                this.assertEquality(2, arrayPixel3Band, dataType, firstValue, secondValue, thirdValue, fourthValue, fifthValue, sixthValue);
            }
        } else if (secondValue != null) {
            if (roiused) {
                arrayPixel = this.testExecutionROI(testBean, 1);
                arrayPixel3Band = this.testExecutionROI(testBean, 3);
            } else if (alphaused) {
                arrayPixel = this.testExecutionAlpha(testBean, 1);
                arrayPixel3Band = this.testExecutionAlpha(testBean, 3);
            }
            if (firstValue == null) {
                this.assertEquality(0, arrayPixel, dataType, testBean.getDestinationNoData()[0], secondValue, thirdValue);
                this.assertEquality(0, arrayPixel3Band, dataType, testBean.getDestinationNoData()[0], secondValue, thirdValue);
                this.assertEquality(1, arrayPixel3Band, dataType, testBean.getDestinationNoData()[0], secondValue, thirdValue);
                this.assertEquality(2, arrayPixel3Band, dataType, testBean.getDestinationNoData()[0], secondValue, thirdValue);
            } else {
                this.assertEquality(0, arrayPixel, dataType, firstValue, secondValue, thirdValue);
                this.assertEquality(0, arrayPixel3Band, dataType, firstValue, secondValue, thirdValue);
                this.assertEquality(1, arrayPixel3Band, dataType, firstValue, secondValue, thirdValue);
                this.assertEquality(2, arrayPixel3Band, dataType, firstValue, secondValue, thirdValue);
            }
        } else {
            this.assertEquality(0, arrayPixel, dataType, firstValue);
            this.assertEquality(0, arrayPixel3Band, dataType, firstValue);
            this.assertEquality(1, arrayPixel3Band, dataType, firstValue);
            this.assertEquality(2, arrayPixel3Band, dataType, firstValue);
        }
    }

    private void assertEquality(int bandIndex, Number[][] arrayPixel, int dataType, Number firstValue) {
        this.assertEquality(bandIndex, arrayPixel, dataType, firstValue, null, null, null, null, null);
    }

    private void assertEquality(int bandIndex, Number[][] arrayPixel, int dataType, Number firstValue, Number secondValue, Number thirdValue) {
        this.assertEquality(bandIndex, arrayPixel, dataType, firstValue, secondValue, thirdValue, null, null, null);
    }

    private void assertEquality(int bandIndex, Number[][] arrayPixel, int dataType, Number firstValue, Number secondValue, Number thirdValue, Number fourthValue, Number fifthValue, Number sixthValue) {
        switch (dataType) {
            case 0: {
                if (bandIndex > 0 && secondValue == null) {
                    Assert.assertEquals((long)firstValue.byteValue(), (long)arrayPixel[0][bandIndex].byteValue());
                } else {
                    Assert.assertEquals((long)firstValue.byteValue(), (long)arrayPixel[bandIndex][0].byteValue());
                }
                if (secondValue != null) {
                    Assert.assertEquals((long)secondValue.byteValue(), (long)arrayPixel[bandIndex][1].byteValue());
                    Assert.assertEquals((long)thirdValue.byteValue(), (long)arrayPixel[bandIndex][2].byteValue());
                }
                if (fourthValue == null) break;
                Assert.assertEquals((long)fourthValue.byteValue(), (long)arrayPixel[bandIndex][3].byteValue());
                Assert.assertEquals((long)fifthValue.byteValue(), (long)arrayPixel[bandIndex][4].byteValue());
                Assert.assertEquals((long)sixthValue.byteValue(), (long)arrayPixel[bandIndex][5].byteValue());
                break;
            }
            case 1: 
            case 2: {
                if (bandIndex > 0 && secondValue == null) {
                    Assert.assertEquals((long)firstValue.shortValue(), (long)arrayPixel[0][bandIndex].shortValue());
                } else {
                    Assert.assertEquals((long)firstValue.shortValue(), (long)arrayPixel[bandIndex][0].shortValue());
                }
                if (secondValue != null) {
                    Assert.assertEquals((long)secondValue.shortValue(), (long)arrayPixel[bandIndex][1].shortValue());
                    Assert.assertEquals((long)thirdValue.shortValue(), (long)arrayPixel[bandIndex][2].shortValue());
                }
                if (fourthValue == null) break;
                Assert.assertEquals((long)fourthValue.shortValue(), (long)arrayPixel[bandIndex][3].shortValue());
                Assert.assertEquals((long)fifthValue.shortValue(), (long)arrayPixel[bandIndex][4].shortValue());
                Assert.assertEquals((long)sixthValue.shortValue(), (long)arrayPixel[bandIndex][5].shortValue());
                break;
            }
            case 3: {
                if (bandIndex > 0 && secondValue == null) {
                    Assert.assertEquals((long)firstValue.intValue(), (long)arrayPixel[0][bandIndex].intValue());
                } else {
                    Assert.assertEquals((long)firstValue.intValue(), (long)arrayPixel[bandIndex][0].intValue());
                }
                if (secondValue != null) {
                    Assert.assertEquals((long)secondValue.intValue(), (long)arrayPixel[bandIndex][1].intValue());
                    Assert.assertEquals((long)thirdValue.intValue(), (long)arrayPixel[bandIndex][2].intValue());
                }
                if (fourthValue == null) break;
                Assert.assertEquals((long)fourthValue.intValue(), (long)arrayPixel[bandIndex][3].intValue());
                Assert.assertEquals((long)fifthValue.intValue(), (long)arrayPixel[bandIndex][4].intValue());
                Assert.assertEquals((long)sixthValue.intValue(), (long)arrayPixel[bandIndex][5].intValue());
                break;
            }
            case 4: {
                if (bandIndex > 0 && secondValue == null) {
                    Assert.assertEquals((double)firstValue.floatValue(), (double)arrayPixel[0][bandIndex].floatValue(), (double)1.5);
                } else {
                    Assert.assertEquals((double)firstValue.floatValue(), (double)arrayPixel[bandIndex][0].floatValue(), (double)1.5);
                }
                if (secondValue != null) {
                    Assert.assertEquals((double)secondValue.floatValue(), (double)arrayPixel[bandIndex][1].floatValue(), (double)1.5);
                    Assert.assertEquals((double)thirdValue.floatValue(), (double)arrayPixel[bandIndex][2].floatValue(), (double)1.5);
                }
                if (fourthValue == null) break;
                Assert.assertEquals((double)fourthValue.floatValue(), (double)arrayPixel[bandIndex][3].floatValue(), (double)1.5);
                Assert.assertEquals((double)fifthValue.floatValue(), (double)arrayPixel[bandIndex][4].floatValue(), (double)1.5);
                Assert.assertEquals((double)sixthValue.floatValue(), (double)arrayPixel[bandIndex][5].floatValue(), (double)1.5);
                break;
            }
            case 5: {
                if (bandIndex > 0 && secondValue == null) {
                    Assert.assertEquals((double)firstValue.doubleValue(), (double)arrayPixel[0][bandIndex].doubleValue(), (double)1.5);
                } else {
                    Assert.assertEquals((double)firstValue.doubleValue(), (double)arrayPixel[bandIndex][0].doubleValue(), (double)1.5);
                }
                if (secondValue != null) {
                    Assert.assertEquals((double)secondValue.doubleValue(), (double)arrayPixel[bandIndex][1].doubleValue(), (double)1.5);
                    Assert.assertEquals((double)thirdValue.doubleValue(), (double)arrayPixel[bandIndex][2].doubleValue(), (double)1.5);
                }
                if (fourthValue == null) break;
                Assert.assertEquals((double)fourthValue.doubleValue(), (double)arrayPixel[bandIndex][3].doubleValue(), (double)1.5);
                Assert.assertEquals((double)fifthValue.doubleValue(), (double)arrayPixel[bandIndex][4].doubleValue(), (double)1.5);
                Assert.assertEquals((double)sixthValue.doubleValue(), (double)arrayPixel[bandIndex][5].doubleValue(), (double)1.5);
                break;
            }
        }
    }

    private static TestBean imageSettings3Images(Number[] validData, Number[] sourceNodata, double[] destinationNoDataValue, int dataType, boolean roiAlphaNotNull, boolean nullNoData) {
        int j;
        if (dataType == 4 && !nullNoData) {
            for (j = 0; j < sourceNodata.length; ++j) {
                sourceNodata[j] = Float.valueOf(Float.NaN);
            }
        } else if (dataType == 5 && !nullNoData) {
            for (j = 0; j < sourceNodata.length; ++j) {
                sourceNodata[j] = Double.NaN;
            }
        }
        TestBean tempMosaicBean = new TestBean();
        RenderedImage image1 = null;
        RenderedImage image3Band1 = null;
        if (sourceNodata[0] == null) {
            image1 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 1, DataDisplacement.DATA_DATA, true, false);
            image3Band1 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 3, DataDisplacement.DATA_DATA, true, false);
        } else {
            image1 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 1, DataDisplacement.NODATA_DATA, true, false);
            image3Band1 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 3, DataDisplacement.NODATA_DATA, true, false);
        }
        RenderedImage image2 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 1, DataDisplacement.DATA_DATA, false, false);
        RenderedImage image3 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 1, DataDisplacement.DATA_DATA, false, true);
        RenderedImage image3Band2 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 3, DataDisplacement.DATA_DATA, false, false);
        RenderedImage image3Band3 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 3, DataDisplacement.DATA_DATA, false, true);
        RenderedImage[] array1Band = new RenderedImage[]{image1, image2, image3};
        RenderedImage[] array3Band = new RenderedImage[]{image3Band1, image3Band2, image3Band3};
        ImageLayout layout = new ImageLayout(0, 0, array1Band[0].getWidth() + array1Band[1].getWidth(), array1Band[0].getHeight() + array1Band[1].getHeight());
        layout.setTileHeight(array1Band[0].getHeight() / 16);
        layout.setTileWidth(array1Band[0].getWidth() / 16);
        hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        tempMosaicBean.setDestinationNoData(destinationNoDataValue);
        tempMosaicBean.setImage(array1Band);
        tempMosaicBean.setImage3Bands(array3Band);
        Range[] nd = new Range[array1Band.length];
        Range[] nd3Bands = new Range[array1Band.length];
        ROI[] rois = new ROI[array1Band.length];
        PlanarImage[] alphas = new PlanarImage[array1Band.length];
        for (int k = 0; k < array1Band.length; ++k) {
            if (sourceNodata[k] != null) {
                switch (dataType) {
                    case 0: {
                        nd[k] = RangeFactory.create((byte)sourceNodata[k].byteValue(), (boolean)true, (byte)sourceNodata[k].byteValue(), (boolean)true);
                        nd3Bands[k] = RangeFactory.create((byte)sourceNodata[k].byteValue(), (boolean)true, (byte)sourceNodata[k].byteValue(), (boolean)true);
                        break;
                    }
                    case 1: 
                    case 2: {
                        nd[k] = RangeFactory.createU((short)sourceNodata[k].shortValue(), (boolean)true, (short)sourceNodata[k].shortValue(), (boolean)true);
                        nd3Bands[k] = RangeFactory.createU((short)sourceNodata[k].shortValue(), (boolean)true, (short)sourceNodata[k].shortValue(), (boolean)true);
                        break;
                    }
                    case 3: {
                        nd[k] = RangeFactory.create((int)sourceNodata[k].intValue(), (boolean)true, (int)sourceNodata[k].intValue(), (boolean)true);
                        nd3Bands[k] = RangeFactory.create((int)sourceNodata[k].intValue(), (boolean)true, (int)sourceNodata[k].intValue(), (boolean)true);
                        break;
                    }
                    case 4: {
                        nd[k] = RangeFactory.create((float)sourceNodata[k].floatValue(), (boolean)true, (float)sourceNodata[k].floatValue(), (boolean)true, (boolean)true);
                        nd3Bands[k] = RangeFactory.create((float)sourceNodata[k].floatValue(), (boolean)true, (float)sourceNodata[k].floatValue(), (boolean)true, (boolean)true);
                        break;
                    }
                    case 5: {
                        nd[k] = RangeFactory.create((double)sourceNodata[k].doubleValue(), (boolean)true, (double)sourceNodata[k].doubleValue(), (boolean)true, (boolean)true);
                        nd3Bands[k] = RangeFactory.create((double)sourceNodata[k].doubleValue(), (boolean)true, (double)sourceNodata[k].doubleValue(), (boolean)true, (boolean)true);
                    }
                }
            }
            if (!roiAlphaNotNull) continue;
            if (k == 1) {
                int imageWidth = image1.getWidth();
                int imageHeigth = image1.getHeight();
                int startRoiXPixelImage1 = imageWidth / 2;
                int startRoiYPixel = 0;
                int roiWidth = imageWidth / 2;
                int roiHeigth = imageHeigth;
                Rectangle roiImage1 = new Rectangle(startRoiXPixelImage1, startRoiYPixel, roiWidth, roiHeigth);
                ROIShape roiData1 = new ROIShape((Shape)roiImage1);
                rois[k] = roiData1;
            }
            if (k != 2) continue;
            Number[] alphaChannelData = new Number[]{30};
            PlanarImage alphaChannel = (PlanarImage)MosaicTest.getSyntheticUniformTypeImage(alphaChannelData, null, dataType, 1, DataDisplacement.DATA_DATA, true, false);
            alphas[k] = alphaChannel = TranslateDescriptor.create((RenderedImage)alphaChannel, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(alphaChannel.getHeight() / 2), null, (RenderingHints)hints);
        }
        if (roiAlphaNotNull) {
            tempMosaicBean.setAlphas(alphas);
            tempMosaicBean.setRois(rois);
        }
        if (!nullNoData) {
            tempMosaicBean.setSourceNoDataRange(nd);
            tempMosaicBean.setSourceNoDataRange3Bands(nd3Bands);
        }
        tempMosaicBean.setSourceValidData(validData);
        return tempMosaicBean;
    }

    private Number[][] testExecution3Image(TestBean testBean, int numBands, boolean overlay) {
        Number[][] arrayPixel = new Number[3][6];
        RenderedOp image5 = null;
        RenderedImage[] sourceArray = null;
        Range[] nd = null;
        if (numBands == 3) {
            sourceArray = testBean.getImage3Bands();
            nd = testBean.getSourceNoDataRange();
        } else {
            sourceArray = testBean.getImage();
            nd = testBean.getSourceNoDataRange3Bands();
        }
        RenderedImage[] mosaicArray = new RenderedImage[3];
        mosaicArray[1] = TranslateDescriptor.create((RenderedImage)sourceArray[1], (Float)Float.valueOf(sourceArray[1].getWidth() / 2), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        mosaicArray[0] = TranslateDescriptor.create((RenderedImage)sourceArray[0], (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        mosaicArray[2] = TranslateDescriptor.create((RenderedImage)sourceArray[2], (Float)Float.valueOf(0.0f), (Float)Float.valueOf(sourceArray[2].getHeight() / 2), null, (RenderingHints)hints);
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        double[] destinationValues = testBean.getDestinationNoData();
        image5 = overlay ? MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)hints) : MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_BLEND, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)hints);
        int dataType = image5.getSampleModel().getDataType();
        int minXTile = image5.getMinTileX();
        int minYTile = image5.getMinTileY();
        int numXTile = image5.getNumXTiles();
        int numYTile = image5.getNumYTiles();
        int maxXTile = minXTile + (numXTile - 1);
        int maxYTile = minYTile + (numYTile - 1);
        int minXTileCoord = minXTile;
        int minYTileCoord = minYTile;
        int medXCoord12 = maxXTile / 2 - 1;
        int medYCoord13 = maxYTile / 2 - 1;
        int medXCoord2 = maxXTile / 2 + (maxXTile / 4 - 1);
        int medYCoord3 = maxYTile / 2 + (maxYTile / 4 - 1);
        Raster[] rasterArray = new Raster[]{image5.getTile(minXTileCoord, minYTileCoord), image5.getTile(medXCoord12, minYTileCoord), image5.getTile(medXCoord2, minYTileCoord), image5.getTile(minXTileCoord, medYCoord13), image5.getTile(medXCoord12, medYCoord13), image5.getTile(minXTileCoord, medYCoord3)};
        int[] arrayPixelInt = null;
        float[] arrayPixelFloat = null;
        double[] arrayPixelDouble = null;
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                arrayPixelInt = new int[6];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 6; ++j) {
                        arrayPixel[i][j] = rasterArray[j].getPixel(rasterArray[j].getMinX(), rasterArray[j].getMinY(), arrayPixelInt)[i];
                    }
                }
                break;
            }
            case 4: {
                arrayPixelFloat = new float[6];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 6; ++j) {
                        arrayPixel[i][j] = Float.valueOf(rasterArray[j].getPixel(rasterArray[j].getMinX(), rasterArray[j].getMinY(), arrayPixelFloat)[i]);
                    }
                }
                break;
            }
            case 5: {
                arrayPixelDouble = new double[3];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 6; ++j) {
                        arrayPixel[i][j] = rasterArray[j].getPixel(rasterArray[j].getMinX(), rasterArray[j].getMinY(), arrayPixelDouble)[i];
                    }
                }
                break;
            }
        }
        if (image5 instanceof RenderedOp) {
            image5.dispose();
        }
        return arrayPixel;
    }

    private Number[][] testExecutionAlpha(TestBean testBean, int numBands) {
        Number[][] arrayPixel = new Number[3][3];
        RenderedImage[] sourceArray = null;
        Range[] nd = null;
        if (numBands == 3) {
            sourceArray = testBean.getImage3Bands();
            nd = testBean.getSourceNoDataRange();
        } else {
            sourceArray = testBean.getImage();
            nd = testBean.getSourceNoDataRange3Bands();
        }
        RenderedImage[] mosaicArray = new RenderedImage[2];
        mosaicArray[1] = TranslateDescriptor.create((RenderedImage)sourceArray[1], (Float)Float.valueOf(sourceArray[1].getWidth() / 2), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        mosaicArray[0] = TranslateDescriptor.create((RenderedImage)sourceArray[0], (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        double[] destinationValues = testBean.getDestinationNoData();
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)hints);
        int dataType = image5.getSampleModel().getDataType();
        int minXTile = image5.getMinTileX();
        int minYTile = image5.getMinTileY();
        int numXTile = image5.getNumXTiles();
        int maxXTile = minXTile + (numXTile - 1);
        Raster[] rasterArray = new Raster[]{image5.getTile(0, 0), image5.getTile((maxXTile + 1) / 2 - 1, minYTile), image5.getTile((maxXTile + 1) / 2 - 1 + (maxXTile + 1) / 4, minYTile)};
        int[] coordinateXarray = new int[3];
        coordinateXarray[0] = 0;
        int tileCenterWidth = rasterArray[1].getWidth();
        coordinateXarray[1] = rasterArray[1].getMinX() + tileCenterWidth / 2;
        int tileRightSecondImWidth = rasterArray[2].getWidth();
        coordinateXarray[2] = rasterArray[2].getMinX() + tileRightSecondImWidth - 1;
        int[] arrayPixelInt = null;
        float[] arrayPixelFloat = null;
        double[] arrayPixelDouble = null;
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                arrayPixelInt = new int[3];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        arrayPixel[i][j] = rasterArray[j].getPixel(coordinateXarray[j], 0, arrayPixelInt)[i];
                    }
                }
                break;
            }
            case 4: {
                arrayPixelFloat = new float[3];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        arrayPixel[i][j] = Float.valueOf(rasterArray[j].getPixel(coordinateXarray[j], 0, arrayPixelFloat)[i]);
                    }
                }
                break;
            }
            case 5: {
                arrayPixelDouble = new double[3];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        arrayPixel[i][j] = rasterArray[j].getPixel(coordinateXarray[j], 0, arrayPixelDouble)[i];
                    }
                }
                break;
            }
        }
        if (image5 instanceof RenderedOp) {
            image5.dispose();
        }
        return arrayPixel;
    }

    private Number[] testExecution(TestBean testBean, int numBands) {
        Number[] arrayPixel = new Number[3];
        RenderedImage[] sourceArray = null;
        Range[] nd = null;
        if (numBands == 3) {
            sourceArray = testBean.getImage3Bands();
            nd = testBean.getSourceNoDataRange();
        } else {
            sourceArray = testBean.getImage();
            nd = testBean.getSourceNoDataRange3Bands();
        }
        RenderedImage[] mosaicArray = new RenderedImage[2];
        mosaicArray[1] = TranslateDescriptor.create((RenderedImage)sourceArray[1], (Float)Float.valueOf(sourceArray[1].getWidth() / 2), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        mosaicArray[0] = TranslateDescriptor.create((RenderedImage)sourceArray[0], (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        double[] destinationValues = testBean.getDestinationNoData();
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)hints);
        int minXTile = image5.getMinTileX();
        int minYTile = image5.getMinTileY();
        int numXTile = image5.getNumXTiles();
        int maxXTile = minXTile + (numXTile - 1);
        Raster upperCenter = image5.getTile(maxXTile / 2, minYTile);
        int minXCoord = upperCenter.getMinX();
        int numXPixel = upperCenter.getWidth();
        int mediumXPixelCoord = minXCoord + numXPixel / 2;
        int[] arrayPixelInt = null;
        float[] arrayPixelFloat = null;
        double[] arrayPixelDouble = null;
        int dataType = image5.getSampleModel().getDataType();
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                arrayPixelInt = new int[3];
                for (int i = 0; i < numBands; ++i) {
                    arrayPixel[i] = upperCenter.getPixel(mediumXPixelCoord, 0, arrayPixelInt)[i];
                }
                break;
            }
            case 4: {
                arrayPixelFloat = new float[3];
                for (int i = 0; i < numBands; ++i) {
                    arrayPixel[i] = Float.valueOf(upperCenter.getPixel(mediumXPixelCoord, 0, arrayPixelFloat)[i]);
                }
                break;
            }
            case 5: {
                arrayPixelDouble = new double[3];
                for (int i = 0; i < numBands; ++i) {
                    arrayPixel[i] = upperCenter.getPixel(mediumXPixelCoord, 0, arrayPixelDouble)[i];
                }
                break;
            }
        }
        if (image5 instanceof RenderedOp) {
            image5.dispose();
        }
        return arrayPixel;
    }

    private Number[][] testExecutionROI(TestBean testBean, int numBands) {
        Number[][] arrayPixel = new Number[3][3];
        RenderedImage[] sourceArray = null;
        Range[] nd = null;
        if (numBands == 3) {
            sourceArray = testBean.getImage3Bands();
            nd = testBean.getSourceNoDataRange();
        } else {
            sourceArray = testBean.getImage();
            nd = testBean.getSourceNoDataRange3Bands();
        }
        RenderedImage[] mosaicArray = new RenderedImage[2];
        mosaicArray[1] = TranslateDescriptor.create((RenderedImage)sourceArray[1], (Float)Float.valueOf(sourceArray[1].getWidth() / 2), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        mosaicArray[0] = TranslateDescriptor.create((RenderedImage)sourceArray[0], (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        PlanarImage[] alphas = testBean.getAlphas();
        ROI[] rois = testBean.getRois();
        double[] destinationValues = testBean.getDestinationNoData();
        RenderedOp image5 = MosaicDescriptor.create((RenderedImage[])mosaicArray, (MosaicType)DEFAULT_MOSAIC_TYPE, (PlanarImage[])alphas, (ROI[])rois, (double[][])null, (double[])destinationValues, (Range[])nd, (RenderingHints)hints);
        int dataType = image5.getSampleModel().getDataType();
        int minXTile = image5.getMinTileX();
        int minYTile = image5.getMinTileY();
        int numXTile = image5.getNumXTiles();
        int maxXTile = minXTile + (numXTile - 1);
        Raster[] rasterArray = new Raster[]{image5.getTile(0, 0), image5.getTile(maxXTile / 4 + 1, minYTile), image5.getTile((maxXTile + 1) / 2 - 1, minYTile)};
        int[] coordinateXarray = new int[3];
        coordinateXarray[0] = 0;
        coordinateXarray[1] = rasterArray[1].getMinX();
        int tileWidth = rasterArray[2].getWidth();
        coordinateXarray[2] = rasterArray[2].getMinX() + tileWidth - 1;
        int[] arrayPixelInt = null;
        float[] arrayPixelFloat = null;
        double[] arrayPixelDouble = null;
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                arrayPixelInt = new int[3];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        arrayPixel[i][j] = rasterArray[j].getPixel(coordinateXarray[j], 0, arrayPixelInt)[i];
                    }
                }
                break;
            }
            case 4: {
                arrayPixelFloat = new float[3];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        arrayPixel[i][j] = Float.valueOf(rasterArray[j].getPixel(coordinateXarray[j], 0, arrayPixelFloat)[i]);
                    }
                }
                break;
            }
            case 5: {
                arrayPixelDouble = new double[3];
                for (int i = 0; i < numBands; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        arrayPixel[i][j] = rasterArray[j].getPixel(coordinateXarray[j], 0, arrayPixelDouble)[i];
                    }
                }
                break;
            }
        }
        if (image5 instanceof RenderedOp) {
            image5.dispose();
        }
        return arrayPixel;
    }

    private static void creationAlpha(TestBean bean, int dataType) {
        Number[] alphaChannelData = new Number[]{30, 70};
        PlanarImage alphaChannel0 = null;
        PlanarImage alphaChannel1 = null;
        alphaChannel0 = (PlanarImage)MosaicTest.getSyntheticUniformTypeImage(alphaChannelData, null, dataType, 1, DataDisplacement.DATA_DATA, true, false);
        alphaChannel1 = (PlanarImage)MosaicTest.getSyntheticUniformTypeImage(alphaChannelData, null, dataType, 1, DataDisplacement.DATA_DATA, false, false);
        alphaChannel1 = TranslateDescriptor.create((RenderedImage)alphaChannel1, (Float)Float.valueOf(alphaChannel1.getWidth() / 2), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        PlanarImage[] alphas = new PlanarImage[]{alphaChannel0, alphaChannel1};
        bean.setAlphas(alphas);
    }

    private static void creationROI(TestBean bean) {
        int imageWidth = bean.getImage()[0].getWidth();
        int startRoiXPixelImage1 = imageWidth - 2;
        int startRoiYPixel = 0;
        int roiWidth = imageWidth;
        int roiHeigth = 50;
        Rectangle roiImage1 = new Rectangle(startRoiXPixelImage1, startRoiYPixel, roiWidth, roiHeigth);
        ROIShape roiData1 = new ROIShape((Shape)roiImage1);
        int startRoiXPixelImage2 = imageWidth / 2;
        Rectangle roiImage2 = new Rectangle(startRoiXPixelImage2, startRoiYPixel, roiWidth, roiHeigth);
        ROIShape roiData2 = new ROIShape((Shape)roiImage2);
        ROI[] rois = new ROI[]{roiData1, roiData2};
        bean.setRois(rois);
    }

    private static TestBean imageSettings(Number[] validData, Number[] sourceNodata, double[] destinationNoDataValue, int dataType, int imageDataNoData) {
        int i;
        DataDisplacement dd = DataDisplacement.values()[imageDataNoData];
        TestBean tempMosaicBean = new TestBean();
        if (dataType == 4) {
            for (i = 0; i < sourceNodata.length; ++i) {
                sourceNodata[i] = Float.valueOf(Float.NaN);
            }
        } else if (dataType == 5) {
            for (i = 0; i < sourceNodata.length; ++i) {
                sourceNodata[i] = Double.NaN;
            }
        }
        RenderedImage image1 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 1, dd, true, false);
        RenderedImage image2 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 1, dd, false, false);
        RenderedImage image3Band1 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 3, dd, true, false);
        RenderedImage image3Band2 = MosaicTest.getSyntheticUniformTypeImage(validData, sourceNodata, dataType, 3, dd, false, false);
        RenderedImage[] array1Band = new RenderedImage[]{image1, image2};
        RenderedImage[] array3Band = new RenderedImage[]{image3Band1, image3Band2};
        ImageLayout layout = new ImageLayout(0, 0, array1Band[0].getWidth() + array1Band[1].getWidth(), array1Band[0].getHeight());
        layout.setTileHeight(array1Band[0].getHeight() / 16);
        layout.setTileWidth(array1Band[0].getWidth() / 16);
        hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        tempMosaicBean.setDestinationNoData(destinationNoDataValue);
        tempMosaicBean.setImage(array1Band);
        tempMosaicBean.setImage3Bands(array3Band);
        Range[] nd = new Range[array1Band.length];
        Range[] nd3Bands = new Range[array1Band.length];
        block9: for (int k = 0; k < array1Band.length; ++k) {
            switch (dataType) {
                case 0: {
                    nd[k] = RangeFactory.create((byte)sourceNodata[k].byteValue(), (boolean)true, (byte)sourceNodata[k].byteValue(), (boolean)true);
                    nd3Bands[k] = RangeFactory.create((byte)sourceNodata[k].byteValue(), (boolean)true, (byte)sourceNodata[k].byteValue(), (boolean)true);
                    continue block9;
                }
                case 1: 
                case 2: {
                    nd[k] = RangeFactory.createU((short)sourceNodata[k].shortValue(), (boolean)true, (short)sourceNodata[k].shortValue(), (boolean)true);
                    nd3Bands[k] = RangeFactory.createU((short)sourceNodata[k].shortValue(), (boolean)true, (short)sourceNodata[k].shortValue(), (boolean)true);
                    continue block9;
                }
                case 3: {
                    nd[k] = RangeFactory.create((int)sourceNodata[k].intValue(), (boolean)true, (int)sourceNodata[k].intValue(), (boolean)true);
                    nd3Bands[k] = RangeFactory.create((int)sourceNodata[k].intValue(), (boolean)true, (int)sourceNodata[k].intValue(), (boolean)true);
                    continue block9;
                }
                case 4: {
                    nd[k] = RangeFactory.create((float)sourceNodata[k].floatValue(), (boolean)true, (float)sourceNodata[k].floatValue(), (boolean)true, (boolean)true);
                    nd3Bands[k] = RangeFactory.create((float)sourceNodata[k].floatValue(), (boolean)true, (float)sourceNodata[k].floatValue(), (boolean)true, (boolean)true);
                    continue block9;
                }
                case 5: {
                    nd[k] = RangeFactory.create((double)sourceNodata[k].doubleValue(), (boolean)true, (double)sourceNodata[k].doubleValue(), (boolean)true, (boolean)true);
                    nd3Bands[k] = RangeFactory.create((double)sourceNodata[k].doubleValue(), (boolean)true, (double)sourceNodata[k].doubleValue(), (boolean)true, (boolean)true);
                }
            }
        }
        tempMosaicBean.setSourceNoDataRange(nd);
        tempMosaicBean.setSourceNoDataRange3Bands(nd3Bands);
        tempMosaicBean.setSourceValidData(validData);
        return tempMosaicBean;
    }

    private static TestBean createBean(int dataType, int imageDataNoData, boolean useROI, boolean useAlpha) {
        Number[] sourceND = new Number[2];
        Number[] validData = new Number[2];
        double[] destinationND = new double[3];
        sourceND[0] = 50;
        sourceND[1] = 50;
        validData[0] = 15;
        validData[1] = 80;
        destinationND[0] = 100.0;
        destinationND[1] = 100.0;
        destinationND[2] = 100.0;
        TestBean bean = MosaicTest.imageSettings(validData, sourceND, destinationND, dataType, imageDataNoData);
        if (useROI) {
            MosaicTest.creationROI(bean);
        }
        if (useAlpha) {
            MosaicTest.creationAlpha(bean, dataType);
        }
        return bean;
    }

    private static TestBean createBean3Images(int dataType, boolean nullNoData, boolean roiAlphaNotNull) {
        Number[] sourceND = new Number[3];
        Number[] validData = new Number[3];
        double[] destinationND = new double[3];
        if (nullNoData) {
            sourceND[0] = null;
            sourceND[1] = null;
            sourceND[2] = null;
        } else {
            sourceND[0] = 50;
            sourceND[1] = 50;
            sourceND[2] = 50;
        }
        validData[0] = 15;
        validData[1] = 65;
        validData[2] = 80;
        destinationND[0] = 100.0;
        destinationND[1] = 100.0;
        destinationND[2] = 100.0;
        TestBean bean = MosaicTest.imageSettings3Images(validData, sourceND, destinationND, dataType, roiAlphaNotNull, nullNoData);
        return bean;
    }

    public static RenderedImage getSyntheticUniformTypeImage(Number[] valueData, Number[] valueNoData, int dataType, int numBands, DataDisplacement dd, boolean isFirstImage, boolean isLastOf3) {
        Number value = 0;
        switch (dd) {
            case DATA_DATA: {
                if (isFirstImage) {
                    value = valueData[0];
                    break;
                }
                value = valueData[1];
                break;
            }
            case NODATA_DATA: {
                if (isFirstImage) {
                    value = valueNoData[0];
                    break;
                }
                value = valueData[1];
                break;
            }
            case NODATA_NODATA: {
                if (isFirstImage) {
                    value = valueNoData[0];
                    break;
                }
                value = valueNoData[1];
                break;
            }
        }
        if (valueData.length == 3 && isLastOf3) {
            value = valueData[2];
        }
        ParameterBlock pb = new ParameterBlock();
        pb.add(512.0f);
        pb.add(512.0f);
        if (numBands == 3) {
            switch (dataType) {
                case 0: {
                    byte valueByte = value.byteValue();
                    Byte[] arraybyte = new Byte[]{valueByte, valueByte, valueByte};
                    pb.add(arraybyte);
                    break;
                }
                case 1: {
                    short valueUShort = value.shortValue();
                    Short[] arrayUShort = new Short[]{(short)(valueUShort & 0xFFFF), (short)(valueUShort & 0xFFFF), (short)(valueUShort & 0xFFFF)};
                    pb.add(arrayUShort);
                    break;
                }
                case 2: {
                    short valueShort = value.shortValue();
                    Short[] arrayShort = new Short[]{valueShort, valueShort, valueShort};
                    pb.add(arrayShort);
                    break;
                }
                case 3: {
                    int valueInt = value.intValue();
                    Integer[] arrayInteger = new Integer[]{valueInt, valueInt, valueInt};
                    pb.add(arrayInteger);
                    break;
                }
                case 4: {
                    float valueFloat = value.floatValue();
                    Float[] arrayFloat = new Float[]{Float.valueOf(valueFloat), Float.valueOf(valueFloat), Float.valueOf(valueFloat)};
                    pb.add(arrayFloat);
                    break;
                }
                case 5: {
                    double valueDouble = value.doubleValue();
                    Double[] arrayDouble = new Double[]{valueDouble, valueDouble, valueDouble};
                    pb.add(arrayDouble);
                }
            }
        } else {
            switch (dataType) {
                case 0: {
                    byte valueByte = value.byteValue();
                    Byte[] arraybyte = new Byte[]{valueByte};
                    pb.add(arraybyte);
                    break;
                }
                case 1: {
                    short valueUShort = value.shortValue();
                    Short[] arrayUShort = new Short[]{(short)(valueUShort & 0xFFFF)};
                    pb.add(arrayUShort);
                    break;
                }
                case 2: {
                    short valueShort = value.shortValue();
                    Short[] arrayShort = new Short[]{valueShort};
                    pb.add(arrayShort);
                    break;
                }
                case 3: {
                    int valueInt = value.intValue();
                    Integer[] arrayInteger = new Integer[]{valueInt};
                    pb.add(arrayInteger);
                    break;
                }
                case 4: {
                    float valueFloat = value.floatValue();
                    Float[] arrayFloat = new Float[]{Float.valueOf(valueFloat)};
                    pb.add(arrayFloat);
                    break;
                }
                case 5: {
                    double valueDouble = value.doubleValue();
                    Double[] arrayDouble = new Double[]{valueDouble};
                    pb.add(arrayDouble);
                }
            }
        }
        return JAI.create((String)"constant", (ParameterBlock)pb);
    }

    private static class TestBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private RenderedImage[] image;
        private RenderedImage[] image3Bands;
        private double[] destinationNoData;
        private Number[] sourceValidData;
        private Range[] sourceNoDataRange;
        private Range[] sourceNoDataRange3Bands;
        private ROI[] rois;
        private PlanarImage[] alphas;

        TestBean() {
        }

        public RenderedImage[] getImage() {
            return this.image;
        }

        public void setImage(RenderedImage[] image) {
            this.image = image;
        }

        public double[] getDestinationNoData() {
            return this.destinationNoData;
        }

        public void setDestinationNoData(double[] destinationNoData) {
            this.destinationNoData = destinationNoData;
        }

        public Number[] getSourceValidData() {
            return this.sourceValidData;
        }

        public void setSourceValidData(Number[] sourceValidData) {
            this.sourceValidData = sourceValidData;
        }

        public RenderedImage[] getImage3Bands() {
            return this.image3Bands;
        }

        public void setImage3Bands(RenderedImage[] image3Bands) {
            this.image3Bands = image3Bands;
        }

        public Range[] getSourceNoDataRange() {
            return this.sourceNoDataRange;
        }

        public void setSourceNoDataRange(Range[] sourceNoDataRange) {
            this.sourceNoDataRange = sourceNoDataRange;
        }

        public Range[] getSourceNoDataRange3Bands() {
            return this.sourceNoDataRange3Bands;
        }

        public void setSourceNoDataRange3Bands(Range[] sourceNoDataRange3Bands) {
            this.sourceNoDataRange3Bands = sourceNoDataRange3Bands;
        }

        public ROI[] getRois() {
            return this.rois;
        }

        public void setRois(ROI[] rois) {
            this.rois = rois;
        }

        public PlanarImage[] getAlphas() {
            return this.alphas;
        }

        public void setAlphas(PlanarImage[] alphas) {
            this.alphas = alphas;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataDisplacement {
        NODATA_NODATA,
        NODATA_DATA,
        DATA_DATA;

    }
}

