/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.mosaic.MosaicDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.NullDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.junit.Test;

public class MosaicTestImage
extends TestBase {
    private static final boolean INTERACTIVE = Boolean.getBoolean("JAI.Ext.Interactive");
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");

    public static RenderedImage getSyntheticByte(byte value) {
        float width = 256.0f;
        float height = 256.0f;
        ParameterBlock pb = new ParameterBlock();
        Byte[] array = new Byte[]{value};
        pb.add(256.0f);
        pb.add(256.0f);
        pb.add(array);
        return JAI.create((String)"constant", (ParameterBlock)pb);
    }

    @Test
    public void testOldMosaicOperation() {
        if (!OLD_DESCRIPTOR) {
            this.testSimpleMosaicOperation(OLD_DESCRIPTOR);
        }
    }

    @Test
    public void testNewMosaicOperation() {
        if (OLD_DESCRIPTOR) {
            this.testSimpleMosaicOperation(!OLD_DESCRIPTOR);
        }
    }

    public void testSimpleMosaicOperation(boolean oldDescriptor) {
        RenderedImage image1 = MosaicTestImage.getSyntheticByte((byte)99);
        RenderedImage image2 = MosaicTestImage.getSyntheticByte((byte)50);
        int width = image1.getWidth();
        ImageLayout layout = new ImageLayout(0, 0, image1.getWidth() + image2.getWidth(), image1.getHeight());
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        double[] background = new double[]{0.0};
        double[][] threshold = new double[][]{{0.0}, {0.0}};
        RenderedOp image3 = TranslateDescriptor.create((RenderedImage)image1, (Float)Float.valueOf((float)width * 0.1f), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        RenderedOp image4 = NullDescriptor.create((RenderedImage)image2, (RenderingHints)hints);
        RenderedImage[] sources = new RenderedImage[]{image4, image3};
        RenderedOp image5 = !oldDescriptor ? MosaicDescriptor.create((RenderedImage[])sources, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])background, null, (RenderingHints)hints) : javax.media.jai.operator.MosaicDescriptor.create((RenderedImage[])sources, (MosaicType)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])threshold, (double[])background, (RenderingHints)hints);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)image5, (boolean)false, (boolean)false);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (image5 instanceof RenderedOp) {
            image5.dispose();
        }
    }
}

