/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.mosaic.MosaicDescriptor;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.NullDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestBase {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean NATIVE_ACCELERATION = Boolean.getBoolean("JAI.Ext.Acceleration");
    private static final boolean MOSAIC_TYPE = Boolean.getBoolean("JAI.Ext.MosaicBlend");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static double destinationNoData = 0.0;
    private static RenderedImage[] images;
    private static RenderingHints hints;
    private static Range[] rangeND;

    @BeforeClass
    public static void initialSetup() {
        byte value1 = 50;
        byte value2 = 100;
        RenderedImage image1 = ComparisonTest.getSyntheticImage(value1);
        RenderedImage image2 = ComparisonTest.getSyntheticImage(value2);
        int width = image1.getWidth();
        ImageLayout layout = new ImageLayout(0, 0, image1.getWidth() + image2.getWidth(), image1.getHeight());
        hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp image3 = TranslateDescriptor.create((RenderedImage)image1, (Float)Float.valueOf((float)width * 0.1f), (Float)Float.valueOf(0.0f), null, (RenderingHints)hints);
        RenderedOp image4 = NullDescriptor.create((RenderedImage)image2, (RenderingHints)hints);
        images = new RenderedImage[2];
        ComparisonTest.images[0] = image4;
        ComparisonTest.images[1] = image3;
        rangeND = null;
        if (RANGE_USED) {
            Range range = RangeFactory.create((byte)100, (boolean)true, (byte)100, (boolean)true);
            rangeND = new Range[]{range, range};
        }
        if (OLD_DESCRIPTOR) {
            JAIExt.registerJAIDescriptor((String)"Mosaic");
        }
    }

    @Test
    public void testNearestNewMosaicDescriptor() {
        if (!OLD_DESCRIPTOR) {
            this.testMosaic(OLD_DESCRIPTOR, MOSAIC_TYPE);
        }
    }

    @Test
    public void testNearestOldMosaicDescriptor() {
        if (OLD_DESCRIPTOR) {
            this.testMosaic(OLD_DESCRIPTOR, MOSAIC_TYPE);
        }
    }

    public void testMosaic(boolean old, boolean blend) {
        MosaicType mosaicType;
        String description = "";
        if (old) {
            description = "Old Mosaic";
            if (NATIVE_ACCELERATION) {
                description = description + " accelerated ";
                System.setProperty("com.sun.media.jai.disableMediaLib", "false");
            } else {
                System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            }
        } else {
            description = "New Mosaic";
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        }
        String mosaic = "";
        if (!blend) {
            mosaicType = javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY;
            mosaic = "Mosaic Type Overlay";
        } else {
            mosaicType = javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_BLEND;
            mosaic = "Mosaic Type Blend";
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageMosaic = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            if (old) {
                double[] background = new double[]{destinationNoData, destinationNoData};
                double[][] threshold = new double[][]{{0.0}, {0.0}};
                imageMosaic = javax.media.jai.operator.MosaicDescriptor.create((RenderedImage[])images, (MosaicType)mosaicType, null, null, (double[][])threshold, (double[])background, (RenderingHints)hints);
            } else {
                double[] destnodata = new double[]{destinationNoData, destinationNoData};
                imageMosaic = MosaicDescriptor.create((RenderedImage[])images, (MosaicType)mosaicType, null, null, (double[][])null, (double[])destnodata, (Range[])rangeND, (RenderingHints)hints);
            }
            long start = System.nanoTime();
            imageMosaic.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println("\n" + mosaic);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageMosaic instanceof RenderedOp) {
            imageMosaic.dispose();
        }
    }

    public static RenderedImage getSyntheticImage(byte value) {
        float width = 512.0f;
        float height = 512.0f;
        ParameterBlock pb = new ParameterBlock();
        Byte[] array = new Byte[]{value, (byte)(value + 1), (byte)(value + 2)};
        pb.add(512.0f);
        pb.add(512.0f);
        pb.add(array);
        return JAI.create((String)"constant", (ParameterBlock)pb);
    }
}

