/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.mosaic.ImageMosaicBean;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

public class MosaicOpImage
extends OpImage {
    public static final double[] DEFAULT_DESTINATION_NO_DATA_VALUE = new double[]{0.0};
    private MosaicType mosaicTypeSelected;
    private int numBands;
    private final ImageMosaicBean[] imageBeans;
    private boolean roiPresent;
    private boolean isAlphaBitmaskUsed;
    private boolean alphaPresent;
    private BorderExtender sourceBorderExtender;
    private BorderExtender zeroBorderExtender;
    private byte[] destinationNoDataByte;
    private short[] destinationNoDataUShort;
    private short[] destinationNoDataShort;
    private int[] destinationNoDataInt;
    private float[] destinationNoDataFloat;
    private double[] destinationNoDataDouble;
    protected byte[][][] byteLookupTable;
    private final boolean[] hasNoData;

    private static final ImageLayout checkLayout(List sources, ImageLayout layout) {
        int i;
        RenderedImage sourceImage = null;
        SampleModel targetSampleModel = null;
        int numSources = sources.size();
        if (numSources > 0) {
            sourceImage = (RenderedImage)sources.get(0);
            targetSampleModel = sourceImage.getSampleModel();
        } else if (layout != null && layout.isValid(268)) {
            targetSampleModel = layout.getSampleModel(null);
            if (targetSampleModel == null) {
                throw new IllegalArgumentException("No sample model present");
            }
        } else {
            throw new IllegalArgumentException("Layout not valid");
        }
        int dataType = targetSampleModel.getDataType();
        int bandNumber = targetSampleModel.getNumBands();
        int sampleSize = targetSampleModel.getSampleSize(0);
        for (i = 1; i < bandNumber; ++i) {
            if (targetSampleModel.getSampleSize(i) == sampleSize) continue;
            throw new IllegalArgumentException("Sample size is not the same for every band");
        }
        if (numSources < 1) {
            return (ImageLayout)layout.clone();
        }
        for (i = 1; i < numSources; ++i) {
            RenderedImage sourceData = (RenderedImage)sources.get(i);
            SampleModel sourceSampleModel = sourceData.getSampleModel();
            if (sourceSampleModel.getDataType() != dataType) {
                throw new IllegalArgumentException("Data type is not the same for every source");
            }
            if (sourceSampleModel.getNumBands() != bandNumber) {
                throw new IllegalArgumentException("Bands number is not the same for every source");
            }
            for (int j = 0; j < bandNumber; ++j) {
                if (sourceSampleModel.getSampleSize(j) == sampleSize) continue;
                throw new IllegalArgumentException("Sample size is not the same for every band");
            }
        }
        ImageLayout mosaicLayout = layout == null ? new ImageLayout() : (ImageLayout)layout.clone();
        Rectangle mosaicBounds = new Rectangle();
        if (mosaicLayout.isValid(15)) {
            mosaicBounds.setBounds(mosaicLayout.getMinX(null), mosaicLayout.getMinY(null), mosaicLayout.getWidth(null), mosaicLayout.getHeight(null));
        } else if (numSources > 0) {
            mosaicBounds.setBounds(sourceImage.getMinX(), sourceImage.getMinY(), sourceImage.getWidth(), sourceImage.getHeight());
            for (int i2 = 1; i2 < numSources; ++i2) {
                RenderedImage source = (RenderedImage)sources.get(i2);
                Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
                mosaicBounds = mosaicBounds.union(sourceBounds);
            }
        }
        mosaicLayout.setMinX(mosaicBounds.x);
        mosaicLayout.setMinY(mosaicBounds.y);
        mosaicLayout.setWidth(mosaicBounds.width);
        mosaicLayout.setHeight(mosaicBounds.height);
        if (mosaicLayout.isValid(256)) {
            SampleModel destSampleModel = mosaicLayout.getSampleModel(null);
            boolean unsetSampleModel = destSampleModel.getNumBands() != bandNumber || destSampleModel.getDataType() != dataType;
            for (int i3 = 0; !unsetSampleModel && i3 < bandNumber; ++i3) {
                if (destSampleModel.getSampleSize(i3) == sampleSize) continue;
                unsetSampleModel = true;
            }
            if (unsetSampleModel) {
                mosaicLayout.unsetValid(256);
            }
        }
        return mosaicLayout;
    }

    public MosaicOpImage(List sources, ImageLayout layout, Map renderingHints, MosaicType mosaicTypeSelected, PlanarImage[] alphaImgs, ROI[] rois, double[][] thresholds, double[] destinationNoData, Range[] noDatas) {
        int i;
        int dataType;
        Rectangle totalBounds;
        boolean nodataExists;
        boolean alphaExists;
        boolean roiExists;
        int numSources;
        block49: {
            block48: {
                super((Vector)sources, MosaicOpImage.checkLayout(sources, layout), renderingHints, true);
                this.numBands = this.sampleModel.getNumBands();
                numSources = this.getNumSources();
                this.mosaicTypeSelected = mosaicTypeSelected;
                this.roiPresent = false;
                this.alphaPresent = false;
                roiExists = rois != null;
                alphaExists = alphaImgs != null;
                boolean bl = nodataExists = noDatas != null;
                if (roiExists && rois.length != numSources) {
                    throw new IllegalArgumentException("roi number is not equal to the source number");
                }
                if (alphaExists && alphaImgs.length != numSources) {
                    throw new IllegalArgumentException("alpha bands number is not equal to the source number");
                }
                if (nodataExists && noDatas.length != numSources) {
                    throw new IllegalArgumentException("no data number is not equal to the source number");
                }
                totalBounds = this.getBounds();
                dataType = this.sampleModel.getDataType();
                this.zeroBorderExtender = BorderExtender.createInstance((int)0);
                if (destinationNoData != null) break block48;
                this.destinationNoDataDouble = DEFAULT_DESTINATION_NO_DATA_VALUE;
                switch (dataType) {
                    case 0: {
                        this.destinationNoDataByte = new byte[numSources];
                        Arrays.fill(this.destinationNoDataByte, (byte)0);
                        break block49;
                    }
                    case 1: {
                        this.destinationNoDataUShort = new short[numSources];
                        Arrays.fill(this.destinationNoDataUShort, (short)0);
                        break block49;
                    }
                    case 2: {
                        this.destinationNoDataShort = new short[numSources];
                        Arrays.fill(this.destinationNoDataShort, (short)Short.MIN_VALUE);
                        break block49;
                    }
                    case 3: {
                        this.destinationNoDataInt = new int[numSources];
                        Arrays.fill(this.destinationNoDataInt, Integer.MIN_VALUE);
                        break block49;
                    }
                    case 4: {
                        this.destinationNoDataFloat = new float[numSources];
                        Arrays.fill(this.destinationNoDataFloat, -3.4028235E38f);
                        break block49;
                    }
                    case 5: {
                        Arrays.fill(this.destinationNoDataDouble, -1.7976931348623157E308);
                        break block49;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data Type");
                    }
                }
            }
            this.destinationNoDataDouble = new double[this.numBands];
            if (destinationNoData.length < this.numBands) {
                Arrays.fill(this.destinationNoDataDouble, destinationNoData[0]);
            } else {
                System.arraycopy(destinationNoData, 0, this.destinationNoDataDouble, 0, this.numBands);
            }
            switch (dataType) {
                case 0: {
                    int i2;
                    this.destinationNoDataByte = new byte[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataByte, (byte)destinationNoData[0]);
                        break;
                    }
                    for (i2 = 0; i2 < this.numBands; ++i2) {
                        this.destinationNoDataByte[i2] = (byte)destinationNoData[i2];
                    }
                    break;
                }
                case 1: {
                    int i2;
                    this.destinationNoDataUShort = new short[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataUShort, (short)((short)destinationNoData[0] & 0xFFFF));
                        break;
                    }
                    for (i2 = 0; i2 < this.numBands; ++i2) {
                        this.destinationNoDataUShort[i2] = (short)((short)destinationNoData[i2] & 0xFFFF);
                    }
                    break;
                }
                case 2: {
                    int i2;
                    this.destinationNoDataShort = new short[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataShort, (short)destinationNoData[0]);
                        break;
                    }
                    for (i2 = 0; i2 < this.numBands; ++i2) {
                        this.destinationNoDataShort[i2] = (short)destinationNoData[i2];
                    }
                    break;
                }
                case 3: {
                    int i2;
                    this.destinationNoDataInt = new int[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataInt, (int)destinationNoData[0]);
                        break;
                    }
                    for (i2 = 0; i2 < this.numBands; ++i2) {
                        this.destinationNoDataInt[i2] = (int)destinationNoData[i2];
                    }
                    break;
                }
                case 4: {
                    int i2;
                    this.destinationNoDataFloat = new float[this.numBands];
                    if (destinationNoData.length < this.numBands) {
                        Arrays.fill(this.destinationNoDataFloat, (float)destinationNoData[0]);
                        break;
                    }
                    for (i2 = 0; i2 < this.numBands; ++i2) {
                        this.destinationNoDataFloat[i2] = (float)destinationNoData[i2];
                    }
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data Type");
                }
            }
        }
        double sourceExtensionBorder = noDatas != null && noDatas.length > 0 && noDatas[0] != null ? noDatas[0].getMin().doubleValue() : this.destinationNoDataDouble[0];
        this.sourceBorderExtender = sourceExtensionBorder == 0.0 ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(new double[]{sourceExtensionBorder});
        this.hasNoData = new boolean[numSources];
        ArrayList<PlanarImage> alphaList = new ArrayList<PlanarImage>();
        this.byteLookupTable = new byte[numSources][this.numBands][256];
        this.imageBeans = new ImageMosaicBean[numSources];
        for (i = 0; i < numSources; ++i) {
            this.imageBeans[i] = new ImageMosaicBean();
        }
        for (i = 0; i < numSources; ++i) {
            Range noDataRange;
            ParameterBlock pb;
            int[] pads;
            ROI roi;
            PlanarImage img = this.getSourceImage(i);
            int[] padding = this.calculatePadding((RenderedImage)img, totalBounds);
            if (padding != null) {
                ParameterBlock pb2 = new ParameterBlock();
                pb2.setSource(img, 0);
                pb2.set(padding[0], 0);
                pb2.set(padding[1], 1);
                pb2.set(padding[2], 2);
                pb2.set(padding[3], 3);
                pb2.set(this.sourceBorderExtender, 4);
                RenderedOp create = JAI.create((String)"border", (ParameterBlock)pb2);
                this.imageBeans[i].setImage((RenderedImage)create);
            } else {
                this.imageBeans[i].setImage((RenderedImage)img);
            }
            PlanarImage alpha = alphaExists ? alphaImgs[i] : null;
            alphaList.add(alpha);
            ROI rOI = roi = roiExists ? rois[i] : null;
            if (alpha != null) {
                this.alphaPresent = true;
                SampleModel alphaSampleModel = alpha.getSampleModel();
                pads = this.calculatePadding((RenderedImage)alpha, totalBounds);
                if (pads != null) {
                    pb = new ParameterBlock();
                    pb.setSource(alpha, 0);
                    pb.set(pads[0], 0);
                    pb.set(pads[1], 1);
                    pb.set(pads[2], 2);
                    pb.set(pads[3], 3);
                    pb.set(this.zeroBorderExtender, 4);
                    RenderedOp create = JAI.create((String)"border", (ParameterBlock)pb);
                    this.imageBeans[i].setAlphaChannel((PlanarImage)create);
                } else {
                    this.imageBeans[i].setAlphaChannel(alpha);
                }
                if (alphaSampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException("Alpha bands number must be 1");
                }
                if (alphaSampleModel.getDataType() != this.sampleModel.getDataType()) {
                    throw new IllegalArgumentException("Alpha sample model dataType and Source sample model dataTypes must be equal");
                }
                if (alphaSampleModel.getSampleSize(0) != this.sampleModel.getSampleSize(0)) {
                    throw new IllegalArgumentException("Alpha sample model sampleSize and Source sample model sampleSize must be equal");
                }
            }
            if (roi != null) {
                this.roiPresent = true;
                PlanarImage roiIMG = roi.getAsImage();
                pads = this.calculatePadding((RenderedImage)roiIMG, totalBounds);
                if (pads != null) {
                    pb = new ParameterBlock();
                    pb.setSource(roiIMG, 0);
                    pb.set(pads[0], 0);
                    pb.set(pads[1], 1);
                    pb.set(pads[2], 2);
                    pb.set(pads[3], 3);
                    pb.set(this.zeroBorderExtender, 4);
                    this.imageBeans[i].setRoiImage((RenderedImage)JAI.create((String)"border", (ParameterBlock)pb));
                } else {
                    this.imageBeans[i].setRoiImage((RenderedImage)roiIMG);
                }
                this.imageBeans[i].setRoi(roi);
            }
            Range range = noDataRange = nodataExists ? noDatas[i] : null;
            if (noDataRange == null) continue;
            this.hasNoData[i] = true;
            this.imageBeans[i].setSourceNoData(noDataRange);
            if (dataType != 0) continue;
            Range noDataByte = noDataRange;
            for (int b = 0; b < this.numBands; ++b) {
                for (int z = 0; z < this.byteLookupTable[i][0].length; ++z) {
                    this.byteLookupTable[i][b][z] = noDataByte.contains(z) ? this.destinationNoDataByte[b] : (byte)z;
                }
            }
        }
        if (!this.isAlphaBitmaskUsed) {
            for (i = 0; i < numSources; ++i) {
                if (alphaList.get(i) != null) continue;
                this.isAlphaBitmaskUsed = true;
                break;
            }
        }
    }

    private int[] calculatePadding(RenderedImage src, Rectangle totalBounds) {
        int bottomP;
        int deltaX0 = src.getMinX() - totalBounds.x;
        int leftP = deltaX0 > 0 ? deltaX0 : 0;
        int deltaY0 = src.getMinY() - totalBounds.y;
        int topP = deltaY0 > 0 ? deltaY0 : 0;
        int deltaX1 = totalBounds.x + totalBounds.width - src.getMinX() - src.getWidth();
        int rightP = deltaX1 > 0 ? deltaX1 : 0;
        int deltaY1 = totalBounds.y + totalBounds.height - src.getMinY() - src.getHeight();
        int n = bottomP = deltaY1 > 0 ? deltaY1 : 0;
        if (leftP + rightP + topP + bottomP == 0) {
            return null;
        }
        return new int[]{leftP, rightP, topP, bottomP};
    }

    public Raster computeTile(int tileX, int tileY) {
        int i;
        WritableRaster destRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(tileX), this.tileYToY(tileY)));
        Rectangle destRectangle = this.getTileRect(tileX, tileY);
        int numSources = this.getNumSources();
        Raster[] sourceRasters = new Raster[numSources];
        Raster[] alphaRasters = new Raster[numSources];
        Raster[] roiRasters = new Raster[numSources];
        Range[] noDataRanges = new Range[numSources];
        for (i = 0; i < numSources; ++i) {
            PlanarImage source = this.getSourceImage(i);
            Rectangle srcRect = this.mapDestRect(destRectangle, i);
            Raster data = null;
            if (srcRect == null || !srcRect.isEmpty()) {
                data = source.getBounds().contains(destRectangle) ? source.getData(destRectangle) : this.imageBeans[i].getImage().getData(destRectangle);
            }
            sourceRasters[i] = data;
            noDataRanges[i] = this.imageBeans[i].getSourceNoData();
            if (data == null) continue;
            PlanarImage alpha = this.imageBeans[i].getAlphaChannel();
            if (this.alphaPresent && alpha != null) {
                alphaRasters[i] = alpha.getData(destRectangle);
            }
            RenderedImage roi = this.imageBeans[i].getRoiImage();
            if (!this.roiPresent || roi == null) continue;
            roiRasters[i] = roi.getData(destRectangle);
        }
        this.computeRect(sourceRasters, destRaster, destRectangle, alphaRasters, roiRasters, noDataRanges);
        for (i = 0; i < numSources; ++i) {
            PlanarImage source;
            Raster sourceData = sourceRasters[i];
            if (sourceData == null || !(source = this.getSourceImage(i)).overlapsMultipleTiles(sourceData.getBounds())) continue;
            this.recycleTile(sourceData);
        }
        return destRaster;
    }

    private void computeRect(Raster[] sourceRasters, WritableRaster destRaster, Rectangle destRectangle, Raster[] alphaRasters, Raster[] roiRasters, Range[] noDataRanges) {
        int sourcesNumber = sourceRasters.length;
        ArrayList<Raster> listRasterSource = new ArrayList<Raster>(sourcesNumber);
        for (int i = 0; i < sourcesNumber; ++i) {
            if (sourceRasters[i] == null) continue;
            listRasterSource.add(sourceRasters[i]);
        }
        int notNullSources = listRasterSource.size();
        if (notNullSources == 0) {
            ImageUtil.fillBackground((WritableRaster)destRaster, (Rectangle)destRectangle, (double[])this.destinationNoDataDouble);
            return;
        }
        SampleModel[] sourceSampleModels = new SampleModel[notNullSources];
        for (int i = 0; i < notNullSources; ++i) {
            sourceSampleModels[i] = ((Raster)listRasterSource.get(i)).getSampleModel();
        }
        int rasterAccessFormatTagID = RasterAccessor.findCompatibleTag((SampleModel[])sourceSampleModels, (SampleModel)destRaster.getSampleModel());
        RasterBeanAccessor[] sourceAccessorsArrayBean = new RasterBeanAccessor[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            Raster alphaRaster;
            RasterBeanAccessor helpAccessor = new RasterBeanAccessor();
            if (sourceRasters[i] != null) {
                RasterFormatTag formatTag = new RasterFormatTag(sourceRasters[i].getSampleModel(), rasterAccessFormatTagID);
                helpAccessor.setDataRasterAccessor(new RasterAccessor(sourceRasters[i], destRectangle, formatTag, null));
            }
            if ((alphaRaster = alphaRasters[i]) != null) {
                SampleModel alphaSampleModel = alphaRaster.getSampleModel();
                int alphaFormatTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)alphaSampleModel);
                RasterFormatTag alphaFormatTag = new RasterFormatTag(alphaSampleModel, alphaFormatTagID);
                helpAccessor.setAlphaRasterAccessor(new RasterAccessor(alphaRaster, destRectangle, alphaFormatTag, this.imageBeans[i].getAlphaChannel().getColorModel()));
            }
            helpAccessor.setRoiRaster(roiRasters[i]);
            helpAccessor.setSourceNoDataRangeRasterAccessor(noDataRanges[i]);
            sourceAccessorsArrayBean[i] = helpAccessor;
        }
        RasterAccessor destinationAccessor = new RasterAccessor((Raster)destRaster, destRectangle, new RasterFormatTag(destRaster.getSampleModel(), rasterAccessFormatTagID), null);
        int dataType = destinationAccessor.getDataType();
        switch (dataType) {
            case 0: {
                this.byteLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 2: {
                this.shortLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 3: {
                this.intLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 4: {
                this.floatLoop(sourceAccessorsArrayBean, destinationAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(sourceAccessorsArrayBean, destinationAccessor);
            }
        }
        destinationAccessor.copyDataToRaster();
    }

    private void byteLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        Object aBandDataByte;
        Object alfaDataByte;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[] sLineOffsets = new int[sourcesNumber];
        int[] sPixelOffsets = new int[sourcesNumber];
        byte[][][] srcDataByte = new byte[sourcesNumber][][];
        byte[][] dstDataByte = dst.getByteDataArrays();
        byte[][] sBandDataByte = new byte[sourcesNumber][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataByte = new byte[sourcesNumber][][];
            aBandDataByte = new byte[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataByte = null;
            aBandDataByte = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataByte[i] = dataRA.getByteDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataByte[i] = alphaRA.getByteDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || this.imageBeans[i].getRoi() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int b = 0; b < dstBands; ++b) {
            int dstX;
            int dPixelOffset;
            int s;
            int dstY;
            for (int s2 = 0; s2 < sourcesNumber; ++s2) {
                if (srcBean[s2].getDataRasterAccessor() != null) {
                    sBandDataByte[s2] = srcDataByte[s2][b];
                    sLineOffsets[s2] = srcBandOffsets[s2][b];
                }
                if (weightTypesUsed[s2] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                aBandDataByte[s2] = alfaDataByte[s2][0];
                aLineOffsets[s2] = alfaBandOffsets[s2][0];
            }
            byte[] dBandDataByte = dstDataByte[b];
            int dLineOffset = dstBandOffsets[b];
            if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                    for (s = 0; s < sourcesNumber; ++s) {
                        if (srcBean[s].getDataRasterAccessor() != null) {
                            sPixelOffsets[s] = sLineOffsets[s];
                            int n = s;
                            sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                        }
                        if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                        aPixelOffsets[s] = aLineOffsets[s];
                        int n = s;
                        aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                    }
                    dPixelOffset = dLineOffset;
                    dLineOffset += dstLineStride;
                    for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                        boolean setDestinationFlag = false;
                        for (int s3 = 0; s3 < sourcesNumber; ++s3) {
                            RasterAccessor dataRA = srcBean[s3].getDataRasterAccessor();
                            if (dataRA == null) continue;
                            byte sourceValueByte = sBandDataByte[s3][sPixelOffsets[s3]];
                            int n = s3;
                            sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s3];
                            boolean isData = true;
                            if (this.hasNoData[s3]) {
                                boolean bl = isData = this.byteLookupTable[s3][b][sourceValueByte & 0xFF] != this.destinationNoDataByte[b];
                            }
                            if (!isData) {
                                setDestinationFlag = false;
                            } else {
                                switch (weightTypesUsed[s3]) {
                                    case WEIGHT_TYPE_ALPHA: {
                                        setDestinationFlag = aBandDataByte[s3][aPixelOffsets[s3]] != 0;
                                        int n2 = s3;
                                        aPixelOffsets[n2] = aPixelOffsets[n2] + alfaPixelStride[s3];
                                        break;
                                    }
                                    case WEIGHT_TYPE_ROI: {
                                        setDestinationFlag = srcBean[s3].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        setDestinationFlag = true;
                                    }
                                }
                            }
                            if (!setDestinationFlag) continue;
                            dBandDataByte[dPixelOffset] = (byte)(sourceValueByte & 0xFF);
                            for (int k = s3 + 1; k < sourcesNumber; ++k) {
                                if (dataRA != null) {
                                    int n3 = k;
                                    sPixelOffsets[n3] = sPixelOffsets[n3] + srcPixelStride[k];
                                }
                                if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                                int n4 = k;
                                aPixelOffsets[n4] = aPixelOffsets[n4] + alfaPixelStride[k];
                            }
                            break;
                        }
                        if (!setDestinationFlag) {
                            dBandDataByte[dPixelOffset] = this.destinationNoDataByte[b];
                        }
                        dPixelOffset += dstPixelStride;
                    }
                }
                continue;
            }
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        sPixelOffsets[s] = sLineOffsets[s];
                        int n = s;
                        sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                dPixelOffset = dLineOffset;
                dLineOffset += dstLineStride;
                for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    double numerator = 0.0;
                    double denominator = 0.0;
                    for (int s4 = 0; s4 < sourcesNumber; ++s4) {
                        if (srcBean[s4].getDataRasterAccessor() == null) continue;
                        byte sourceValueByte = sBandDataByte[s4][sPixelOffsets[s4]];
                        int n = s4;
                        sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s4];
                        double weight = 0.0;
                        boolean isData = true;
                        if (this.hasNoData[s4]) {
                            boolean bl = isData = this.byteLookupTable[s4][b][sourceValueByte & 0xFF] != this.destinationNoDataByte[b];
                        }
                        if (!isData) {
                            weight = 0.0;
                        } else {
                            switch (weightTypesUsed[s4]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataByte[s4][aPixelOffsets[s4]] & 0xFF;
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n5 = s4;
                                    aPixelOffsets[n5] = aPixelOffsets[n5] + alfaPixelStride[s4];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s4].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        numerator += weight * (double)(sourceValueByte & 0xFF);
                        denominator += weight;
                    }
                    dBandDataByte[dPixelOffset] = denominator == 0.0 ? this.destinationNoDataByte[b] : ImageUtil.clampRoundByte((double)(numerator / denominator));
                    dPixelOffset += dstPixelStride;
                }
            }
        }
    }

    private void ushortLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        Object aBandDataUshort;
        Object alfaDataUshort;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[] sLineOffsets = new int[sourcesNumber];
        int[] sPixelOffsets = new int[sourcesNumber];
        short[][][] srcDataUshort = new short[sourcesNumber][][];
        short[][] dstDataUshort = dst.getShortDataArrays();
        short[][] sBandDataUshort = new short[sourcesNumber][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataUshort = new short[sourcesNumber][][];
            aBandDataUshort = new short[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataUshort = null;
            aBandDataUshort = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataUshort[i] = dataRA.getShortDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataUshort[i] = alphaRA.getShortDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || this.imageBeans[i].getRoi() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int b = 0; b < dstBands; ++b) {
            int dstX;
            int dPixelOffset;
            int s;
            int dstY;
            for (int s2 = 0; s2 < sourcesNumber; ++s2) {
                if (srcBean[s2].getDataRasterAccessor() != null) {
                    sBandDataUshort[s2] = srcDataUshort[s2][b];
                    sLineOffsets[s2] = srcBandOffsets[s2][b];
                }
                if (weightTypesUsed[s2] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                aBandDataUshort[s2] = alfaDataUshort[s2][0];
                aLineOffsets[s2] = alfaBandOffsets[s2][0];
            }
            short[] dBandDataUshort = dstDataUshort[b];
            int dLineOffset = dstBandOffsets[b];
            if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                    for (s = 0; s < sourcesNumber; ++s) {
                        if (srcBean[s].getDataRasterAccessor() != null) {
                            sPixelOffsets[s] = sLineOffsets[s];
                            int n = s;
                            sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                        }
                        if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                        aPixelOffsets[s] = aLineOffsets[s];
                        int n = s;
                        aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                    }
                    dPixelOffset = dLineOffset;
                    dLineOffset += dstLineStride;
                    for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                        boolean setDestinationFlag = false;
                        for (int s3 = 0; s3 < sourcesNumber; ++s3) {
                            RasterAccessor dataRA = srcBean[s3].getDataRasterAccessor();
                            if (dataRA == null) continue;
                            short sourceValueUshort = (short)(sBandDataUshort[s3][sPixelOffsets[s3]] & 0xFFFF);
                            int n = s3;
                            sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s3];
                            boolean isData = true;
                            if (this.hasNoData[s3]) {
                                Range noDataRangeUShort = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                boolean bl = isData = !noDataRangeUShort.contains(sourceValueUshort);
                            }
                            if (!isData) {
                                setDestinationFlag = false;
                            } else {
                                switch (weightTypesUsed[s3]) {
                                    case WEIGHT_TYPE_ALPHA: {
                                        setDestinationFlag = aBandDataUshort[s3][aPixelOffsets[s3]] != 0;
                                        int n2 = s3;
                                        aPixelOffsets[n2] = aPixelOffsets[n2] + alfaPixelStride[s3];
                                        break;
                                    }
                                    case WEIGHT_TYPE_ROI: {
                                        setDestinationFlag = srcBean[s3].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        setDestinationFlag = true;
                                    }
                                }
                            }
                            if (!setDestinationFlag) continue;
                            dBandDataUshort[dPixelOffset] = sourceValueUshort;
                            for (int k = s3 + 1; k < sourcesNumber; ++k) {
                                if (dataRA != null) {
                                    int n3 = k;
                                    sPixelOffsets[n3] = sPixelOffsets[n3] + srcPixelStride[k];
                                }
                                if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                                int n4 = k;
                                aPixelOffsets[n4] = aPixelOffsets[n4] + alfaPixelStride[k];
                            }
                            break;
                        }
                        if (!setDestinationFlag) {
                            dBandDataUshort[dPixelOffset] = this.destinationNoDataUShort[b];
                        }
                        dPixelOffset += dstPixelStride;
                    }
                }
                continue;
            }
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        sPixelOffsets[s] = sLineOffsets[s];
                        int n = s;
                        sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                dPixelOffset = dLineOffset;
                dLineOffset += dstLineStride;
                for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    double numerator = 0.0;
                    double denominator = 0.0;
                    for (int s4 = 0; s4 < sourcesNumber; ++s4) {
                        if (srcBean[s4].getDataRasterAccessor() == null) continue;
                        short sourceValueUshort = (short)(sBandDataUshort[s4][sPixelOffsets[s4]] & 0xFFFF);
                        int n = s4;
                        sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s4];
                        double weight = 0.0;
                        boolean isData = true;
                        if (this.hasNoData[s4]) {
                            Range noDataRangeUShort = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                            boolean bl = isData = !noDataRangeUShort.contains(sourceValueUshort);
                        }
                        if (!isData) {
                            weight = 0.0;
                        } else {
                            switch (weightTypesUsed[s4]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataUshort[s4][aPixelOffsets[s4]] & 0xFFFF;
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n5 = s4;
                                    aPixelOffsets[n5] = aPixelOffsets[n5] + alfaPixelStride[s4];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s4].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        numerator += weight * (double)sourceValueUshort;
                        denominator += weight;
                    }
                    dBandDataUshort[dPixelOffset] = denominator == 0.0 ? this.destinationNoDataUShort[b] : ImageUtil.clampRoundUShort((double)(numerator / denominator));
                    dPixelOffset += dstPixelStride;
                }
            }
        }
    }

    private void shortLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        Object aBandDataShort;
        Object alfaDataShort;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[] sLineOffsets = new int[sourcesNumber];
        int[] sPixelOffsets = new int[sourcesNumber];
        short[][][] srcDataShort = new short[sourcesNumber][][];
        short[][] dstDataShort = dst.getShortDataArrays();
        short[][] sBandDataShort = new short[sourcesNumber][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataShort = new short[sourcesNumber][][];
            aBandDataShort = new short[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataShort = null;
            aBandDataShort = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataShort[i] = dataRA.getShortDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataShort[i] = alphaRA.getShortDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || this.imageBeans[i].getRoi() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int b = 0; b < dstBands; ++b) {
            int dstX;
            int dPixelOffset;
            int s;
            int dstY;
            for (int s2 = 0; s2 < sourcesNumber; ++s2) {
                if (srcBean[s2].getDataRasterAccessor() != null) {
                    sBandDataShort[s2] = srcDataShort[s2][b];
                    sLineOffsets[s2] = srcBandOffsets[s2][b];
                }
                if (weightTypesUsed[s2] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                aBandDataShort[s2] = alfaDataShort[s2][0];
                aLineOffsets[s2] = alfaBandOffsets[s2][0];
            }
            short[] dBandDataShort = dstDataShort[b];
            int dLineOffset = dstBandOffsets[b];
            if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                    for (s = 0; s < sourcesNumber; ++s) {
                        if (srcBean[s].getDataRasterAccessor() != null) {
                            sPixelOffsets[s] = sLineOffsets[s];
                            int n = s;
                            sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                        }
                        if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                        aPixelOffsets[s] = aLineOffsets[s];
                        int n = s;
                        aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                    }
                    dPixelOffset = dLineOffset;
                    dLineOffset += dstLineStride;
                    for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                        boolean setDestinationFlag = false;
                        for (int s3 = 0; s3 < sourcesNumber; ++s3) {
                            RasterAccessor dataRA = srcBean[s3].getDataRasterAccessor();
                            if (dataRA == null) continue;
                            short sourceValueShort = sBandDataShort[s3][sPixelOffsets[s3]];
                            int n = s3;
                            sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s3];
                            boolean isData = true;
                            if (this.hasNoData[s3]) {
                                Range noDataRangeShort = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                boolean bl = isData = !noDataRangeShort.contains(sourceValueShort);
                            }
                            if (!isData) {
                                setDestinationFlag = false;
                            } else {
                                switch (weightTypesUsed[s3]) {
                                    case WEIGHT_TYPE_ALPHA: {
                                        setDestinationFlag = aBandDataShort[s3][aPixelOffsets[s3]] != 0;
                                        int n2 = s3;
                                        aPixelOffsets[n2] = aPixelOffsets[n2] + alfaPixelStride[s3];
                                        break;
                                    }
                                    case WEIGHT_TYPE_ROI: {
                                        setDestinationFlag = srcBean[s3].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        setDestinationFlag = true;
                                    }
                                }
                            }
                            if (!setDestinationFlag) continue;
                            dBandDataShort[dPixelOffset] = sourceValueShort;
                            for (int k = s3 + 1; k < sourcesNumber; ++k) {
                                if (dataRA != null) {
                                    int n3 = k;
                                    sPixelOffsets[n3] = sPixelOffsets[n3] + srcPixelStride[k];
                                }
                                if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                                int n4 = k;
                                aPixelOffsets[n4] = aPixelOffsets[n4] + alfaPixelStride[k];
                            }
                            break;
                        }
                        if (!setDestinationFlag) {
                            dBandDataShort[dPixelOffset] = this.destinationNoDataShort[b];
                        }
                        dPixelOffset += dstPixelStride;
                    }
                }
                continue;
            }
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        sPixelOffsets[s] = sLineOffsets[s];
                        int n = s;
                        sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                dPixelOffset = dLineOffset;
                dLineOffset += dstLineStride;
                for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    double numerator = 0.0;
                    double denominator = 0.0;
                    for (int s4 = 0; s4 < sourcesNumber; ++s4) {
                        if (srcBean[s4].getDataRasterAccessor() == null) continue;
                        short sourceValueShort = sBandDataShort[s4][sPixelOffsets[s4]];
                        int n = s4;
                        sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s4];
                        double weight = 0.0;
                        boolean isData = true;
                        if (this.hasNoData[s4]) {
                            Range noDataRangeShort = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                            boolean bl = isData = !noDataRangeShort.contains(sourceValueShort);
                        }
                        if (!isData) {
                            weight = 0.0;
                        } else {
                            switch (weightTypesUsed[s4]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataShort[s4][aPixelOffsets[s4]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n5 = s4;
                                    aPixelOffsets[n5] = aPixelOffsets[n5] + alfaPixelStride[s4];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s4].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        numerator += weight * (double)sourceValueShort;
                        denominator += weight;
                    }
                    dBandDataShort[dPixelOffset] = denominator == 0.0 ? this.destinationNoDataShort[b] : ImageUtil.clampRoundShort((double)(numerator / denominator));
                    dPixelOffset += dstPixelStride;
                }
            }
        }
    }

    private void intLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        Object aBandDataInt;
        Object alfaDataInt;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[] sLineOffsets = new int[sourcesNumber];
        int[] sPixelOffsets = new int[sourcesNumber];
        int[][][] srcDataInt = new int[sourcesNumber][][];
        int[][] dstDataInt = dst.getIntDataArrays();
        int[][] sBandDataInt = new int[sourcesNumber][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataInt = new int[sourcesNumber][][];
            aBandDataInt = new int[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataInt = null;
            aBandDataInt = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataInt[i] = dataRA.getIntDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataInt[i] = alphaRA.getIntDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || this.imageBeans[i].getRoi() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int b = 0; b < dstBands; ++b) {
            int dstX;
            int dPixelOffset;
            int s;
            int dstY;
            for (int s2 = 0; s2 < sourcesNumber; ++s2) {
                if (srcBean[s2].getDataRasterAccessor() != null) {
                    sBandDataInt[s2] = srcDataInt[s2][b];
                    sLineOffsets[s2] = srcBandOffsets[s2][b];
                }
                if (weightTypesUsed[s2] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                aBandDataInt[s2] = alfaDataInt[s2][0];
                aLineOffsets[s2] = alfaBandOffsets[s2][0];
            }
            int[] dBandDataInt = dstDataInt[b];
            int dLineOffset = dstBandOffsets[b];
            if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                    for (s = 0; s < sourcesNumber; ++s) {
                        if (srcBean[s].getDataRasterAccessor() != null) {
                            sPixelOffsets[s] = sLineOffsets[s];
                            int n = s;
                            sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                        }
                        if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                        aPixelOffsets[s] = aLineOffsets[s];
                        int n = s;
                        aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                    }
                    dPixelOffset = dLineOffset;
                    dLineOffset += dstLineStride;
                    for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                        boolean setDestinationFlag = false;
                        for (int s3 = 0; s3 < sourcesNumber; ++s3) {
                            RasterAccessor dataRA = srcBean[s3].getDataRasterAccessor();
                            if (dataRA == null) continue;
                            int sourceValueInt = sBandDataInt[s3][sPixelOffsets[s3]];
                            int n = s3;
                            sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s3];
                            boolean isData = true;
                            if (this.hasNoData[s3]) {
                                Range noDataRangeInt = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                boolean bl = isData = !noDataRangeInt.contains(sourceValueInt);
                            }
                            if (!isData) {
                                setDestinationFlag = false;
                            } else {
                                switch (weightTypesUsed[s3]) {
                                    case WEIGHT_TYPE_ALPHA: {
                                        setDestinationFlag = aBandDataInt[s3][aPixelOffsets[s3]] != 0;
                                        int n2 = s3;
                                        aPixelOffsets[n2] = aPixelOffsets[n2] + alfaPixelStride[s3];
                                        break;
                                    }
                                    case WEIGHT_TYPE_ROI: {
                                        setDestinationFlag = srcBean[s3].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        setDestinationFlag = true;
                                    }
                                }
                            }
                            if (!setDestinationFlag) continue;
                            dBandDataInt[dPixelOffset] = sourceValueInt;
                            for (int k = s3 + 1; k < sourcesNumber; ++k) {
                                if (dataRA != null) {
                                    int n3 = k;
                                    sPixelOffsets[n3] = sPixelOffsets[n3] + srcPixelStride[k];
                                }
                                if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                                int n4 = k;
                                aPixelOffsets[n4] = aPixelOffsets[n4] + alfaPixelStride[k];
                            }
                            break;
                        }
                        if (!setDestinationFlag) {
                            dBandDataInt[dPixelOffset] = this.destinationNoDataInt[b];
                        }
                        dPixelOffset += dstPixelStride;
                    }
                }
                continue;
            }
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        sPixelOffsets[s] = sLineOffsets[s];
                        int n = s;
                        sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                dPixelOffset = dLineOffset;
                dLineOffset += dstLineStride;
                for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    double numerator = 0.0;
                    double denominator = 0.0;
                    for (int s4 = 0; s4 < sourcesNumber; ++s4) {
                        if (srcBean[s4].getDataRasterAccessor() == null) continue;
                        int sourceValueInt = sBandDataInt[s4][sPixelOffsets[s4]];
                        int n = s4;
                        sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s4];
                        double weight = 0.0;
                        boolean isData = true;
                        if (this.hasNoData[s4]) {
                            Range noDataRangeInt = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                            boolean bl = isData = !noDataRangeInt.contains(sourceValueInt);
                        }
                        if (!isData) {
                            weight = 0.0;
                        } else {
                            switch (weightTypesUsed[s4]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataInt[s4][aPixelOffsets[s4]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n5 = s4;
                                    aPixelOffsets[n5] = aPixelOffsets[n5] + alfaPixelStride[s4];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s4].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        numerator += weight * (double)sourceValueInt;
                        denominator += weight;
                    }
                    dBandDataInt[dPixelOffset] = denominator == 0.0 ? this.destinationNoDataInt[b] : ImageUtil.clampRoundInt((double)(numerator / denominator));
                    dPixelOffset += dstPixelStride;
                }
            }
        }
    }

    private void floatLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        Object aBandDataFloat;
        Object alfaDataFloat;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[] sLineOffsets = new int[sourcesNumber];
        int[] sPixelOffsets = new int[sourcesNumber];
        float[][][] srcDataFloat = new float[sourcesNumber][][];
        float[][] dstDataFloat = dst.getFloatDataArrays();
        float[][] sBandDataFloat = new float[sourcesNumber][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataFloat = new float[sourcesNumber][][];
            aBandDataFloat = new float[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataFloat = null;
            aBandDataFloat = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataFloat[i] = dataRA.getFloatDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataFloat[i] = alphaRA.getFloatDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || this.imageBeans[i].getRoi() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int b = 0; b < dstBands; ++b) {
            int dstX;
            int dPixelOffset;
            int s;
            int dstY;
            for (int s2 = 0; s2 < sourcesNumber; ++s2) {
                if (srcBean[s2].getDataRasterAccessor() != null) {
                    sBandDataFloat[s2] = srcDataFloat[s2][b];
                    sLineOffsets[s2] = srcBandOffsets[s2][b];
                }
                if (weightTypesUsed[s2] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                aBandDataFloat[s2] = alfaDataFloat[s2][0];
                aLineOffsets[s2] = alfaBandOffsets[s2][0];
            }
            float[] dBandDataFloat = dstDataFloat[b];
            int dLineOffset = dstBandOffsets[b];
            if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                    for (s = 0; s < sourcesNumber; ++s) {
                        if (srcBean[s].getDataRasterAccessor() != null) {
                            sPixelOffsets[s] = sLineOffsets[s];
                            int n = s;
                            sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                        }
                        if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                        aPixelOffsets[s] = aLineOffsets[s];
                        int n = s;
                        aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                    }
                    dPixelOffset = dLineOffset;
                    dLineOffset += dstLineStride;
                    for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                        boolean setDestinationFlag = false;
                        for (int s3 = 0; s3 < sourcesNumber; ++s3) {
                            Range noDataRangeFloat;
                            RasterAccessor dataRA = srcBean[s3].getDataRasterAccessor();
                            if (dataRA == null) continue;
                            float sourceValueFloat = sBandDataFloat[s3][sPixelOffsets[s3]];
                            int n = s3;
                            sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s3];
                            boolean isData = true;
                            if (this.hasNoData[s3] && (noDataRangeFloat = srcBean[s3].getSourceNoDataRangeRasterAccessor()) != null) {
                                boolean bl = isData = !noDataRangeFloat.contains(sourceValueFloat);
                            }
                            if (!isData) {
                                setDestinationFlag = false;
                            } else {
                                switch (weightTypesUsed[s3]) {
                                    case WEIGHT_TYPE_ALPHA: {
                                        setDestinationFlag = aBandDataFloat[s3][aPixelOffsets[s3]] != 0.0f;
                                        int n2 = s3;
                                        aPixelOffsets[n2] = aPixelOffsets[n2] + alfaPixelStride[s3];
                                        break;
                                    }
                                    case WEIGHT_TYPE_ROI: {
                                        setDestinationFlag = srcBean[s3].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        setDestinationFlag = true;
                                    }
                                }
                            }
                            if (!setDestinationFlag) continue;
                            dBandDataFloat[dPixelOffset] = sourceValueFloat;
                            for (int k = s3 + 1; k < sourcesNumber; ++k) {
                                if (dataRA != null) {
                                    int n3 = k;
                                    sPixelOffsets[n3] = sPixelOffsets[n3] + srcPixelStride[k];
                                }
                                if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                                int n4 = k;
                                aPixelOffsets[n4] = aPixelOffsets[n4] + alfaPixelStride[k];
                            }
                            break;
                        }
                        if (!setDestinationFlag) {
                            dBandDataFloat[dPixelOffset] = this.destinationNoDataFloat[b];
                        }
                        dPixelOffset += dstPixelStride;
                    }
                }
                continue;
            }
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        sPixelOffsets[s] = sLineOffsets[s];
                        int n = s;
                        sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                dPixelOffset = dLineOffset;
                dLineOffset += dstLineStride;
                for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    double numerator = 0.0;
                    double denominator = 0.0;
                    for (int s4 = 0; s4 < sourcesNumber; ++s4) {
                        Range noDataRangeFloat;
                        if (srcBean[s4].getDataRasterAccessor() == null) continue;
                        float sourceValueFloat = sBandDataFloat[s4][sPixelOffsets[s4]];
                        int n = s4;
                        sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s4];
                        double weight = 0.0;
                        boolean isData = true;
                        if (this.hasNoData[s4] && (noDataRangeFloat = srcBean[s4].getSourceNoDataRangeRasterAccessor()) != null) {
                            boolean bl = isData = !noDataRangeFloat.contains(sourceValueFloat);
                        }
                        if (!isData) {
                            weight = 0.0;
                        } else {
                            switch (weightTypesUsed[s4]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataFloat[s4][aPixelOffsets[s4]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n5 = s4;
                                    aPixelOffsets[n5] = aPixelOffsets[n5] + alfaPixelStride[s4];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s4].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        if (isData) {
                            numerator += weight * (double)sourceValueFloat;
                        }
                        denominator += weight;
                    }
                    dBandDataFloat[dPixelOffset] = denominator == 0.0 ? this.destinationNoDataFloat[b] : ImageUtil.clampFloat((double)(numerator / denominator));
                    dPixelOffset += dstPixelStride;
                }
            }
        }
    }

    private void doubleLoop(RasterBeanAccessor[] srcBean, RasterAccessor dst) {
        Object aBandDataDouble;
        Object alfaDataDouble;
        int[] aPixelOffsets;
        int[] aLineOffsets;
        Object alfaBandOffsets;
        int[] alfaPixelStride;
        int[] alfaLineStride;
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[] sLineOffsets = new int[sourcesNumber];
        int[] sPixelOffsets = new int[sourcesNumber];
        double[][][] srcDataDouble = new double[sourcesNumber][][];
        double[][] dstDataDouble = dst.getDoubleDataArrays();
        double[][] sBandDataDouble = new double[sourcesNumber][];
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
            alfaDataDouble = new double[sourcesNumber][][];
            aBandDataDouble = new double[sourcesNumber][];
        } else {
            alfaLineStride = null;
            alfaPixelStride = null;
            alfaBandOffsets = null;
            aLineOffsets = null;
            aPixelOffsets = null;
            alfaDataDouble = null;
            aBandDataDouble = null;
        }
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            RasterAccessor dataRA = srcBean[i].getDataRasterAccessor();
            if (dataRA == null) continue;
            srcLineStride[i] = dataRA.getScanlineStride();
            srcPixelStride[i] = dataRA.getPixelStride();
            srcBandOffsets[i] = dataRA.getBandOffsets();
            srcDataDouble[i] = dataRA.getDoubleDataArrays();
            RasterAccessor alphaRA = srcBean[i].getAlphaRasterAccessor();
            if (alphaPresentinRaster & alphaRA != null) {
                alfaDataDouble[i] = alphaRA.getDoubleDataArrays();
                alfaBandOffsets[i] = alphaRA.getBandOffsets();
                alfaPixelStride[i] = alphaRA.getPixelStride();
                alfaLineStride[i] = alphaRA.getScanlineStride();
            }
            if (alphaRA != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || this.imageBeans[i].getRoi() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        for (int b = 0; b < dstBands; ++b) {
            int dstX;
            int dPixelOffset;
            int s;
            int dstY;
            for (int s2 = 0; s2 < sourcesNumber; ++s2) {
                if (srcBean[s2].getDataRasterAccessor() != null) {
                    sBandDataDouble[s2] = srcDataDouble[s2][b];
                    sLineOffsets[s2] = srcBandOffsets[s2][b];
                }
                if (weightTypesUsed[s2] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                aBandDataDouble[s2] = alfaDataDouble[s2][0];
                aLineOffsets[s2] = alfaBandOffsets[s2][0];
            }
            double[] dBandDataDouble = dstDataDouble[b];
            int dLineOffset = dstBandOffsets[b];
            if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                    for (s = 0; s < sourcesNumber; ++s) {
                        if (srcBean[s].getDataRasterAccessor() != null) {
                            sPixelOffsets[s] = sLineOffsets[s];
                            int n = s;
                            sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                        }
                        if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                        aPixelOffsets[s] = aLineOffsets[s];
                        int n = s;
                        aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                    }
                    dPixelOffset = dLineOffset;
                    dLineOffset += dstLineStride;
                    for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                        boolean setDestinationFlag = false;
                        for (int s3 = 0; s3 < sourcesNumber; ++s3) {
                            Range noDataRangeDouble;
                            RasterAccessor dataRA = srcBean[s3].getDataRasterAccessor();
                            if (dataRA == null) continue;
                            double sourceValueDouble = sBandDataDouble[s3][sPixelOffsets[s3]];
                            int n = s3;
                            sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s3];
                            boolean isData = true;
                            if (this.hasNoData[s3] && (noDataRangeDouble = srcBean[s3].getSourceNoDataRangeRasterAccessor()) != null) {
                                boolean bl = isData = !noDataRangeDouble.contains(sourceValueDouble);
                            }
                            if (!isData) {
                                setDestinationFlag = false;
                            } else {
                                switch (weightTypesUsed[s3]) {
                                    case WEIGHT_TYPE_ALPHA: {
                                        setDestinationFlag = aBandDataDouble[s3][aPixelOffsets[s3]] != 0.0;
                                        int n2 = s3;
                                        aPixelOffsets[n2] = aPixelOffsets[n2] + alfaPixelStride[s3];
                                        break;
                                    }
                                    case WEIGHT_TYPE_ROI: {
                                        setDestinationFlag = srcBean[s3].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        setDestinationFlag = true;
                                    }
                                }
                            }
                            if (!setDestinationFlag) continue;
                            dBandDataDouble[dPixelOffset] = sourceValueDouble;
                            for (int k = s3 + 1; k < sourcesNumber; ++k) {
                                if (dataRA != null) {
                                    int n3 = k;
                                    sPixelOffsets[n3] = sPixelOffsets[n3] + srcPixelStride[k];
                                }
                                if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                                int n4 = k;
                                aPixelOffsets[n4] = aPixelOffsets[n4] + alfaPixelStride[k];
                            }
                            break;
                        }
                        if (!setDestinationFlag) {
                            dBandDataDouble[dPixelOffset] = this.destinationNoDataDouble[b];
                        }
                        dPixelOffset += dstPixelStride;
                    }
                }
                continue;
            }
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        sPixelOffsets[s] = sLineOffsets[s];
                        int n = s;
                        sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                dPixelOffset = dLineOffset;
                dLineOffset += dstLineStride;
                for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    double numerator = 0.0;
                    double denominator = 0.0;
                    for (int s4 = 0; s4 < sourcesNumber; ++s4) {
                        Range noDataRangeDouble;
                        if (srcBean[s4].getDataRasterAccessor() == null) continue;
                        double sourceValueDouble = sBandDataDouble[s4][sPixelOffsets[s4]];
                        int n = s4;
                        sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s4];
                        double weight = 0.0;
                        boolean isData = true;
                        if (this.hasNoData[s4] && (noDataRangeDouble = srcBean[s4].getSourceNoDataRangeRasterAccessor()) != null) {
                            boolean bl = isData = !noDataRangeDouble.contains(sourceValueDouble);
                        }
                        if (!isData) {
                            weight = 0.0;
                        } else {
                            switch (weightTypesUsed[s4]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    weight = aBandDataDouble[s4][aPixelOffsets[s4]];
                                    weight = weight > 0.0 && this.isAlphaBitmaskUsed ? 1.0 : (weight /= 255.0);
                                    int n5 = s4;
                                    aPixelOffsets[n5] = aPixelOffsets[n5] + alfaPixelStride[s4];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s4].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        if (isData) {
                            numerator += weight * sourceValueDouble;
                        }
                        denominator += weight;
                    }
                    dBandDataDouble[dPixelOffset] = denominator == 0.0 ? this.destinationNoDataDouble[b] : numerator / denominator;
                    dPixelOffset += dstPixelStride;
                }
            }
        }
    }

    public Rectangle mapDestRect(Rectangle destRectangle, int sourceRasterIndex) {
        if (destRectangle == null) {
            throw new IllegalArgumentException("Destination rectangle is not defined");
        }
        if (sourceRasterIndex < 0 || sourceRasterIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index must be between 0 and source dimension-1");
        }
        return destRectangle.intersection(this.getSourceImage(sourceRasterIndex).getBounds());
    }

    public Rectangle mapSourceRect(Rectangle sourceRectangle, int sourceRasterIndex) {
        if (sourceRectangle == null) {
            throw new IllegalArgumentException("Destination rectangle is not defined");
        }
        if (sourceRasterIndex < 0 || sourceRasterIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index must be between 0 and source dimension-1");
        }
        return sourceRectangle.intersection(this.getBounds());
    }

    private static class RasterBeanAccessor {
        private RasterAccessor dataRasterAccessor;
        private RasterAccessor alphaRasterAccessor;
        private Raster roiRaster;
        private Range sourceNoDataRangeRasterAccessor;

        RasterBeanAccessor() {
        }

        public RasterAccessor getDataRasterAccessor() {
            return this.dataRasterAccessor;
        }

        public void setDataRasterAccessor(RasterAccessor dataRasterAccessor) {
            this.dataRasterAccessor = dataRasterAccessor;
        }

        public RasterAccessor getAlphaRasterAccessor() {
            return this.alphaRasterAccessor;
        }

        public void setAlphaRasterAccessor(RasterAccessor alphaRasterAccessor) {
            this.alphaRasterAccessor = alphaRasterAccessor;
        }

        public Raster getRoiRaster() {
            return this.roiRaster;
        }

        public void setRoiRaster(Raster roiRaster) {
            this.roiRaster = roiRaster;
        }

        public Range getSourceNoDataRangeRasterAccessor() {
            return this.sourceNoDataRangeRasterAccessor;
        }

        public void setSourceNoDataRangeRasterAccessor(Range sourceNoDataRangeRasterAccessor) {
            this.sourceNoDataRangeRasterAccessor = sourceNoDataRangeRasterAccessor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WeightType {
        WEIGHT_TYPE_ALPHA,
        WEIGHT_TYPE_ROI,
        WEIGHT_TYPE_NODATA;

    }
}

