/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.mosaic.ImageMosaicBean;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

public class MosaicOpImage2
extends OpImage {
    public static final Number[] DEFAULT_DESTINATION_NO_DATA_VALUE = new Number[]{0};
    private MosaicType mosaicTypeSelected;
    private int numBands;
    private ImageMosaicBean[] imageBeans;
    private boolean roiPresent;
    private boolean isAlphaBitmaskUsed;
    private boolean alphaPresent;
    private BorderExtender sourceBorderExtender;
    private BorderExtender zeroBorderExtender;
    private Number[] destinationNoData;

    private static final ImageLayout checkLayout(List sources, ImageLayout layout) {
        int i;
        RenderedImage sourceImage = null;
        SampleModel targetSampleModel = null;
        ColorModel targetColorModel = null;
        int numSources = sources.size();
        if (numSources > 0) {
            sourceImage = (RenderedImage)sources.get(0);
            targetSampleModel = sourceImage.getSampleModel();
            targetColorModel = sourceImage.getColorModel();
        } else if (layout != null && layout.isValid(268)) {
            targetSampleModel = layout.getSampleModel(null);
            if (targetSampleModel == null) {
                throw new IllegalArgumentException("No sample model present");
            }
        } else {
            throw new IllegalArgumentException("Layout not valid");
        }
        int dataType = targetSampleModel.getDataType();
        int bandNumber = targetSampleModel.getNumBands();
        int sampleSize = targetSampleModel.getSampleSize(0);
        for (i = 1; i < bandNumber; ++i) {
            if (targetSampleModel.getSampleSize(i) == sampleSize) continue;
            throw new IllegalArgumentException("Sample size is not the same for every band");
        }
        if (numSources < 1) {
            return (ImageLayout)layout.clone();
        }
        for (i = 1; i < numSources; ++i) {
            RenderedImage sourceData = (RenderedImage)sources.get(i);
            SampleModel sourceSampleModel = sourceData.getSampleModel();
            if (sourceSampleModel.getDataType() != dataType) {
                throw new IllegalArgumentException("Data type is not the same for every source");
            }
            if (sourceSampleModel.getNumBands() != bandNumber) {
                throw new IllegalArgumentException("Bands number is not the same for every source");
            }
            for (int j = 0; j < bandNumber; ++j) {
                if (sourceSampleModel.getSampleSize(j) == sampleSize) continue;
                throw new IllegalArgumentException("Sample size is not the same for every band");
            }
        }
        ImageLayout mosaicLayout = layout == null ? new ImageLayout() : (ImageLayout)layout.clone();
        Rectangle mosaicBounds = new Rectangle();
        if (mosaicLayout.isValid(15)) {
            mosaicBounds.setBounds(mosaicLayout.getMinX(null), mosaicLayout.getMinY(null), mosaicLayout.getWidth(null), mosaicLayout.getHeight(null));
        } else if (numSources > 0) {
            mosaicBounds.setBounds(sourceImage.getMinX(), sourceImage.getMinY(), sourceImage.getWidth(), sourceImage.getHeight());
            for (int i2 = 1; i2 < numSources; ++i2) {
                RenderedImage source = (RenderedImage)sources.get(i2);
                Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
                mosaicBounds = mosaicBounds.union(sourceBounds);
            }
        }
        mosaicLayout.setMinX(mosaicBounds.x);
        mosaicLayout.setMinY(mosaicBounds.y);
        mosaicLayout.setWidth(mosaicBounds.width);
        mosaicLayout.setHeight(mosaicBounds.height);
        if (mosaicLayout.isValid(256)) {
            SampleModel destSampleModel = mosaicLayout.getSampleModel(null);
            boolean unsetSampleModel = destSampleModel.getNumBands() != bandNumber || destSampleModel.getDataType() != dataType;
            for (int i3 = 0; !unsetSampleModel && i3 < bandNumber; ++i3) {
                if (destSampleModel.getSampleSize(i3) == sampleSize) continue;
                unsetSampleModel = true;
            }
            if (unsetSampleModel) {
                mosaicLayout.unsetValid(256);
            }
        }
        return mosaicLayout;
    }

    public MosaicOpImage2(List sources, ImageLayout layout, Map renderingHints, ImageMosaicBean[] images, MosaicType mosaicTypeSelected, Number[] destinationNoData) {
        super((Vector)sources, MosaicOpImage2.checkLayout(sources, layout), renderingHints, true);
        double sourceExtensionBorder;
        int i;
        if (sources.size() != images.length) {
            throw new IllegalArgumentException("Source and images must have the same length");
        }
        int dataType = this.sampleModel.getDataType();
        this.numBands = this.sampleModel.getNumBands();
        int numSources = this.getNumSources();
        this.mosaicTypeSelected = mosaicTypeSelected;
        this.imageBeans = images;
        this.roiPresent = false;
        this.alphaPresent = false;
        ArrayList<PlanarImage> alphaList = new ArrayList<PlanarImage>();
        for (i = 0; i < numSources; ++i) {
            PlanarImage alpha = this.imageBeans[i].getAlphaChannel();
            alphaList.add(alpha);
            ROI imageROI = this.imageBeans[i].getRoi();
            if (alpha != null) {
                this.alphaPresent = true;
                SampleModel alphaSampleModel = alpha.getSampleModel();
                if (alphaSampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException("Alpha bands number must be 1");
                }
                if (alphaSampleModel.getDataType() != this.sampleModel.getDataType()) {
                    throw new IllegalArgumentException("Alpha sample model dataType and Source sample model dataTypes must be equal");
                }
                if (alphaSampleModel.getSampleSize(0) != this.sampleModel.getSampleSize(0)) {
                    throw new IllegalArgumentException("Alpha sample model sampleSize and Source sample model sampleSize must be equal");
                }
            }
            if (imageROI == null) continue;
            this.roiPresent = true;
        }
        boolean bl = this.isAlphaBitmaskUsed = mosaicTypeSelected != MosaicDescriptor.MOSAIC_TYPE_BLEND || !this.alphaPresent || alphaList.size() < numSources;
        if (!this.isAlphaBitmaskUsed) {
            for (i = 0; i < numSources; ++i) {
                if (alphaList.get(i) != null) continue;
                this.isAlphaBitmaskUsed = true;
                break;
            }
        }
        switch (dataType) {
            case 0: {
                sourceExtensionBorder = 0.0;
                break;
            }
            case 1: {
                sourceExtensionBorder = 0.0;
                break;
            }
            case 2: {
                sourceExtensionBorder = -32768.0;
                break;
            }
            case 3: {
                sourceExtensionBorder = -2.147483648E9;
                break;
            }
            case 4: {
                sourceExtensionBorder = -3.4028234663852886E38;
                break;
            }
            default: {
                sourceExtensionBorder = -1.7976931348623157E308;
            }
        }
        Object object = this.sourceBorderExtender = sourceExtensionBorder == 0.0 ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(new double[]{sourceExtensionBorder});
        if (this.alphaPresent || this.roiPresent) {
            this.zeroBorderExtender = BorderExtender.createInstance((int)0);
        }
        this.destinationNoData = destinationNoData == null ? DEFAULT_DESTINATION_NO_DATA_VALUE : new Number[this.numBands];
        if (destinationNoData.length < this.numBands) {
            Arrays.fill(this.destinationNoData, destinationNoData[0]);
        } else {
            System.arraycopy(destinationNoData, 0, this.destinationNoData, 0, this.numBands);
        }
    }

    public Raster computeTile(int tileX, int tileY) {
        int i;
        WritableRaster destRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(tileX), this.tileYToY(tileY)));
        Rectangle destRectangle = this.getTileRect(tileX, tileY);
        int numSources = this.getNumSources();
        RasterBean[] rasterBeanArray = new RasterBean[numSources];
        for (i = 0; i < numSources; ++i) {
            PlanarImage source = this.getSourceImage(i);
            Rectangle srcRect = this.mapDestRect(destRectangle, i);
            Raster data = srcRect != null && srcRect.isEmpty() ? null : source.getExtendedData(destRectangle, this.sourceBorderExtender);
            RasterBean tempBean = new RasterBean();
            tempBean.setDataRaster(data);
            tempBean.setSourceNoDataRangeRaster(this.imageBeans[i].getSourceNoData());
            rasterBeanArray[i] = tempBean;
            if (data == null) continue;
            PlanarImage alpha = this.imageBeans[i].getAlphaChannel();
            if (this.alphaPresent && alpha != null) {
                rasterBeanArray[i].setAlphaRaster(alpha.getExtendedData(destRectangle, this.zeroBorderExtender));
            }
            ROI roi = this.imageBeans[i].getRoi();
            if (!this.roiPresent || roi == null) continue;
            rasterBeanArray[i].setRoiRaster(roi.getAsImage().getExtendedData(destRectangle, this.zeroBorderExtender));
        }
        this.computeRect(rasterBeanArray, destRaster, destRectangle);
        for (i = 0; i < numSources; ++i) {
            PlanarImage source;
            Raster sourceData = rasterBeanArray[i].getDataRaster();
            if (sourceData == null || !(source = this.getSourceImage(i)).overlapsMultipleTiles(sourceData.getBounds())) continue;
            this.recycleTile(sourceData);
        }
        return destRaster;
    }

    private void computeRect(RasterBean[] rasterBeanArray, WritableRaster destRaster, Rectangle destRectangle) {
        int sourcesNumber = rasterBeanArray.length;
        ArrayList<Raster> listRasterSource = new ArrayList<Raster>(sourcesNumber);
        for (int i = 0; i < sourcesNumber; ++i) {
            if (rasterBeanArray[i].getDataRaster() == null) continue;
            listRasterSource.add(rasterBeanArray[i].getDataRaster());
        }
        int notNullSources = listRasterSource.size();
        if (notNullSources == 0) {
            double[] noSourceFiller = new double[this.destinationNoData.length];
            for (int i = 0; i < this.destinationNoData.length; ++i) {
                noSourceFiller[i] = this.destinationNoData[i].doubleValue();
            }
            ImageUtil.fillBackground((WritableRaster)destRaster, (Rectangle)destRectangle, (double[])noSourceFiller);
            return;
        }
        SampleModel[] sourceSampleModels = new SampleModel[notNullSources];
        for (int i = 0; i < notNullSources; ++i) {
            sourceSampleModels[i] = ((Raster)listRasterSource.get(i)).getSampleModel();
        }
        int rasterAccessFormatTagID = RasterAccessor.findCompatibleTag((SampleModel[])sourceSampleModels, (SampleModel)destRaster.getSampleModel());
        RasterBeanAccessor[] sourceAccessorsArrayBean = new RasterBeanAccessor[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            Raster alphaRaster;
            RasterBeanAccessor helpAccessor = new RasterBeanAccessor();
            if (rasterBeanArray[i].getDataRaster() != null) {
                RasterFormatTag formatTag = new RasterFormatTag(rasterBeanArray[i].getDataRaster().getSampleModel(), rasterAccessFormatTagID);
                helpAccessor.setDataRasterAccessor(new RasterAccessor(rasterBeanArray[i].getDataRaster(), destRectangle, formatTag, null));
            }
            if ((alphaRaster = rasterBeanArray[i].getAlphaRaster()) != null) {
                SampleModel alphaSampleModel = alphaRaster.getSampleModel();
                int alphaFormatTagID = RasterAccessor.findCompatibleTag(null, (SampleModel)alphaSampleModel);
                RasterFormatTag alphaFormatTag = new RasterFormatTag(alphaSampleModel, alphaFormatTagID);
                helpAccessor.setAlphaRasterAccessor(new RasterAccessor(alphaRaster, destRectangle, alphaFormatTag, this.imageBeans[i].getAlphaChannel().getColorModel()));
            }
            helpAccessor.setRoiRaster(rasterBeanArray[i].getRoiRaster());
            helpAccessor.setSourceNoDataRangeRasterAccessor(rasterBeanArray[i].getSourceNoDataRangeRaster());
            sourceAccessorsArrayBean[i] = helpAccessor;
        }
        RasterAccessor destinationAccessor = new RasterAccessor((Raster)destRaster, destRectangle, new RasterFormatTag(destRaster.getSampleModel(), rasterAccessFormatTagID), null);
        this.computeRectType(sourceAccessorsArrayBean, destinationAccessor, destinationAccessor.getDataType());
        destinationAccessor.copyDataToRaster();
    }

    private void computeRectType(RasterBeanAccessor[] srcBean, RasterAccessor dst, int dataType) {
        int sourcesNumber = srcBean.length;
        int[] srcLineStride = new int[sourcesNumber];
        int[] srcPixelStride = new int[sourcesNumber];
        int[][] srcBandOffsets = new int[sourcesNumber][];
        int[] sLineOffsets = new int[sourcesNumber];
        int[] sPixelOffsets = new int[sourcesNumber];
        Object srcDataByte = null;
        Object srcDataUShort = null;
        Object srcDataShort = null;
        Object srcDataInt = null;
        Object srcDataFloat = null;
        Object srcDataDouble = null;
        Object alfaDataByte = null;
        Object alfaDataUShort = null;
        Object alfaDataShort = null;
        Object alfaDataInt = null;
        Object alfaDataFloat = null;
        Object alfaDataDouble = null;
        byte[][] dstDataByte = null;
        short[][] dstDataUShort = null;
        short[][] dstDataShort = null;
        int[][] dstDataInt = null;
        float[][] dstDataFloat = null;
        double[][] dstDataDouble = null;
        Object sBandDataByte = null;
        Object sBandDataUShort = null;
        Object sBandDataShort = null;
        Object sBandDataInt = null;
        Object sBandDataFloat = null;
        Object sBandDataDouble = null;
        Object aBandDataByte = null;
        Object aBandDataUShort = null;
        Object aBandDataShort = null;
        Object aBandDataInt = null;
        Object aBandDataFloat = null;
        Object aBandDataDouble = null;
        boolean alphaPresentinRaster = false;
        for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getAlphaRasterAccessor() == null) continue;
            alphaPresentinRaster = true;
            break;
        }
        int[] alfaLineStride = null;
        int[] alfaPixelStride = null;
        Object alfaBandOffsets = null;
        int[] aLineOffsets = null;
        int[] aPixelOffsets = null;
        if (alphaPresentinRaster) {
            alfaLineStride = new int[sourcesNumber];
            alfaPixelStride = new int[sourcesNumber];
            alfaBandOffsets = new int[sourcesNumber][];
            aLineOffsets = new int[sourcesNumber];
            aPixelOffsets = new int[sourcesNumber];
        }
        switch (dataType) {
            case 0: {
                srcDataByte = new byte[sourcesNumber][][];
                dstDataByte = dst.getByteDataArrays();
                sBandDataByte = new byte[sourcesNumber][];
                if (!alphaPresentinRaster) break;
                alfaDataByte = new byte[sourcesNumber][][];
                aBandDataByte = new byte[sourcesNumber][];
                break;
            }
            case 1: {
                srcDataUShort = new short[sourcesNumber][][];
                dstDataUShort = dst.getShortDataArrays();
                sBandDataUShort = new short[sourcesNumber][];
                if (!alphaPresentinRaster) break;
                alfaDataUShort = new short[sourcesNumber][][];
                aBandDataUShort = new short[sourcesNumber][];
                break;
            }
            case 2: {
                srcDataShort = new short[sourcesNumber][][];
                dstDataShort = dst.getShortDataArrays();
                sBandDataShort = new short[sourcesNumber][];
                if (!alphaPresentinRaster) break;
                alfaDataShort = new short[sourcesNumber][][];
                aBandDataShort = new short[sourcesNumber][];
                break;
            }
            case 3: {
                srcDataInt = new int[sourcesNumber][][];
                dstDataInt = dst.getIntDataArrays();
                sBandDataInt = new int[sourcesNumber][];
                if (!alphaPresentinRaster) break;
                alfaDataInt = new int[sourcesNumber][][];
                aBandDataInt = new int[sourcesNumber][];
                break;
            }
            case 4: {
                srcDataFloat = new float[sourcesNumber][][];
                dstDataFloat = dst.getFloatDataArrays();
                sBandDataFloat = new float[sourcesNumber][];
                if (!alphaPresentinRaster) break;
                alfaDataFloat = new float[sourcesNumber][][];
                aBandDataFloat = new float[sourcesNumber][];
                break;
            }
            case 5: {
                srcDataDouble = new double[sourcesNumber][][];
                dstDataDouble = dst.getDoubleDataArrays();
                sBandDataDouble = new double[sourcesNumber][];
                if (!alphaPresentinRaster) break;
                alfaDataDouble = new double[sourcesNumber][][];
                aBandDataDouble = new double[sourcesNumber][];
            }
        }
        block137: for (int i = 0; i < sourcesNumber; ++i) {
            if (srcBean[i].getDataRasterAccessor() == null) continue;
            srcLineStride[i] = srcBean[i].getDataRasterAccessor().getScanlineStride();
            srcPixelStride[i] = srcBean[i].getDataRasterAccessor().getPixelStride();
            srcBandOffsets[i] = srcBean[i].getDataRasterAccessor().getBandOffsets();
            switch (dataType) {
                case 0: {
                    srcDataByte[i] = srcBean[i].getDataRasterAccessor().getByteDataArrays();
                    if (!(alphaPresentinRaster & srcBean[i].getAlphaRasterAccessor() != null)) continue block137;
                    alfaDataByte[i] = srcBean[i].getAlphaRasterAccessor().getByteDataArrays();
                    alfaBandOffsets[i] = srcBean[i].getAlphaRasterAccessor().getBandOffsets();
                    continue block137;
                }
                case 1: {
                    srcDataUShort[i] = srcBean[i].getDataRasterAccessor().getShortDataArrays();
                    if (!(alphaPresentinRaster & srcBean[i].getAlphaRasterAccessor() != null)) continue block137;
                    alfaDataUShort[i] = srcBean[i].getAlphaRasterAccessor().getShortDataArrays();
                    alfaBandOffsets[i] = srcBean[i].getAlphaRasterAccessor().getBandOffsets();
                    continue block137;
                }
                case 2: {
                    srcDataShort[i] = srcBean[i].getDataRasterAccessor().getShortDataArrays();
                    if (!(alphaPresentinRaster & srcBean[i].getAlphaRasterAccessor() != null)) continue block137;
                    alfaDataShort[i] = srcBean[i].getAlphaRasterAccessor().getShortDataArrays();
                    alfaBandOffsets[i] = srcBean[i].getAlphaRasterAccessor().getBandOffsets();
                    continue block137;
                }
                case 3: {
                    srcDataInt[i] = srcBean[i].getDataRasterAccessor().getIntDataArrays();
                    if (!(alphaPresentinRaster & srcBean[i].getAlphaRasterAccessor() != null)) continue block137;
                    alfaDataInt[i] = srcBean[i].getAlphaRasterAccessor().getIntDataArrays();
                    alfaBandOffsets[i] = srcBean[i].getAlphaRasterAccessor().getBandOffsets();
                    continue block137;
                }
                case 4: {
                    srcDataFloat[i] = srcBean[i].getDataRasterAccessor().getFloatDataArrays();
                    if (!(alphaPresentinRaster & srcBean[i].getAlphaRasterAccessor() != null)) continue block137;
                    alfaDataFloat[i] = srcBean[i].getAlphaRasterAccessor().getFloatDataArrays();
                    alfaBandOffsets[i] = srcBean[i].getAlphaRasterAccessor().getBandOffsets();
                    continue block137;
                }
                case 5: {
                    srcDataDouble[i] = srcBean[i].getDataRasterAccessor().getDoubleDataArrays();
                    if (!(alphaPresentinRaster & srcBean[i].getAlphaRasterAccessor() != null)) continue block137;
                    alfaDataDouble[i] = srcBean[i].getAlphaRasterAccessor().getDoubleDataArrays();
                    alfaBandOffsets[i] = srcBean[i].getAlphaRasterAccessor().getBandOffsets();
                }
            }
        }
        int dstMinX = dst.getX();
        int dstMinY = dst.getY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstMaxX = dstMinX + dstWidth;
        int dstMaxY = dstMinY + dstHeight;
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        WeightType[] weightTypesUsed = new WeightType[sourcesNumber];
        for (int i = 0; i < sourcesNumber; ++i) {
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_NODATA;
            if (srcBean[i].getAlphaRasterAccessor() != null) {
                weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ALPHA;
                continue;
            }
            if (!this.roiPresent || this.imageBeans[i].getRoi() == null) continue;
            weightTypesUsed[i] = WeightType.WEIGHT_TYPE_ROI;
        }
        for (int b = 0; b < dstBands; ++b) {
            int dstX;
            int dPixelOffset;
            int s;
            int dstY;
            for (int s2 = 0; s2 < sourcesNumber; ++s2) {
                if (srcBean[s2].getDataRasterAccessor() != null) {
                    switch (dataType) {
                        case 0: {
                            sBandDataByte[s2] = srcDataByte[s2][b];
                            break;
                        }
                        case 1: {
                            sBandDataUShort[s2] = srcDataUShort[s2][b];
                            break;
                        }
                        case 2: {
                            sBandDataShort[s2] = srcDataShort[s2][b];
                            break;
                        }
                        case 3: {
                            sBandDataInt[s2] = srcDataInt[s2][b];
                            break;
                        }
                        case 4: {
                            sBandDataFloat[s2] = srcDataFloat[s2][b];
                            break;
                        }
                        case 5: {
                            sBandDataDouble[s2] = srcDataDouble[s2][b];
                        }
                    }
                    sLineOffsets[s2] = srcBandOffsets[s2][b];
                }
                if (weightTypesUsed[s2] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                switch (dataType) {
                    case 0: {
                        aBandDataByte[s2] = alfaDataByte[s2][0];
                        break;
                    }
                    case 1: {
                        aBandDataUShort[s2] = alfaDataUShort[s2][0];
                        break;
                    }
                    case 2: {
                        aBandDataShort[s2] = alfaDataShort[s2][0];
                        break;
                    }
                    case 3: {
                        aBandDataInt[s2] = alfaDataInt[s2][0];
                        break;
                    }
                    case 4: {
                        aBandDataFloat[s2] = alfaDataFloat[s2][0];
                        break;
                    }
                    case 5: {
                        aBandDataDouble[s2] = alfaDataDouble[s2][0];
                    }
                }
                aLineOffsets[s2] = alfaBandOffsets[s2][0];
            }
            byte[] dBandDataByte = null;
            short[] dBandDataUShort = null;
            short[] dBandDataShort = null;
            int[] dBandDataInt = null;
            float[] dBandDataFloat = null;
            double[] dBandDataDouble = null;
            switch (dataType) {
                case 0: {
                    dBandDataByte = dstDataByte[b];
                    break;
                }
                case 1: {
                    dBandDataUShort = dstDataUShort[b];
                    break;
                }
                case 2: {
                    dBandDataShort = dstDataShort[b];
                    break;
                }
                case 3: {
                    dBandDataInt = dstDataInt[b];
                    break;
                }
                case 4: {
                    dBandDataFloat = dstDataFloat[b];
                    break;
                }
                case 5: {
                    dBandDataDouble = dstDataDouble[b];
                }
            }
            int dLineOffset = dstBandOffsets[b];
            if (this.mosaicTypeSelected == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                    for (s = 0; s < sourcesNumber; ++s) {
                        if (srcBean[s].getDataRasterAccessor() != null) {
                            sPixelOffsets[s] = sLineOffsets[s];
                            int n = s;
                            sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                        }
                        if (srcBean[s].getAlphaRasterAccessor() == null) continue;
                        aPixelOffsets[s] = aLineOffsets[s];
                        int n = s;
                        aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                    }
                    dPixelOffset = dLineOffset;
                    dLineOffset += dstLineStride;
                    for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                        boolean setDestinationFlag = false;
                        for (int s3 = 0; s3 < sourcesNumber; ++s3) {
                            if (srcBean[s3].getDataRasterAccessor() == null) continue;
                            byte sourceValueByte = 0;
                            short sourceValueUShort = 0;
                            short sourceValueShort = 0;
                            int sourceValueInt = 0;
                            float sourceValueFloat = 0.0f;
                            double sourceValueDouble = 0.0;
                            switch (dataType) {
                                case 0: {
                                    sourceValueByte = sBandDataByte[s3][sPixelOffsets[s3]];
                                    break;
                                }
                                case 1: {
                                    sourceValueUShort = sBandDataUShort[s3][sPixelOffsets[s3]];
                                    break;
                                }
                                case 2: {
                                    sourceValueShort = sBandDataShort[s3][sPixelOffsets[s3]];
                                    break;
                                }
                                case 3: {
                                    sourceValueInt = sBandDataInt[s3][sPixelOffsets[s3]];
                                    break;
                                }
                                case 4: {
                                    sourceValueFloat = sBandDataFloat[s3][sPixelOffsets[s3]];
                                    break;
                                }
                                case 5: {
                                    sourceValueDouble = sBandDataDouble[s3][sPixelOffsets[s3]];
                                }
                            }
                            int n = s3;
                            sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s3];
                            boolean isData = true;
                            switch (dataType) {
                                case 0: {
                                    Range noDataRangeByte = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                    if (noDataRangeByte == null) break;
                                    isData = !noDataRangeByte.contains((byte)(sourceValueByte & 0xFF));
                                    break;
                                }
                                case 1: {
                                    Range noDataRangeUShort = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                    if (noDataRangeUShort == null) break;
                                    isData = !noDataRangeUShort.contains((short)(sourceValueUShort & 0xFFFF));
                                    break;
                                }
                                case 2: {
                                    Range noDataRangeShort = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                    if (noDataRangeShort == null) break;
                                    isData = !noDataRangeShort.contains(sourceValueShort);
                                    break;
                                }
                                case 3: {
                                    Range noDataRangeInt = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                    if (noDataRangeInt == null) break;
                                    isData = !noDataRangeInt.contains(sourceValueInt);
                                    break;
                                }
                                case 4: {
                                    Range noDataRangeFloat = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                    if (noDataRangeFloat == null) break;
                                    isData = !noDataRangeFloat.contains(sourceValueFloat);
                                    break;
                                }
                                case 5: {
                                    Range noDataRangeDouble = srcBean[s3].getSourceNoDataRangeRasterAccessor();
                                    if (noDataRangeDouble == null) break;
                                    boolean bl = isData = !noDataRangeDouble.contains(sourceValueDouble);
                                }
                            }
                            if (!isData) {
                                setDestinationFlag = false;
                            } else {
                                switch (weightTypesUsed[s3]) {
                                    case WEIGHT_TYPE_ALPHA: {
                                        switch (dataType) {
                                            case 0: {
                                                setDestinationFlag = aBandDataByte[s3][aPixelOffsets[s3]] != 0;
                                                break;
                                            }
                                            case 1: {
                                                setDestinationFlag = aBandDataUShort[s3][aPixelOffsets[s3]] != 0;
                                                break;
                                            }
                                            case 2: {
                                                setDestinationFlag = aBandDataShort[s3][aPixelOffsets[s3]] != 0;
                                                break;
                                            }
                                            case 3: {
                                                setDestinationFlag = aBandDataInt[s3][aPixelOffsets[s3]] != 0;
                                                break;
                                            }
                                            case 4: {
                                                setDestinationFlag = aBandDataFloat[s3][aPixelOffsets[s3]] != 0.0f;
                                                break;
                                            }
                                            case 5: {
                                                setDestinationFlag = aBandDataDouble[s3][aPixelOffsets[s3]] != 0.0;
                                            }
                                        }
                                        int n2 = s3;
                                        aPixelOffsets[n2] = aPixelOffsets[n2] + alfaPixelStride[s3];
                                        break;
                                    }
                                    case WEIGHT_TYPE_ROI: {
                                        setDestinationFlag = srcBean[s3].getRoiRaster().getSample(dstX, dstY, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        setDestinationFlag = true;
                                    }
                                }
                            }
                            if (!setDestinationFlag) continue;
                            switch (dataType) {
                                case 0: {
                                    dBandDataByte[dPixelOffset] = sourceValueByte;
                                    break;
                                }
                                case 1: {
                                    dBandDataUShort[dPixelOffset] = sourceValueUShort;
                                    break;
                                }
                                case 2: {
                                    dBandDataShort[dPixelOffset] = sourceValueShort;
                                    break;
                                }
                                case 3: {
                                    dBandDataInt[dPixelOffset] = sourceValueInt;
                                    break;
                                }
                                case 4: {
                                    dBandDataFloat[dPixelOffset] = sourceValueFloat;
                                    break;
                                }
                                case 5: {
                                    dBandDataDouble[dPixelOffset] = sourceValueDouble;
                                }
                            }
                            for (int k = s3 + 1; k < sourcesNumber; ++k) {
                                if (srcBean[k].getDataRasterAccessor() != null) {
                                    int n3 = k;
                                    sPixelOffsets[n3] = sPixelOffsets[n3] + srcPixelStride[k];
                                }
                                if (srcBean[k].getAlphaRasterAccessor() == null) continue;
                                int n4 = k;
                                aPixelOffsets[n4] = aPixelOffsets[n4] + alfaPixelStride[k];
                            }
                            break;
                        }
                        if (!setDestinationFlag) {
                            switch (dataType) {
                                case 0: {
                                    dBandDataByte[dPixelOffset] = this.destinationNoData[b].byteValue();
                                    break;
                                }
                                case 1: {
                                    dBandDataUShort[dPixelOffset] = this.destinationNoData[b].shortValue();
                                    break;
                                }
                                case 2: {
                                    dBandDataShort[dPixelOffset] = this.destinationNoData[b].shortValue();
                                    break;
                                }
                                case 3: {
                                    dBandDataInt[dPixelOffset] = this.destinationNoData[b].intValue();
                                    break;
                                }
                                case 4: {
                                    dBandDataFloat[dPixelOffset] = this.destinationNoData[b].floatValue();
                                    break;
                                }
                                case 5: {
                                    dBandDataDouble[dPixelOffset] = this.destinationNoData[b].doubleValue();
                                }
                            }
                        }
                        dPixelOffset += dstPixelStride;
                    }
                }
                continue;
            }
            for (dstY = dstMinY; dstY < dstMaxY; ++dstY) {
                for (s = 0; s < sourcesNumber; ++s) {
                    if (srcBean[s].getDataRasterAccessor() != null) {
                        sPixelOffsets[s] = sLineOffsets[s];
                        int n = s;
                        sLineOffsets[n] = sLineOffsets[n] + srcLineStride[s];
                    }
                    if (weightTypesUsed[s] != WeightType.WEIGHT_TYPE_ALPHA) continue;
                    aPixelOffsets[s] = aLineOffsets[s];
                    int n = s;
                    aLineOffsets[n] = aLineOffsets[n] + alfaLineStride[s];
                }
                dPixelOffset = dLineOffset;
                dLineOffset += dstLineStride;
                for (dstX = dstMinX; dstX < dstMaxX; ++dstX) {
                    double numerator = 0.0;
                    double denominator = 0.0;
                    for (int s4 = 0; s4 < sourcesNumber; ++s4) {
                        if (srcBean[s4].getDataRasterAccessor() == null) continue;
                        byte sourceValueByte = 0;
                        short sourceValueUShort = 0;
                        short sourceValueShort = 0;
                        int sourceValueInt = 0;
                        float sourceValueFloat = 0.0f;
                        double sourceValueDouble = 0.0;
                        switch (dataType) {
                            case 0: {
                                sourceValueByte = sBandDataByte[s4][sPixelOffsets[s4]];
                                break;
                            }
                            case 1: {
                                sourceValueUShort = sBandDataUShort[s4][sPixelOffsets[s4]];
                                break;
                            }
                            case 2: {
                                sourceValueShort = sBandDataShort[s4][sPixelOffsets[s4]];
                                break;
                            }
                            case 3: {
                                sourceValueInt = sBandDataInt[s4][sPixelOffsets[s4]];
                                break;
                            }
                            case 4: {
                                sourceValueFloat = sBandDataFloat[s4][sPixelOffsets[s4]];
                                break;
                            }
                            case 5: {
                                sourceValueDouble = sBandDataDouble[s4][sPixelOffsets[s4]];
                            }
                        }
                        int n = s4;
                        sPixelOffsets[n] = sPixelOffsets[n] + srcPixelStride[s4];
                        double weight = 0.0;
                        boolean isData = true;
                        switch (dataType) {
                            case 0: {
                                Range noDataRangeByte = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeByte == null) break;
                                isData = !noDataRangeByte.contains((byte)(sourceValueByte & 0xFF));
                                break;
                            }
                            case 1: {
                                Range noDataRangeUShort = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeUShort == null) break;
                                isData = !noDataRangeUShort.contains((short)(sourceValueUShort & 0xFFFF));
                                break;
                            }
                            case 2: {
                                Range noDataRangeShort = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeShort == null) break;
                                isData = !noDataRangeShort.contains(sourceValueShort);
                                break;
                            }
                            case 3: {
                                Range noDataRangeInt = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeInt == null) break;
                                isData = !noDataRangeInt.contains(sourceValueInt);
                                break;
                            }
                            case 4: {
                                Range noDataRangeFloat = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeFloat == null) break;
                                isData = !noDataRangeFloat.contains(sourceValueFloat);
                                break;
                            }
                            case 5: {
                                Range noDataRangeDouble = srcBean[s4].getSourceNoDataRangeRasterAccessor();
                                if (noDataRangeDouble == null) break;
                                boolean bl = isData = !noDataRangeDouble.contains(sourceValueDouble);
                            }
                        }
                        if (!isData) {
                            weight = 0.0;
                        } else {
                            switch (weightTypesUsed[s4]) {
                                case WEIGHT_TYPE_ALPHA: {
                                    switch (dataType) {
                                        case 0: {
                                            weight = aBandDataByte[s4][aPixelOffsets[s4]] & 0xFF;
                                            if (weight > 0.0 && this.isAlphaBitmaskUsed) {
                                                weight = 1.0;
                                                break;
                                            }
                                            weight /= 255.0;
                                            break;
                                        }
                                        case 1: {
                                            weight = aBandDataUShort[s4][aPixelOffsets[s4]] & 0xFFFF;
                                            if (weight > 0.0 && this.isAlphaBitmaskUsed) {
                                                weight = 1.0;
                                                break;
                                            }
                                            weight /= 65535.0;
                                            break;
                                        }
                                        case 2: {
                                            weight = aBandDataShort[s4][aPixelOffsets[s4]] & 0xFFFF;
                                            if (weight > 0.0 && this.isAlphaBitmaskUsed) {
                                                weight = 1.0;
                                                break;
                                            }
                                            weight /= 32767.0;
                                            break;
                                        }
                                        case 3: {
                                            weight = aBandDataInt[s4][aPixelOffsets[s4]];
                                            if (weight > 0.0 && this.isAlphaBitmaskUsed) {
                                                weight = 1.0;
                                                break;
                                            }
                                            weight /= 2.147483647E9;
                                            break;
                                        }
                                        case 4: {
                                            weight = aBandDataFloat[s4][aPixelOffsets[s4]];
                                            if (!(weight > 0.0) || !this.isAlphaBitmaskUsed) break;
                                            weight = 1.0;
                                            break;
                                        }
                                        case 5: {
                                            weight = aBandDataDouble[s4][aPixelOffsets[s4]];
                                            if (!(weight > 0.0) || !this.isAlphaBitmaskUsed) break;
                                            weight = 1.0;
                                        }
                                    }
                                    int n5 = s4;
                                    aPixelOffsets[n5] = aPixelOffsets[n5] + alfaPixelStride[s4];
                                    break;
                                }
                                case WEIGHT_TYPE_ROI: {
                                    weight = srcBean[s4].getRoiRaster().getSample(dstX, dstY, 0) > 0 ? 1.0 : 0.0;
                                    break;
                                }
                                default: {
                                    weight = 1.0;
                                }
                            }
                        }
                        switch (dataType) {
                            case 0: {
                                numerator += weight * (double)(sourceValueByte & 0xFF);
                                break;
                            }
                            case 1: {
                                numerator += weight * (double)(sourceValueUShort & 0xFFFF);
                                break;
                            }
                            case 2: {
                                numerator += weight * (double)sourceValueShort;
                                break;
                            }
                            case 3: {
                                numerator += weight * (double)sourceValueInt;
                                break;
                            }
                            case 4: {
                                if (!isData) break;
                                numerator += weight * (double)sourceValueFloat;
                                break;
                            }
                            case 5: {
                                if (!isData) break;
                                numerator += weight * sourceValueDouble;
                            }
                        }
                        denominator += weight;
                    }
                    if (denominator == 0.0) {
                        switch (dataType) {
                            case 0: {
                                dBandDataByte[dPixelOffset] = this.destinationNoData[b].byteValue();
                                break;
                            }
                            case 1: {
                                dBandDataUShort[dPixelOffset] = this.destinationNoData[b].shortValue();
                                break;
                            }
                            case 2: {
                                dBandDataShort[dPixelOffset] = this.destinationNoData[b].shortValue();
                                break;
                            }
                            case 3: {
                                dBandDataInt[dPixelOffset] = this.destinationNoData[b].intValue();
                                break;
                            }
                            case 4: {
                                dBandDataFloat[dPixelOffset] = this.destinationNoData[b].floatValue();
                                break;
                            }
                            case 5: {
                                dBandDataDouble[dPixelOffset] = this.destinationNoData[b].doubleValue();
                            }
                        }
                    } else {
                        switch (dataType) {
                            case 0: {
                                dBandDataByte[dPixelOffset] = ImageUtil.clampRoundByte((double)(numerator / denominator));
                                break;
                            }
                            case 1: {
                                dBandDataUShort[dPixelOffset] = ImageUtil.clampRoundUShort((double)(numerator / denominator));
                                break;
                            }
                            case 2: {
                                dBandDataShort[dPixelOffset] = ImageUtil.clampRoundShort((double)(numerator / denominator));
                                break;
                            }
                            case 3: {
                                dBandDataInt[dPixelOffset] = ImageUtil.clampRoundInt((double)(numerator / denominator));
                                break;
                            }
                            case 4: {
                                dBandDataFloat[dPixelOffset] = (float)(numerator / denominator);
                                break;
                            }
                            case 5: {
                                dBandDataDouble[dPixelOffset] = numerator / denominator;
                            }
                        }
                    }
                    dPixelOffset += dstPixelStride;
                }
            }
        }
    }

    public Rectangle mapDestRect(Rectangle destRectangle, int sourceRasterIndex) {
        if (destRectangle == null) {
            throw new IllegalArgumentException("Destination rectangle is not defined");
        }
        if (sourceRasterIndex < 0 || sourceRasterIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index must be between 0 and source dimension-1");
        }
        return destRectangle.intersection(this.getSourceImage(sourceRasterIndex).getBounds());
    }

    public Rectangle mapSourceRect(Rectangle sourceRectangle, int sourceRasterIndex) {
        if (sourceRectangle == null) {
            throw new IllegalArgumentException("Destination rectangle is not defined");
        }
        if (sourceRasterIndex < 0 || sourceRasterIndex >= this.getNumSources()) {
            throw new IllegalArgumentException("Source index must be between 0 and source dimension-1");
        }
        return sourceRectangle.intersection(this.getBounds());
    }

    private static class RasterBeanAccessor {
        private RasterAccessor dataRasterAccessor;
        private RasterAccessor alphaRasterAccessor;
        private Raster roiRaster;
        private Range sourceNoDataRangeRasterAccessor;

        RasterBeanAccessor() {
        }

        public RasterAccessor getDataRasterAccessor() {
            return this.dataRasterAccessor;
        }

        public void setDataRasterAccessor(RasterAccessor dataRasterAccessor) {
            this.dataRasterAccessor = dataRasterAccessor;
        }

        public RasterAccessor getAlphaRasterAccessor() {
            return this.alphaRasterAccessor;
        }

        public void setAlphaRasterAccessor(RasterAccessor alphaRasterAccessor) {
            this.alphaRasterAccessor = alphaRasterAccessor;
        }

        public Raster getRoiRaster() {
            return this.roiRaster;
        }

        public void setRoiRaster(Raster roiRaster) {
            this.roiRaster = roiRaster;
        }

        public Range getSourceNoDataRangeRasterAccessor() {
            return this.sourceNoDataRangeRasterAccessor;
        }

        public void setSourceNoDataRangeRasterAccessor(Range sourceNoDataRangeRasterAccessor) {
            this.sourceNoDataRangeRasterAccessor = sourceNoDataRangeRasterAccessor;
        }
    }

    private static class RasterBean {
        private Raster dataRaster;
        private Raster alphaRaster;
        private Raster roiRaster;
        private Range sourceNoDataRangeRaster;

        public Raster getDataRaster() {
            return this.dataRaster;
        }

        public void setDataRaster(Raster dataRaster) {
            this.dataRaster = dataRaster;
        }

        public Raster getAlphaRaster() {
            return this.alphaRaster;
        }

        public void setAlphaRaster(Raster alphaRaster) {
            this.alphaRaster = alphaRaster;
        }

        public Raster getRoiRaster() {
            return this.roiRaster;
        }

        public void setRoiRaster(Raster roiRaster) {
            this.roiRaster = roiRaster;
        }

        public Range getSourceNoDataRangeRaster() {
            return this.sourceNoDataRangeRaster;
        }

        public void setSourceNoDataRangeRaster(Range sourceNoDataRangeRaster) {
            this.sourceNoDataRangeRaster = sourceNoDataRangeRaster;
        }

        RasterBean() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WeightType {
        WEIGHT_TYPE_ALPHA,
        WEIGHT_TYPE_ROI,
        WEIGHT_TYPE_NODATA;

    }
}

