/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.mosaic;

import it.geosolutions.jaiext.mosaic.PixelIterator;
import it.geosolutions.jaiext.mosaic.RasterAccessorExt;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.CropDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PixelIteratorTest {
    private static final int SIZE = 4;
    private static final int BASE_BLUE = 0;
    private static final int BASE_GREEN = 20;
    private static final int BASE_RED = 40;
    private BufferedImage image;

    @Before
    public void buildSampleImage() {
        this.image = new BufferedImage(4, 4, 5);
        int[] v = new int[]{0, 20, 40};
        WritableRaster raster = this.image.getWritableTile(0, 0);
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                raster.setPixel(c, r, v);
                v[0] = v[0] + 1;
                v[1] = v[1] + 1;
                v[2] = v[2] + 1;
            }
        }
    }

    @Test
    public void testAligned() {
        Rectangle bounds = this.image.getData().getBounds();
        RasterFormatTag[] tags = RasterAccessorExt.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.image}, (RenderedImage)this.image);
        PixelIterator.PixelIteratorByte reader = new PixelIterator.PixelIteratorByte(bounds, bounds, (RasterAccessor)new RasterAccessorExt((Raster)this.image.getRaster(), bounds, tags[0], this.image.getColorModel(), 3, 0));
        byte[] expected = new byte[]{0, 20, 40};
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                Assert.assertTrue((boolean)reader.hasData());
                Assert.assertFalse((boolean)reader.isDone());
                byte[] px = reader.read();
                Assert.assertArrayEquals((byte[])expected, (byte[])px);
                expected[0] = (byte)(expected[0] + 1);
                expected[1] = (byte)(expected[1] + 1);
                expected[2] = (byte)(expected[2] + 1);
                reader.nextPixel();
            }
            reader.nextLine();
        }
    }

    @Test
    public void testSubImage() {
        int c;
        RenderedOp cropped = CropDescriptor.create((RenderedImage)this.image, (Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Float)Float.valueOf(2.0f), (Float)Float.valueOf(2.0f), null);
        Rectangle destBounds = this.image.getData().getBounds();
        Rectangle sourceBounds = cropped.getBounds();
        RasterFormatTag[] tags = RasterAccessorExt.findCompatibleTags((RenderedImage[])new RenderedImage[]{cropped}, (RenderedImage)this.image);
        PixelIterator.PixelIteratorByte iterator = new PixelIterator.PixelIteratorByte(sourceBounds, destBounds, (RasterAccessor)new RasterAccessorExt(cropped.getData(), sourceBounds, tags[0], this.image.getColorModel(), 3, 0));
        for (c = 0; c < 4; ++c) {
            Assert.assertFalse((boolean)iterator.hasData());
            Assert.assertFalse((boolean)iterator.isDone());
            iterator.nextPixel();
        }
        iterator.nextLine();
        Assert.assertFalse((boolean)iterator.hasData());
        Assert.assertFalse((boolean)iterator.isDone());
        iterator.nextPixel();
        Assert.assertTrue((boolean)iterator.hasData());
        Assert.assertArrayEquals((byte[])new byte[]{5, 25, 45}, (byte[])iterator.read());
        Assert.assertFalse((boolean)iterator.isDone());
        iterator.nextPixel();
        Assert.assertTrue((boolean)iterator.hasData());
        Assert.assertArrayEquals((byte[])new byte[]{6, 26, 46}, (byte[])iterator.read());
        Assert.assertFalse((boolean)iterator.isDone());
        iterator.nextPixel();
        Assert.assertFalse((boolean)iterator.hasData());
        Assert.assertFalse((boolean)iterator.isDone());
        iterator.nextPixel();
        iterator.nextLine();
        Assert.assertFalse((boolean)iterator.hasData());
        Assert.assertFalse((boolean)iterator.isDone());
        iterator.nextPixel();
        Assert.assertTrue((boolean)iterator.hasData());
        Assert.assertArrayEquals((byte[])new byte[]{9, 29, 49}, (byte[])iterator.read());
        Assert.assertFalse((boolean)iterator.isDone());
        iterator.nextPixel();
        Assert.assertTrue((boolean)iterator.hasData());
        Assert.assertArrayEquals((byte[])new byte[]{10, 30, 50}, (byte[])iterator.read());
        Assert.assertFalse((boolean)iterator.isDone());
        iterator.nextPixel();
        Assert.assertFalse((boolean)iterator.hasData());
        Assert.assertTrue((boolean)iterator.isDone());
        iterator.nextPixel();
        iterator.nextLine();
        for (c = 0; c < 4; ++c) {
            Assert.assertFalse((boolean)iterator.hasData());
            Assert.assertTrue((boolean)iterator.isDone());
            iterator.nextPixel();
        }
    }
}

