/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rescale;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.rescale.RescaleDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RescaleTest
extends TestBase {
    private static final double TOLERANCE = 0.01;
    private static RenderedImage[] sourceIMG;
    private static ROI roi;
    private static byte noDataB;
    private static short noDataU;
    private static short noDataS;
    private static int noDataI;
    private static float noDataF;
    private static double noDataD;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static double[] scales;
    private static double[] offsets;
    private static double destNoData;
    private static Rectangle roiBounds;

    @BeforeClass
    public static void initialSetup() {
        roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roi = new ROIShape((Shape)roiBounds);
        noDataB = (byte)50;
        noDataU = (short)50;
        noDataS = (short)50;
        noDataI = 50;
        noDataF = 50.0f;
        noDataD = 50.0;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataU, (boolean)minIncluded, (short)noDataU, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        IMAGE_FILLER = true;
        sourceIMG = new RenderedImage[6];
        RescaleTest.sourceIMG[0] = RescaleTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false);
        RescaleTest.sourceIMG[1] = RescaleTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataU, (boolean)false);
        RescaleTest.sourceIMG[2] = RescaleTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false);
        RescaleTest.sourceIMG[3] = RescaleTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false);
        RescaleTest.sourceIMG[4] = RescaleTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false);
        RescaleTest.sourceIMG[5] = RescaleTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false);
        IMAGE_FILLER = false;
        scales = new double[]{10.0, 20.0, 30.0};
        offsets = new double[]{0.0, 1.0, 2.0};
        destNoData = 0.0;
    }

    @Test
    public void testNoRangeNoRoi() {
        boolean roiUsed = false;
        boolean noDataRangeUsed = false;
        boolean useROIAccessor = false;
        TestBase.TestSelection select = TestBase.TestSelection.NO_ROI_ONLY_DATA;
        this.testRescale(sourceIMG[0], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[1], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[2], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[3], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[4], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[5], roiUsed, noDataRangeUsed, useROIAccessor, select);
    }

    @Test
    public void testRoiBounds() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = false;
        boolean useROIAccessor = false;
        TestBase.TestSelection select = TestBase.TestSelection.ROI_ONLY_DATA;
        this.testRescale(sourceIMG[0], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[1], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[2], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[3], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[4], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[5], roiUsed, noDataRangeUsed, useROIAccessor, select);
    }

    @Test
    public void testRoiAccessor() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = false;
        boolean useROIAccessor = true;
        TestBase.TestSelection select = TestBase.TestSelection.ROI_ACCESSOR_ONLY_DATA;
        this.testRescale(sourceIMG[0], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[1], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[2], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[3], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[4], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[5], roiUsed, noDataRangeUsed, useROIAccessor, select);
    }

    @Test
    public void testNoData() {
        boolean roiUsed = false;
        boolean noDataRangeUsed = true;
        boolean useROIAccessor = false;
        TestBase.TestSelection select = TestBase.TestSelection.NO_ROI_NO_DATA;
        this.testRescale(sourceIMG[0], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[1], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[2], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[3], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[4], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[5], roiUsed, noDataRangeUsed, useROIAccessor, select);
    }

    @Test
    public void testRoiNoData() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = true;
        boolean useROIAccessor = false;
        TestBase.TestSelection select = TestBase.TestSelection.ROI_NO_DATA;
        this.testRescale(sourceIMG[0], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[1], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[2], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[3], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[4], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[5], roiUsed, noDataRangeUsed, useROIAccessor, select);
    }

    @Test
    public void testRoiAccessorNoData() {
        boolean roiUsed = true;
        boolean noDataRangeUsed = true;
        boolean useROIAccessor = true;
        TestBase.TestSelection select = TestBase.TestSelection.ROI_ACCESSOR_NO_DATA;
        this.testRescale(sourceIMG[0], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[1], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[2], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[3], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[4], roiUsed, noDataRangeUsed, useROIAccessor, select);
        this.testRescale(sourceIMG[5], roiUsed, noDataRangeUsed, useROIAccessor, select);
    }

    public void testRescale(RenderedImage source, boolean roiUsed, boolean noDataUsed, boolean useRoiAccessor, TestBase.TestSelection select) {
        Range noDataRange;
        int dataType;
        Object roiData;
        block41: {
            block40: {
                roiData = roiUsed ? roi : null;
                dataType = source.getSampleModel().getDataType();
                if (!noDataUsed) break block40;
                switch (dataType) {
                    case 0: {
                        noDataRange = noDataByte;
                        break block41;
                    }
                    case 1: {
                        noDataRange = noDataUShort;
                        break block41;
                    }
                    case 2: {
                        noDataRange = noDataShort;
                        break block41;
                    }
                    case 3: {
                        noDataRange = noDataInt;
                        break block41;
                    }
                    case 4: {
                        noDataRange = noDataFloat;
                        break block41;
                    }
                    case 5: {
                        noDataRange = noDataDouble;
                        break block41;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            noDataRange = null;
        }
        RenderedOp rescaled = RescaleDescriptor.create((RenderedImage)source, (double[])scales, (double[])offsets, (ROI)roiData, (Range)noDataRange, (boolean)useRoiAccessor, (double)destNoData, null);
        if (INTERACTIVE && TEST_SELECTOR.intValue() == select.getType()) {
            RenderedImageBrowser.showChain((RenderedImage)rescaled, (boolean)false, (boolean)roiUsed);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            rescaled.getTiles();
        }
        int tileMinX = rescaled.getMinTileX();
        int tileMinY = rescaled.getMinTileY();
        Raster tileDest = rescaled.getTile(tileMinX, tileMinY);
        Raster tileSource = source.getTile(tileMinX, tileMinY);
        int tileMinXpix = tileDest.getMinX();
        int tileMinYpix = tileDest.getMinY();
        int tileMaxXpix = tileDest.getWidth() + tileMinXpix;
        int tileMaxYpix = tileDest.getHeight() + tileMinYpix;
        double scaleFactor = scales[0];
        double offset = offsets[0];
        for (int i = tileMinXpix; i < tileMaxXpix; ++i) {
            block19: for (int j = tileMinYpix; j < tileMaxYpix; ++j) {
                switch (dataType) {
                    case 0: {
                        byte destValueB = (byte)tileDest.getSample(i, j, 0);
                        int srcValueB = tileSource.getSample(i, j, 0) & 0xFF;
                        byte calculationB = ImageUtil.clampRoundByte((double)((double)srcValueB * scaleFactor + offset));
                        if (roiUsed && noDataUsed) {
                            if (!roiBounds.contains(i, j) || noDataRange.contains((byte)srcValueB)) continue block19;
                            Assert.assertEquals((long)calculationB, (long)destValueB);
                            continue block19;
                        }
                        if (roiUsed) {
                            if (!roiBounds.contains(i, j)) continue block19;
                            Assert.assertEquals((long)calculationB, (long)destValueB);
                            continue block19;
                        }
                        if (noDataUsed) {
                            if (noDataRange.contains((byte)srcValueB)) continue block19;
                            Assert.assertEquals((long)calculationB, (long)destValueB);
                            continue block19;
                        }
                        Assert.assertEquals((long)calculationB, (long)destValueB);
                        continue block19;
                    }
                    case 1: {
                        short destValueU = (short)tileDest.getSample(i, j, 0);
                        int srcValueU = tileSource.getSample(i, j, 0) & 0xFFFF;
                        short calculationU = ImageUtil.clampRoundUShort((double)((double)srcValueU * scaleFactor + offset));
                        if (roiUsed && noDataUsed) {
                            if (!roiBounds.contains(i, j) || noDataRange.contains((short)srcValueU)) continue block19;
                            Assert.assertEquals((long)calculationU, (long)destValueU);
                            continue block19;
                        }
                        if (roiUsed) {
                            if (!roiBounds.contains(i, j)) continue block19;
                            Assert.assertEquals((long)calculationU, (long)destValueU);
                            continue block19;
                        }
                        if (noDataUsed) {
                            if (noDataRange.contains((short)srcValueU)) continue block19;
                            Assert.assertEquals((long)calculationU, (long)destValueU);
                            continue block19;
                        }
                        Assert.assertEquals((long)calculationU, (long)destValueU);
                        continue block19;
                    }
                    case 2: {
                        short destValueS = (short)tileDest.getSample(i, j, 0);
                        short srcValueS = (short)tileSource.getSample(i, j, 0);
                        short calculationS = ImageUtil.clampRoundShort((double)((double)srcValueS * scaleFactor + offset));
                        if (roiUsed && noDataUsed) {
                            if (!roiBounds.contains(i, j) || noDataRange.contains(srcValueS)) continue block19;
                            Assert.assertEquals((long)calculationS, (long)destValueS);
                            continue block19;
                        }
                        if (roiUsed) {
                            if (!roiBounds.contains(i, j)) continue block19;
                            Assert.assertEquals((long)calculationS, (long)destValueS);
                            continue block19;
                        }
                        if (noDataUsed) {
                            if (noDataRange.contains(srcValueS)) continue block19;
                            Assert.assertEquals((long)calculationS, (long)destValueS);
                            continue block19;
                        }
                        Assert.assertEquals((long)calculationS, (long)destValueS);
                        continue block19;
                    }
                    case 3: {
                        int destValueI = tileDest.getSample(i, j, 0);
                        int srcValueI = tileSource.getSample(i, j, 0);
                        int calculationI = ImageUtil.clampRoundInt((double)((double)srcValueI * scaleFactor + offset));
                        if (roiUsed && noDataUsed) {
                            if (!roiBounds.contains(i, j) || noDataRange.contains(srcValueI)) continue block19;
                            Assert.assertEquals((long)calculationI, (long)destValueI);
                            continue block19;
                        }
                        if (roiUsed) {
                            if (!roiBounds.contains(i, j)) continue block19;
                            Assert.assertEquals((long)calculationI, (long)destValueI);
                            continue block19;
                        }
                        if (noDataUsed) {
                            if (noDataRange.contains(srcValueI)) continue block19;
                            Assert.assertEquals((long)calculationI, (long)destValueI);
                            continue block19;
                        }
                        Assert.assertEquals((long)calculationI, (long)destValueI);
                        continue block19;
                    }
                    case 4: {
                        float destValueF = tileDest.getSampleFloat(i, j, 0);
                        float srcValueF = tileSource.getSampleFloat(i, j, 0);
                        float calculationF = (float)((double)srcValueF * scaleFactor + offset);
                        if (roiUsed && noDataUsed) {
                            if (!roiBounds.contains(i, j) || noDataRange.contains(srcValueF)) continue block19;
                            Assert.assertEquals((double)calculationF, (double)destValueF, (double)0.01);
                            continue block19;
                        }
                        if (roiUsed) {
                            if (!roiBounds.contains(i, j)) continue block19;
                            Assert.assertEquals((double)calculationF, (double)destValueF, (double)0.01);
                            continue block19;
                        }
                        if (noDataUsed) {
                            if (noDataRange.contains(srcValueF)) continue block19;
                            Assert.assertEquals((double)calculationF, (double)destValueF, (double)0.01);
                            continue block19;
                        }
                        Assert.assertEquals((double)calculationF, (double)destValueF, (double)0.01);
                        continue block19;
                    }
                    case 5: {
                        double destValueD = tileDest.getSampleDouble(i, j, 0);
                        double srcValueD = tileSource.getSampleDouble(i, j, 0);
                        double calculationD = srcValueD * scaleFactor + offset;
                        if (roiUsed && noDataUsed) {
                            if (!roiBounds.contains(i, j) || noDataRange.contains(srcValueD)) continue block19;
                            Assert.assertEquals((double)calculationD, (double)destValueD, (double)0.01);
                            continue block19;
                        }
                        if (roiUsed) {
                            if (!roiBounds.contains(i, j)) continue block19;
                            Assert.assertEquals((double)calculationD, (double)destValueD, (double)0.01);
                            continue block19;
                        }
                        if (noDataUsed) {
                            if (noDataRange.contains(srcValueD)) continue block19;
                            Assert.assertEquals((double)calculationD, (double)destValueD, (double)0.01);
                            continue block19;
                        }
                        Assert.assertEquals((double)calculationD, (double)destValueD, (double)0.01);
                        continue block19;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
        }
    }
}

