/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rlookup;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.rlookup.LookupItem;
import it.geosolutions.jaiext.rlookup.LookupItemComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeLookupTable<T extends Number, U extends Number> {
    private final List<LookupItem<T, U>> items;

    private RangeLookupTable(Builder builder) {
        this.items = new ArrayList<LookupItem<T, U>>(builder.items);
        Collections.sort(this.items, new LookupItemComparator());
    }

    public LookupItem<T, U> getLookupItem(T srcValue) {
        if (this.items.isEmpty()) {
            return null;
        }
        int lo = 0;
        int hi = this.items.size() - 1;
        while (hi >= lo) {
            int mid = lo + (hi - lo) / 2;
            LookupItem<T, U> item = this.items.get(mid);
            Range r = item.getRange();
            if (r.containsN(srcValue)) {
                return item;
            }
            if (!Double.isInfinite(r.getMin().doubleValue()) && Double.compare(((Number)srcValue).doubleValue(), r.getMin().doubleValue()) <= 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LookupItem<T, U> item : this.items) {
            sb.append(item).append("; ");
        }
        return sb.toString();
    }

    List<LookupItem<T, U>> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T extends Number, U extends Number> {
        private final List<LookupItem<T, U>> items = new ArrayList<LookupItem<T, U>>();

        public RangeLookupTable<T, U> build() {
            return new RangeLookupTable(this);
        }

        public Builder add(Range srcRange, U resultValue) {
            if (srcRange == null || resultValue == null) {
                throw new IllegalArgumentException("arguments must not be null");
            }
            for (LookupItem<T, U> item : this.items) {
                if (!srcRange.intersects(item.getRange())) continue;
                List diffs = RangeFactory.subtract((Range)item.getRange(), (Range)srcRange);
                for (Range diff : diffs) {
                    this.add(diff, resultValue);
                }
                return this;
            }
            this.items.add(new LookupItem(srcRange, resultValue));
            return this;
        }
    }
}

