/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rlookup;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.rlookup.RangeLookupTable;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeLookupTest
extends TestBase {
    private static final int WIDTH = 10;
    private static final double TOLERANCE = 1.0E-6;
    private static RenderedImage[] images;
    private static ROIShape roi;
    private static Double defaultV;

    @BeforeClass
    public static void initialSetup() {
        images = new RenderedImage[6];
        IMAGE_FILLER = true;
        RangeLookupTest.images[0] = RangeLookupTest.createTestImage((int)0, (int)10, (int)10, (Number)0, (boolean)false);
        RangeLookupTest.images[1] = RangeLookupTest.createTestImage((int)1, (int)10, (int)10, (Number)0, (boolean)false);
        RangeLookupTest.images[2] = RangeLookupTest.createTestImage((int)2, (int)10, (int)10, (Number)0, (boolean)false);
        RangeLookupTest.images[3] = RangeLookupTest.createTestImage((int)3, (int)10, (int)10, (Number)0, (boolean)false);
        RangeLookupTest.images[4] = RangeLookupTest.createTestImage((int)4, (int)10, (int)10, (Number)Float.valueOf(0.0f), (boolean)false);
        RangeLookupTest.images[5] = RangeLookupTest.createTestImage((int)5, (int)10, (int)10, (Number)0.0, (boolean)false);
        IMAGE_FILLER = false;
        roi = new ROIShape((Shape)new Rectangle(2, 2, 3, 3));
        defaultV = new Double(13.0);
    }

    @Test
    public void byteToByte() {
        Number[] breaks = new Byte[]{(byte)2, (byte)4, (byte)6, (byte)8};
        Number[] values = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        RenderedImage srcImg = images[0];
        this.assertLookup(breaks, values, srcImg, 0);
    }

    @Test
    public void byteToByteROI() {
        Number[] breaks = new Byte[]{(byte)2, (byte)4, (byte)6, (byte)8};
        Number[] values = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        RenderedImage srcImg = images[0];
        this.assertLookup(breaks, values, srcImg, 0, (ROI)roi, defaultV);
    }

    @Test
    public void byteToShort() {
        Number[] breaks = new Byte[]{(byte)2, (byte)4, (byte)6, (byte)8};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[0];
        this.assertLookup(breaks, values, srcImg, 2);
    }

    @Test
    public void byteToInt() {
        Number[] breaks = new Byte[]{(byte)2, (byte)4, (byte)6, (byte)8};
        Number[] values = new Integer[]{-50, -10, 0, 10, 50};
        RenderedImage srcImg = images[0];
        this.assertLookup(breaks, values, srcImg, 3);
    }

    @Test
    public void byteToFloat() {
        Number[] breaks = new Byte[]{(byte)2, (byte)4, (byte)6, (byte)8};
        Number[] values = new Float[]{Float.valueOf(-50.0f), Float.valueOf(-10.0f), Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(50.0f)};
        RenderedImage srcImg = images[0];
        this.assertLookup(breaks, values, srcImg, 4);
    }

    @Test
    public void byteToDouble() {
        Number[] breaks = new Byte[]{(byte)2, (byte)4, (byte)6, (byte)8};
        Number[] values = new Double[]{-50.0, -10.0, 0.0, 10.0, 50.0};
        RenderedImage srcImg = images[0];
        this.assertLookup(breaks, values, srcImg, 5);
    }

    @Test
    public void shortToByte() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        RenderedImage srcImg = images[2];
        this.assertLookup(breaks, values, srcImg, 0);
    }

    @Test
    public void shortToShort() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[2];
        this.assertLookup(breaks, values, srcImg, 2);
    }

    @Test
    public void shortToShortROI() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[2];
        this.assertLookup(breaks, values, srcImg, 2, (ROI)roi, defaultV);
    }

    @Test
    public void shortToInt() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Integer[]{-50, -10, 0, 10, 50};
        RenderedImage srcImg = images[2];
        this.assertLookup(breaks, values, srcImg, 3);
    }

    @Test
    public void shortToFloat() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Float[]{Float.valueOf(-50.0f), Float.valueOf(-10.0f), Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(50.0f)};
        RenderedImage srcImg = images[2];
        this.assertLookup(breaks, values, srcImg, 4);
    }

    @Test
    public void shortToDouble() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Double[]{-50.0, -10.0, 0.0, 10.0, 50.0};
        RenderedImage srcImg = images[2];
        this.assertLookup(breaks, values, srcImg, 5);
    }

    @Test
    public void ushortToByte() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 0);
    }

    @Test
    public void ushortToShort() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 2);
    }

    @Test
    public void ushortToInt() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Integer[]{-50, -10, 0, 10, 50};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 3);
    }

    @Test
    public void ushortToFloat() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Float[]{Float.valueOf(-50.0f), Float.valueOf(-10.0f), Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(50.0f)};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 4);
    }

    @Test
    public void ushortToDouble() {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Double[]{-50.0, -10.0, 0.0, 10.0, 50.0};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 5);
    }

    @Test
    public void intToByte() {
        Number[] breaks = new Integer[]{2, 4, 6, 8};
        Number[] values = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        RenderedImage srcImg = images[3];
        this.assertLookup(breaks, values, srcImg, 0);
    }

    @Test
    public void intToShort() {
        Number[] breaks = new Integer[]{2, 4, 6, 8};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[3];
        this.assertLookup(breaks, values, srcImg, 2);
    }

    @Test
    public void intToInt() {
        Number[] breaks = new Integer[]{2, 4, 6, 8};
        Number[] values = new Integer[]{-50, -10, 0, 10, 50};
        RenderedImage srcImg = images[3];
        this.assertLookup(breaks, values, srcImg, 3);
    }

    @Test
    public void intToIntROI() {
        Number[] breaks = new Integer[]{2, 4, 6, 8};
        Number[] values = new Integer[]{-50, -10, 0, 10, 50};
        RenderedImage srcImg = images[3];
        this.assertLookup(breaks, values, srcImg, 3, (ROI)roi, defaultV);
    }

    @Test
    public void intToFloat() {
        Number[] breaks = new Integer[]{2, 4, 6, 8};
        Number[] values = new Float[]{Float.valueOf(-50.0f), Float.valueOf(-10.0f), Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(50.0f)};
        RenderedImage srcImg = images[3];
        this.assertLookup(breaks, values, srcImg, 4);
    }

    @Test
    public void intToDouble() {
        Number[] breaks = new Integer[]{2, 4, 6, 8};
        Number[] values = new Double[]{-50.0, -10.0, 0.0, 10.0, 50.0};
        RenderedImage srcImg = images[3];
        this.assertLookup(breaks, values, srcImg, 5);
    }

    @Test
    public void floatToByte() {
        Number[] breaks = new Float[]{Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(6.0f), Float.valueOf(8.0f)};
        Number[] values = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        RenderedImage srcImg = images[4];
        this.assertLookup(breaks, values, srcImg, 0);
    }

    @Test
    public void floatToShort() {
        Number[] breaks = new Float[]{Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(6.0f), Float.valueOf(8.0f)};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[4];
        this.assertLookup(breaks, values, srcImg, 2);
    }

    @Test
    public void floatToInt() {
        Number[] breaks = new Float[]{Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(6.0f), Float.valueOf(8.0f)};
        Number[] values = new Integer[]{-50, -10, 0, 10, 50};
        RenderedImage srcImg = images[4];
        this.assertLookup(breaks, values, srcImg, 3);
    }

    @Test
    public void floatToFloat() {
        Number[] breaks = new Float[]{Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(6.0f), Float.valueOf(8.0f)};
        Number[] values = new Float[]{Float.valueOf(-50.0f), Float.valueOf(-10.0f), Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(50.0f)};
        RenderedImage srcImg = images[4];
        this.assertLookup(breaks, values, srcImg, 4);
    }

    @Test
    public void floatToFloatROI() {
        Number[] breaks = new Float[]{Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(6.0f), Float.valueOf(8.0f)};
        Number[] values = new Float[]{Float.valueOf(-50.0f), Float.valueOf(-10.0f), Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(50.0f)};
        RenderedImage srcImg = images[4];
        this.assertLookup(breaks, values, srcImg, 4, (ROI)roi, defaultV);
    }

    @Test
    public void floatToDouble() {
        Number[] breaks = new Float[]{Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(6.0f), Float.valueOf(8.0f)};
        Number[] values = new Double[]{-50.0, -10.0, 0.0, 10.0, 50.0};
        RenderedImage srcImg = images[4];
        this.assertLookup(breaks, values, srcImg, 5);
    }

    @Test
    public void doubleToByte() {
        Number[] breaks = new Double[]{2.0, 4.0, 6.0, 8.0};
        Number[] values = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        RenderedImage srcImg = images[5];
        this.assertLookup(breaks, values, srcImg, 0);
    }

    @Test
    public void doubleToShort() {
        Number[] breaks = new Double[]{2.0, 4.0, 6.0, 8.0};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[5];
        this.assertLookup(breaks, values, srcImg, 2);
    }

    @Test
    public void doubleToInt() {
        Number[] breaks = new Double[]{2.0, 4.0, 6.0, 8.0};
        Number[] values = new Integer[]{-50, -10, 0, 10, 50};
        RenderedImage srcImg = images[5];
        this.assertLookup(breaks, values, srcImg, 3);
    }

    @Test
    public void doubleToFloat() {
        Number[] breaks = new Double[]{2.0, 4.0, 6.0, 8.0};
        Number[] values = new Float[]{Float.valueOf(-50.0f), Float.valueOf(-10.0f), Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(50.0f)};
        RenderedImage srcImg = images[5];
        this.assertLookup(breaks, values, srcImg, 4);
    }

    @Test
    public void doubleToDouble() {
        Number[] breaks = new Double[]{2.0, 4.0, 6.0, 8.0};
        Number[] values = new Double[]{-50.0, -10.0, 0.0, 10.0, 50.0};
        RenderedImage srcImg = images[5];
        this.assertLookup(breaks, values, srcImg, 5);
    }

    @Test
    public void doubleToDoubleROI() {
        Number[] breaks = new Double[]{2.0, 4.0, 6.0, 8.0};
        Number[] values = new Double[]{-50.0, -10.0, 0.0, 10.0, 50.0};
        RenderedImage srcImg = images[5];
        this.assertLookup(breaks, values, srcImg, 5, (ROI)roi, defaultV);
    }

    @Test
    public void shortToShortWithNoNegativeValues() throws Exception {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Short[]{(short)0, (short)1, (short)2, (short)3, (short)4};
        RenderedImage srcImg = images[2];
        this.assertLookup(breaks, values, srcImg, 1);
    }

    @Test
    public void ushortToUShort() throws Exception {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Short[]{(short)0, (short)1, (short)2, (short)3, (short)4};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 1);
    }

    @Test
    public void ushortToUShortROI() throws Exception {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Short[]{(short)0, (short)1, (short)2, (short)3, (short)4};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 1, (ROI)roi, defaultV);
    }

    @Test
    public void ushortSourceWithNegativeDestValues() throws Exception {
        Number[] breaks = new Short[]{(short)2, (short)4, (short)6, (short)8};
        Number[] values = new Short[]{(short)-50, (short)-10, (short)0, (short)10, (short)50};
        RenderedImage srcImg = images[1];
        this.assertLookup(breaks, values, srcImg, 2);
    }

    private <T extends Number, U extends Number> void assertLookup(T[] breaks, U[] values, RenderedImage srcImg, int destType) {
        this.assertLookup((Number[])breaks, (Number[])values, srcImg, destType, null, null);
    }

    private <T extends Number, U extends Number> void assertLookup(T[] breaks, U[] values, RenderedImage srcImg, int destType, ROI roi, Double defaultValue) {
        RangeLookupTable table = RangeLookupTest.createTable(breaks, values);
        RenderedOp destImg = this.doOp(srcImg, table, roi, defaultValue);
        Assert.assertEquals((long)destType, (long)destImg.getSampleModel().getDataType());
        this.assertImageValues(srcImg, table, (RenderedImage)destImg, roi, defaultValue);
    }

    public static <T extends Number, U extends Number> RangeLookupTable<T, U> createTable(T[] breaks, U[] values) {
        int N = breaks.length;
        if (values.length != N + 1) {
            throw new IllegalArgumentException("values array length should be breaks array length + 1");
        }
        RangeLookupTable.Builder builder = new RangeLookupTable.Builder();
        Range r = RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)((Number)breaks[0]).doubleValue(), (boolean)false);
        builder.add(r, values[0]);
        for (int i = 1; i < N; ++i) {
            r = RangeFactory.create((double)((Number)breaks[i - 1]).doubleValue(), (boolean)true, (double)((Number)breaks[i]).doubleValue(), (boolean)false);
            builder.add(r, values[i]);
        }
        r = RangeFactory.create((double)((Number)breaks[N - 1]).doubleValue(), (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)false);
        builder.add(r, values[N]);
        return builder.build();
    }

    private RenderedOp doOp(RenderedImage srcImg, RangeLookupTable table, ROI roi, Double defaultValue) {
        ParameterBlockJAI pb = new ParameterBlockJAI("RLookup");
        pb.setSource("source0", (Object)srcImg);
        pb.setParameter("table", (Object)table);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("default", (Object)defaultValue);
        return JAI.create((String)"RLookup", (ParameterBlock)pb);
    }

    private void assertImageValues(RenderedImage srcImg, RangeLookupTable table, RenderedImage destImg, ROI roi, Double defaultValue) {
        int srcType = srcImg.getSampleModel().getDataType();
        int destType = destImg.getSampleModel().getDataType();
        RectIter srcIter = RectIterFactory.create((RenderedImage)srcImg, null);
        RectIter destIter = RectIterFactory.create((RenderedImage)destImg, null);
        int x = 0;
        int y = 0;
        boolean roiExists = roi != null;
        Rectangle bounds = roiExists ? roi.getBounds() : null;
        while (true) {
            Number srcVal = this.getSourceImageValue(srcIter, srcType);
            Number expectedVal = table.getLookupItem(srcVal).getValue();
            if (!(!roiExists || bounds.contains(x, y) && roi.contains(x, y))) {
                expectedVal = defaultValue;
            }
            switch (destType) {
                case 0: {
                    Assert.assertEquals((long)expectedVal.byteValue(), (long)((byte)destIter.getSample()));
                    break;
                }
                case 2: {
                    Assert.assertEquals((long)expectedVal.shortValue(), (long)((short)destIter.getSample()));
                    break;
                }
                case 3: {
                    Assert.assertEquals((long)expectedVal.intValue(), (long)destIter.getSample());
                    break;
                }
                case 4: {
                    Assert.assertEquals((double)expectedVal.floatValue(), (double)destIter.getSampleFloat(), (double)1.0E-6);
                    break;
                }
                case 5: {
                    Assert.assertEquals((double)expectedVal.doubleValue(), (double)destIter.getSampleDouble(), (double)1.0E-6);
                }
            }
            srcIter.nextPixelDone();
            ++x;
            if (!destIter.nextPixelDone()) continue;
            srcIter.nextLineDone();
            srcIter.startPixels();
            destIter.startPixels();
            ++y;
            x = 0;
            if (destIter.nextLineDone()) break;
        }
    }

    private Number getSourceImageValue(RectIter srcIter, int srcType) {
        Number val = null;
        switch (srcType) {
            case 0: {
                val = (byte)(srcIter.getSample() & 0xFF);
                break;
            }
            case 2: {
                val = (short)srcIter.getSample();
                break;
            }
            case 1: {
                val = (short)(srcIter.getSample() & 0xFFFF);
                break;
            }
            case 3: {
                val = srcIter.getSample();
                break;
            }
            case 4: {
                val = Float.valueOf(srcIter.getSampleFloat());
                break;
            }
            case 5: {
                val = (short)srcIter.getSampleDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        return val;
    }
}

