/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rlookup;

import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.rlookup.LookupItem;
import it.geosolutions.jaiext.rlookup.RangeLookupTable;
import it.geosolutions.jaiext.rlookup.RangeLookupTest;
import it.geosolutions.jaiext.testclasses.TestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeLookupTableTest
extends TestBase {
    private RangeLookupTable.Builder<Integer, Integer> builder;

    @Before
    public void initialsetup() {
        this.builder = new RangeLookupTable.Builder();
    }

    @Test
    public void simpleLookup() throws Exception {
        Number[] breaks = new Integer[]{-10, -5, 0, 5, 10};
        Number[] values = new Integer[]{-99, -1, 0, 1, 2, 99};
        RangeLookupTable table = RangeLookupTest.createTable((Number[])breaks, (Number[])values);
        int N = breaks.length;
        int startVal = (Integer)breaks[0] - 1;
        int endVal = (Integer)breaks[N - 1] + 1;
        int k = 0;
        int expected = (Integer)values[0];
        for (int val = startVal; val <= endVal; ++val) {
            if (val >= (Integer)breaks[k]) {
                expected = (Integer)values[k + 1];
                if (k < N - 1) {
                    ++k;
                }
            }
            LookupItem match = table.getLookupItem((Number)val);
            Assert.assertNotNull((Object)match);
            Assert.assertEquals((long)expected, (long)((Integer)match.getValue()).intValue());
        }
    }

    @Test
    public void addOverlappedRange() throws Exception {
        this.builder.add(RangeFactory.create((int)5, (boolean)true, (int)10, (boolean)true), (Number)1);
        this.builder.add(RangeFactory.create((int)0, (boolean)true, (int)20, (boolean)true), (Number)2);
        RangeLookupTable table = this.builder.build();
        for (int val = 0; val <= 20; ++val) {
            int expected = val < 5 || val > 10 ? 2 : 1;
            LookupItem match = table.getLookupItem((Number)val);
            Assert.assertNotNull((Object)match);
            Assert.assertEquals((long)expected, (long)((Integer)match.getValue()).intValue());
        }
    }

    @Test
    public void addCompletelyOverlappedRange() throws Exception {
        this.builder.add(RangeFactory.create((int)0, (boolean)true, (int)20, (boolean)true), (Number)1);
        this.builder.add(RangeFactory.create((int)5, (boolean)true, (int)10, (boolean)true), (Number)2);
        RangeLookupTable table = this.builder.build();
        for (int val = 0; val <= 20; ++val) {
            LookupItem match = table.getLookupItem((Number)val);
            Assert.assertNotNull((Object)match);
            Assert.assertEquals((long)1L, (long)((Integer)match.getValue()).intValue());
        }
    }

    @Test
    public void lookupWithIntervalGap() throws Exception {
        this.builder.add(RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)-1.0, (boolean)false), (Number)1);
        this.builder.add(RangeFactory.create((double)1.0, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false), (Number)1);
        RangeLookupTable table = this.builder.build();
        Assert.assertEquals((long)1L, (long)((Integer)table.getLookupItem((Number)-2).getValue()).intValue());
        Assert.assertNull((Object)table.getLookupItem((Number)-1));
        Assert.assertNull((Object)table.getLookupItem((Number)0));
        Assert.assertNull((Object)table.getLookupItem((Number)1));
        Assert.assertEquals((long)1L, (long)((Integer)table.getLookupItem((Number)2).getValue()).intValue());
    }

    @Test
    public void lookupWithPointGap() throws Exception {
        this.builder.add(RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)0.0, (boolean)false), (Number)1);
        this.builder.add(RangeFactory.create((double)0.0, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false), (Number)1);
        RangeLookupTable table = this.builder.build();
        Assert.assertEquals((long)1L, (long)((Integer)table.getLookupItem((Number)-1).getValue()).intValue());
        Assert.assertNull((Object)table.getLookupItem((Number)0));
        Assert.assertEquals((long)1L, (long)((Integer)table.getLookupItem((Number)1).getValue()).intValue());
    }
}

