/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.Scale2Descriptor;
import it.geosolutions.jaiext.scale.Scale2PropertyGenerator;
import it.geosolutions.jaiext.scale.TestScale2;
import it.geosolutions.jaiext.translate.TranslateIntOpImage;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.NullDescriptor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CoverageClassTest
extends TestScale2 {
    @Test
    public void testROIProperty() {
        Scale2Descriptor descriptor = new Scale2Descriptor();
        Scale2PropertyGenerator propertyGenerator = (Scale2PropertyGenerator)descriptor.getPropertyGenerators()[0];
        boolean useROIAccessor = false;
        boolean bicubic2Disabled = false;
        boolean dataType = false;
        Object noDataRange = null;
        javax.media.jai.InterpolationNearest interpNear = new javax.media.jai.InterpolationNearest();
        javax.media.jai.InterpolationBilinear interpBil = new javax.media.jai.InterpolationBilinear(8);
        javax.media.jai.InterpolationBicubic interpBic = new javax.media.jai.InterpolationBicubic(8);
        byte imageValue = 127;
        RenderedImage testImg = CoverageClassTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        ROIShape roi = new ROIShape((Shape)new Rectangle(testImg.getMinX(), testImg.getMinY(), testImg.getWidth(), testImg.getHeight()));
        RenderedOp testIMG = NullDescriptor.create((RenderedImage)testImg, null);
        RenderedOp scaleImgNear = Scale2Descriptor.create((RenderedImage)testIMG, (Double)this.scaleXd, (Double)this.scaleYd, (Double)this.transXd, (Double)this.transYd, (Interpolation)interpNear, (ROI)roi, (Boolean)useROIAccessor, null, null, null);
        RenderedOp scaleImgBil = Scale2Descriptor.create((RenderedImage)testIMG, (Double)this.scaleXd, (Double)this.scaleYd, (Double)this.transXd, (Double)this.transYd, (Interpolation)interpBil, (ROI)roi, (Boolean)useROIAccessor, null, null, null);
        RenderedOp scaleImgBic = Scale2Descriptor.create((RenderedImage)testIMG, (Double)this.scaleXd, (Double)this.scaleYd, (Double)this.transXd, (Double)this.transYd, (Interpolation)interpBic, (ROI)roi, (Boolean)useROIAccessor, null, null, null);
        scaleImgNear.getTile(0, 0);
        scaleImgBil.getTile(0, 0);
        scaleImgBic.getTile(0, 0);
        ROI roiNear = (ROI)propertyGenerator.getProperty("roi", (Object)scaleImgNear);
        this.checkROIConsistentWithImage(roiNear, (RenderedImage)scaleImgNear);
        ROI roiBil = (ROI)propertyGenerator.getProperty("roi", (Object)scaleImgBil);
        this.checkROIConsistentWithImage(roiBil, (RenderedImage)scaleImgBil);
        ROI roiBic = (ROI)propertyGenerator.getProperty("roi", (Object)scaleImgBic);
        this.checkROIConsistentWithImage(roiBic, (RenderedImage)scaleImgBic);
        if (scaleImgNear instanceof RenderedOp) {
            scaleImgNear.dispose();
        }
        if (scaleImgBil instanceof RenderedOp) {
            scaleImgBil.dispose();
        }
        if (scaleImgBic instanceof RenderedOp) {
            scaleImgBic.dispose();
        }
    }

    private void checkROIConsistentWithImage(ROI roi, RenderedImage image) {
        Assert.assertEquals((Object)roi.getBounds(), (Object)new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight()));
        PlanarImage roiImage = roi.getAsImage();
        Assert.assertEquals((long)image.getTileWidth(), (long)roiImage.getTileWidth());
        Assert.assertEquals((long)image.getTileHeight(), (long)roiImage.getTileHeight());
    }

    @Test
    public void testTranslation() {
        boolean useROIAccessor = false;
        int dataType = 0;
        Range noDataRange = null;
        double xScale = 1.0;
        double yScale = 1.0;
        double xTrans = 3.0;
        double yTrans = 3.0;
        byte imageValue = 127;
        InterpolationNearest interpNear = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
        this.testTranslation(useROIAccessor, dataType, xScale, yScale, xTrans, yTrans, imageValue, (Interpolation)interpNear);
        InterpolationBilinear interpBilinear = new InterpolationBilinear(8, noDataRange, useROIAccessor, this.destinationNoData, dataType);
        this.testTranslation(useROIAccessor, dataType, xScale, yScale, xTrans, yTrans, imageValue, (Interpolation)interpBilinear);
        InterpolationBicubic interpBicubic = new InterpolationBicubic(8, noDataRange, useROIAccessor, this.destinationNoData, dataType, true, 8);
        this.testTranslation(useROIAccessor, dataType, xScale, yScale, xTrans, yTrans, imageValue, (Interpolation)interpBicubic);
    }

    public void testTranslation(boolean useROIAccessor, int dataType, double xScale, double yScale, double xTrans, double yTrans, byte imageValue, Interpolation interpolation) {
        RenderedImage testIMG = CoverageClassTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        PlanarImage testImgWithROI = PlanarImage.wrapRenderedImage((RenderedImage)testIMG);
        testImgWithROI.setProperty("roi", (Object)new ROIShape((Shape)new Rectangle(0, 0, DEFAULT_WIDTH / 2, DEFAULT_HEIGHT / 2)));
        RenderedOp scaleImgNear = Scale2Descriptor.create((RenderedImage)testImgWithROI, (Double)xScale, (Double)yScale, (Double)xTrans, (Double)yTrans, (Interpolation)interpolation, null, (Boolean)useROIAccessor, null, null, null);
        scaleImgNear.getTiles();
        Assert.assertThat((Object)scaleImgNear.getRendering(), (Matcher)CoreMatchers.instanceOf(TranslateIntOpImage.class));
        Object roi = scaleImgNear.getProperty("roi");
        Assert.assertThat((Object)roi, (Matcher)CoreMatchers.instanceOf(ROI.class));
        Assert.assertThat((Object)((ROI)roi).getAsImage(), (Matcher)CoreMatchers.instanceOf(TranslateIntOpImage.class));
        double actualX = scaleImgNear.getMinX();
        double actualY = scaleImgNear.getMinY();
        double expectedX = (double)testIMG.getMinX() + xTrans;
        double expectedY = (double)testIMG.getMinY() + yTrans;
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
        Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        if (scaleImgNear instanceof RenderedOp) {
            scaleImgNear.dispose();
        }
    }

    @Test
    public void testCopy() {
        boolean useROIAccessor = false;
        int dataType = 0;
        Range noDataRange = null;
        double xScale = 1.0;
        double yScale = 1.0;
        double xTrans = 0.0;
        double yTrans = 0.0;
        byte imageValue = 127;
        InterpolationNearest interpNear = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
        RenderedImage testIMG = CoverageClassTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        RenderedOp scaleImgNear = Scale2Descriptor.create((RenderedImage)testIMG, (Double)xScale, (Double)yScale, (Double)xTrans, (Double)yTrans, (Interpolation)interpNear, null, (Boolean)useROIAccessor, null, null, null);
        scaleImgNear.getTiles();
        double actualX = scaleImgNear.getMinX();
        double actualY = scaleImgNear.getMinY();
        double expectedX = testIMG.getMinX();
        double expectedY = testIMG.getMinY();
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
        Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        if (scaleImgNear instanceof RenderedOp) {
            scaleImgNear.dispose();
        }
    }
}

