/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.Rational;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.huldra.math.BigInt;

public abstract class Scale2OpImage
extends GeometricOpImage {
    protected double scaleX;
    protected double scaleY;
    protected double transX;
    protected double transY;
    protected Rational scaleXRational;
    protected Rational scaleYRational;
    protected BigInt scaleXRationalNum;
    protected BigInt scaleXRationalDenom;
    protected BigInt scaleYRationalNum;
    protected BigInt scaleYRationalDenom;
    protected Rational invScaleXRational;
    protected Rational invScaleYRational;
    protected BigInt invScaleXRationalNum;
    protected BigInt invScaleXRationalDenom;
    protected BigInt invScaleYRationalNum;
    protected BigInt invScaleYRationalDenom;
    protected Rational transXRational;
    protected Rational transYRational;
    protected BigInt transXRationalNum;
    protected BigInt transXRationalDenom;
    protected BigInt transYRationalNum;
    protected BigInt transYRationalDenom;
    protected static float rationalTolerance = 1.0E-8f;
    protected static BigInt ZERO = new BigInt(0);
    private int lpad;
    private int rpad;
    private int tpad;
    private int bpad;
    protected final ROI srcROI;
    protected final PlanarImage srcROIImage;
    protected final boolean hasROI;
    protected final Rectangle roiBounds;
    protected boolean useRoiAccessor;
    protected long invScaleXInt;
    protected BigInt invScaleXFrac;
    protected long invScaleYInt;
    protected BigInt invScaleYFrac;
    protected Interpolation interpolator = null;
    protected boolean isBinary;
    protected int subsampleBits;
    protected int one;
    protected int interp_width;
    protected int interp_height;
    protected int interp_left;
    protected int interp_top;
    protected int shift;
    protected int shift2;
    protected int round2;
    protected int precisionBits;
    protected int round;
    protected int dataType;
    protected Range noData;
    protected boolean hasNoData = false;
    protected byte[] destinationNoDataByte;
    protected short[] destinationNoDataUShort;
    protected short[] destinationNoDataShort;
    protected int[] destinationNoDataInt;
    protected float[] destinationNoDataFloat;
    protected double[] destinationNoDataDouble;
    protected boolean isNegativeInf = false;
    protected boolean isPositiveInf = false;
    protected boolean isRangeNaN = false;
    protected boolean isNearestNew = false;
    protected boolean isBilinearNew = false;
    protected boolean isBicubicNew = false;
    protected boolean caseA;
    protected boolean caseB;
    protected boolean caseC;
    protected RenderedOp srcROIImgExt;
    protected RenderedOp extendedIMG;
    protected Rectangle roiRect;
    static final BorderExtender ROI_EXTENDER = BorderExtender.createInstance((int)0);

    public static ImageLayout layoutHelper(RenderedImage source, double scaleX, double scaleY, double transX, double transY, Interpolation interp, ImageLayout il) {
        Rational scaleXRational = Rational.approximate((double)scaleX, (double)rationalTolerance);
        Rational scaleYRational = Rational.approximate((double)scaleY, (double)rationalTolerance);
        BigInt scaleXRationalNum = new BigInt(scaleXRational.num);
        BigInt scaleXRationalDenom = new BigInt(scaleXRational.denom);
        BigInt scaleYRationalNum = new BigInt(scaleYRational.num);
        BigInt scaleYRationalDenom = new BigInt(scaleYRational.denom);
        Rational transXRational = Rational.approximate((double)transX, (double)rationalTolerance);
        Rational transYRational = Rational.approximate((double)transY, (double)rationalTolerance);
        BigInt transXRationalNum = new BigInt(transXRational.num);
        BigInt transXRationalDenom = new BigInt(transXRational.denom);
        BigInt transYRationalNum = new BigInt(transYRational.num);
        BigInt transYRationalDenom = new BigInt(transYRational.denom);
        ImageLayout layout = il == null ? new ImageLayout() : (ImageLayout)il.clone();
        int x0 = source.getMinX();
        int y0 = source.getMinY();
        int w = source.getWidth();
        int h = source.getHeight();
        BigInt dx0Num = new BigInt(x0);
        BigInt dx0Denom = new BigInt(1);
        BigInt dy0Num = new BigInt(y0);
        BigInt dy0Denom = new BigInt(1);
        BigInt dx1Num = new BigInt(x0 + w);
        BigInt dx1Denom = new BigInt(1);
        BigInt dy1Num = new BigInt(y0 + h);
        BigInt dy1Denom = new BigInt(1);
        dx0Num.mul(scaleXRationalNum);
        dx0Denom.mul(scaleXRationalDenom);
        dy0Num.mul(scaleYRationalNum);
        dy0Denom.mul(scaleYRationalDenom);
        dx1Num.mul(scaleXRationalNum);
        dx1Denom.mul(scaleXRationalDenom);
        dy1Num.mul(scaleYRationalNum);
        dy1Denom.mul(scaleYRationalDenom);
        dx0Num.mul(2);
        dx0Num.sub(dx0Denom);
        dx0Denom.mul(2);
        dy0Num.mul(2);
        dy0Num.sub(dy0Denom);
        dy0Denom.mul(2);
        dx1Num = Scale2OpImage.subnew(Scale2OpImage.mulnew(dx1Num, 2), Scale2OpImage.mulnew(dx1Denom, 3));
        dx1Denom.mul(2);
        dy1Num = Scale2OpImage.subnew(Scale2OpImage.mulnew(dy1Num, 2), Scale2OpImage.mulnew(dy1Denom, 3));
        dy1Denom.mul(2);
        dx0Num.mul(transXRationalDenom);
        dx0Num.add(Scale2OpImage.mulnew(transXRationalNum, dx0Denom));
        dx0Denom.mul(transXRationalDenom);
        dy0Num.mul(transYRationalDenom);
        dy0Num.add(Scale2OpImage.mulnew(transYRationalNum, dy0Denom));
        dy0Denom.mul(transYRationalDenom);
        dx1Num.mul(transXRationalDenom);
        dx1Num.add(Scale2OpImage.mulnew(transXRationalNum, dx1Denom));
        dx1Denom.mul(transXRationalDenom);
        dy1Num.mul(transYRationalDenom);
        dy1Num.add(Scale2OpImage.mulnew(transYRationalNum, dy1Denom));
        dy1Denom.mul(transYRationalDenom);
        int l_x0 = Rational.ceil((long)dx0Num.longValue(), (long)dx0Denom.longValue());
        int l_y0 = Rational.ceil((long)dy0Num.longValue(), (long)dy0Denom.longValue());
        int l_x1 = Rational.ceil((long)dx1Num.longValue(), (long)dx1Denom.longValue());
        int l_y1 = Rational.ceil((long)dy1Num.longValue(), (long)dy1Denom.longValue());
        layout.setMinX(l_x0);
        layout.setMinY(l_y0);
        int width = l_x1 - l_x0 + 1;
        int height = l_y1 - l_y0 + 1;
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        layout.setWidth(width);
        layout.setHeight(height);
        return layout;
    }

    protected final void preComputePositionsInt(Rectangle destRect, int srcRectX, int srcRectY, int srcPixelStride, int srcScanlineStride, int[] xpos, int[] ypos, int[] xfracvalues, int[] yfracvalues, int roiScanlineStride, int[] yposRoi) {
        int i;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int dx = destRect.x;
        int dy = destRect.y;
        BigInt syNum = new BigInt(dy);
        BigInt syDenom = new BigInt(1);
        syNum.mul(this.transYRationalDenom);
        syNum.sub(Scale2OpImage.mulnew(this.transYRationalNum, syDenom));
        syDenom.mul(this.transYRationalDenom);
        syNum.mul(2);
        syNum.add(syDenom);
        syDenom.mul(2);
        syNum.mul(this.invScaleYRationalNum);
        syDenom.mul(this.invScaleYRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            syNum.mul(2);
            syNum.sub(syDenom);
            syDenom.mul(2);
        }
        int srcYInt = Rational.floor((long)syNum.longValue(), (long)syDenom.longValue());
        BigInt srcYFrac = Scale2OpImage.modnew(syNum, syDenom);
        if (srcYInt < 0) {
            srcYFrac = Scale2OpImage.addnew(syDenom, srcYFrac);
        }
        BigInt commonYDenom = Scale2OpImage.mulnew(syDenom, this.invScaleYRationalDenom);
        srcYFrac.mul(this.invScaleYRationalDenom);
        BigInt newInvScaleYFrac = Scale2OpImage.mulnew(this.invScaleYFrac, syDenom);
        BigInt sxNum = new BigInt(dx);
        BigInt sxDenom = new BigInt(1);
        sxNum.mul(this.transXRationalDenom);
        sxNum.sub(Scale2OpImage.mulnew(this.transXRationalNum, sxDenom));
        sxDenom.mul(this.transXRationalDenom);
        sxNum.mul(2);
        sxNum.add(sxDenom);
        sxDenom.mul(2);
        sxNum.mul(this.invScaleXRationalNum);
        sxDenom.mul(this.invScaleXRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            sxNum.mul(2);
            sxNum.sub(sxDenom);
            sxDenom.mul(2);
        }
        int srcXInt = Rational.floor((long)sxNum.longValue(), (long)sxDenom.longValue());
        BigInt srcXFrac = Scale2OpImage.modnew(sxNum, sxDenom);
        if (srcXInt < 0) {
            srcXFrac = Scale2OpImage.addnew(sxDenom, srcXFrac);
        }
        BigInt commonXDenom = Scale2OpImage.mulnew(sxDenom, this.invScaleXRationalDenom);
        srcXFrac.mul(this.invScaleXRationalDenom);
        BigInt newInvScaleXFrac = Scale2OpImage.mulnew(this.invScaleXFrac, sxDenom);
        for (i = 0; i < dwidth; ++i) {
            xpos[i] = this.isBinary ? srcXInt : (srcXInt - srcRectX) * srcPixelStride;
            if (this.isBilinearNew || this.isBicubicNew) {
                xfracvalues[i] = (int)(1.0f * srcXFrac.floatValue() / commonXDenom.floatValue() * (float)this.one);
            }
            srcXInt = (int)((long)srcXInt + this.invScaleXInt);
            srcXFrac.add(newInvScaleXFrac);
            if (srcXFrac.compareTo(commonXDenom) < 0) continue;
            ++srcXInt;
            srcXFrac.sub(commonXDenom);
        }
        for (i = 0; i < dheight; ++i) {
            ypos[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * srcScanlineStride;
            if (this.useRoiAccessor) {
                yposRoi[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * roiScanlineStride;
            }
            if (this.isBilinearNew || this.isBicubicNew) {
                yfracvalues[i] = (int)(1.0f * srcYFrac.floatValue() / commonYDenom.floatValue() * (float)this.one);
            }
            srcYInt = (int)((long)srcYInt + this.invScaleYInt);
            srcYFrac.add(newInvScaleYFrac);
            if (srcYFrac.compareTo(commonYDenom) < 0) continue;
            ++srcYInt;
            srcYFrac.sub(commonYDenom);
        }
    }

    protected final void preComputePositionsFloat(Rectangle destRect, int srcRectX, int srcRectY, int srcPixelStride, int srcScanlineStride, int[] xpos, int[] ypos, float[] xfracvalues, float[] yfracvalues, int roiScanlineStride, int[] yposRoi) {
        int i;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int dx = destRect.x;
        int dy = destRect.y;
        BigInt syNum = new BigInt(dy);
        BigInt syDenom = new BigInt(1);
        syNum.mul(this.transYRationalDenom);
        syNum.sub(Scale2OpImage.mulnew(this.transYRationalNum, syDenom));
        syDenom.mul(this.transYRationalDenom);
        syNum.mul(2);
        syNum.add(syDenom);
        syDenom.mul(2);
        syNum.mul(this.invScaleYRationalNum);
        syDenom.mul(this.invScaleYRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            syNum.mul(2);
            syNum.sub(syDenom);
            syDenom.mul(2);
        }
        int srcYInt = Rational.floor((long)syNum.longValue(), (long)syDenom.longValue());
        BigInt srcYFrac = Scale2OpImage.modnew(syNum, syDenom);
        if (srcYInt < 0) {
            srcYFrac = Scale2OpImage.addnew(syDenom, srcYFrac);
        }
        BigInt commonYDenom = Scale2OpImage.mulnew(syDenom, this.invScaleYRationalDenom);
        srcYFrac.mul(this.invScaleYRationalDenom);
        BigInt newInvScaleYFrac = Scale2OpImage.mulnew(this.invScaleYFrac, syDenom);
        BigInt sxNum = new BigInt(dx);
        BigInt sxDenom = new BigInt(1);
        sxNum.mul(this.transXRationalDenom);
        sxNum.sub(Scale2OpImage.mulnew(this.transXRationalNum, sxDenom));
        sxDenom.mul(this.transXRationalDenom);
        sxNum.mul(2);
        sxNum.add(sxDenom);
        sxDenom.mul(2);
        sxNum.mul(this.invScaleXRationalNum);
        sxDenom.mul(this.invScaleXRationalDenom);
        if (this.isBilinearNew || this.isBicubicNew) {
            sxNum.mul(2);
            sxNum.sub(sxDenom);
            sxDenom.mul(2);
        }
        int srcXInt = Rational.floor((long)sxNum.longValue(), (long)sxDenom.longValue());
        BigInt srcXFrac = Scale2OpImage.modnew(sxNum, sxDenom);
        if (srcXInt < 0) {
            srcXFrac = Scale2OpImage.addnew(sxDenom, srcXFrac);
        }
        BigInt commonXDenom = Scale2OpImage.mulnew(sxDenom, this.invScaleXRationalDenom);
        srcXFrac.mul(this.invScaleXRationalDenom);
        BigInt newInvScaleXFrac = Scale2OpImage.mulnew(this.invScaleXFrac, sxDenom);
        for (i = 0; i < dwidth; ++i) {
            xpos[i] = this.isBinary ? srcXInt : (srcXInt - srcRectX) * srcPixelStride;
            if (this.isBilinearNew || this.isBicubicNew) {
                xfracvalues[i] = 1.0f * srcXFrac.floatValue() / commonXDenom.floatValue();
            }
            srcXInt = (int)((long)srcXInt + this.invScaleXInt);
            srcXFrac.add(newInvScaleXFrac);
            if (srcXFrac.compareTo(commonXDenom) < 0) continue;
            ++srcXInt;
            srcXFrac.sub(commonXDenom);
        }
        for (i = 0; i < dheight; ++i) {
            ypos[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * srcScanlineStride;
            if (this.useRoiAccessor) {
                yposRoi[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * roiScanlineStride;
            }
            if (this.isBilinearNew || this.isBicubicNew) {
                yfracvalues[i] = 1.0f * srcYFrac.floatValue() / commonYDenom.floatValue();
            }
            srcYInt = (int)((long)srcYInt + this.invScaleYInt);
            srcYFrac.add(newInvScaleYFrac);
            if (srcYFrac.compareTo(commonYDenom) < 0) continue;
            ++srcYInt;
            srcYFrac.sub(commonYDenom);
        }
    }

    private static Map<Object, Object> configHelper(RenderedImage source, Map<Object, Object> configuration, Interpolation interp) {
        RenderingHints config = configuration;
        if (ImageUtil.isBinary((SampleModel)source.getSampleModel()) && (interp == null || interp instanceof InterpolationNearest || interp instanceof InterpolationBilinear)) {
            if (configuration == null) {
                config = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            } else if (!config.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints hints = new RenderingHints(null);
                hints.putAll((Map<?, ?>)configuration);
                config = hints;
                config.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return config;
    }

    public Scale2OpImage(RenderedImage source, ImageLayout layout, Map configuration, boolean cobbleSources, BorderExtender extender, Interpolation interp, double scaleX, double scaleY, double transX, double transY, boolean useRoiAccessor, double[] backgroundValues) {
        super(Scale2OpImage.vectorize((RenderedImage)source), Scale2OpImage.layoutHelper(source, scaleX, scaleY, transX, transY, interp, layout), Scale2OpImage.configHelper(source, configuration, interp), cobbleSources, extender, interp, backgroundValues);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.transX = transX;
        this.transY = transY;
        this.scaleXRational = Rational.approximate((double)scaleX, (double)rationalTolerance);
        this.scaleYRational = Rational.approximate((double)scaleY, (double)rationalTolerance);
        this.scaleXRationalNum = new BigInt(this.scaleXRational.num);
        this.scaleXRationalDenom = new BigInt(this.scaleXRational.denom);
        this.scaleYRationalNum = new BigInt(this.scaleYRational.num);
        this.scaleYRationalDenom = new BigInt(this.scaleYRational.denom);
        this.transXRational = Rational.approximate((double)transX, (double)rationalTolerance);
        this.transYRational = Rational.approximate((double)transY, (double)rationalTolerance);
        this.transXRationalNum = new BigInt(this.transXRational.num);
        this.transXRationalDenom = new BigInt(this.transXRational.denom);
        this.transYRationalNum = new BigInt(this.transYRational.num);
        this.transYRationalDenom = new BigInt(this.transYRational.denom);
        this.invScaleXRational = new Rational(this.scaleXRational);
        this.invScaleXRational.invert();
        this.invScaleYRational = new Rational(this.scaleYRational);
        this.invScaleYRational.invert();
        this.invScaleXRationalNum = new BigInt(this.invScaleXRational.num);
        this.invScaleXRationalDenom = new BigInt(this.invScaleXRational.denom);
        this.invScaleYRationalNum = new BigInt(this.invScaleYRational.num);
        this.invScaleYRationalDenom = new BigInt(this.invScaleYRational.denom);
        this.lpad = interp.getLeftPadding();
        this.rpad = interp.getRightPadding();
        this.tpad = interp.getTopPadding();
        this.bpad = interp.getBottomPadding();
        if (extender == null) {
            int l_y1;
            BigInt dy1Denom;
            BigInt dy1Num;
            BigInt dx1Denom;
            BigInt dx1Num;
            BigInt dy0Denom;
            BigInt dy0Num;
            BigInt dx0Denom;
            BigInt dx0Num;
            int x0 = source.getMinX();
            int y0 = source.getMinY();
            int w = source.getWidth();
            int h = source.getHeight();
            BigInt x0Big = new BigInt(x0);
            BigInt y0Big = new BigInt(y0);
            BigInt wBig = new BigInt(w);
            BigInt hBig = new BigInt(h);
            if (interp instanceof InterpolationNearest) {
                dx0Num = new BigInt(x0);
                dx0Denom = new BigInt(1);
                dy0Num = new BigInt(y0);
                dy0Denom = new BigInt(1);
                dx1Num = Scale2OpImage.addnew(x0Big, wBig);
                dx1Denom = new BigInt(1);
                dy1Num = Scale2OpImage.addnew(y0Big, hBig);
                dy1Denom = new BigInt(1);
            } else {
                dx0Num = Scale2OpImage.mul2Add1new(x0Big);
                dx0Denom = new BigInt(2);
                dy0Num = Scale2OpImage.mul2Add1new(y0Big);
                dy0Denom = new BigInt(2);
                dx1Num = Scale2OpImage.addnew(Scale2OpImage.mulnew(x0Big, 2), Scale2OpImage.mulnew(wBig, 2));
                dx1Num.add(1);
                dx1Denom = new BigInt(2);
                dy1Num = Scale2OpImage.addnew(Scale2OpImage.mulnew(y0Big, 2), Scale2OpImage.mulnew(hBig, 2));
                dy1Num.add(1);
                dy1Denom = new BigInt(2);
                dx0Num = Scale2OpImage.addnew(Scale2OpImage.mulnew(dx0Denom, this.lpad), dx0Num);
                dy0Num = Scale2OpImage.addnew(Scale2OpImage.mulnew(dy0Denom, this.tpad), dy0Num);
                dx1Num.sub(Scale2OpImage.mulnew(dx1Denom, this.rpad));
                dy1Num.sub(Scale2OpImage.mulnew(dy1Denom, this.bpad));
            }
            dx0Num.mul(this.scaleXRationalNum);
            dx0Denom.mul(this.scaleXRationalDenom);
            dx0Num.mul(this.transXRationalDenom);
            dx0Num.add(Scale2OpImage.mulnew(this.transXRationalNum, dx0Denom));
            dx0Denom.mul(this.transXRationalDenom);
            dy0Num.mul(this.scaleYRationalNum);
            dy0Denom.mul(this.scaleYRationalDenom);
            dy0Num.mul(this.transYRationalDenom);
            dy0Num.add(Scale2OpImage.mulnew(this.transYRationalNum, dy0Denom));
            dy0Denom.mul(this.transYRationalDenom);
            dx1Num.mul(this.scaleXRationalNum);
            dx1Denom.mul(this.scaleXRationalDenom);
            dx1Num.mul(this.transXRationalDenom);
            dx1Num.add(Scale2OpImage.mulnew(this.transXRationalNum, dx1Denom));
            dx1Denom.mul(this.transXRationalDenom);
            dy1Num.mul(this.scaleYRationalNum);
            dy1Denom.mul(this.scaleYRationalDenom);
            dy1Num.mul(this.transYRationalDenom);
            dy1Num.add(Scale2OpImage.mulnew(this.transYRationalNum, dy1Denom));
            dy1Denom.mul(this.transYRationalDenom);
            dx0Num.mul(2);
            dx0Num.sub(dx0Denom);
            dx0Denom.mul(2);
            dy0Num.mul(2);
            dy0Num.sub(dy0Denom);
            dy0Denom.mul(2);
            int l_x0 = Rational.ceil((long)dx0Num.longValue(), (long)dx0Denom.longValue());
            int l_y0 = Rational.ceil((long)dy0Num.longValue(), (long)dy0Denom.longValue());
            dx1Num.mul(2);
            dx1Num.sub(dx1Denom);
            dx1Denom.mul(2);
            dy1Num.mul(2);
            dy1Num.sub(dy1Denom);
            dy1Denom.mul(2);
            int l_x1 = Rational.floor((long)dx1Num.longValue(), (long)dx1Denom.longValue());
            if (dx1Num.equals(Scale2OpImage.mulnew(dx1Denom, l_x1))) {
                --l_x1;
            }
            if (dy1Num.equals(Scale2OpImage.mulnew(dy1Denom, l_y1 = Rational.floor((long)dy1Num.longValue(), (long)dy1Denom.longValue())))) {
                --l_y1;
            }
            this.computableBounds = new Rectangle(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
        } else {
            this.computableBounds = this.getBounds();
            int leftPadding = this.lpad;
            int topPadding = this.tpad;
            if (interp instanceof InterpolationBilinear || interp instanceof InterpolationBicubic) {
                ++leftPadding;
                ++topPadding;
            }
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(source, 0);
            pb.set(leftPadding, 0);
            pb.set(this.rpad, 1);
            pb.set(topPadding, 2);
            pb.set(this.bpad, 3);
            pb.set(extender, 4);
            this.extendedIMG = JAI.create((String)"border", (ParameterBlock)pb);
        }
        Object property = source.getProperty("ROI");
        if (property instanceof ROI) {
            int bottomP;
            this.srcROI = (ROI)property;
            this.srcROIImage = this.srcROI.getAsImage();
            this.roiRect = new Rectangle(this.srcROIImage.getMinX() - this.lpad, this.srcROIImage.getMinY() - this.tpad, this.srcROIImage.getWidth() + this.lpad + this.rpad, this.srcROIImage.getHeight() + this.tpad + this.bpad);
            this.roiBounds = this.srcROIImage.getBounds();
            Rectangle srcRect = new Rectangle(source.getMinX() - this.lpad, source.getMinY() - this.tpad, source.getWidth() + this.lpad + this.rpad, source.getHeight() + this.tpad + this.bpad);
            int deltaX0 = this.roiBounds.x - srcRect.x;
            int leftP = deltaX0 > 0 ? deltaX0 : 0;
            int deltaY0 = this.roiBounds.y - srcRect.y;
            int topP = deltaY0 > 0 ? deltaY0 : 0;
            int deltaX1 = srcRect.x + srcRect.width - this.roiBounds.x - this.roiBounds.width;
            int rightP = deltaX1 > 0 ? deltaX1 : 0;
            int deltaY1 = srcRect.y + srcRect.height - this.roiBounds.y - this.roiBounds.height;
            int n = bottomP = deltaY1 > 0 ? deltaY1 : 0;
            if (interp instanceof InterpolationBilinear || interp instanceof InterpolationBicubic) {
                ++leftP;
                ++topP;
            }
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.srcROIImage, 0);
            pb.set(leftP, 0);
            pb.set(rightP, 1);
            pb.set(topP, 2);
            pb.set(bottomP, 3);
            pb.set(ROI_EXTENDER, 4);
            this.srcROIImgExt = JAI.create((String)"border", (ParameterBlock)pb);
            this.hasROI = true;
            this.useRoiAccessor = useRoiAccessor;
        } else {
            this.srcROI = null;
            this.srcROIImage = null;
            this.roiBounds = null;
            this.hasROI = false;
        }
    }

    public Point2D mapDestPoint(Point2D destPt, int sourceIndex) {
        if (destPt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D pt = (Point2D)destPt.clone();
        pt.setLocation((destPt.getX() - this.transX + 0.5) / this.scaleX - 0.5, (destPt.getY() - this.transY + 0.5) / this.scaleY - 0.5);
        return pt;
    }

    public Point2D mapSourcePoint(Point2D sourcePt, int sourceIndex) {
        if (sourcePt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D pt = (Point2D)sourcePt.clone();
        pt.setLocation(this.scaleX * (sourcePt.getX() + 0.5) + this.transX - 0.5, this.scaleY * (sourcePt.getY() + 0.5) + this.transY - 0.5);
        return pt;
    }

    protected Rectangle forwardMapRect(Rectangle sourceRect, int sourceIndex) {
        int l_y1;
        BigInt dy1Denom;
        BigInt dy1Num;
        BigInt dx1Denom;
        BigInt dx1Num;
        BigInt dy0Denom;
        BigInt dy0Num;
        BigInt dx0Denom;
        BigInt dx0Num;
        if (sourceRect == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int x0 = sourceRect.x;
        int y0 = sourceRect.y;
        int w = sourceRect.width;
        int h = sourceRect.height;
        BigInt x0Big = new BigInt(x0);
        BigInt y0Big = new BigInt(y0);
        BigInt wBig = new BigInt(w);
        BigInt hBig = new BigInt(h);
        if (this.interp instanceof InterpolationNearest) {
            dx0Num = new BigInt(x0);
            dx0Denom = new BigInt(1);
            dy0Num = new BigInt(y0);
            dy0Denom = new BigInt(1);
            dx1Num = Scale2OpImage.addnew(x0Big, wBig);
            dx1Denom = new BigInt(1);
            dy1Num = Scale2OpImage.addnew(y0Big, hBig);
            dy1Denom = new BigInt(1);
        } else {
            dx0Num = Scale2OpImage.mul2Add1new(x0Big);
            dx0Denom = new BigInt(2);
            dy0Num = Scale2OpImage.mul2Add1new(y0Big);
            dy0Denom = new BigInt(2);
            dx1Num = Scale2OpImage.addnew(Scale2OpImage.addnew(Scale2OpImage.mulnew(x0Big, 2), Scale2OpImage.mulnew(wBig, 2)), 1);
            dx1Denom = new BigInt(2);
            dy1Num = Scale2OpImage.addnew(Scale2OpImage.addnew(Scale2OpImage.mulnew(y0Big, 2), Scale2OpImage.mulnew(hBig, 2)), 1);
            dy1Denom = new BigInt(2);
        }
        dx0Num.mul(this.scaleXRationalNum);
        dx0Denom.mul(this.scaleXRationalDenom);
        dx0Num.mul(this.transXRationalDenom);
        dx0Num.add(Scale2OpImage.mulnew(this.transXRationalNum, dx0Denom));
        dx0Denom.mul(this.transXRationalDenom);
        dy0Num.mul(this.scaleYRationalNum);
        dy0Denom.mul(this.scaleYRationalDenom);
        dy0Num.mul(this.transYRationalDenom);
        dy0Num.add(Scale2OpImage.mulnew(this.transYRationalNum, dy0Denom));
        dy0Denom.mul(this.transYRationalDenom);
        dx1Num.mul(this.scaleXRationalNum);
        dx1Denom.mul(this.scaleXRationalDenom);
        dx1Num.mul(this.transXRationalDenom);
        dx1Num.add(Scale2OpImage.mulnew(this.transXRationalNum, dx1Denom));
        dx1Denom.mul(this.transXRationalDenom);
        dy1Num.mul(this.scaleYRationalNum);
        dy1Denom.mul(this.scaleYRationalDenom);
        dy1Num.mul(this.transYRationalDenom);
        dy1Num.add(Scale2OpImage.mulnew(this.transYRationalNum, dy1Denom));
        dy1Denom.mul(this.transYRationalDenom);
        dx0Num.mul(2);
        dx0Num.sub(dx0Denom);
        dx0Denom.mul(2);
        dy0Num.mul(2);
        dy0Num.sub(dy0Denom);
        dy0Denom.mul(2);
        int l_x0 = Rational.ceil((long)dx0Num.longValue(), (long)dx0Denom.longValue());
        int l_y0 = Rational.ceil((long)dy0Num.longValue(), (long)dy0Denom.longValue());
        dx1Num.mul(2);
        dx1Num.sub(dx1Denom);
        dx1Denom.mul(2);
        dy1Num.mul(2);
        dy1Num.sub(dy1Denom);
        dy1Denom.mul(2);
        int l_x1 = Rational.floor((long)dx1Num.longValue(), (long)dx1Denom.longValue());
        if (dx1Num.equals(Scale2OpImage.mulnew(dx1Denom, l_x1))) {
            --l_x1;
        }
        if (dy1Num.equals(Scale2OpImage.mulnew(dy1Denom, l_y1 = Rational.floor((long)dy1Num.longValue(), (long)dy1Denom.longValue())))) {
            --l_y1;
        }
        return new Rectangle(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        if (destRect == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (sourceIndex != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int x0 = destRect.x;
        int y0 = destRect.y;
        int w = destRect.width;
        int h = destRect.height;
        BigInt x0Big = new BigInt(x0);
        BigInt y0Big = new BigInt(y0);
        BigInt wBig = new BigInt(w);
        BigInt hBig = new BigInt(h);
        BigInt sx0Num = Scale2OpImage.mul2Add1new(x0Big);
        BigInt sx0Denom = new BigInt(2);
        BigInt sy0Num = Scale2OpImage.mul2Add1new(y0Big);
        BigInt sy0Denom = new BigInt(2);
        BigInt sx1Num = Scale2OpImage.addnew(Scale2OpImage.mulnew(x0Big, 2), Scale2OpImage.mulnew(wBig, 2));
        sx1Num.sub(1);
        BigInt sx1Denom = new BigInt(2);
        BigInt sy1Num = Scale2OpImage.addnew(Scale2OpImage.mulnew(y0Big, 2), Scale2OpImage.mulnew(hBig, 2));
        sy1Num.sub(1);
        BigInt sy1Denom = new BigInt(2);
        sx0Num.mul(this.transXRationalDenom);
        sx0Num.sub(Scale2OpImage.mulnew(this.transXRationalNum, sx0Denom));
        sx0Denom.mul(this.transXRationalDenom);
        sy0Num.mul(this.transYRationalDenom);
        sy0Num.sub(Scale2OpImage.mulnew(this.transYRationalNum, sy0Denom));
        sy0Denom.mul(this.transYRationalDenom);
        sx1Num.mul(this.transXRationalDenom);
        sx1Num.sub(Scale2OpImage.mulnew(this.transXRationalNum, sx1Denom));
        sx1Denom.mul(this.transXRationalDenom);
        sy1Num.mul(this.transYRationalDenom);
        sy1Num.sub(Scale2OpImage.mulnew(this.transYRationalNum, sy1Denom));
        sy1Denom.mul(this.transYRationalDenom);
        sx0Num.mul(this.invScaleXRationalNum);
        sx0Denom.mul(this.invScaleXRationalDenom);
        sy0Num.mul(this.invScaleYRationalNum);
        sy0Denom.mul(this.invScaleYRationalDenom);
        sx1Num.mul(this.invScaleXRationalNum);
        sx1Denom.mul(this.invScaleXRationalDenom);
        sy1Num.mul(this.invScaleYRationalNum);
        sy1Denom.mul(this.invScaleYRationalDenom);
        int s_x0 = 0;
        int s_y0 = 0;
        int s_x1 = 0;
        int s_y1 = 0;
        if (this.interp instanceof InterpolationNearest) {
            s_x0 = Rational.floor((long)sx0Num.longValue(), (long)sx0Denom.longValue());
            s_y0 = Rational.floor((long)sy0Num.longValue(), (long)sy0Denom.longValue());
            s_x1 = Rational.floor((long)sx1Num.longValue(), (long)sx1Denom.longValue());
            s_y1 = Rational.floor((long)sy1Num.longValue(), (long)sy1Denom.longValue());
        } else {
            s_x0 = Rational.floor((long)Scale2OpImage.subnew(Scale2OpImage.mulnew(sx0Num, 2), sx0Denom).longValue(), (long)Scale2OpImage.mulnew(sx0Denom, 2).longValue());
            s_y0 = Rational.floor((long)Scale2OpImage.subnew(Scale2OpImage.mulnew(sy0Num, 2), sy0Denom).longValue(), (long)Scale2OpImage.mulnew(sy0Denom, 2).longValue());
            long sx1Num05 = Scale2OpImage.subnew(Scale2OpImage.mulnew(sx1Num, 2), sx1Denom).longValue();
            long sx1Denom2 = Scale2OpImage.mulnew(sx1Denom, 2).longValue();
            long sy1Num05 = Scale2OpImage.subnew(Scale2OpImage.mulnew(sy1Num, 2), sy1Denom).longValue();
            long sy1Denom2 = Scale2OpImage.mulnew(sy1Denom, 2).longValue();
            if (this.extender != null) {
                s_x1 = Rational.ceil((long)sx1Num05, (long)sx1Denom2);
                s_y1 = Rational.ceil((long)sy1Num05, (long)sy1Denom2);
            } else {
                s_x1 = Rational.floor((long)sx1Num05, (long)sx1Denom2);
                s_y1 = Rational.floor((long)sy1Num05, (long)sy1Denom2);
            }
        }
        return new Rectangle(s_x0, s_y0, s_x1 - s_x0 + 1, s_y1 - s_y0 + 1);
    }

    public Raster computeTile(int tileX, int tileY) {
        if (!this.cobbleSources) {
            return super.computeTile(tileX, tileY);
        }
        int orgX = this.tileXToX(tileX);
        int orgY = this.tileYToY(tileY);
        WritableRaster dest = this.createWritableRaster(this.sampleModel, new Point(orgX, orgY));
        Rectangle rect = new Rectangle(orgX, orgY, this.tileWidth, this.tileHeight);
        Rectangle destRect = rect.intersection(this.computableBounds);
        if (destRect.width <= 0 || destRect.height <= 0) {
            return dest;
        }
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        Raster[] sources = new Raster[1];
        PlanarImage source0 = this.getSourceImage(0);
        IntegerSequence srcXSplits = new IntegerSequence();
        IntegerSequence srcYSplits = new IntegerSequence();
        source0.getSplits(srcXSplits, srcYSplits, srcRect);
        if (srcXSplits.getNumElements() == 1 && srcYSplits.getNumElements() == 1) {
            sources[0] = this.getImageData(source0, srcRect);
            this.computeRect(sources, dest, destRect);
        } else {
            int srcTileWidth = source0.getTileWidth();
            int srcTileHeight = source0.getTileHeight();
            srcYSplits.startEnumeration();
            while (srcYSplits.hasMoreElements()) {
                int ysplit = srcYSplits.nextElement();
                srcXSplits.startEnumeration();
                while (srcXSplits.hasMoreElements()) {
                    int xsplit = srcXSplits.nextElement();
                    Rectangle srcTile = new Rectangle(xsplit, ysplit, srcTileWidth, srcTileHeight);
                    Rectangle newSrcRect = srcRect.intersection(srcTile);
                    if (!(this.interp instanceof InterpolationNearest)) {
                        if (newSrcRect.width <= this.interp.getWidth()) {
                            Rectangle wSrcRect = new Rectangle();
                            wSrcRect.x = newSrcRect.x;
                            wSrcRect.y = newSrcRect.y - this.tpad - 1;
                            wSrcRect.width = 2 * (this.lpad + this.rpad + 1);
                            wSrcRect.height = newSrcRect.height + this.bpad + this.tpad + 2;
                            wSrcRect = wSrcRect.intersection(source0.getBounds());
                            Rectangle wDestRect = this.mapSourceRect(wSrcRect, 0);
                            wDestRect = wDestRect.intersection(destRect);
                            if (wDestRect.width > 0 && wDestRect.height > 0) {
                                sources[0] = this.getImageData(source0, wSrcRect);
                                this.computeRect(sources, dest, wDestRect);
                            }
                        }
                        if (newSrcRect.height <= this.interp.getHeight()) {
                            Rectangle hSrcRect = new Rectangle();
                            hSrcRect.x = newSrcRect.x - this.lpad - 1;
                            hSrcRect.y = newSrcRect.y;
                            hSrcRect.width = newSrcRect.width + this.lpad + this.rpad + 2;
                            hSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                            hSrcRect = hSrcRect.intersection(source0.getBounds());
                            Rectangle hDestRect = this.mapSourceRect(hSrcRect, 0);
                            hDestRect = hDestRect.intersection(destRect);
                            if (hDestRect.width > 0 && hDestRect.height > 0) {
                                sources[0] = this.getImageData(source0, hSrcRect);
                                this.computeRect(sources, dest, hDestRect);
                            }
                        }
                    }
                    if (newSrcRect.width <= 0 || newSrcRect.height <= 0) continue;
                    Rectangle newDestRect = this.mapSourceRect(newSrcRect, 0);
                    newDestRect = newDestRect.intersection(destRect);
                    if (newDestRect.width > 0 && newDestRect.height > 0) {
                        sources[0] = this.getImageData(source0, newSrcRect);
                        this.computeRect(sources, dest, newDestRect);
                    }
                    if (this.interp instanceof InterpolationNearest) continue;
                    Rectangle RTSrcRect = new Rectangle();
                    RTSrcRect.x = newSrcRect.x + newSrcRect.width - 1 - this.rpad - this.lpad;
                    RTSrcRect.y = newSrcRect.y;
                    RTSrcRect.width = 2 * (this.lpad + this.rpad + 1);
                    RTSrcRect.height = newSrcRect.height;
                    Rectangle RTDestRect = this.mapSourceRect(RTSrcRect, 0);
                    RTDestRect = RTDestRect.intersection(destRect);
                    RTSrcRect = this.mapDestRect(RTDestRect, 0);
                    if (RTDestRect.width > 0 && RTDestRect.height > 0) {
                        sources[0] = this.getImageData(source0, RTSrcRect);
                        this.computeRect(sources, dest, RTDestRect);
                    }
                    Rectangle BTSrcRect = new Rectangle();
                    BTSrcRect.x = newSrcRect.x;
                    BTSrcRect.y = newSrcRect.y + newSrcRect.height - 1 - this.bpad - this.tpad;
                    BTSrcRect.width = newSrcRect.width;
                    BTSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle BTDestRect = this.mapSourceRect(BTSrcRect, 0);
                    BTDestRect = BTDestRect.intersection(destRect);
                    BTSrcRect = this.mapDestRect(BTDestRect, 0);
                    if (BTDestRect.width > 0 && BTDestRect.height > 0) {
                        sources[0] = this.getImageData(source0, BTSrcRect);
                        this.computeRect(sources, dest, BTDestRect);
                    }
                    Rectangle LRTSrcRect = new Rectangle();
                    LRTSrcRect.x = newSrcRect.x + newSrcRect.width - 1 - this.rpad - this.lpad;
                    LRTSrcRect.y = newSrcRect.y + newSrcRect.height - 1 - this.bpad - this.tpad;
                    LRTSrcRect.width = 2 * (this.rpad + this.lpad + 1);
                    LRTSrcRect.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle LRTDestRect = this.mapSourceRect(LRTSrcRect, 0);
                    LRTDestRect = LRTDestRect.intersection(destRect);
                    LRTSrcRect = this.mapDestRect(LRTDestRect, 0);
                    if (LRTDestRect.width <= 0 || LRTDestRect.height <= 0) continue;
                    sources[0] = this.getImageData(source0, LRTSrcRect);
                    this.computeRect(sources, dest, LRTDestRect);
                }
            }
        }
        return dest;
    }

    private Raster getImageData(PlanarImage source, Rectangle srcRect) {
        if (this.extender == null) {
            return source.getData(srcRect);
        }
        if (source.getBounds().contains(srcRect)) {
            return source.getData(srcRect);
        }
        return this.extendedIMG.getData(srcRect);
    }

    public synchronized void dispose() {
        if (this.srcROIImage != null) {
            this.srcROIImage.dispose();
        }
        if (this.srcROIImgExt != null) {
            this.srcROIImgExt.dispose();
        }
        super.dispose();
    }

    protected static BigInt modnew(BigInt num, BigInt den) {
        BigInt result = num.copy();
        result.mod(den);
        if (result.compareTo(ZERO) > 0 && num.compareTo(ZERO) < 0) {
            result.sub(den);
        }
        return result;
    }

    protected static BigInt addnew(BigInt a, int b) {
        BigInt result = a.copy();
        result.add(b);
        return result;
    }

    protected static BigInt addnew(BigInt a, BigInt b) {
        BigInt result = a.copy();
        result.add(b);
        return result;
    }

    protected static BigInt subnew(BigInt a, BigInt b) {
        BigInt result = a.copy();
        result.sub(b);
        return result;
    }

    protected static BigInt mulnew(BigInt a, BigInt b) {
        BigInt result = a.copy();
        result.mul(b);
        return result;
    }

    protected static BigInt mulnew(BigInt a, int b) {
        BigInt result = a.copy();
        result.mul(b);
        return result;
    }

    private static BigInt mul2Add1new(BigInt n) {
        BigInt result = n.copy();
        result.mul(2);
        result.add(1);
        return result;
    }
}

